C +++
C
C Source: src/source/id/inv_linear.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	inv_linear.F
C Revision 1.3  91/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C 
C Revision 1.2  91/03/25  13:41:05  khan
C DO WHILE to GOTO's
C 
C Revision 1.1  90/07/17  15:36:34  khan
C Initial revision
C 
C 
C ---

C+++
C
C	SUBROUTINE		INV_LINEAR
C
C	PURPOSE			Use linear interpolation to make an array 
C				equal space in Y-axis
C
C	INPUT:			XY(2,201) array.
C				
C	OUTPUT:			X_NEW(201), the new X array.
C
C---
	SUBROUTINE	INV_LINEAR	(XY,NE,X_NEW,ADJUST)
	
	IMPLICIT	REAL*8	(A-H,O-Z)
	DIMENSION	XY(2,201),X_NEW(201)

	YSTEP	= (XY(2,NE)-XY(2,1))/(NE-1)
	ISTART	= 1
	X_NEW(1)	= XY(1,1)
	X_NEW(NE)	= XY(1,NE)

	DO 15 I = 2, NE-1
	  Y_NEW	= XY(2,1) + (I-1)*YSTEP

C +++
C Replace DO ... WHILE with GOTO statements.
C
C	  DO WHILE (Y_NEW.GT.XY(2,ISTART))
C	    ISTART	= ISTART + 1
C	  END DO
C ---
 19	CONTINUE
	  IF (Y_NEW.GT.XY(2,ISTART)) THEN
	    ISTART	= ISTART + 1
	    GOTO 19
	  ENDIF
	  
	  IF (XY(2,ISTART).NE.XY(2,ISTART-1)) THEN
	    X_NEW(I) = XY(1,ISTART-1) + (XY(1,ISTART) - XY(1,ISTART-1))/
     $				        (XY(2,ISTART) - XY(2,ISTART-1))*
     $				        (Y_NEW - XY(2,ISTART-1))
	  ELSE
C
C If the probability is the same, then just use the average value.
C
	    X_NEW(I) = (XY(1,ISTART-1)+XY(1,ISTART))/2.0D0
	  END IF

15	CONTINUE

C
C Now check whether any 2 adjacant points are spaced too far apart in X.
C
	ASTEP	= (XY(1,NE)-XY(1,1))/(NE-1)
	DO 25 I = 1, NE-1
	  XSTEP	= X_NEW(I+1) - X_NEW(I)
	  IF (XSTEP.GT.ASTEP) THEN
	    X_NEW(I)	 = X_NEW(I) + ADJUST*XSTEP
	    X_NEW(I+1)	 = X_NEW(I+1) - ADJUST*XSTEP
	  END IF
25	CONTINUE
	X_NEW(1)	= XY(1,1)
	X_NEW(NE)	= XY(1,NE)
C
	RETURN
	END
