	SUBROUTINE	INTEGRATE	(FXY,FY,FNUM)

	IMPLICIT	REAL*8	(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif

	DIMENSION	FXY(101,101),FY(101),TEMP(101)

	IF (IANGLE.EQ.1) THEN			! Polar coordinate
	  DO 19 J = 1, NT
	    FY(J)	= 0.0E0
	    THE		= THEMIN + (J-1)*THESTEP
	    IF (J.GT.1) THEN
	      DO 29 I = 1, NP
	   	TEMP(I)	= FXY(I,J) * THE
29	      CONTINUE
	    ELSE
	      ARN	= 0.0E0
	      DO 39 I = 1, NP
	  	ARN	= ARN + 0.5D0*(FXY(I,1) + FXY(I,2))
39	      CONTINUE
	      ARN	= ARN/NP
	      DO 49 I = 1, NP
		TEMP(I)	= ARN*0.5D0*THESTEP/2.0
49	      CONTINUE
	    END IF
	    DO 59 I = 1, NP-1
	      FY(J) 	= FY(J) + 0.5E0*(TEMP(I) + TEMP(I+1))*PHISTEP
59	    CONTINUE
19	  CONTINUE

	ELSE IF (IANGLE.EQ.2) THEN		! Cartesian coordinate
	  DO 69 J = 1, NT
	    FY(J)	= 0.0E0
	    DO 79 I = 1, NP-1
	      FY(J)	= FY(J) + 0.5*(FXY(I,J)+FXY(I+1,J)) *PHISTEP
79	    CONTINUE
69	  CONTINUE

	END IF

	FNUM	= 0.0E0
	DO 89 J = 1, NT-1
	  FNUM	= FNUM + 0.5*(FY(J)+FY(J+1)) *THESTEP
89	CONTINUE

	RETURN

	END
