	SUBROUTINE	CHOOSE	(ENER,ATHETA,NT0,APHI,NP0)

	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif
C
	DIMENSION	ATHETA(101),APHI(40)
	DIMENSION	TSTART(10),TEND(10)
	LOGICAL		FLAG1,FLAG2
     	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /

	IF (IANGLE.EQ.1) THEN			! Polar coordinate

	  EDIV	= SQRT(EDIVX**2 + EDIVY**2)
	  IF (THESTEP.NE.0.0) THEN
	    NT0	= ABS(3.0*EDIV/THESTEP) + NT
	  ELSE
	    NT0	= NT
	  END IF

	  ATMAX	= THEMAX + 3.0*EDIV
	  ATMIN	= THEMIN - 3.0*EDIV
	  IF (ATMIN.LT.0.0D0)	ATMIN	= 0.0D0

	  APMAX	= PHIMAX + 3.0*EDIV
	  APMIN	= PHIMIN - 3.0*EDIV
	  IF ((APMAX-APMIN).GT.TWOPI)	THEN
	    APMIN	= 0.0E0
	    APMAX	= TWOPI
	  END IF

	ELSE					! Cartesian coordinate
C
C To decide the number of points to be used.
C
	  IF (THESTEP.NE.0.0) THEN 
	    NY0	= ABS(3.0*EDIVY/THESTEP) + NT
	  ELSE
	    NY0	= NT
	  END IF
	  IF (PHISTEP.NE.0.0) then
	    NX0	= ABS(3.0*EDIVX/PHISTEP) + NP
	  ELSE
	    NX0	= NP
	  END IF
	  NT0	= MAX(NY0,NX0)
	  THEMAX0	= THEMAX + 3.0*EDIVY
	  THEMIN0	= THEMIN - 3.0*EDIVY
	  PHIMAX0	= PHIMAX + 3.0*EDIVX
	  PHIMIN0	= PHIMIN - 3.0*EDIVX
	  A1	= SQRT(THEMAX0**2 + PHIMAX0**2)
	  A2	= SQRT(THEMIN0**2 + PHIMIN0**2)
	  ATMAX	= MAX(A1,A2)
	  ATMIN	= MIN(A1,A2)
C
C To determine the azmuthal angle limits
C
	  CALL	ATAN_2	(THEMAX0,PHIMAX0,AP1)
	  CALL	ATAN_2	(THEMAX0,PHIMIN0,AP2)
	  CALL	ATAN_2	(THEMIN0,PHIMAX0,AP3)
	  CALL	ATAN_2	(THEMIN0,PHIMIN0,AP4)
	  APMIN	= MIN(MIN(MIN(AP1,AP2),AP3),AP4)
	  APMAX	= MAX(MAX(MAX(AP1,AP2),AP3),AP4)

	  IF ((THEMAX0*THEMIN0).LE.0) THEN
	    IF ((PHIMAX0*PHIMIN0).LE.0) THEN
	      ATMIN	= 0.0
	      APMIN	= 0.0
	      APMAX	= (TWOPI*35)/36.0
	    ELSE	    
	      ATMIN	= MIN(ABS(PHIMIN0),ABS(PHIMAX0))
	    END IF
	  ELSE
	    IF ((PHIMAX0*PHIMIN0).LE.0) THEN
	      ATMIN	= MIN(ABS(THEMIN0),ABS(THEMAX0))
	    ELSE
	    END IF
	  END IF

	END IF
	IF (NT0.GT.101) NT0	= 101
	IF (NT0.LT.11)	NT0	= 11
C
C initialize the Phi array, at 10 degree interval.
C
	 TEN_DEG	= PIHALF/9.0E0
	 ITEMP		= APMIN/TEN_DEG
	 APMIN		= ITEMP*TEN_DEG
	 NP0 = 0
	   DO 19 I = 1, 40
	     PHI_A	= APMIN + (I-1)*TEN_DEG
	     IF (PHI_A.GT.(APMAX+0.5*TEN_DEG)) GO TO 201
	     APHI(I)	= PHI_A
	     NP0	= NP0 + 1
19	 CONTINUE	   
201	 CONTINUE

C
C For theta, we put them at the ith harmonics.  
C The number of available points in theta, NTEMP, is normally NT minus the 2 
C end points (THEMIN and THEMAX).
C
	  RLAMDA 	= 12398.52/ENER*1.0D-10			! meter
	  DI		= 2.0/NCOMP
	  NHAR		= 0
	  NTEMP		= NT0 - 2
	  JSTART	= 2
C
C Fill in TSTART(i) and TEND(i), the boundary of the ith harmonics.  It 
C includes up to the 2nd minimum on either side of the harmonics.
C
	  DO 29 I = 1, 10
	    THE_1	= (I-DI)*RLAMDA/RLAU*(2.0*GA0**2) - 1.0 - 0.5*(RK**2)
	    THE_2	= (I+DI)*RLAMDA/RLAU*(2.0*GA0**2) - 1.0 - 0.5*(RK**2)
	    IF (THE_1.GE.0.0)	THE_1 = SQRT(THE_1/GA0**2)
	    IF (THE_2.GE.0.0)	THE_2 = SQRT(THE_2/GA0**2)
	    FLAG1	= (THE_1.GE.ATMIN).AND.(THE_1.LE.ATMAX)
	    FLAG2	= (THE_2.GE.ATMIN).AND.(THE_2.LE.ATMAX)
	    IF (FLAG1.OR.FLAG2) THEN
	      NHAR	= NHAR + 1
	      IF (FLAG1) THEN
		TSTART(NHAR)	= THE_1
	      ELSE
	        TSTART(NHAR)	= ATMIN
		NTEMP		= NTEMP + 1
		JSTART		= 1
	      END IF
	      IF (FLAG2) THEN
		TEND(NHAR)	= THE_2
	      ELSE
	        TEND(NHAR)	= ATMAX
		NTEMP		= NTEMP + 1
	      END IF
	    END IF
29	  CONTINUE	  
C
C Make sure there are at least 3 points per harmonic.
C
	  IF (3*NHAR.GT.NTEMP) THEN
	    NN		= NT0 - NTEMP
	    NTEMP	= 3*NHAR
	    NT0		= NTEMP + NN
	  END IF
C
C If catch no harmonics, just keep the uniform distribution.
C
	  IF (NHAR.EQ.0) THEN			
	    ASTEP	= (ATMAX-ATMIN)/(NT0-1)
	    DO 39 J = 1, NT0
	      ATHETA(J)	= ATMIN + (J-1)*ASTEP
39	    CONTINUE 
	  ELSE
C
C Check for the unlikely case of overlap.
C
	    DO 49 I = 2, NHAR
	      IF (TSTART(I).LT.TEND(I-1))THEN
	 	TAV		= (TSTART(I) + TEND(I-1))/2.0
		TSTART(I)	= TAV + 1.0E-6
		TEND(I-1)	= TAV
	      END IF
49	    CONTINUE 
C
C Spread the available points NTEMP to the various harmonics.
C
	    ND2	= NTEMP/NHAR
	    ND1	= NTEMP - ND2*(NHAR-1)
	    DO 59 I = 1, NHAR
	      IF (I.EQ.1) THEN
		ND 	= ND1
	      ELSE
		ND 	= ND2
	      END IF

	      TSTEP	= (TEND(I) - TSTART(I))/(ND-1)

	      DO 69 II = 1, ND
		ATHETA(JSTART)		= TSTART(I) + (II-1)*TSTEP
		JSTART			= JSTART + 1
69	      CONTINUE 
59	    CONTINUE 
	    ATHETA(1)		= ATMIN
	    ATHETA(NT0)		= ATMAX
	  END IF
	RETURN
	END
