C +++
C
C Source: src/source/bm/beam.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	beam.F
C Revision 1.1  90/07/11  10:44:54  khan
C Initial revision
C 
C 
C ---

***********************************************************************
* This program computes the phase space parameters for ALADDIN
     	IMPLICIT REAL*4 (A-H,O-Z)

     	DIMENSION BETA(2,2),GAMMA(2,2)

     	BETA(1,1)	=   2.704   	! X, 1.0 GeV
     	BETA(1,2)	=   2.54	! X,  .75
     	BETA(2,1)	=   5.625	! Y, 1.0
     	BETA(2,2)	=   6.3		! Y,  .75

     	GAMMA(1,1)	=   0.3699	! X, 1.0
     	GAMMA(1,2)	=   0.394	! X,  .75
     	GAMMA(2,1)	=   0.1778	! Y, 1.0
     	GAMMA(2,2)	=   0.1587	! Y,  .75

3     	WRITE(6,*)'Energy: 1.0 Gev = 1, 0.75 = 2'
     	READ(5,*)I_ENER

2     	WRITE(6,*)'Beam X (1) or Y (2) '
     	READ(5,*)I_COOR

1     	WRITE(6,*)'Coordinate ?'
     	READ(5,*)WHAT

     	EPSI = GAMMA(I_COOR,I_ENER)*WHAT**2

     	WRITE(6,*)'Emittance is :',EPSI

     	WHAT_PRI  =   SQRT(EPSI/BETA(I_COOR,I_ENER))

     	WRITE(6,*)'Max divergency is :',WHAT_PRI

     	WRITE(6,*)
     $	'Enter 1 for new emittance,2 for diff. coord.,3 for new energy'
     	READ(5,*)I_WHERE

     	GO TO (1,2,3),I_WHERE

     	END
