C +++
C
C Source: src/lib/ibcccu.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: ibcccu.f
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:56:11  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - IBCCCU                                        IBCC0010
C                                                                       IBCC0020
C-----------------------------------------------------------------------IBCC0030
C                                                                       IBCC0040
C   COMPUTER            - VAX/DOUBLE                                    IBCC0050
C                                                                       IBCC0060
C   LATEST REVISION     - JUNE 1, 1982                                  IBCC0070
C                                                                       IBCC0080
C   PURPOSE             - BICUBIC SPLINE TWO-DIMENSIONAL COEFFICIENT    IBCC0090
C                           CALCULATOR                                  IBCC0100
C                                                                       IBCC0110
C   USAGE               - CALL IBCCCU (F,X,NX,Y,NY,C,IC,WK,IER)         IBCC0120
C                                                                       IBCC0130
C   ARGUMENTS    F      - NX BY NY MATRIX CONTAINING THE FUNCTION       IBCC0140
C                           VALUES. (INPUT) F(I,J) IS THE FUNCTION VALUEIBCC0150
C                           AT THE POINT (X(I),Y(J)) FOR I=1,...,NX AND IBCC0160
C                           J=1,...,NY.                                 IBCC0170
C                X      - VECTOR OF LENGTH NX. (INPUT) X MUST BE        IBCC0180
C                           ORDERED SO THAT X(I) .LT. X(I+1) FOR        IBCC0190
C                           I=1,...,NX-1.                               IBCC0200
C                NX     - NUMBER OF ELEMENTS IN X. (INPUT) NX MUST BE   IBCC0210
C                           .GE. 4.                                     IBCC0220
C                Y      - VECTOR OF LENGTH NY. (INPUT) Y MUST BE        IBCC0230
C                           ORDERED SO THAT Y(J) .LT. Y(J+1) FOR        IBCC0240
C                           J=1,...,NY-1.                               IBCC0250
C                NY     - NUMBER OF ELEMENTS IN Y. (INPUT) NY MUST BE   IBCC0260
C                           .GE. 4.                                     IBCC0270
C                         NOTE - THE COORDINATE PAIRS (X(I),Y(J)), FOR  IBCC0280
C                           I=1,...,NX AND J=1,...,NY, GIVE THE POINTS  IBCC0290
C                           WHERE THE FUNCTION VALUES F(I,J) ARE        IBCC0300
C                           DEFINED.                                    IBCC0310
C                C      - ARRAY OF SPLINE COEFFICIENTS. (OUTPUT)        IBCC0320
C                           C IS OF DIMENSION 2 BY NX BY 2 BY NY.       IBCC0330
C                           AT THE POINT (X(I),Y(J))                    IBCC0340
C                             C(1,I,1,J) = S                            IBCC0350
C                             C(2,I,1,J) = DS/DX                        IBCC0360
C                             C(1,I,2,J) = DS/DY                        IBCC0370
C                             C(2,I,2,J) = D(DS/DX)/DY                  IBCC0380
C                           WHERE S(X,Y) IS THE SPLINE APPROXIMATION.   IBCC0390
C                           (NOTE - C IS TREATED INTERNALLY AS A        IBCC0400
C                             2 BY NX BY 2*NY ARRAY BECAUSE CERTAIN     IBCC0410
C                             ENVIRONMENTS DO NOT PERMIT QUADRUPLY-     IBCC0420
C                             DIMENSIONED ARRAYS.  IN THESE             IBCC0430
C                             ENVIRONMENTS THE CALLING PROGRAM MAY      IBCC0440
C                             DIMENSION C IN THE SAME MANNER.)          IBCC0450
C                IC     - ROW DIMENSION OF MATRIX F AND SECOND          IBCC0460
C                           DIMENSION OF ARRAY C EXACTLY AS             IBCC0470
C                           SPECIFIED IN THE DIMENSION STATEMENT.       IBCC0480
C                           (INPUT). IC MUST BE .GE. NX.                IBCC0490
C                WK     - WORK VECTOR OF LENGTH                         IBCC0500
C                           2*NX*NY+2*MAX(NX,NY)                        IBCC0510
C                IER    - ERROR PARAMETER. (OUTPUT)                     IBCC0520
C                         TERMINAL ERROR                                IBCC0530
C                           IER = 129, IC IS LESS THAN NX               IBCC0540
C                           IER = 130, NX IS LESS THAN 4                IBCC0550
C                           IER = 131, NY IS LESS THAN 4                IBCC0560
C                           IER = 132, X OR Y ARE NOT ORDERED SO THAT   IBCC0570
C                             X(I) .LT. X(I+1) AND                      IBCC0580
C                             Y(I) .LT. Y(I+1)                          IBCC0590
C                                                                       IBCC0600
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         IBCC0610
C                       - SINGLE/H36,H48,H60                            IBCC0620
C                                                                       IBCC0630
C   REQD. IMSL ROUTINES - IBCDCU,UERTST,UGETIO                          IBCC0640
C                                                                       IBCC0650
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           IBCC0660
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      IBCC0670
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  IBCC0680
C                                                                       IBCC0690
C   COPYRIGHT           - 1982 BY IMSL, INC. ALL RIGHTS RESERVED.       IBCC0700
C                                                                       IBCC0710
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN IBCC0720
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    IBCC0730
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        IBCC0740
C                                                                       IBCC0750
C-----------------------------------------------------------------------IBCC0760
C                                                                       IBCC0770
      SUBROUTINE IBCCCU (F,X,NX,Y,NY,C,IC,WK,IER)                       IBCC0780
C                                  SPECIFICATIONS FOR ARGUMENTS         IBCC0790
      INTEGER            NX,NY,IC,IER                                   IBCC0800
      DOUBLE PRECISION   F(IC,1),X(1),Y(1),C(2,IC,1),WK(1)              IBCC0810
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   IBCC0820
      INTEGER            IWK                                            IBCC0830
C                                  FIRST EXECUTABLE STATEMENT           IBCC0840
      IER = 129                                                         IBCC0850
      IF (IC .LT. NX) GO TO 9000                                        IBCC0860
      IER = 130                                                         IBCC0870
      IF (NX .LT. 4) GO TO 9000                                         IBCC0880
      IER = 131                                                         IBCC0890
      IF (NY .LT. 4) GO TO 9000                                         IBCC0900
      IWK = 2*NY*NX                                                     IBCC0910
      CALL IBCDCU(X,F,NX,NY,WK(IWK+1),WK,IC,NY,IER)                     IBCC0920
      IF (IER .GT. 0) GO TO 9000                                        IBCC0930
      CALL IBCDCU(Y,WK,NY,2*NX,WK(IWK+1),C,NY,2*IC,IER)                 IBCC0940
      IF (IER .EQ. 0) GO TO 9005                                        IBCC0950
 9000 CONTINUE                                                          IBCC0960
      CALL UERTST(IER,6HIBCCCU)                                         IBCC0970
 9005 RETURN                                                            IBCC0980
      END                                                               IBCC0990
C   IMSL ROUTINE NAME   - IBCDCU                                        IBCD0010
C                                                                       IBCD0020
C-----------------------------------------------------------------------IBCD0030
C                                                                       IBCD0040
C   COMPUTER            - VAX/DOUBLE                                    IBCD0050
C                                                                       IBCD0060
C   LATEST REVISION     - JUNE 1, 1982                                  IBCD0070
C                                                                       IBCD0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE IBCCCU IBCD0090
C                                                                       IBCD0100
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         IBCD0110
C                       - SINGLE/H36,H48,H60                            IBCD0120
C                                                                       IBCD0130
C   REQD. IMSL ROUTINES - NONE REQUIRED                                 IBCD0140
C                                                                       IBCD0150
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           IBCD0160
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      IBCD0170
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  IBCD0180
C                                                                       IBCD0190
C   COPYRIGHT           - 1982 BY IMSL, INC. ALL RIGHTS RESERVED.       IBCD0200
C                                                                       IBCD0210
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN IBCD0220
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    IBCD0230
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        IBCD0240
C                                                                       IBCD0250
C-----------------------------------------------------------------------IBCD0260
C                                                                       IBCD0270
      SUBROUTINE IBCDCU (TAU,GTAU,N,M,W,VS,IC1,IC2,IER)                 IBCD0280
C                                  SPECIFICATIONS FOR ARGUMENTS         IBCD0290
      INTEGER            N,M,IC1,IC2,IER                                IBCD0300
      DOUBLE PRECISION   TAU(N),GTAU(IC1,1),W(N,2),VS(IC2,2,1)          IBCD0310
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   IBCD0320
      INTEGER            I,JJ,JM1,JP1,J,K,LIM,LL,LP1,NM1                IBCD0330
      DOUBLE PRECISION   AA,BB,C1,C2,CC,DD,DTAU,G,H,RATIO,U,XILIM       IBCD0340
C                                  FIRST EXECUTABLE STATEMENT           IBCD0350
      LIM = N-3                                                         IBCD0360
      NM1 = N-1                                                         IBCD0370
      LP1 = LIM+1                                                       IBCD0380
      IER = 132                                                         IBCD0390
      W(2,1) = TAU(3)-TAU(1)                                            IBCD0400
      IF (W(2,1).LE.0.0D0) RETURN                                       IBCD0410
      DO 5 K=1,M                                                        IBCD0420
         VS(K,1,1) = GTAU(1,K)                                          IBCD0430
    5 CONTINUE                                                          IBCD0440
      XILIM = TAU(1)                                                    IBCD0450
      IF (LIM.LT.2) GO TO 20                                            IBCD0460
      XILIM = TAU(N-2)                                                  IBCD0470
      DO 15 I=2,LIM                                                     IBCD0480
         J = I+1                                                        IBCD0490
         W(J,1) = TAU(I+2)-TAU(J)                                       IBCD0500
         IF (W(J,1).LE.0.0D0) RETURN                                    IBCD0510
         DO 10 K=1,M                                                    IBCD0520
   10    VS(K,1,I) = GTAU(J,K)                                          IBCD0530
   15 CONTINUE                                                          IBCD0540
   20 W(LP1,1) = TAU(N)-XILIM                                           IBCD0550
      IF (W(LP1,1).LE.0.0D0) RETURN                                     IBCD0560
      DO 25 K=1,M                                                       IBCD0570
   25 VS(K,1,LP1) = GTAU(N,K)                                           IBCD0580
      DO 35 I=2,LP1                                                     IBCD0590
         DO 30 K=1,M                                                    IBCD0600
   30    VS(K,2,I) = (VS(K,1,I)-VS(K,1,I-1))/W(I,1)                     IBCD0610
   35 CONTINUE                                                          IBCD0620
      DTAU = TAU(2)-TAU(1)                                              IBCD0630
      RATIO = DTAU/W(2,1)                                               IBCD0640
      W(1,2) = (RATIO-1.D0)**2                                          IBCD0650
      W(1,1) = RATIO*(RATIO-1.D0)                                       IBCD0660
      C1 = RATIO*(2.D0*RATIO-3.D0)                                      IBCD0670
      DO 40 K=1,M                                                       IBCD0680
   40 VS(K,2,1) = (GTAU(2,K)-GTAU(1,K))/DTAU+VS(K,2,2)*C1               IBCD0690
      IF (LIM.LT.2) GO TO 55                                            IBCD0700
      DO 50 I=2,LIM                                                     IBCD0710
         J = I+1                                                        IBCD0720
         JJ = I-1                                                       IBCD0730
         G = -W(J,1)/W(JJ,2)                                            IBCD0740
         C1 = 3.D0*W(I,1)                                               IBCD0750
         C2 = 3.D0*W(J,1)                                               IBCD0760
         DO 45 K=1,M                                                    IBCD0770
   45    VS(K,2,I) = G*VS(K,2,JJ)+C1*VS(K,2,J)+C2*VS(K,2,I)             IBCD0780
         W(I,2) = G*W(JJ,1)+2.D0*(W(I,1)+W(J,1))                        IBCD0790
   50 CONTINUE                                                          IBCD0800
   55 DTAU = TAU(N-1)-XILIM                                             IBCD0810
      RATIO = DTAU/W(LP1,1)                                             IBCD0820
      G = -(RATIO-1.D0)**2/W(LIM,2)                                     IBCD0830
      W(LP1,2) = RATIO*(RATIO-1.D0)                                     IBCD0840
      C1 = RATIO*(2.D0*RATIO-3.D0)                                      IBCD0850
      DO 60 K=1,M                                                       IBCD0860
   60 VS(K,2,LP1) = (GTAU(N-1,K)-VS(K,1,LIM))/DTAU+VS(K,2,LP1)*C1       IBCD0870
      W(LP1,2) = G*W(LIM,1)+W(LP1,2)                                    IBCD0880
      DO 65 K=1,M                                                       IBCD0890
   65 VS(K,2,LP1) = (G*VS(K,2,LIM)+VS(K,2,LP1))/W(LP1,2)                IBCD0900
      J = LIM                                                           IBCD0910
   70 DO 75 K=1,M                                                       IBCD0920
   75 VS(K,2,J) = (VS(K,2,J)-W(J,1)*VS(K,2,J+1))/W(J,2)                 IBCD0930
      J = J-1                                                           IBCD0940
      IF (J.GT.0) GO TO 70                                              IBCD0950
      DO 95 K=1,M                                                       IBCD0960
         DO 85 JJ=1,N                                                   IBCD0970
            J = N+1-JJ                                                  IBCD0980
            JM1 = J-1                                                   IBCD0990
            IF (J.EQ.N) JM1 = J-2                                       IBCD1000
            IF (J.EQ.1) JM1 = J                                         IBCD1010
            DO 80 LL=1,2                                                IBCD1020
               VS(K,LL,J) = VS(K,LL,JM1)                                IBCD1030
   80       CONTINUE                                                    IBCD1040
   85    CONTINUE                                                       IBCD1050
         DO 90 J=2,NM1,LIM                                              IBCD1060
            JM1 = J-1                                                   IBCD1070
            JP1 = J+1                                                   IBCD1080
            IF (JM1.EQ.2) JM1 = 1                                       IBCD1090
            IF (JP1.EQ.NM1) JP1 = N                                     IBCD1100
            H = TAU(JP1)-TAU(JM1)                                       IBCD1110
            U = TAU(J)-TAU(JM1)                                         IBCD1120
            AA = VS(K,1,JM1)                                            IBCD1130
            BB = VS(K,2,JM1)                                            IBCD1140
            CC = (3.D0*(VS(K,1,JP1)-VS(K,1,JM1))/H-(VS(K,2,JP1)+        IBCD1150
     *      2.D0*VS(K,2,JM1)))/H                                        IBCD1160
            DD = (2.D0*(VS(K,1,JM1)-VS(K,1,JP1))/H+(VS(K,2,JP1)+        IBCD1170
     *      VS(K,2,JM1)))/H**2                                          IBCD1180
            VS(K,1,J) = AA+U*(BB+U*(CC+DD*U))                           IBCD1190
            VS(K,2,J) = BB+U*(2.D0*CC+3.D0*DD*U)                        IBCD1200
   90    CONTINUE                                                       IBCD1210
   95 CONTINUE                                                          IBCD1220
      IER = 0                                                           IBCD1230
      RETURN                                                            IBCD1240
      END                                                               IBCD1250
