C +++
C
C Source: src/lib/cputim.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: cputim.F
C Revision 1.5  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.4  91/04/05  13:54:17  cwelnak
C changed quotes on #include
C 
C Revision 1.3  91/03/22  12:07:49  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.2  90/11/13  14:04:47  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/10/31  13:31:36  khan
C Initial revision
C 
C
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

#if defined(vms)
C +++
C  THIS FUNCTION RETURNS THE ELAPSED CPU TIME SINCE
C  THE JOB WAS FIRST STARTED AS A REAL NUMBER OF SECONDS
C
C  IT USES THE GETJPI (GET JOB/PROCESS INFORMATION) 
C  SYSTEM SERVICE
C
C  THE SYMBOL JPI$_CPUTIM IS DEFINED IN THE $JPIDEF MACRO
C  IN THE SYSTEM MACRO LIBRARY [SYSLIB]STARLET.MLB
C
C ---
	FUNCTION CPUTIM

	PARAMETER JPI$_CPUTIM=1031

C ELAPSED CPU TIME IN 10 MILLISECOND UNITS
	INTEGER*4 ICPU
C ARGUMENT LIST FOR GETJPI SYSTEM SERVICE CALL
	INTEGER*4 ITMLST(4)
	INTEGER*2 WRDLST(8)
	EQUIVALENCE (ITMLST(1),WRDLST(1))
C INITIALIZE ARGUMENT LIST
	DATA WRDLST(1)/4/,WRDLST(2)/JPI$_CPUTIM/
	DATA ITMLST(3)/0/,ITMLST(4)/0/
	ITMLST(2)=%LOC(ICPU)

	CALL SYS$GETJPI(,,,ITMLST,,,)
	CPUTIM=FLOAT(ICPU)*.01
	RETURN
	END

#elif defined(rs6000)
	DOUBLE PRECISION FUNCTION CPUTIM ()
	INTEGER ITIME
C
	ITIME	= MCLOCK ()
	CPUTIM	= REAL(ITIME)*0.01
	RETURN
	END

#elif defined(G77)
	DOUBLE PRECISION FUNCTION CPUTIM ()
	INTEGER ITIME
C
	ITIME	= MCLOCK ()
	CPUTIM	= REAL(ITIME)*0.01
	RETURN
	END
#else

C#elif unix
	DOUBLE PRECISION FUNCTION CPUTIM ()
C	FUNCTION CPUTIM
C
	EXTERNAL ETIME
	REAL*4	TARRAY (2)
	REAL*4	ETIME
C
	CPUTIM  = ETIME (TARRAY)
	RETURN
	END
C
#endif
