dnl--------------------------------------------------------------------
dnl Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
dnl All rights reserved.
dnl
dnl You can use and distribute this software under the terms of the license
dnl you should have received along with this software.
dnl For a copy of the license or for additional information about this software,
dnl write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
dnl Email: obst@xcc-ka.de.
dnl--------------------------------------------------------------------
dnl aclocal.m4 - dietmar theobald - 11/9/93
dnl
dnl OBST autoconf: additional macros
dnl--------------------------------------------------------------------
dnl	This file is an input file used by the GNU "autoconf" program to
dnl	generate the file "configure", which is run during installation
dnl	to configure the system for the local environment.
dnl
dnl	As with autoconf itself, the generated configure script is free
dnl	software. Using the terms of the autoconf 2.1 license, the "data"
dnl	portions of this file are covered by the OBST license (see above).
dnl--------------------------------------------------------------------
dnl
AC_PREREQ(2.1)dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_USAGE(<module>,<inner>)
dnl	Expanded to the "-quoted definition of a (shell) variable 'usage'
dnl	which contains a help text for an OBST configure.in spec.
dnl	<inner> is expected to describe additional options.
dnl	AC_PROVIDE(OBST_ITSELF) is invoked, iff this is the configuration
dnl	file for the OBST core distribution itself.
dnl
dnl OBST_INIT_SCRIPT(<code>)
dnl	Contains code that initializes local variables of the configure
dnl	script.
dnl	The initialization of a standard autoconf variable will be
dnl	overwritten later on.
dnl....................................................................
define(OBST_USAGE,[dnl
AC_DIVERT_PUSH(AC_DIVERSION_NOTICE)dnl
OBST_VAR(usage)="
usage: configure [[--<option>[=<value>]]] ...

Set compilation and installation parameters for $1 using the GNU
autoconf system.
Besides the standard GNU configure options (see below), the following
options are recognized (there must be no white space in an option spec):
ifelse($2,,,[  ][$2])dnl
  --usage,--help        Print options and exit.
"
AC_DIVERT_POP()])dnl
dnl....................................................................
define(OBST_INIT_SCRIPT,
[AC_DIVERT_PUSH(AC_DIVERSION_NOTICE)dnl
$1
AC_DIVERT_POP()])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_DO_OPTS(<arglist>,<curr_opt>,<inner>)
dnl	The macro takes the standard OBST configuration options from
dnl	<arglist> and processes them. Each option is assigned to <curr_opt>
dnl	before processing it.
dnl	<arglist> must contain the original argument list passed to the
dnl	configure script (i.e. $*).
dnl	In particular, any substitution option contained in <arglist>
dnl	is processed via OBST_CONFFILE_OPT, OBST_SUBST_OPT, OBST_DEFINE_OPT,
dnl	and OBST_PREVENT_OPT, respectively.
dnl	<inner> is code to process additional options, whereby <inner> is
dnl	inside a `case' statement switching by '$<curr_opt>'.
dnl	It defines the variables '<.>defaultdirs' (as '$srcdir/include/etc'),
dnl	'<.>tmpf', and 'srcdir_abs' (absolute path of $srcdir).
dnl	If their counterparts $prefix and $exec_prefix are non-empty, the
dnl	variables $OBST_VAR(prefix) and $OBST_VAR(exec_prefix) are set to a
dnl	non-empty value.
dnl	In OBST applications, a rule for searching an installed OBST version
dnl	is added.
dnl
dnl OBST_FINISH_INIT()
dnl	Called in OBST_DO_OPTS. This is expanded after the standard
dnl	GNU argument loop and serves a) to add standard stuff to the body
dnl	of configure, and b) to pass on settings from the OBST argument loop
dnl	that were reset in the GNU loop.
dnl
dnl OBST_COPY_TOFROM_GNU()
dnl	For some standard GNU variables such as 'prefix':
dnl	. If not yet defined, and there was a substitution for them, assign
dnl	  the substitution value to the shell variable used by GNU.
dnl	. Otherwise, an OBST substitution with the current value of the GNU
dnl	  variable gets defined.
dnl....................................................................
define(OBST_DO_OPTS,[dnl
AC_DIVERT_PUSH(AC_DIVERSION_NOTICE)dnl
dnl OBST_VAR(defaultdirs)="./include/etc";OBST_VAR(tmpf)=/tmp/conf[$$]ig
OBST_VAR(opts_out)=; OBST_VAR(opts_saved)=""; OBST_VAR(opts_in)="$1"
verbose=; silent=
for OBST_VAR(o) in [$]OBST_VAR(opts_in) ""
do case "[$]OBST_VAR(o)" in
      --usage|--help) OBST_VAR(opts_in)=
		      OBST_VAR(opts_out)="--help"
		      echo "[$]OBST_VAR(usage)"
		      break;;
   esac
done
for $2 in [$]OBST_VAR(opts_in) ""
do
   case "[$]$2" in
      --silent|--silen|--sile|--sil|--si|--s|--quiet|--quie|--qui|--qu|--q|\
       -silent| -silen| -sile| -sil| -si| -s| -quiet| -quie| -qui| -qu| -q)
			    silent=yes
			    OBST_VAR(opts_out)="[$]OBST_VAR(opts_out) '--q'"
			    continue
			    ;;
      --verbose|--verbos|--verbo|--verb|--v|\
       -verbose| -verbos| -verbo| -verb| -v)
			    verbose=yes
			    OBST_VAR(opts_out)="[$]OBST_VAR(opts_out) '-v'"
			    continue
			    ;;
      --[define]:*=*)       OBST_DEFINE_OPT([$]$2)	;;
      --subst:*=*)          OBST_SUBST_OPT([$]$2)	;;
      --prevent:*)          OBST_PREVENT_OPT([$]$2)	;;
      --conf-file=*)	    OBST_CONFFILE_OPT([$]$2)	;;
$3
      '')		    ;;
      *)		    OBST_VAR(opts_out)="[$]OBST_VAR(opts_out) '[$]$2'"
			    continue
			    ;;
   esac
dnl #### prevent options from piling up, remove technical garbage
   case "[$]$2" in
      --conf-file=local.cnf | '') continue ;;
   esac
   OBST_VAR(opts_saved)="[$]OBST_VAR(opts_saved) '[$]$2'"
done
dnl #### save definitions (file gets cleared in AC_INIT; see OBST_OUTPUT)
test -s confdefs.h && cp confdefs.h [$]OBST_VAR(tmpf).defs
eval set - [$]OBST_VAR(opts_out) # "''"
dnl #### note: The above ensures that [$]* is properly set even if $opts_out
dnl ####       is empty. It requires that the GNU part ignores at least one
dnl ####       empty option string.
AC_DIVERT_POP()dnl
OBST_FINISH_INIT])dnl
dnl....................................................................
define(OBST_FINISH_INIT,
[AC_DIVERT_PUSH(AC_DIVERSION_INIT)dnl
dnl #### As far as `opts_saved' is concerned, this neglects the special
dnl #### processing of arguments done in configure.
ac_configure_args="[$]ac_configure_args [$]OBST_VAR(opts_saved)"
dnl
OBST_COPY_TOFROM_GNU
srcdir_abs="`(cd [$]srcdir; pwd | sed 's|/tmp_mnt||')`" AC_SUBST(srcdir_abs)
dnl #### Make sure all possibly required lib directories are really there (they
dnl #### were removed from the GNU distribution of OBST3-3.5 by the GNU
dnl #### administrators for no obvious reason).
test -d "[$]srcdir/lib"     || mkdir "[$]srcdir/lib"
test -d "[$]srcdir/lib/pic" || mkdir "[$]srcdir/lib/pic"
dnl #### Here starts the standard stuff to be provided in
dnl #### each configure body.
dnl #### Always provide the @SET_MAKE@ substitution
if test -n "[$]OBST_VAR(SET_MAKE)"
then SET_MAKE="[$]OBST_VAR(SET_MAKE)"
else AC_PROG_MAKE_SET OBST_VAR(SET_MAKE)=_ ; fi
AC_DIVERT_POP()])dnl
dnl....................................................................
define(OBST_COPY_TOFROM_GNU,[dnl
for OBST_VAR(vnm) in prefix exec_prefix
do if test "`eval echo '\[$]'[$]OBST_VAR(vnm)`" = NONE; then
      if OBST_VAR_DEFINED(OBST_VAR([$]OBST_VAR(vnm))); then
         eval "[$]OBST_VAR(vnm)='`eval echo '\[$]'OBST_VAR([$]OBST_VAR(vnm))`'"
      fi
   else
      eval "OBST_VAR([$]OBST_VAR(vnm))='`eval echo '\[$]'[$]OBST_VAR(vnm)`'"
   fi
done
])dnl
dnl--------------------------------------------------------------------
dnl OBST_OUTPUT(<file>...,<add_commands>=NULL)
dnl	Variant of AC_OUTPUT(<file>...) which accounts for OBST_SUBST.
dnl	If the 2nd argument is defined, its contents are appended to
dnl	config.status.
dnl	Any files with pathprefix $<.>tmpf are removed.
dnl	If OBST_OUTPUT_NAMES is defined, then the first argument is ignored
dnl	and the value of OBST_OUTPUT_NAMES is used instead.
dnl
dnl OBST_SED(<file>,<cmds>)
dnl	Applies sed commands <cmds> to <file>.
dnl
dnl OBST_SCRIPTS(<file>...)
dnl	For all files in the (whitespace separated) argument list: they are
dnl	made executable.
dnl
dnl	*** OBST_SED, OBST_SCRIPTS must be used as arguments to OBST_OUTPUT.
dnl....................................................................
define(OBST_OUTPUT,[dnl
dnl #### copy definitions back (see OBST_DO_OPTS)
test -s [$]OBST_VAR(tmpf).defs && cat [$]OBST_VAR(tmpf).defs >>confdefs.h
OBST_COPY_TOFROM_GNU
OBST_IF_PROVIDED([OBST_SUBST],[dnl
AC_DIVERT_PUSH(AC_DIVERSION_SED)dnl
[$]OBST_SUBST_VAR
AC_DIVERT_POP()dnl
])dnl
AC_OUTPUT(ifdef([OBST_OUTPUT_NAMES],[OBST_OUTPUT_NAMES],[$1]),
OBST_VAR(tmpf)=/tmp/conf[$$]ig
[$2]
rm -rf [$]OBST_VAR(tmpf)*)dnl
rm -rf [$]OBST_VAR(tmpf)*
])dnl
dnl....................................................................
define(OBST_SED,[dnl
cp $1 [$]OBST_VAR(tmpf);rm -f $1;sed $2 [$]OBST_VAR(tmpf) >$1
])dnl
dnl....................................................................
define(OBST_SCRIPTS,[chmod a+x $1])dnl
dnl--------------------------------------------------------------------
dnl OBST_ANNOUNCE(<msg>)
dnl	Print the given information on steps configure does/is going to do.
dnl
dnl OBST_RESULT(<msg>)
dnl	Print the given message as a result of the current/previous
dnl	configuration step.
dnl
dnl OBST_REPORT_ASSIGN(<variable-name>,<value>==$<variable_name>)
dnl	Report the assignment <variable-name>=$<value>, respecting the
dnl	--verbose option.
dnl	<value> defaults to $<variable-name> if omitted.
dnl
dnl OBST_REPORT_DEFINITION(<variable-name>,<value>==$<variable_name>)
dnl	Report the definition <variable-name>=$<value>, respecting the
dnl	--verbose option.
dnl	<value> defaults to $<variable-name> if omitted.
dnl
dnl OBST_REPORT_PREVENT(<variable-name>)
dnl	Report a prevent declaration for <variable-name>, respecting the
dnl	--verbose option.
dnl
dnl OBST_WARN(<msg>)
dnl	Print the given warning.
dnl....................................................................
define(OBST_ANNOUNCE,
test -n "[$]silent" || echo $1)dnl
define(OBST_RESULT,
test -z "[$]verbose" || echo $1)dnl
define(OBST_REPORT_ASSIGN,
test -z "[$]verbose" || echo "	setting $1 to \"[ifelse($2,,[$]$1,$2)]\"")dnl
define(OBST_REPORT_DEFINITION,
test -z "[$]verbose" || echo "	defining $1 as \"[ifelse($2,,[$]$1,$2)]\"")dnl
define(OBST_REPORT_PREVENT,
test -z "[$]verbose" || echo "	blocking definitions for $1")dnl
define(OBST_WARN,echo >&2 "*** WARNING:" $1)dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_WS(), OBST_ID(), OBST_SHID()
dnl 	Utility constants for sed expressions: white space, identifier,
dnl 	shell variable name.
dnl....................................................................
define(OBST_WS,[[[ 	]*]])dnl
define(OBST_ID,[[[-+_.A-Za-z][-+_.A-Za-z0-9]*]])dnl
define(OBST_SHID,[[[_A-Za-z][_A-Za-z0-9]*]])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_GETVAL(<assgn>,<assgn-char>=='=')
dnl	Parses an "...<assgn-char><value>" string and yields <value>.
dnl
dnl OBST_GET_DEFINE(<name>,<file>)
dnl	Parses <file> and yields the value of '#define <name>'.
dnl
dnl OBST_GET_MACRO(<name>,<file>)
dnl	Parses <file> and yields the value of '<name> = <val>'.
dnl
dnl OBST_LSTRIP(<str>,<strip-expr>,<add-sed-cmds>==NULL)
dnl	Yields <str> after stripping the leftmost part (optionally)
dnl	matched by <strip-expr>.
dnl	If present, the additional sed expressions are applied before
dnl	returning <str>.
dnl
dnl OBST_VARPREFIX()
dnl	Yields a prefix which is employed to create a `separate` name space,
dnl	in particular for the variables used in OBST_SUBST, OBST_DEFINE.
dnl
dnl OBST_VAR(<name>)
dnl	Prepends OBST_VARPREFIX to <name>.
dnl
dnl OBST_VARNAME(<name>)
dnl	yields <name> where all characters except for A-Z,a-z,0-9 are
dnl	replaced by '_'.
dnl
dnl OBST_VAR_DEFINED(<name>)
dnl	Tests whether the shell variable <name> is already defined.
dnl
dnl OBST_WITHOPT(<opt>,<val>)
dnl	Transforms an option '--with*-<nm>' into the assignment of
dnl	<val> to the (shell) variable 'with_<nm>', whereby all
dnl	occurences of '-' in <nm> have been replaced by '_'.
dnl
dnl OBST_CONFFILE_OPT(<opt>)
dnl	Invokes OBST_CONFFILE(<file>) for an option '*=<file>'.
dnl
dnl OBST_CONF_OPT(<opt>,<macro>)
dnl	Auxiliary definition for performing OBST_DEFINE_OPT, OBST_SUBST_OPT.
dnl
dnl OBST_DEFINE_OPT(<opt>)
dnl	Parses an '--define:<nm>=<txt>' option and issues
dnl	OBST_DEFINE(<nm>,<txt>).
dnl
dnl OBST_SUBST_OPT(<opt>)
dnl	Parses an '--subst:<nm>=<txt>' option and issues
dnl	OBST_SUBST(<nm>,<txt>).
dnl
dnl OBST_PREVENT_OPT(<opt>)
dnl	Parses an '--prevent:<nm>' option and issues OBST_PREVENT(<nm>).
dnl....................................................................
define(OBST_GETVAL,[`echo "$1" | sed 's|[[[^=]]]*=\(.*\)|\1|'`])dnl
dnl....................................................................
define(OBST_GET_DEFINE,[dnl
`sed -n -e 's|^[#]OBST_WS[define]OBST_WS[$1]OBST_WS\(.*\)|\1|p' $2`])dnl
dnl....................................................................
define(OBST_GET_MACRO,[dnl
`sed -n -e 's|^OBST_WS[$1]OBST_WS=OBST_WS\(.*\)|\1|p' $2`])dnl
dnl....................................................................
define(OBST_LSTRIP,`echo "$1" | sed 's|^$2||[ifelse($3,,,;[$3])]'`)dnl
dnl....................................................................
define(OBST_VARPREFIX,__)dnl
dnl....................................................................
define(OBST_VAR,OBST_VARPREFIX$1)dnl
dnl....................................................................
define(OBST_VARNAME,[`echo "$1" | sed 's|[[[^A-Za-z0-9]]]|_|g'`])dnl
dnl....................................................................
define(OBST_VAR_DEFINED,[changequote(,)dnl
[ -n "`eval echo '${'"$1"'+.}'`" ]changequote([,])])dnl
dnl....................................................................
define(OBST_WITHOPT,[dnl
OBST_VAR(o)="OBST_LSTRIP($1,--[[[a-z]]]*-,s|[[[^A-Za-z0-9]]]|_|g)"
eval "with_[$]OBST_VAR(o)='$2'"])dnl
dnl....................................................................
define(OBST_CONFFILE_OPT,
[OBST_CONFFILE(OBST_GETVAL($1))])dnl
dnl....................................................................
define(OBST_CONF_OPT,[dnl
eval `echo "$1" | [sed -n 's|^[^:]*:\([^=]*\)=\(.*\)|]OBST_VAR(n)="\1";OBST_VAR(v)="\2"|p'`
$2([$]OBST_VAR(n),[$]OBST_VAR(v))dnl
])dnl
dnl....................................................................
define(OBST_SUBST_OPT,[OBST_CONF_OPT([$1],[OBST_SUBST])])dnl
dnl....................................................................
define(OBST_DEFINE_OPT,[OBST_CONF_OPT([$1],[OBST_DEFINE])])dnl
dnl....................................................................
define(OBST_PREVENT_OPT,[changequote(,)dnl
eval `echo "$1" | sed -n 's|^[^:]*:\(.*\)|OBST_VAR(n)="\1"|p'`
changequote([,])dnl
OBST_PREVENT([$]OBST_VAR(n))])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_FILE_SEARCH(<variable>, <file>, <dirs>, <pref> = "", <suff> = "")
dnl	Search <file> in the whitespace separated list of directories
dnl	<dirs>.
dnl	<variable> is initialized to "" and set to "<pref><dir><suff>"
dnl	for the first directory <dir> containing <file>.
dnl	<pref> and <suff> must be quoted if these are literal strings.
dnl	If no such directory can be found, a warning message is issued.
dnl....................................................................
define(OBST_FILE_SEARCH,[dnl
$1=;for OBST_VAR(d) in $3
changequote(,)dnl
do for OBST_VAR(f) in $OBST_VAR(d)/$2
   do [ -r "$OBST_VAR(f)" ] && { $1=$4"$OBST_VAR(d)"$5; break 2; }
   done
done
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_FILE_CHECK(<variable>, <file>, <dirs>, <pref> = "", <suff> = "")
dnl
dnl Like OBST_FILE_SEARCH, plus:
dnl  o a warning message is issued, if <file> is not found.
dnl  o an OBST_SUBST call is issued for <variable>.
dnl....................................................................
define(OBST_FILE_CHECK,[dnl
OBST_FILE_SEARCH($1,$2,$3,$4,$5)
changequote(,)dnl
[ -n "$$1" ] || changequote([,])OBST_WARN("couldn't find \"$2\" in \"$3\"")
OBST_SUBST($1,$$1)dnl
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_IF_PROVIDED(<macro>,<if-true>,<if-false>)
dnl	Variant of `ifdef' which tests, if AC_PROVIDE(<macro>) has been
dnl	executed.
dnl....................................................................
define(OBST_IF_PROVIDED,[ifdef([AC_PROVIDE_$1],[$2],[$3])])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_QUOTE
dnl	?????
dnl
dnl OBST_SUBST_VAR()
dnl	Name of the variable used for accumulating substitutions.
dnl
dnl OBST_SUBST(<original>,<replacement>,no_check==NULL)
dnl	Variant of AC_SUBST for the case when <original> is not known
dnl	until `configure' gets executed.
dnl	If the third argument is null, the substitution is only
dnl	performed if the shell variable <original'> is not yet defined,
dnl	whereby <original'> is <original> with all characters except for
dnl	A-Z,a-z,0-9 replaced by '_' and prepended by OBST_VARPREFIX.
dnl	In case the substitution is performed, <original'> is set to
dnl	<replacement>.
dnl	If required, '-quotes must be used for <replacement> (no "-quotes).
dnl
dnl OBST_DEFINE(<name>,<value>,no_check==NULL)
dnl	Variant of AC_DEFINE_UNQUOTED analogous to OBST_SUBST: if the
dnl	third argument is null, the definition is only performed if
dnl	<name'> is not yet set and <name'> is then set to <value>.
dnl
dnl *** note: substitutions defined earlier take precedence over later ones!
dnl
dnl *** AC_CONFIG_HEADER must be defined in order for this macro to work.
dnl	note: Therefore, AC_CONFIG_HEADER is called in OBST_INIT.
dnl
dnl OBST_PREVENT(<name>,no_check==NULL)
dnl	Prevents a later definition for <name> by setting <name'> to an
dnl	arbitrary non-empty string. If the 2nd argument is null, this is
dnl	only done if <name'> is not yet set.
dnl....................................................................
define(OBST_QUOTE,
`echo "$1='$2'"|sed "s%=''\(.\)%=\"'\"'\1%;s%\([[[^=]]]\)''\[$]%\1'\"'\"%"`)dnl
dnl....................................................................
define(OBST_SUBST_VAR,OBST_VAR(addsubst))dnl
dnl....................................................................
define(OBST_SUBST,[dnl
ifelse($3,,[dnl
OBST_VAR(vnm)="OBST_VAR(OBST_VARNAME($1))";OBST_VAR_DEFINED([$]OBST_VAR(vnm))||])dnl
changequote(`,')dnl
{ [ -z "$OBST_SUBST_VAR`_'" ] || OBST_SUBST_VAR="$OBST_SUBST_VAR
"
OBST_SUBST_VAR="${OBST_SUBST_VAR}s%@$1@%$2%g";OBST_SUBST_VAR`_'=+
changequote([,])OBST_REPORT_ASSIGN($1,$2)
ifelse($3,,eval [OBST_QUOTE([$]OBST_VAR(vnm),$2)];)}
AC_PROVIDE([$0])])dnl
dnl....................................................................
define(OBST_DEFINE,
[ifelse($3,,[dnl
OBST_VAR(vnm)="OBST_VAR(OBST_VARNAME($1))";OBST_VAR_DEFINED([$]OBST_VAR(vnm))||])dnl
{ AC_DEFINE_UNQUOTED($1,$2)
ifelse($3,,eval [OBST_QUOTE([$]OBST_VAR(vnm),$2)])
OBST_REPORT_DEFINITION($1,$2)
}])dnl
dnl....................................................................
define(OBST_PREVENT,[dnl
ifelse($2,,[dnl
OBST_VAR(vnm)="OBST_VAR(OBST_VARNAME($1))";OBST_VAR_DEFINED([$]OBST_VAR(vnm))|| ])dnl
{ eval "[$]OBST_VAR(vnm)=''"; OBST_REPORT_PREVENT($1) ;}])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_CONFFILE(<file>...)
dnl	If <name'> (see below) is not yet defined, <name>=<value>,
dnl	<name>:<value> pairs are read from the given files and the
dnl	according substitutions/definitions are defined via OBST_SUBST,
dnl	OBST_DEFINE, and OBST_PREVENT, respectively.
dnl	Additionally, the shell variable <name'> is set to <value>,
dnl	whereby <name'> is <name> with all characters except for A-Z,a-z,0-9
dnl	replaced by '_' and prepended by OBST_VARPREFIX.
dnl	Files which are not readable are reported and then discarded.
dnl	If a file is not found, it is searched in $<.>defaultdirs.
dnl
dnl *** note: substitutions/definitions defined earlier take precedence!
dnl....................................................................
define(OBST_CONFFILE,[dnl
OBST_VAR(fs)=
for OBST_VAR(f) in $1 ""
changequote(,)dnl
do if [ -r "$OBST_VAR(f)" ]; then
      OBST_VAR(fs)="$OBST_VAR(fs) $OBST_VAR(f)"
   elif [ "$OBST_VAR(f)" != "" ]; then
      OBST_VAR(_f)=
      for OBST_VAR(d) in $OBST_VAR(defaultdirs)
      do [ -r "$OBST_VAR(d)/$OBST_VAR(f)" ] && OBST_VAR(_f)="$OBST_VAR(d)/$OBST_VAR(f)"
      done
      if [ -n "$OBST_VAR(_f)" ]; then
changequote([,])dnl
	 OBST_VAR(fs)="[$]OBST_VAR(fs) [$]OBST_VAR(_f)"
      else
	 OBST_WARN("file \"[$]OBST_VAR(f)\" not found")
      fi
   fi
done
OBST_ANNOUNCE("processing configuration file(s)[$]OBST_VAR(fs)")
sed -n "s|^OBST_WS\(!\)OBST_WS\(OBST_ID\).*|\2 \1 _|p
s|^OBST_WS\([with-]OBST_ID\)OBST_WS\[$]|\1 + yes|p
s|^OBST_WS\([enable-]OBST_ID\)OBST_WS\[$]|\1 + yes|p
s|^OBST_WS\([with-]OBST_ID\)OBST_WS[=]OBST_WS\(.*\)|\1 + \2|p
s|^OBST_WS\([enable-]OBST_ID\)OBST_WS[=]OBST_WS\(.*\)|\1 + \2|p
s|^OBST_WS\(OBST_ID\)OBST_WS\([[=:]]\)OBST_WS\(.*\)|\1 \2 \3|p" [$]OBST_VAR(fs) /dev/null\
| { while read name sep val
    do
       vname="]OBST_VARNAME([$]name)["
       if test '+' = "[$]sep"; then
	  OBST_REPORT_ASSIGN([$]vname,[$]val)
	  OBST_VAR(c)=OBST_QUOTE([$]vname,[$]val)
	  echo "[$]OBST_VAR(c)" >> [$]OBST_VAR(tmpf)
       else
	  OBST_VAR_DEFINED(OBST_VAR([$]vname)) || {
	     case "[$]sep" in
	        =) OBST_SUBST([$]name,[$]val,__no-check__) ;;
	        :) OBST_DEFINE([$]name,[$]val,__no-check__);;
		!) OBST_REPORT_PREVENT([$]name); val=      ;;
	     esac
	     OBST_VAR(c)=OBST_QUOTE(OBST_VAR([$]vname),[$]val)
	     echo "[$]OBST_VAR(c)" >> [$]OBST_VAR(tmpf); eval "[$]OBST_VAR(c)"
	  }
       fi
    done
    echo "OBST_SUBST_VAR='[$]OBST_SUBST_VAR'
OBST_SUBST_VAR[_]=[$]OBST_SUBST_VAR[_]
DEFS='[$]DEFS'" >> [$]OBST_VAR(tmpf)
  }
eval "`cat [$]OBST_VAR(tmpf)`"
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_EXPAND_INSTMACROS()
dnl	Defines substitutions for the expanded versions of @libdir@,
dnl	@cntdir@, @tcllibdir@, and @includedir@, which are named @libdir_exp@,
dnl	@cntdir_exp@, @tcllibdir_exp@, and @includedir_exp@, respectively.
dnl....................................................................
define(OBST_EXPAND_INSTMACROS,[dnl
OBST_COPY_TOFROM_GNU
echo > [$]OBST_VAR(tmpf) "
prefix=[$]prefix
exec_prefix=[$]exec_prefix
cntdir=[$]OBST_VAR(cntdir)
libdir=[$]OBST_VAR(libdir)
tcllibdir=[$]OBST_VAR(tcllibdir)
includedir=[$]OBST_VAR(includedir)
_dummy_target: ;@echo 'OBST_VAR(libdir_exp)=\[$](libdir);OBST_VAR(cntdir_exp)=\[$](cntdir);OBST_VAR(tcllibdir_exp)=\[$](tcllibdir);OBST_VAR(includedir_exp)=\[$](includedir)'"
eval `make -f [$]OBST_VAR(tmpf) 2>/dev/null`
OBST_SUBST(libdir_exp,[$]OBST_VAR(libdir_exp),__no-check__)dnl
OBST_SUBST(cntdir_exp,[$]OBST_VAR(cntdir_exp),__no-check__)dnl
OBST_SUBST(tcllibdir_exp,[$]OBST_VAR(tcllibdir_exp),__no-check__)dnl
OBST_SUBST(includedir_exp,[$]OBST_VAR(includedir_exp),__no-check__)])dnl
dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_DIRNAME(<path>)
dnl	Strips the last part from <path>.
dnl....................................................................
define(OBST_DIRNAME,[changequote(,)dnl
`echo $1|sed 's|/[^/]*$||'`dnl
changequote([,])])dnl
dnl
dnl "EXTENDED" FORTRAN. This is the kind that accepts .F files and
dnl pre-processes the files before actually compiling it.
dnl
dnl CXRL_LANG_EXT_FORTRAN()
AC_DEFUN(CXRL_LANG_EXT_FORTRAN,
[define([AC_LANG], [EXT_FORTRAN])dnl
ac_ext=F
ac_cpp='echo $FC_CPP -D__DUMMY_CPP_DEFINE__ $CPPFLAGS 1>&AC_FD_CC;
$FC_CPP $CPPFLAGS'
ac_compile='echo ${FC-f77} -c -D__DUMMY_CPP_DEFINE__ $FFLAGS $CPPFLAGS fconftest.$ac_ext 1>&AC_FD_CC;
${FC-f77} -c -D__DUMMY_CPP_DEFINE__ $FFLAGS $CPPFLAGS fconftest.$ac_ext 1>&AC_FD_CC 2>&AC_FD_CC'
ac_link='echo ${FC-f77} -o conftest $FFLAGS $CPPFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC;
${FC-f77} -o conftest $FFLAGS $CPPFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC 2>&AC_FD_CC'
])
dnl
dnl FORTRAN 77. This is the kind that accepts .f files. 
dnl
dnl CXRL_LANG_FORTRAN()
AC_DEFUN(CXRL_LANG_FORTRAN,
[define([AC_LANG], [FORTRAN])dnl
ac_ext=f
ac_cpp='echo No CPP defined for .f files;'
ac_compile='echo ${FC-f77} -c $FFLAGS fconftest.$ac_ext 1>&AC_FD_CC;
${FC-f77} -c $FFLAGS fconftest.$ac_ext 1>&AC_FD_CC 2>&AC_FD_CC'
ac_link='echo ${FC-f77} -o conftest $FFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC;
${FC-f77} -o conftest $FFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC 2>&AC_FD_CC'
])


dnl CXRL_TRY_F77_COMPILE(SUBROUTINE-BODY,
dnl             [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_TRY_F77_COMPILE,
[
AC_LANG_SAVE
CXRL_LANG_FORTRAN
cat > fconftest.$ac_ext <<EOF
        program conftest
       	stop
       	end
c
c test subroutine.
c       	
        subroutine tsub
        [$1]
       	return
       	end
EOF
if AC_TRY_EVAL(ac_compile); then
  ifelse([$2], , :, [rm -rf fconftest*
  $2])
ifelse([$3], , , [else
  rm -rf fconftest*
  $3
])dnl
fi
AC_LANG_RESTORE
rm -f fconftest*]
)

dnl CXRL_TRY_F77_LINK(SUBROUTINE-BODY,
dnl             [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_TRY_F77_LINK,
[
AC_LANG_SAVE
CXRL_LANG_FORTRAN
cat > fconftest.$ac_ext <<EOF
        program conftest
       	stop
       	end
c
c test subroutine.
c       	
        subroutine tsub
        [$1]
       	return
       	end
EOF
if AC_TRY_EVAL(ac_link); then
  ifelse([$2], , :, [rm -rf fconftest*
  $2])
ifelse([$3], , , [else
  rm -rf fconftest*
  $3
])dnl
fi
AC_LANG_RESTORE
rm -f fconftest*]
)


dnl CXRL_CHECK_BRAINDEAD_FC_DRIVER([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_CHECK_BRAINDEAD_FC_DRIVER,
[
AC_LANG_SAVE
CXRL_LANG_EXT_FORTRAN
# check for braindead FORTRAN compiler driver.
#
# create the include file and such things
#
rm -rf fconftest*
cat > fconftest.inc << EOF
c
c this is a FORTRAN header.
c
#if unix
c
c unix comments.
c
#elif vms
c
c vms comments.
c
#elif mac
c
c MAC comments.
c
#endif
EOF
cat > fconftest.$ac_ext <<EOF
#include "fconftest.inc"
        program fconftest
       	stop
       	end
c
c test subroutine.
c       	
        subroutine tsub
        call foosub
       	return
       	end
EOF
cxrl_nm_check='(${NM-nm} fconftest.o | grep -i foosub) 1>&AC_FD_CC 2>&AC_FD_CC'
if eval $ac_compile && eval $cxrl_nm_check; then
  ifelse([$1], , :, [rm -rf fconftest*
  $1])
ifelse([$2], , , [else
  rm -rf fconftest*
  $2
])dnl
fi
AC_LANG_RESTORE
rm -f fconftest*]
)

dnl ### Checking for FORTRAN library functions


dnl CXRL_CHECK_F77_SUBROUTINE(SUBROUTINE, DECL, SUBROUTINE-ARGS,
dnl		[ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_CHECK_F77_SUBROUTINE,
[AC_MSG_CHECKING([for F77 SUBROUTINE $1])
AC_CACHE_VAL(cxrl_cv_f77_func_$1,
[CXRL_TRY_F77_LINK([
	$2
	call $1($3)
],
  eval "cxrl_cv_f77_funcc_$1=yes", eval "cxrl_cv_f77_funcc_$1=no")])dnl
if eval "test \"`echo '$cxrl_cv_f77_funcc_'$1`\" = yes"; then
  AC_MSG_RESULT(yes)
  ifelse([$4], , :, [$4])
else
  AC_MSG_RESULT(no)
ifelse([$5], , , [$5
])dnl
fi
])

