#
#	$Id: domakefile.tcl,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
#
#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

# Tis program is used to generate the Makefile.in files for building Unix
# binaries.
#

source [file join [file dirname [info script]] doxx.tcl]

p {
# Makefile --
#
# This file is a Makefile to compile Tix with Tk version
# @@_V_TK_VER_@@. If it has the name "Makefile.in" then it is a
# template for a Makefile; to generate the actual Makefile, run
# "./configure", which is a configuration script generated by the
# "autoconf" program (constructs like "@foo@" will get replaced in the
# actual Makefile.

#----------------------------------------------------------------
# Things you can change to personalize the Makefile for your own
# site (you can make these changes in either Makefile.in or
# Makefile, but changes to Makefile will get lost if you re-run
# the configuration script).
#----------------------------------------------------------------

# Default top-level directories in which to install architecture-
# specific files (exec_prefix) and machine-independent files such
# as scripts (prefix).  The values specified here may be overridden
# at configure-time with the --exec-prefix and --prefix options
# to the "configure" script.

prefix      = @prefix@
exec_prefix = @exec_prefix@
TIX_VERSION = @TIX_VERSION@

@SET_MAKE@

# Directory in which to install the library of Tix scripts and demos
# (note: you can set the TIX_LIBRARY environment variable at run-time to
# override the compiled-in location):
TIX_LIBRARY =	$(prefix)/lib/tix$(TIX_VERSION)

# Directory in which to install the archive libtix.a:
LIB_DIR =	$(exec_prefix)/lib
LIB_INSTALL_DIR = $(LIB_DIR)
LIB_RUNTIME_DIR = $(LIB_DIR)

# Directory in which to install the program tixwish:
BIN_DIR =	$(exec_prefix)/bin

# To change the compiler switches, for example to change from -O
# to -g, change the following line:
CFLAGS = -O

# To disable ANSI-C procedure prototypes reverse the comment characters
# on the following lines:
PROTO_FLAGS =
#PROTO_FLAGS = -DNO_PROTOTYPE

# To enable memory debugging reverse the comment characters on the following
# lines. Warning: if you enable memory debugging, you must do it
# *everywhere*, including all the code that calls Tcl, and you must use
# ckalloc and ckfree everywhere instead of malloc and free.
MEM_DEBUG_FLAGS =
#MEM_DEBUG_FLAGS = -DTCL_MEM_DEBUG

# Some versions of make, like SGI's, use the following variable to
# determine which shell to use for executing commands:
SHELL =		/bin/sh
}

p74 {
# Location of the Tcl @@_V_TCL_VER_@@ source directory.
#
TCL_SRC_DIR     = @TCL_SRC_DIR@

# Location of the Tk @@_V_TK_VER_@@ source directory.
#
TK_SRC_DIR      = @TK_SRC_DIR@

# A "-I" switch that can be used when compiling to make all of the
# X11 include files accessible (the configure script will try to
# set this value, and will cause it to be an empty string if the
# include files are accessible via /usr/include).
X11_INCLUDES =	@XINCLUDES@

# Linker switch(es) to use to link with the X11 library archive (the
# configure script will try to set this value automatically, but you
# can override it).
X11_LIB_SWITCHES = @XLIBSW@

# Libraries to use when linking:  must include at least Tix, Tcl, Xlib,
# and the math library (in that order).  The "@LIBS@" part will be
# replaced (or has already been replaced) with relevant libraries as
# determined by the configure script.
LIBS = @ITK_BUILD_LIB_SPEC@ @ITCL_BUILD_LIB_SPEC@ \\
    $(TK_SRC_DIR)/libtk.a $(TCL_SRC_DIR)/libtcl.a \
    $(X11_LIB_SWITCHES) @LIBS@ @MATH_LIBS@

# Libraries for building a stand-alone Tclsh.
#
LIBS_TCLONLY = $(TCL_SRC_DIR)/libtcl.a @LIBS@ @MATH_LIBS@

RUN_TCLSH	= TCL_LIBRARY=$(TCL_SRC_DIR)/library \\
		  TK_LIBRARY=$(TK_SRC_DIR)/library \\
	          $(TCL_SRC_DIR)/tclsh
}

p75+ {
# Location of the Tcl @@_V_TCL_VER_@@ source directory.
#
TCL_SRC_DIR     = @TCL_SRC_DIR@
TCL_GENERIC_DIR = $(TCL_SRC_DIR)/generic

# Location of the Tk @@_V_TK_VER_@@ source directory.
#
TK_SRC_DIR      = @TK_SRC_DIR@
TK_GENERIC_DIR  = $(TK_SRC_DIR)/generic

# Libraries to use when linking:
LIBS = @ITK_BUILD_LIB_SPEC@ @ITCL_BUILD_LIB_SPEC@ \\
    @TK_BUILD_LIB_SPEC@ @TCL_BUILD_LIB_SPEC@ @TK_LIBS@

# Libraries for building a stand-alone Tclsh.
#
LIBS_TCLONLY = @TCL_BUILD_LIB_SPEC@ @TCL_LIBS@

RUN_TCLSH	= TCL_LIBRARY=$(TCL_SRC_DIR)/library \\
		  TK_LIBRARY=$(TK_SRC_DIR)/library \\
	          $(TCL_SRC_DIR)/unix/tclsh
}

pitcl {
# Location of the ITcl @@_V_ITCL_VER_@@ root directory.
#
ITCL_ROOT_DIR   = @ITCL_ROOT_DIR@
ITCL_SRC_DIR    = $(ITCL_ROOT_DIR)/itcl
ITK_SRC_DIR     = $(ITCL_ROOT_DIR)/itk
}

p {

#----------------------------------------------------------------
# The information below is modified by the configure script when
# Makefile is generated from Makefile.in.  You shouldn't normally
# modify any of this stuff by hand.
#----------------------------------------------------------------
}

p {
CC		 = @CC@
}

p75+ {
SHLIB_CFLAGS	 = @SHLIB_CFLAGS@
SHLIB_LD	 = @SHLIB_LD@
SHLIB_SUFFIX	 = @SHLIB_SUFFIX@
SHLIB_VERSION	 = @SHLIB_VERSION@
TIX_SHLIB_CFLAGS = @TIX_SHLIB_CFLAGS@
TK_XINCLUDES     = @TK_XINCLUDES@
}

if !$ITCL {
    p {
ITCL_EXT =
    }
} else {
    p {
ITCL_EXT = .1
    }
}

p {
SRC_DIR		 = @TIX_SRC_DIR@
GENERIC_DIR	 = $(SRC_DIR)/generic
UNIX_DIR	 = $(SRC_DIR)/unix
AC_FLAGS	 = @DEFS@ @TIX_DEFS@
RANLIB		 = @RANLIB@
INSTALL		 = @TIX_SRC_DIR@/install.sh -c
INSTALL_PROGRAM  = @INSTALL_PROGRAM@
INSTALL_DATA	 = @INSTALL_DATA@

TIX_LIB_FILE     = @TIX_LIB_FILE@
TIX_EXE_FILE     = @TIX_EXE_FILE@
TCL_SAM_FILE	 = @TCL_SAM_FILE@
TK_SAM_FILE	 = @TK_SAM_FILE@
TIX_SAM_FILE	 = @TIX_SAM_FILE@
TCL_SAMEXE_FILE	 = @TCL_SAMEXE_FILE@
TK_SAMEXE_FILE	 = @TK_SAMEXE_FILE@
TIX_SAMEXE_FILE	 = @TIX_SAMEXE_FILE@

INST_EXE         = $(TIX_EXE_FILE)$(TIX_VERSION).@@_V_TCL_VER_@@$(ITCL_EXT)
INST_TIX_SAMEXE  = $(TIX_SAMEXE_FILE)$(TIX_VERSION).@@_V_TCL_VER_@@$(ITCL_EXT)
INST_TK_SAMEXE   = $(TK_SAMEXE_FILE)@@_V_TK_VER_@@
INST_TCL_SAMEXE  = $(TCL_SAMEXE_FILE)@@_V_TCL_VER_@@
}

if $ENABLE_SAM {
    if $SAM_EXE {
	p {
SAM_TARGETS     = $(TCL_SAM_FILE)    $(TK_SAM_FILE)    $(TIX_SAM_FILE) \\
    		  $(TCL_SAMEXE_FILE) $(TK_SAMEXE_FILE) $(TIX_SAMEXE_FILE)
        }
    } else {
	p {
SAM_TARGETS     = $(TIX_SAM_FILE)
	}
    }
}

p {
TIX_SAM_TARGETS	= @TIX_SAM_TARGETS@
SAM_INSTALL	= @TIX_SAM_INSTALL@
}


if $ITCL {
    if {$subs(@@_V_ITCL_VER_@@) == "2.1"} {
	p {
ITCL21_CFLAGS = -DITCL_21=1
	}
    } else {
	p {
ITCL21_CFLAGS =
        }
    }
    if {$subs(@@_V_ITCL_VER_@@) == "2.0"} {
	p {
ITCL_CFLAGS	 = -I$(ITCL_ROOT_DIR)/itcl -I$(ITCL_ROOT_DIR)/itk
	}
    } else {
	p {
ITCL_CFLAGS	 = -I$(ITCL_ROOT_DIR)/itcl/generic \\
		   -I$(ITCL_ROOT_DIR)/itk/generic $(ITCL21_CFLAGS)
	}
    }
} else {
    p {
ITCL_CFLAGS	 =
    }
}

p74 {
CC_SWITCHES = $(CFLAGS) $(AC_FLAGS) \\
    -I$(TCL_SRC_DIR) -I$(TK_SRC_DIR) $(ITCL_CFLAGS) \\
    -I$(GENERIC_DIR) -I$(UNIX_DIR) $(X11_INCLUDES)
}

p75+ {
CC_SWITCHES = $(CFLAGS) $(AC_FLAGS) -I$(TCL_GENERIC_DIR) \\
    -I$(TCL_SRC_DIR)/unix -I$(TK_GENERIC_DIR) -I$(TK_SRC_DIR)/unix \\
    $(ITCL_CFLAGS) \\
    -I$(GENERIC_DIR) -I$(UNIX_DIR) $(TK_XINCLUDES) $(TIX_SHLIB_CFLAGS)
}


p {
#----------------------------------------------------------------
# The information below should be usable as is. You shouldn't need
# to modify it.
#----------------------------------------------------------------

CORE_OBJS = \\
	tixClass.o \\
	tixCmds.o \\
	tixCompat.o \\
	tixError.o \\
	tixGeometry.o \\
	tixInit.o \\
	tixItcl.o \\
	tixList.o \\
	tixMethod.o \\
	tixOption.o  \\
	tixScroll.o \\
	tixSmpLs.o \\
	tixUtils.o \\
	tixWidget.o

DITEM_OBJS = \\
	tixDItem.o \\
	tixDiITxt.o \\
	tixDiImg.o \\
	tixDiStyle.o \\
	tixDiText.o \\
	tixDiWin.o

MANAGER_OBJS = \\
	tixForm.o \\
	tixFormMisc.o

WIDGET_OBJS = \\
	tixGrid.o \\
	tixGrData.o \\
	tixGrFmt.o \\
	tixGrRC.o \\
	tixGrSel.o \\
	tixGrSort.o \\
	tixGrUtl.o \\
	tixHList.o \\
	tixHLCol.o \\
	tixHLInd.o \\
	tixHLHdr.o \\
	tixInputO.o \\
	tixNBFrame.o \\
	tixTList.o

MISC_OBJS = \\
	tixImgCmp.o \\
	tixImgXpm.o \\
	tixMwm.o

UNIX_OBJS = \\
	tixUnixDraw.o \\
	tixUnixXpm.o \\
	tixUnixWm.o

OBJS = $(CORE_OBJS) $(DITEM_OBJS) $(MANAGER_OBJS) $(MISC_OBJS) \\
	$(WIDGET_OBJS) $(UNIX_OBJS)

TCL_SAM_OBJS = \\
        tclUnixSam@@_V_TCLVER_@@.o

TK_SAM_OBJS = \\
        tkUnixSam@@_V_TKVER_@@.o

TIX_SAM_OBJS = \\
        $(OBJS) tixUnixSam.o
}

p {
#----------------------------------------------------------------------
# These are the scripts that we'll compile into the SAM's. The
# scripts of TK must be included in the fixed order.
#----------------------------------------------------------------------
}

p {
TCL_SCRIPTS = $(TCL_SRC_DIR)/library/*.tcl
}

if {$subs(@@_V_TCL_VER_@@) == 7.4} {p {
TK_SCRIPTS = \\
    $(TK_SRC_DIR)/library/tkerror.tcl \\
    $(TK_SRC_DIR)/library/dialog.tcl \\
    $(TK_SRC_DIR)/library/focus.tcl \\
    $(TK_SRC_DIR)/library/obsolete.tcl \\
    $(TK_SRC_DIR)/library/palette.tcl \\
    $(TK_SRC_DIR)/library/tearoff.tcl \\
    $(SRC_DIR)/generic/tk4.0/tk.tcl \\
    $(TK_SRC_DIR)/library/button.tcl \\
    $(TK_SRC_DIR)/library/entry.tcl \\
    $(TK_SRC_DIR)/library/listbox.tcl \\
    $(TK_SRC_DIR)/library/menu.tcl \\
    $(TK_SRC_DIR)/library/scale.tcl \\
    $(TK_SRC_DIR)/library/scrollbar.tcl \\
    $(TK_SRC_DIR)/library/text.tcl
}}

if {$subs(@@_V_TCL_VER_@@) == 7.5} {p {
TK_SCRIPTS = \\
    $(TK_SRC_DIR)/library/bgerror.tcl \\
    $(TK_SRC_DIR)/library/dialog.tcl \\
    $(TK_SRC_DIR)/library/focus.tcl \\
    $(TK_SRC_DIR)/library/obsolete.tcl \\
    $(TK_SRC_DIR)/library/optMenu.tcl \\
    $(TK_SRC_DIR)/library/palette.tcl \\
    $(TK_SRC_DIR)/library/tearoff.tcl \\
    $(SRC_DIR)/generic/tk4.1/tk.tcl \\
    $(TK_SRC_DIR)/library/button.tcl \\
    $(TK_SRC_DIR)/library/entry.tcl \\
    $(TK_SRC_DIR)/library/listbox.tcl \\
    $(TK_SRC_DIR)/library/menu.tcl \\
    $(TK_SRC_DIR)/library/scale.tcl \\
    $(TK_SRC_DIR)/library/scrlbar.tcl \\
    $(TK_SRC_DIR)/library/text.tcl \\
    $(SRC_DIR)/generic/tk4.1/console.tcl
}}

if {$subs(@@_V_TCL_VER_@@) == 7.6} {p {
TK_SCRIPTS = \\
    $(TK_SRC_DIR)/library/bgerror.tcl \\
    $(TK_SRC_DIR)/library/dialog.tcl \\
    $(TK_SRC_DIR)/library/focus.tcl \\
    $(TK_SRC_DIR)/library/obsolete.tcl \\
    $(TK_SRC_DIR)/library/optMenu.tcl \\
    $(TK_SRC_DIR)/library/palette.tcl \\
    $(TK_SRC_DIR)/library/tearoff.tcl \\
    $(TK_SRC_DIR)/library/clrpick.tcl \\
    $(TK_SRC_DIR)/library/comdlg.tcl \\
    $(TK_SRC_DIR)/library/msgbox.tcl \\
    $(TK_SRC_DIR)/library/tkfbox.tcl \\
    $(TK_SRC_DIR)/library/xmfbox.tcl \\
    $(SRC_DIR)/generic/tk4.2/tk.tcl \\
    $(TK_SRC_DIR)/library/button.tcl \\
    $(TK_SRC_DIR)/library/entry.tcl \\
    $(TK_SRC_DIR)/library/listbox.tcl \\
    $(TK_SRC_DIR)/library/menu.tcl \\
    $(TK_SRC_DIR)/library/scale.tcl \\
    $(TK_SRC_DIR)/library/scrlbar.tcl \\
    $(TK_SRC_DIR)/library/text.tcl \\
    $(SRC_DIR)/generic/tk4.2/console.tcl
}}

if {$subs(@@_V_TCL_VER_@@) == 8.0} {p {
TK_SCRIPTS = \\
    $(TK_SRC_DIR)/library/bgerror.tcl \\
    $(TK_SRC_DIR)/library/dialog.tcl \\
    $(TK_SRC_DIR)/library/focus.tcl \\
    $(TK_SRC_DIR)/library/obsolete.tcl \\
    $(TK_SRC_DIR)/library/optMenu.tcl \\
    $(TK_SRC_DIR)/library/palette.tcl \\
    $(TK_SRC_DIR)/library/tearoff.tcl \\
    $(TK_SRC_DIR)/library/clrpick.tcl \\
    $(TK_SRC_DIR)/library/comdlg.tcl \\
    $(TK_SRC_DIR)/library/msgbox.tcl \\
    $(TK_SRC_DIR)/library/tkfbox.tcl \\
    $(TK_SRC_DIR)/library/xmfbox.tcl \\
    $(SRC_DIR)/generic/tk4.2/tk.tcl \\
    $(TK_SRC_DIR)/library/button.tcl \\
    $(TK_SRC_DIR)/library/entry.tcl \\
    $(TK_SRC_DIR)/library/listbox.tcl \\
    $(TK_SRC_DIR)/library/menu.tcl \\
    $(TK_SRC_DIR)/library/scale.tcl \\
    $(TK_SRC_DIR)/library/scrlbar.tcl \\
    $(TK_SRC_DIR)/library/text.tcl \\
    $(SRC_DIR)/generic/tk8.0/console.tcl
}}

p {
TIX_SCRIPTS = \\
    $(SRC_DIR)/library/pref/*.fsc \\
    $(SRC_DIR)/library/pref/*.csc \\
    $(SRC_DIR)/library/*.tcl
}

##
## Compilation rules for main targets
##

p {
all: $(TIX_LIB_FILE) $(TIX_EXE_FILE) @TIX_SAM_TARGETS@

$(TIX_LIB_FILE): $(OBJS)
	rm -f $(TIX_LIB_FILE)
	@TIX_MAKE_LIB@
	$(RANLIB) $(TIX_LIB_FILE)

$(TCL_SAM_FILE): $(TCL_SAM_OBJS)
	rm -f $(TCL_SAM_FILE)
	@TCL_MAKE_SAM@
	$(RANLIB) $(TCL_SAM_FILE)

$(TK_SAM_FILE): $(TK_SAM_OBJS)
	rm -f $(TK_SAM_FILE)
	@TK_MAKE_SAM@
	$(RANLIB) $(TK_SAM_FILE)

$(TIX_SAM_FILE): $(TIX_SAM_OBJS)
	rm -f $(TIX_SAM_FILE)
	@TIX_MAKE_SAM@
	$(RANLIB) $(TIX_SAM_FILE)

$(TIX_EXE_FILE): tixAppInit.o $(TIX_LIB_FILE)
	$(CC) @LD_FLAGS@ tixAppInit.o @TIX_BUILD_LIB_SPEC@ $(LIBS) \\
		@TIX_LD_SEARCH_FLAGS@ -o $(TIX_EXE_FILE)

$(TCL_SAMEXE_FILE): $(UNIX_DIR)/samAppInit.c $(TCL_SAM_FILE)
	$(CC) $(CC_SWITCHES) @LD_FLAGS@ -DUSE_TCL $(UNIX_DIR)/samAppInit.c \\
	    @TCL_BUILD_SAM_SPEC@ $(LIBS_TCLONLY) \\
	    @TIX_LD_SEARCH_FLAGS@ -o $(TCL_SAMEXE_FILE)

$(TK_SAMEXE_FILE): $(UNIX_DIR)/samAppInit.c $(TCL_SAM_FILE) $(TK_SAM_FILE)
	$(CC) $(CC_SWITCHES) @LD_FLAGS@ -DUSE_TK $(UNIX_DIR)/samAppInit.c \\
	    @TK_BUILD_SAM_SPEC@ @TCL_BUILD_SAM_SPEC@ $(LIBS) \\
	    @TIX_LD_SEARCH_FLAGS@ -o $(TK_SAMEXE_FILE)

$(TIX_SAMEXE_FILE): $(UNIX_DIR)/samAppInit.c $(TCL_SAM_FILE) $(TK_SAM_FILE) \\
	        $(TIX_SAM_FILE)
	$(CC) $(CC_SWITCHES) @LD_FLAGS@ -DUSE_TIX $(UNIX_DIR)/samAppInit.c \\
	    @TIX_BUILD_SAM_SPEC@ \\
	    @TK_BUILD_SAM_SPEC@ @TCL_BUILD_SAM_SPEC@ \\
	    $(LIBS) \\
	    @TIX_LD_SEARCH_FLAGS@ -o $(TIX_SAMEXE_FILE)

}

##
## .o file rules
##

p {
#----------------------------------------------------------------------
#
#			.o file rules
#
#----------------------------------------------------------------------
tixAppInit.o : tixAppInit.c
	$(CC) -c $(CC_SWITCHES) tixAppInit.c

tixClass.o : $(GENERIC_DIR)/tixClass.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixClass.c

tixCmds.o: $(GENERIC_DIR)/tixCmds.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixCmds.c

tixCompat.o: $(GENERIC_DIR)/tixCompat.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixCompat.c

tixDItem.o: $(GENERIC_DIR)/tixDItem.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixDItem.c

tixDiImg.o: $(GENERIC_DIR)/tixDiImg.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixDiImg.c

tixDiITxt.o: $(GENERIC_DIR)/tixDiITxt.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixDiITxt.c

tixDiStyle.o: $(GENERIC_DIR)/tixDiStyle.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixDiStyle.c

tixDiText.o: $(GENERIC_DIR)/tixDiText.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixDiText.c

tixDiWin.o: $(GENERIC_DIR)/tixDiWin.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixDiWin.c

tixError.o: $(GENERIC_DIR)/tixError.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixError.c

tixForm.o: $(GENERIC_DIR)/tixForm.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixForm.c

tixFormMisc.o: $(GENERIC_DIR)/tixFormMisc.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixFormMisc.c

tixGeometry.o: $(GENERIC_DIR)/tixGeometry.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGeometry.c

tixGrid.o: $(GENERIC_DIR)/tixGrid.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGrid.c 

tixGrData.o: $(GENERIC_DIR)/tixGrData.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGrData.c 

tixGrFmt.o: $(GENERIC_DIR)/tixGrFmt.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGrFmt.c

tixGrRC.o: $(GENERIC_DIR)/tixGrRC.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGrRC.c

tixGrSel.o: $(GENERIC_DIR)/tixGrSel.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGrSel.c

tixGrSort.o: $(GENERIC_DIR)/tixGrSort.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGrSort.c

tixGrUtl.o: $(GENERIC_DIR)/tixGrUtl.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixGrUtl.c

tixHLCol.o: $(GENERIC_DIR)/tixHLCol.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixHLCol.c

tixHLHdr.o: $(GENERIC_DIR)/tixHLHdr.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixHLHdr.c

tixHLInd.o: $(GENERIC_DIR)/tixHLInd.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixHLInd.c

tixHList.o: $(GENERIC_DIR)/tixHList.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixHList.c

tixImgCmp.o: $(GENERIC_DIR)/tixImgCmp.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixImgCmp.c

tixImgXpm.o: $(GENERIC_DIR)/tixImgXpm.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixImgXpm.c

tixInit.o: $(GENERIC_DIR)/tixInit.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixInit.c

tixItcl.o: $(GENERIC_DIR)/tixItcl.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixItcl.c

tixInputO.o : $(GENERIC_DIR)/tixInputO.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixInputO.c

tixList.o: $(GENERIC_DIR)/tixList.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixList.c

tixMethod.o : $(GENERIC_DIR)/tixMethod.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixMethod.c

tixMwm.o: $(GENERIC_DIR)/tixMwm.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixMwm.c

tixNBFrame.o: $(GENERIC_DIR)/tixNBFrame.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixNBFrame.c

tixOption.o: $(GENERIC_DIR)/tixOption.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixOption.c

tixSmpLs.o: $(GENERIC_DIR)/tixSmpLs.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixSmpLs.c

tixScroll.o: $(GENERIC_DIR)/tixScroll.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixScroll.c

tixTList.o: $(GENERIC_DIR)/tixTList.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixTList.c

tixUtils.o: $(GENERIC_DIR)/tixUtils.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixUtils.c

tixWidget.o: $(GENERIC_DIR)/tixWidget.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tixWidget.c

tixUnixDraw.o: $(UNIX_DIR)/tixUnixDraw.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tixUnixDraw.c

tixUnixXpm.o: $(UNIX_DIR)/tixUnixXpm.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tixUnixXpm.c

tixUnixWm.o: $(UNIX_DIR)/tixUnixWm.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tixUnixWm.c

#
# Dependence rules for SAM
#
tclUnixSam@@_V_TCLVER_@@.o: tclUnixSam@@_V_TCLVER_@@.c tclSamLib.c
	$(CC) -c $(CC_SWITCHES) tclUnixSam@@_V_TCLVER_@@.c

tclSamLib.c:
	$(RUN_TCLSH) $(SRC_DIR)/tools/tclc.tcl $(TCL_SCRIPTS) \\
	    > tclSamLib.c

tkUnixSam@@_V_TKVER_@@.o: tkUnixSam@@_V_TKVER_@@.c tkSamLib.c
	$(CC) -c $(CC_SWITCHES) tkUnixSam@@_V_TKVER_@@.c

tkSamLib.c:
	$(RUN_TCLSH) $(SRC_DIR)/tools/tclc.tcl $(TK_SCRIPTS) \\
	    > tkSamLib.c

tixUnixSam.o: $(UNIX_DIR)/tixUnixSam.c $(UNIX_DIR)/tixSamLib.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tixUnixSam.c

$(UNIX_DIR)/tixSamLib.c:
	$(RUN_TCLSH) $(SRC_DIR)/tools/tclc.tcl $(TIX_SCRIPTS) \\
	    > $(UNIX_DIR)/tixSamLib.c
}

pitcl {
IWIDGETS = iwidgets@@_V_IWIDGETS_VER_@@
}

p {

tests: $(TIX_EXE_FILE)
	TCL_LIBRARY=$(TCL_SRC_DIR)/library TK_LIBRARY=$(TK_SRC_DIR)/library \\
	    ITCL_LIBRARY=$(ITCL_SRC_DIR)/library \\
	    ITK_LIBRARY=$(ITK_SRC_DIR)/library \\
	    IWIDGETS_LIBRARY=$(ITCL_ROOT_DIR)/$(IWIDGETS) \\
	    TIX_LIBRARY=$(SRC_DIR)/library \\
    	    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:. \\
	    ./$(TIX_EXE_FILE) $(SRC_DIR)/tests/Driver.tcl
}

p_sam {
sa-tests: $(TIX_SAMEXE_FILE)
	./$(TIX_SAMEXE_FILE) $(SRC_DIR)/tests/Driver.tcl
}

p {
#----------------------------------------------------------------------
#
#			INSTALLATION
#
#----------------------------------------------------------------------
_install_: $(TIX_LIB_FILE) $(TIX_EXE_FILE) $(SAM_INSTALL)
	@for i in $(LIB_DIR) $(BIN_DIR) ; \\
	    do \\
	    if [ ! -d $$i ] ; then \\
		echo "Making directory $$i"; \\
		mkdir $$i; \\
		chmod 755 $$i; \\
		else true; \\
		fi; \\
	    done;
	@echo "Installing $(TIX_LIB_FILE) as $(LIB_DIR)/$(TIX_LIB_FILE)"
	@$(INSTALL_PROGRAM) $(TIX_LIB_FILE) $(LIB_DIR)/$(TIX_LIB_FILE)
	@echo "Installing $(TIX_EXE_FILE) as $(BIN_DIR)/$(INST_EXE)"
	@$(INSTALL_PROGRAM) $(TIX_EXE_FILE) $(BIN_DIR)/$(INST_EXE)

_install_sam_exe_: $(SAM_TARGETS)
	@for i in $(LIB_DIR) $(BIN_DIR) ; \\
	    do \\
	    if [ ! -d $$i ] ; then \\
		echo "Making directory $$i"; \\
		mkdir $$i; \\
		chmod 755 $$i; \\
		else true; \\
		fi; \\
	    done;
	@echo "Installing $(TK_SAM_FILE) as $(LIB_DIR)/$(TK_SAM_FILE)"
	@$(INSTALL_PROGRAM) $(TK_SAM_FILE) $(LIB_DIR)/$(TK_SAM_FILE)
	@echo "Installing $(TCL_SAM_FILE) as $(LIB_DIR)/$(TCL_SAM_FILE)"
	@$(INSTALL_PROGRAM) $(TCL_SAM_FILE) $(LIB_DIR)/$(TCL_SAM_FILE)
	@echo ""
	@echo "Installing $(TIX_SAMEXE_FILE) as $(BIN_DIR)/$(INST_TIX_SAMEXE)"
	@$(INSTALL_PROGRAM) $(TIX_SAMEXE_FILE) $(BIN_DIR)/$(INST_TIX_SAMEXE)
	@echo "Installing $(TK_SAMEXE_FILE) as $(BIN_DIR)/$(INST_TK_SAMEXE)"
	@$(INSTALL_PROGRAM) $(TK_SAMEXE_FILE) $(BIN_DIR)/$(INST_TK_SAMEXE)
	@echo "Installing $(TCL_SAMEXE_FILE) as $(BIN_DIR)/$(INST_TCL_SAMEXE)"
	@$(INSTALL_PROGRAM) $(TCL_SAMEXE_FILE) $(BIN_DIR)/$(INST_TCL_SAMEXE)

_install_sam_lib_: $(SAM_TARGETS)
	@for i in $(LIB_DIR) $(BIN_DIR) ; \\
	    do \\
	    if [ ! -d $$i ] ; then \\
		echo "Making directory $$i"; \\
		mkdir $$i; \\
		chmod 755 $$i; \\
		else true; \\
		fi; \\
	    done;
	@echo "Installing $(TIX_SAM_FILE) as $(LIB_DIR)/$(TIX_SAM_FILE)"
	@$(INSTALL_PROGRAM) $(TIX_SAM_FILE) $(LIB_DIR)/$(TIX_SAM_FILE)


install: _install_
	@echo The binary files have been installed.
	@echo You probably need to make install in the parent directory
	@echo to install other files.
}


##
## cleanup rules, etc
##

p {
sam_clean:
	rm -f $(UNIX_DIR)/tixSamLib.c $(UNIX_DIR)/tixBitmaps.c

clean: 
	rm -f *.so *.a *.o *_s.o core errs *~ \\#* TAGS *.E sta* \\
	    a.out errors $(TIX_EXE_FILE) $(TIX_LIB_FILE) *.bak \\
	    $(SAM_TARGETS) tclSamLib.c tkSamLib.c

distclean: clean
	rm -f Makefile config.* lib.exp

depend:
	makedepend -- $(CC_SWITCHES) -- $(SRCS)

Makefile: Makefile.in
	./config.status

.c.o:
	$(CC) -c $(CC_SWITCHES) $<

# DO NOT DELETE THIS LINE -- make depend depends on it.
}
