'\"
'\" $Id: tixExFileSelectDialog.n,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
'\"----------------------------------------------------------------------
.TH tixExFileSelectDialog n 4.0 Tix "Tix Built-In Commands"
.BS
'\"
'\"
'\"----------------------------------------------------------------------
.SH NAME
tixExFileSelectDialog \- Create and manipulate tixExFileSelectDialog widgets
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixExFileSelectDialog \fIpathName \fR?\fIoptions\fR?
'\"
'\"
'\"----------------------------------------------------------------------
.SH SUPER-CLASS
The \fBTixExFileSelectDialog\fR class does not have a super-class.
'\"
'\"----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'\"
\fBTixExFileSelectDialog\fR supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'\"
'\"
'\"----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'\"
'\"----------BEGIN
.OP \-command command Command
Specifies the command to be called when the user chooses on a filename
(usually by selecting the filename and clicking on the "OK" button").
The command is called with one argument, the complete pathname of the
file.
'\"----------END
'\"
'\"----------------------------------------------------------------------
.SH SUBWIDGETS
'\"----------BEGIN
.LP
.nf
Name:		\fBfsbox\fR
Class:		\fBTixExFileSelectBox\fR
.fi
.IP
The ExFileSelectBox subwidget embedded inside the ExFileSelectDialog.
'\"----------END
.BE
'\"
'\"
'\"----------------------------------------------------------------------
.SH DESCRIPTION
'\"
.PP
'\"
The \fBtixExFileSelectDialog\fR command creates a new window (given by
the \fIpathName\fR argument) and makes it into a ExFileSelectDialog
widget. Additional options, described above, may be specified on the
command line or in the option database to configure aspects of the
ExFileSelectDialog such as its cursor and relief.

The ExFileSelectDialog widget provides an convenient method for the
user to select files. The style of the ExFileSelectDialog widget is
very similar to the standard file dialog in MS Windows 3.1.
'\"
'\"
'\"----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'\"
The \fBtixExFileSelectDialog\fR command creates a new Tcl command whose
name is the same as the path name of the ExFileSelectDialog's
window. This command may be used to invoke various operations on the
widget. It has the following general form:
'\"
.RS
.CS
'\"
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
.RE
'\"
\fIPathName\fR is the name of the command, which is the same as the
ExFileSelectDialog widget's path name. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command. The following
commands are possible for ExFileSelectDialog widgets:
'\"
.TP
\fIpathName \fBcget\fR \fIoption\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixExFileSelectDialog\fR command.
'\"
'\"
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'\"
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixExFileSelectDialog\fR command.
'\"
'\"
.TP
\fIpathName \fBpopdown\fR 
'\"
Withdraws the ExFileSelectDialog from the screen.
'\"
.TP
\fIpathName \fBpopup\fR 
'\"
Pops up the ExFileSelectDialog on the screen.
'\"
'\"
.TP
\fIpathName \fBsubwidget \fIname ?args?\fR 
'\"
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'\"
'\"
'\"
'\"----------------------------------------------------------------------
'\".SH BINDINGS
'\".PP
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)



