'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: lreplace.n,v 1.1.1.2 1998/11/22 20:34:50 khan Exp $
'\" 
.so man.macros
.TH lreplace n 7.4 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
lreplace \- Replace elements in a list with new elements
.SH SYNOPSIS
\fBlreplace \fIlist first last \fR?\fIelement element ...\fR?
.BE

.SH DESCRIPTION
.PP
\fBLreplace\fR returns a new list formed by replacing one or more elements of
\fIlist\fR with the \fIelement\fR arguments.
\fIFirst\fR gives the index in \fIlist\fR of the first element
to be replaced (0 refers to the first element).
If \fIfirst\fR is less than zero then it refers to the first
element of \fIlist\fR;  the element indicated by \fIfirst\fR
must exist in the list.
\fILast\fR gives the index in \fIlist\fR of the last element
to be replaced.
If \fIlast\fR is less than \fIfirst\fR then no elements are deleted;
the new elements are simply inserted before \fIfirst\fR.
\fIFirst\fR or \fIlast\fR may be \fBend\fR
(or any abbreviation of it) to refer to the last element of the list.
The \fIelement\fR arguments specify zero or more new arguments to
be added to the list in place of those that were deleted.
Each \fIelement\fR argument will become a separate element of
the list.
If no \fIelement\fR arguments are specified, then the elements
between \fIfirst\fR and \fIlast\fR are simply deleted.

.SH KEYWORDS
element, list, replace
