#
# launcher.tcl -- launch SHADOW programs somehow ...
#

set shadow_version "2.3.3"

package require Tk
load cygtclreg80 registry
load choose_directory
load shellexec
load cygpath

#
# get_rootdir: Find and return the POSIX'ified root directory of SHADOW
# installation. 
#
proc get_rootdir {shadow_version} {
  global env

  set rootdir ""

  if {[info exist env(SHADOW_ROOT)]} {
    set rootdir $env(SHADOW_ROOT)
  } else {
    set regkey HKEY_LOCAL_MACHINE\\Software\\CXrL\\SHADOW\\$shadow_version
    if {! [catch {registry get $regkey SHADOW_ROOT} rootdir]} {
      set rootdir [file attributes $rootdir -shortname]
    } else {
      set rootdir ""
    }
  }

  if {$rootdir == ""} {
    set rootdir [file dirname [file dirname [file dirname [info script]]]]
    set rootdir [file native $rootdir]
    set rootdir [file attributes $rootdir -longname]
    tk_messageBox -title "Error" -type ok -icon error -message \
      "Cannot find SHADOW installation. I'll go ahead anyway and see what happens ... Using $rootdir"
    set rootdir [file attributes $rootdir -shortname]
  } 
  set rootdir [cygwin_conv_path_to_posix -full $rootdir]
  return $rootdir
}

proc run_prog {shroot wd prog args} {
  global env
  set bindir [file join $shroot bin]
  set libexecdir [file join $shroot libexec]
  set shell [file join $bindir bash]
  set wrapper [file join $libexecdir run-prog.sh]
  if {0} {
    tk_messageBox -title "DEBUG" -type ok -icon error -message \
      "INFO: shell: $shell, wrapper: $wrapper, bindir: $bindir, wd: $wd, prog: $prog, args: $args" 
  }
  switch -- "$prog" {
    "-shell"
      -
    "-unixshell" {
      set progfile "-shell $bindir $wd"
    }
    "-dosshell" {
      set shell $env(COMSPEC)
      set wrapper "[file join $libexecdir run-prog.bat]"
      set wrapper [cygwin_conv_path_to_win32 -full $wrapper]
      set wrapper "/K [file native $wrapper]"
      set dosbindir [cygwin_conv_path_to_win32 -full $bindir]
      set doswd [cygwin_conv_path_to_win32 -full $wd]
      set progfile "-shell [file native $dosbindir] [file native $doswd]"
    }
    default {
      set dosprog [cygwin_conv_path_to_win32 $prog]
      if {0} {
	tk_messageBox -title "DEBUG" -type ok -icon error -message \
	  "prog = $prog, dosprog = $dosprog"
      }
      if {[file pathtype $dosprog] == "absolute"} {
	set progfile [file attributes "$dosprog" -shortname]
      } else {
	set progfile [file join $bindir $prog]
      }
    }
  }
  # avoid the issue of # !/bin/sh etc at top.
  set env(SHELL) $shell
  if {[string tolower [file extension $progfile]] == ".sh"} {
    set progfile "$shell $progfile"
  }
  if {0} {
    tk_messageBox -title "DEBUG" -type ok -icon error -message \
      "Executing: shellexec open $shell \"$wrapper $progfile $args\" $wd"
  }

  if {[catch {shellexec open $shell "$wrapper $progfile $args" $wd} message]} {
    tk_messageBox -title "Error" -type ok -icon error -message \
      "Error running program $prog. Windows says: $message."
  }
}

proc launch {prog args} {
  global env shadow_version

  set dir_blurb " 
    Pick a directory where you want to run [file rootname $prog]:"
  set wd [choose_directory -initialdir [pwd] -title $dir_blurb]
  if {$wd == ""} {
    set wd [pwd]
  }
  set wd [cygwin_conv_path_to_win32 -full $wd]
  regsub {\\} $wd {/} wd
  set wd [file attribute $wd -shortname]

  set shroot [get_rootdir $shadow_version]
  set bindir [file join $shroot bin]
  set env(SHADOW_ROOT) [cygwin_conv_path_to_win32 -full $shroot]

  # In case we have Cygwin 1.x+ installed, prepend /bin first.
  set env(PATH) /bin:$env(PATH)
  # And then prepend SHADOW binary directory.
  set env(PATH) $bindir:$env(PATH)
  eval run_prog $shroot $wd "$prog" $args
}

wm withdraw .
eval launch "[lindex $argv 0]" [lrange $argv 1 end]
exit 0
