#
# launcher.tcl -- launch SHADOW programs somehow ...
#

set shadow_version "2.3.2"

package require Tk
load cygtclreg80 registry
load choose_directory
load shellexec

proc get_rootdir {shadow_version} {
  global env

  set rootdir ""

  if {[info exist env(SHADOW_ROOT)]} {
    set rootdir $env(SHADOW_ROOT)
  } else {
    set regkey HKEY_LOCAL_MACHINE\\Software\\CXrL\\SHADOW\\$shadow_version
    if {! [catch {registry get $regkey SHADOW_ROOT} rootdir]} {
      set rootdir [file attributes $rootdir -shortname]
    } else {
      set rootdir ""
    }
  }

  if {$rootdir == ""} {
    set rootdir [file dirname [file dirname [file dirname [info script]]]]
    regsub {//([a-zA-Z])/} $rootdir {\1:/} rootdir
    set rootdir [file native $rootdir]
    set rootdir [file attributes $rootdir -longname]
    tk_messageBox -title "Error" -type ok -icon error -message \
      "Cannot find SHADOW installation. I'll go ahead anyway and see what happens ... Using $rootdir"
    set rootdir [file attributes $rootdir -shortname]
  } 
  regsub {([a-zA-Z]):(/|\\)} $rootdir {\2\2\1\2} rootdir
  return $rootdir
}

proc run_prog {bindir wd prog args} {
  global env
  set shell [file join $bindir bash]
  set wrapper [file join $bindir run-prog.sh]
  switch -- "$prog" {
    "-shell"
      -
    "-unixshell" {
      set progfile "-shell $bindir $wd"
    }
    "-dosshell" {
      set shell $env(COMSPEC)
      set wrapper "[file join $bindir run-prog.bat]"
      regsub {//([a-zA-Z])/} $wrapper {\1:/} wrapper
      set wrapper "/K [file native $wrapper]"
      regsub {//([a-zA-Z])/} $bindir {\1:/} dosbindir
      regsub {//([a-zA-Z])/} $wd {\1:/} doswd
      set progfile "-shell [file native $dosbindir] [file native $doswd]"
    }
    default {
      regsub {//([a-zA-Z])/} "$prog" {\1:/} dosprog
      if {0} {
	tk_messageBox -title "Error" -type ok -icon error -message \
	  "prog = $prog, dosprog = $dosprog"
      }
      if {[file pathtype $dosprog] == "absolute"} {
	set progfile [file attributes "$dosprog" -shortname]
      } else {
	set progfile [file join $bindir $prog]
      }
    }
  }
  # avoid the issue of # !/bin/sh etc at top.
  set env(SHELL) $shell
  if {[string tolower [file extension $progfile]] == ".sh"} {
    set progfile "$shell $progfile"
  }
  if {0} {
    tk_messageBox -title "Error" -type ok -icon error -message \
      "Executing: shellexec open $shell \"$wrapper $progfile $args\" $wd"
  }

  if {[catch {shellexec open $shell "$wrapper $progfile $args" $wd} message]} {
    tk_messageBox -title "Error" -type ok -icon error -message \
      "Error running program $prog. Windows says: $message."
  }
}

proc launch {prog args} {
  global env shadow_version

  set dir_blurb " 
    Pick a directory where you want to run [file rootname $prog]:"
  set wd [choose_directory -initialdir [pwd] -title $dir_blurb]
  if {$wd == ""} {
    set wd [pwd]
  }
  regsub {//([a-zA-Z])/} $wd {\1:/} wd
  regsub {\\} $wd {/} wd
  set wd [file attribute $wd -shortname]

  set bindir [file join [get_rootdir $shadow_version] bin]
  set env(SHADOW_ROOT) [file dirname $bindir]
  set env(PATH) $bindir:$env(PATH)

  # if we have Cygwin installed, do that here as well.
  set cygreg "HKEY_LOCAL_MACHINE\\Software\\Cygnus Solutions\\GNUPro\\i586-cygwin32\\i586-cygwin32"
  if {![catch {registry keys $cygreg} cygversions]} {
    set cygver [lindex [lsort -decreasing $cygversions] 0]
    set cygkey "$cygreg\\$cygver"
    if {! [catch {registry get $cygkey "Install Path"} cygroot]} {
      regsub {\\} $cygroot {/} cygroot
      regsub {([a-zA-Z]):(/|\\)} $cygroot {\2\2\1\2} cygroot
      set cygbin [file join $cygroot H-i586-cygwin32 bin]
      set env(PATH) $env(PATH):$cygbin
    }
  }
  eval run_prog $bindir $wd "$prog" $args
}

wm withdraw .
eval launch "[lindex $argv 0]" [lrange $argv 1 end]
exit 0
