#
# help.tcl: help routines for XMenu
#
# ------------------------------------------------
# Mumit Khan <khan@xraylith.wisc.edu>
# Center for X-ray Lithography
# University of Wisconsin-Madison
# 3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Copyright (c) 1994-1996 Mumit Khan
#

#
# TOP_HELP: help on using XMenu
#
proc top_help {{w .}} {
    global gvars
    set msg ""
    append msg "Use FILE LOAD to load SOURCE and SYSTEM.\n"
    append msg "Use ADD to add SOURCE, OE and SCREEN.\n"
    append msg "Use EDIT to edit SOURCE, OE and SCREEN parameters.\n"
    append msg "Use OPTIONS to access various SYSTEM information.\n"
    append msg "Use PREFERENCES to change user-specific preferences.\n"
    append msg "Entering `?' in any entry field brings up spot help.\n"
    dialog .help {Toplevel Help} "$msg" {} 0 Dismiss
}

#
# ITEM_HELP: gives some info on the current item.
#
proc item_help {w page_name item_name} {
    global gvars
    set the_item [xitem list $page_name $item_name]
    set item_record [lindex $the_item 1]
    set item_na [lindex $the_item 5]
    set item_value [lindex $the_item 6]
    set item_submenu [lindex $the_item 7]
    set vallowed [xitem vallowed $page_name $item_name]
    set msg ""
    append msg "Menu item:         $item_name\n"
    append msg "Record type:       $item_record\n"
    append msg "current value:     $item_value\n"
    append msg "allowable values:\n"
    foreach allowed $vallowed {
	append msg "                   $allowed\n"
    }
    if {$item_submenu != ""} {
	append msg "name of submenu:   $item_submenu\n"
    }
    dialog .help {Item Help} "$msg" {} 0 Dismiss
}

#
# COMMAND_HELP: gives some info on XMenu/Tcl commands
#
proc command_help {w file} {
    global gvars
    if {[catch "open $file r" fin] != 0} {
	set msg "HELP file \"$file\" not available."
    } else {
	set msg [read $fin]
	close $fin
    }
    dialog .help {Command Help} "$msg" {} 0 Dismiss 6i
}
