
;+
; NAME:
;	XWINDOW
; PURPOSE:
;	Ceates a graphic window embedded in a widget.
;	useful to make (and print) graphics from widget applications.
; CATEGORY:
;	Widgets.
; CALLING SEQUENCE:
;	Xwindow [, keywords]
; INPUTS:
;	None.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;	GROUP = The widget ID of the widget that calls Xplot.
;	When this ID is specified, a death of the caller results
;	in a death of Xplot.
;	WINDOW_SIZE = a 2-dim vector containing the width and
;	height of the graphical window (in pixels).
;	WTITLE = title for the main window
;	BUFFER = String array with the idl command to be executed.
;	DATA = idl variable containing the data needed by BUFFER
;	EDIT = if set, creates an EDIT button to allow the user
;	to interactively edit the buffer
; OUTPUTS:
;	Creates a Window with a graph.
; OPTIONAL OUTPUT PARAMETERS:
;    None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	Starts xmanager, if not yest started.
; RESTRICTIONS:
;	Data to be used in the buffer commands is passes exclusively in
;	string format or by using the DATA keyword.
;	It is possible to use variables in the buffer, but this variables 
;	must have a name included in the list: i,j,a0,...a10,b0,...b10,
;	c0,...,c10 (this is due to the fact that EXECUTE cannot create
;	variables on the fly. The variable must be pre-initializad.
; PROCEDURE:
;	Uses EXECUTE to execute the commands in BUFFER
; EXAMPLES:
;	1) Xwindow   (you will get a sample surface)
;	2) Xwindow,Buffer='tvscl,dist(500)' (you get an image)
;	3) Example of using the DATA keyword:
;	   a = dist(500)
;	   Xwindow,Buffer='tvscl,data',Data=a 
;	4) Example of using a anonymous structure to pass multiple data
;	   z= dist(20)
;	   x = findgen(20)*5
;	   y = findgen(20)*8
;	    xwindow,b='surface,data.z,data.x,data.y',data={z:z,x:x,y:y}
;	5) Example of using multiline buffer:
;	   xwindow,Buffer=['!p.multi=[0,2,2]', $
;		'for i=1,4 do surface,dist(20)','!p.multi=0']
;
; MODIFICATION HISTORY:
;	Created NOV-1995 by M. Sanchez del Rio (srio@esrf.fr) (c)ESRF
;	96-01-08 MSR When /edit is selected, and n_elements(buffer) EQ 1
;		presents the buffer in a text widget at the bottom.
;	96-09-24 MSR Uses xdisplayfile1 instead xscrmenu for editing
;		buffer. No "cancel" possibility.
;	96-10-02 MSR allows resizing window.
;	97-04-03 MSR uses /no_block kw in xmanager call for idl version NE 4
;	97-10-16 MSR adds the internal variables to be used within BUFFER.
;-

pro xwindow_event,event

widget_control,event.id,get_uvalue=uvalue
widget_control,event.top,get_uvalue=state

widget_control,state.wset,get_value=windownum
wset,windownum


if event.top eq event.id then begin ; resize drawing area
  widget_control,state.wset,scr_xsize=event.x-5,scr_ysize=event.y-37
  data = state.data
  ; define user variables 
  i=0 & j=0 & k=0 
  a0=0 & a1=0 & a2=0 & a3=0 & a4=0 & a5=0 & a6=0 & a7=0 & a8=0 & a9=0 & a10=0
  b0=0 & b1=0 & b2=0 & b3=0 & b4=0 & b5=0 & b6=0 & b7=0 & b8=0 & b9=0 & b10=0
  c0=0 & c1=0 & c2=0 & c3=0 & c4=0 & c5=0 & c6=0 & c7=0 & c8=0 & c9=0 & c10=0

  if n_elements(state.buffer) EQ 1 then $
    itmp = execute(state.buffer(0)) else $
    for ih=0L,n_elements(state.buffer)-1 do junk = execute(state.buffer(ih))
  return
endif

case uvalue of
  'QUIT':  widget_control,event.top,/DESTROY
  'PRINT': xprint,buffer=state.buffer, data = state.data
  'EDIT': Begin
	tmp = state.buffer
        data = state.data
	if n_elements(tmp) GT 1 then begin
	  ; srio adds fieldlen 25 Apr 1996.
          ;XscrMenu,tmp,ACTION = action, FIELDLEN=50
	  xdisplayfile1,text=tmp,/modal,title='Buffer to edit'
          ;if action EQ 'DONT' then return
	endif else widget_control,event.id,get_value=tmp
	  widget_control,event.top,set_uvalue = $
	{wset:state.wset,buffer:tmp, data:data} 
	; define user variables 
	i=0 & j=0 & k=0 
	a0=0 & a1=0 & a2=0 & a3=0 & a4=0 & a5=0 
	a6=0 & a7=0 & a8=0 & a9=0 & a10=0
	b0=0 & b1=0 & b2=0 & b3=0 & b4=0 & b5=0 
	b6=0 & b7=0 & b8=0 & b9=0 & b10=0
	c0=0 & c1=0 & c2=0 & c3=0 & c4=0 & c5=0 
	c6=0 & c7=0 & c8=0 & c9=0 & c10=0

	if n_elements(tmp) EQ 1 then itmp = execute(tmp(0)) else $
	   for ih=0L,n_elements(tmp)-1 do junk = execute(tmp(ih))
	End
  else:
endcase
;
;
end
;
;=========================================================================
;
pro xwindow,buffer=buffer,window_size = w_size, data = data, $
  wtitle=wtitle, edit=edit, group = group

if not(keyword_set(group)) then group=0
if not(keyword_set(buffer)) then buffer = 'surface,data'
if not(keyword_set(data)) then data = dist(30)
if not(keyword_set(wtitle)) then wtitle = 'Xwindow'


;
; widget def
;
wbase = widget_base(title=wtitle,/col,/TLB_SIZE_EVENTS)
wbuttons = widget_base(wbase,/ROW)

wquit = widget_button(wbuttons,VALUE='Quit',UVALUE='QUIT')
wprint = widget_button(wbuttons,VALUE='Print',UVALUE='PRINT')

if n_elements(w_size) lt 2 then begin     ; default window size
  device, GET_SCREEN = w_size
  w_size = (w_size(0) * [5,4]) /9
endif
wdraw = widget_draw(wbase,XSIZE=w_size(0), YSIZE=w_size(1))

if keyword_set(edit) then begin
  if n_elements(buffer) GT 1 then $
  wedit = widget_button(wbuttons,VALUE='Edit Xwindow buffer',UVALUE='EDIT') $
  else  wedit = widget_text(wbase,VALUE=buffer,/EDIT,/ALIGN_LEFT,$
    UVALUE='EDIT',XSIZE=strlen(buffer)+15)
endif
;
; state
;
state = { wset:wdraw , buffer:buffer, data:data}

widget_control,wbase,set_uval=state,/REALIZE
widget_control,wbase,/REALIZE
;help,buffer
;print,'>>>>>>>>>>',buffer

; define user variables 
i=0 & j=0 & k=0 
a0=0 & a1=0 & a2=0 & a3=0 & a4=0 & a5=0 & a6=0 & a7=0 & a8=0 & a9=0 & a10=0
b0=0 & b1=0 & b2=0 & b3=0 & b4=0 & b5=0 & b6=0 & b7=0 & b8=0 & b9=0 & b10=0
c0=0 & c1=0 & c2=0 & c3=0 & c4=0 & c5=0 & c6=0 & c7=0 & c8=0 & c9=0 & c10=0

if n_elements(buffer) EQ 1 then tmp = execute(buffer(0)) else $
   for ih=0L,n_elements(buffer)-1 do tmp = execute(buffer(ih))
if strmid(!version.release,0,1) EQ '4' then $
  xmanager, 'xwindow', wbase,group=group else $
  xmanager, 'xwindow', wbase,group=group,/no_block
end

