;+
;
;
; =================================  Xspec ===============================
;
;   Xspec is a widget based graphical interface to visualize data
;   stored in SPEC files.
;
;   The main window contains the following controls
;
;	FILE Menu:
;	  LOAD SPEC FILE...: To Load a Spec File with Data.
;		When selecting a file with the Load File window,
;		The different names of scans appear in a list 
;		widget in the main window. Click a given one
;		and use the buttons Header and Plot.
;	  EXIT:	Exit or Quit the program
;
;	TOOLS Menu:
;	  XSPEC (Empty): Create a new (empty) window of Xspec
;	  XPLOT (Empty): Create a new (empty) window of XPlot
;
;       HELP:   Shows this text (Xspec) or the documentation of
;		SPEC_ACCESS
;
;
;	CONTROL BUTTONS:
;	  HEADER:  Opens a text window with the contents of the
;		header of the selected scan.
;	  PLOT: Send the data of the scan to Xplot for graphical
;		visualization and analysis. Displays also a text
;		window containing the scan column numbers and their
;		labels. This is useful to identify the meaning of the
;		column number from the Xplot window.
;		The displayed column in Xplot are the first one for
;		the X coordinate and the last one for the Y coordinate.
;		The column selection can be changed from the Xplot
;		window.
;
;	A list widget with the scan list names is presented below 
;	the buttons. Click a given one  to select it and then use
;	the HEADER or the PLOT button. Double-click makes the same
;	effect that single click (Selection) plus pressing the PLOT 
;	button.
;		
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. September 1995
;	It uses SPEC_ACCESS (P. Fajardo) and XPLOT (M. Sanchez del Rio)
;	October-1995. MSR New version.
;	November-1995 MSR Xspec is obsolete: All its functionality has
;		been improved and integrated in xplot2.1
;
;-
;
PRO xspec_event,event
;
;
widget_control,event.id,GET_UVALUE=eventuval 
widget_control,event.top,GET_UVALUE=state,/no_copy
;
CASE eventuval OF
  'LOADFILE':	BEGIN
	file = pickfile(FILTER='*',/READ,GROUP=event.top,/NOCONF)
	if file eq '' then GOTO,out
	widget_control,/hourglass
	wText = state.wText
	wScan = state.wScan
	Text = ['Spec file: '+file]
	Text = [Text,'Scan list (compressed form): '+$
	spec_access(h1,file,/list,/compress,/str)]
	widget_control,wText,set_value=Text
	state = { wText:wText, wScan:wScan, specHandle:h1, XplotId:-1L }
	END
  'EXIT':	BEGIN
	widget_control,event.top,/Destroy
	return
	END
  'HEADER':	BEGIN
	widget_control,state.wScan,get_value=scan
	scan = scan(0)
	if strcompress(scan,/rem) EQ '' then begin
	  tmp = widget_message(/ERROR,$
	  ['No selection has been done.','Please select a scan.'])
	  goto,out
	endif
	index = spec_scan(state.specHandle,scan)
	if index EQ -1 then begin
	  tmp = widget_message(/ERROR,$
	  ['Error reading selected scan.','Please select a scan.'])
	  goto,out
	endif
	text = spec_headers(state.specHandle,scan)
	ShowInfo,TITLE= state.specHandle.specfile+' Header of Scan: '+$
	  scan, GROUP=event.top,INFOTEXT=text, WIDTH=$
	  max(strlen(text)), HEIGH=n_elements(text)
	END
  'LABELS':	BEGIN
	widget_control,state.wScan,get_value=scan
	scan = scan(0)
	if strcompress(scan,/rem) EQ '' then begin
	  tmp = widget_message(/ERROR,$
	  ['No selection has been done.','Please select a scan.'])
	  goto,out
	endif
	index = spec_scan(state.specHandle,scan)
	if index EQ -1 then begin
	  tmp = widget_message(/ERROR,$
	  ['Error reading selected scan.','Please select a scan.'])
	  goto,out
	endif
	labels = spec_labels(state.specHandle,scan)
	ShowInfo,TITLE= state.specHandle.specfile+' Columns of Scan: '+$
         scan, GROUP=Event.top,INFOTEXT=labels, WIDTH=$
          max(strlen(labels)), HEIGH=n_elements(labels)
	END
  'MOTORS':	BEGIN
	widget_control,state.wScan,get_value=scan
	scan = scan(0)
	if strcompress(scan,/rem) EQ '' then begin
	  tmp = widget_message(/ERROR,$
	  ['No selection has been done.','Please select a scan.'])
	  goto,out
	endif
	index = spec_scan(state.specHandle,scan)
	if index EQ -1 then begin
	  tmp = widget_message(/ERROR,$
	  ['Error reading selected scan.','Please select a scan.'])
	  goto,out
	endif
	motors = spec_motors(state.specHandle,scan)
	ShowInfo,TITLE= state.specHandle.specfile+' Motors of Scan: '+$
         scan, GROUP=Event.top,INFOTEXT=motors, WIDTH=$
          max(strlen(motors)), HEIGH=n_elements(motors)
	END
  'PLOT':	BEGIN
	widget_control,state.wScan,get_value=scan
	scan = scan(0)
	if strcompress(scan,/rem) EQ '' then begin
	  tmp = widget_message(/ERROR,$
	  ['No selection has been done.','Please select a scan.'])
	  goto,out
	endif
	index = spec_scan(state.specHandle,scan)
	if index EQ -1 then begin
	  tmp = widget_message(/ERROR,$
	  ['Error reading selected scan.','Please select a scan.'])
	  goto,out
	endif

	labels = spec_labels(state.specHandle,scan)
	labels2 = labels
	for i=0,n_elements(labels)-1 do $
	  labels2(i) = 'Column '+strcompress(i+1,/rem)+' is: '+labels(i)
	data = spec_data(state.specHandle,scan)
	Xplot,data,Wtitle=state.specHandle.specfile+' Data of Scan: '+$
	  scan,PARENT = parent
	ShowInfo,TITLE= state.specHandle.specfile+' Columns of Scan: '+$
	  scan, GROUP=PARENT,INFOTEXT=labels2, WIDTH=$
	  max(strlen(labels2)), HEIGH=n_elements(labels2)
	state.XplotId = parent
	END
  'OPLOT':	BEGIN
	widget_control,state.wScan,get_value=scan
	scan = scan(0)
	if strcompress(scan,/rem) EQ '' then begin
	  tmp = widget_message(/ERROR,$
	  ['No selection has been done.','Please select a scan.'])
	  goto,out
	endif
	index = spec_scan(state.specHandle,scan)
	if index EQ -1 then begin
	  tmp = widget_message(/ERROR,$
	  ['Error reading selected scan.','Please select a scan.'])
	  goto,out
	endif

	labels = spec_labels(state.specHandle,scan)
	labels2 = labels
	for i=0,n_elements(labels)-1 do $
	  labels2(i) = 'Column '+strcompress(i+1,/rem)+' is: '+labels(i)
	data = spec_data(state.specHandle,scan)
	tmp = widget_info(state.XplotId,/Valid_id)
	Ncol = spec_columns(state.specHandle,scan)
	if state.XplotId EQ -1 or tmp EQ 0 then begin
	  Xplot,data,Wtitle=state.specHandle.specfile+' Data of Scan: '+$
	  scan,PARENT = parent
	  state.XplotId = parent
	endif else begin
	  widget_control,state.XplotId,get_uvalue=sss,/no_copy
	  sss.dthcurrent = handle_create()
	  handle_value,sss.dthcurrent,data,/set
	  widget_control,sss.wids.ncol,SET_VALUE= $
	                          strcompress(Ncol,/REM)
	  widget_control,sss.wids.message,SET_VALUE= $
		'Xplot message: Current set is SPEC scan: '+scan
	  if fix(sss.wids.xcol) GT Ncol then begin
	    widget_control,sss.wids.xcol,SET_VALUE='1'
	    sss.xpdt.Xcol = 1
	  endif
	  if fix(sss.wids.ycol) GT Ncol then begin
	    widget_control,sss.wids.ycol,SET_VALUE=strcompress(Ncol,/REM)
	    sss.xpdt.Ycol = Ncol
	  endif
	  xplot_plot,sss
	  widget_control,state.XplotId,set_uvalue=sss,/no_copy
	endelse

	ShowInfo,TITLE= state.specHandle.specfile+' Columns of Scan: '+$
	  scan, GROUP=state.XplotId,INFOTEXT=labels2, WIDTH=$
	  max(strlen(labels2)), HEIGH=n_elements(labels2)
	END
  'XPLOT': xplot
  'XSPEC': xspec
  'HELP':		BEGIN
			widget_control, event.id, get_value=eventval
			eventval = strlowcase(eventval)
                         ; The beginning of the file will be cut and
                         ; saved into the file xplot.hlp
                         doc_library,eventval, PRINT='cat > '+eventval+'.hlp'
                         XDISPLAYFILE1,eventval+'.hlp',GROUP=event.top, $
				HEIGHT = 48, /REMOVE
		END
  else:
ENDCASE
OUT:
widget_control,event.top,set_uvalue=state,/no_copy
end
;
;=======================================================================
;
PRO xspec,file,GROUP=group
;
on_error,2

if not(keyword_set(wtitle)) then wtitle='Xspec'

if keyword_set(file) then begin
  widget_control,/hourglass
  Text = ['Spec file: '+file]
  Text = [Text,'Scan list (compressed form): '+$
		spec_access(specHandle,file,/list,/compress,/str)]
endif else begin
  Text = ''
  specHandle = 0
endelse
;
; the widgets
;
wWindow = $
  Widget_base(title=Wtitle,MBAR=wMenuBar)	; base window
wBase = Widget_base(wWindow,/Column)	; base widget

;
; build the menu bar
;
wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
  wLoadFile=WIDGET_BUTTON(wFileMenu, VALUE='Load SPEC File...', $
	UVALUE='LOADFILE')
  wExit=WIDGET_BUTTON(wFileMenu, VALUE='Exit', UVALUE='EXIT')

wToolsMenu =  WIDGET_BUTTON(wMenuBar, VALUE='Tools', /MENU)
  wSpec=WIDGET_BUTTON(wToolsMenu, VALUE='Xspec (empty)', UVALUE='XSPEC')
  wXplot=WIDGET_BUTTON(wToolsMenu, VALUE='Xplot (empty)', UVALUE='XPLOT')


wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='Xspec', UVALUE='HELP')
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='Spec_access', UVALUE='HELP')
;
; build the buttons panel
;
wButtons   = Widget_base(wBase,/Row)	; buttons
wHeader = Widget_button(wButtons,value='Header',Uvalue='HEADER') 
wLabels = Widget_button(wButtons,value='Column Labels',Uvalue='LABELS') 
wMotors = Widget_button(wButtons,value='Motor names',Uvalue='MOTORS') 
wOPlot = Widget_button(wButtons,value='Plot',Uvalue='OPLOT') 
wPlot = Widget_button(wButtons,value='Plot (New Window)',Uvalue='PLOT') 
;
; build the text panel
;
wText = Widget_text(wBase,value=Text,xsize=60,ysize=4)
wtmp = widget_base(wBase,/Row)
wLabel = Widget_Label(wtmp,value='Select SPEC ScanId:',/ALIGN_LEFT)
wScan = Widget_text(wtmp,value='',uvalue='SCAN',/EDIT)


; structure  to memorize the widget's ids to be changed during the run.

state = { wText:wText, wScan:wScan, specHandle:specHandle, XplotId:-1L }


widget_control, wWindow, /NO_COPY, /REALIZE
widget_control, wWindow, set_uvalue=state, /NO_COPY

xmanager, 'xspec', wWindow, GROUP_LEADER=group
end
