;+
; NAME:
;	XPRINT
;
; PURPOSE:
;	This procedure prints a text or some graphics to the printer or
;		to file
;
; CATEGORY:
;	Widgets, general utility
;
; CALLING SEQUENCE:
;	XPRINT, Keyword_parameters
; INPUTS:
;	Inputs are got from common blocks and/or keyword parameters.
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	BUFFER:	In case of printing of graphics, you have to
;			store the draw commands in this vector of strings.
;			In case of text you have to omit this keyword.
;
;	DATA:	The data to be printed. For text it is only a string or
;		a vector of strings. For graphics it is usually a matrix
;		which stores the data used by the commands 'BUFFER'.
;
;	NOTYPE:	If you set this keyword you will not be able to choose
;		between 'Portait' and 'Landscape' printing, i.e. the
;		buttons for setting it will not appear.
;		It is worth using always in case of printing text. 
;
;	GROUP:	The widget ID of the group leader widget.
;	COLOR:	When set to 1, then set the ps device for color output
;		by using the PHASER procedure
;	FILE:	name of a file on disk to be printed. Example
;		Xprint,FILE='a.dat',/NOTYPE
;	NORESIZE: avoids to adjust the character size and window
;		Horizontal?Vertical aspect ratio.
;
; OUTPUTS:
;	Normally: the printed text or graphics
;	If you print to file: the file
;	The routine modifies the variables of the printdefaults common
;	block.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;	xprint:	the structure containing the parameters and "frame0", 
;	to store the window position for next xprint calls.
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;	You can use this routine if the 'BUFFER' commands use
;	only one variable whose name has to be data. The program gets
;	the value if you set the DATA keyword. The other values have
;	to be transferred as constants.
;	It is possible to use variables in the buffer, but this variables 
;	must have a name included in the list: i,j,a0,...a10,b0,...b10,
;	c0,...,c10 (this is due to the fact that EXECUTE cannot create
;	variables on the fly. The variable must be pre-initializad).
;	The buffer is executed via the EXECUTE command, so it assumes
;	the own limitations of EXECUTE
;
; PROCEDURE:
;
; EXAMPLE:
;	Printing an image stored in the matrix img by using the surface
;	command. The values greater than maxval will not appear.
;
;	On display we would use the next command:
;		'surface,data, MAX_VALUE=maxval
;
;	For printing we use the next:
;
;	buffer=strarr(1)
;	buffer(0)='surface,data, MAX_VALUE='+str(maxval)
;	xprint,BUFFER=buffer,DATA=img
;
; MODIFICATION HISTORY:
; 	Written by:	Szabolcs Kesmarki, July 1993.
;	93-11-18 M. Sanchez del Rio adds default common block variables
;			and adds the COLOR keyword
;	93-11-23 M. Sanchez del Rio adds FILE keyword
;	94-02-22 MSR renames it from printing to xprint, and rewrites
;		it in a shorter procedure
;	95-08-18 MSR makes to read the default printer name from
;		the corresponding environment variable
;	96-01-17 MSR makes to read the default printer name from
;		a call to GetSysPrinter()
;	97-02-13 MSR changes the filename when printing to avoid
;		rewriting the xplot.ps file that the user may want to keep. 
;		First attemp to Windows 95 port. Use "message,/info" for 
;		messaging.
;	97-03-05 bug fixed: setting encapsulated and then non-encapsulated 
;		didn't work. Now device,encapsulated=0 is set when printing.
;	97-10-16 srio@esrf.fr makes the text fields larger and maintain
;		the window position in the screen for successive calls (added 
;		frame0 to common block). Define internal variables for
;		buffer executions (a0,...,c10,i,j). uses sdep(). Adds a
;		1 second delay for printing (problems with Solaris).
;	97-11-18 srio@esrf.fr included changes from R. Dejus: 
;       	96-05-20 RJD, added wait statement before executing rm of 
;		xprint.ps Removed resizing of characters and window size.
;		NOTE: the wait is for 1 sec and to avoid resizing
;		the new keyword NORESIZE must be used.
;-
PRO Xprint,BUFFER=buffer,DATA=data,COLOR=color,FILE=file, $
  PRINTER=printer, PSFILE=psfile,XPRINTSTR=xprintstr, $
  NOORIENTATION=noorientation,GROUP=group, NORESIZE=NoResize
common xprint,str,frame0
;
on_error,2
olddevice=!d.name

; define user variables 
i=0 & j=0 & k=0 
a0=0 & a1=0 & a2=0 & a3=0 & a4=0 & a5=0 & a6=0 & a7=0 & a8=0 & a9=0 & a10=0
b0=0 & b1=0 & b2=0 & b3=0 & b4=0 & b5=0 & b6=0 & b7=0 & b8=0 & b9=0 & b10=0
c0=0 & c1=0 & c2=0 & c3=0 & c4=0 & c5=0 & c6=0 & c7=0 & c8=0 & c9=0 & c10=0
;
;create the structure if it does not exist
;
if keyword_set(str) then begin
  message,/info,'Input structure already defined'
  xprintstr = str
endif
if not(keyword_set(xprintstr)) then BEGIN
  if sdep() EQ 'WINDOWS' then begin
    PrinterName = ['']
    dest= ['3','      ','PostScript File', $
          'Encapsulated PS File','Ghostview']
  endif else begin
    PrinterName = GetSysPrinter(/Verbose)
    dest= ['0','Printer','PostScript File', $
          'Encapsulated PS File','Ghostview']
  endelse  

  xprintstr = { Print ,  $
    Destination:dest, $
    Orientation:['0','Portrait','Landscape'], $
    PrinterName:PrinterName(0), FileName:'xprint.ps',  $
    Color:['0','Black & White','Color'] } 
endif

titles = ['Destination:', 'Orientation:', 'Printer Name:', $
  'File Name:', 'Color:' ]

flags= ['1','1','w(0) EQ 0','w(0) EQ 1 OR w(0) EQ 2 OR w(0) EQ 3','1']

if not(keyword_set(NoResize)) then begin
  ch = [!d.x_ch_size, !d.y_ch_size] / float([!d.x_size, !d.y_size])
  ratio = !d.x_size/float(!d.y_size)
  ;print,'XPRINT: ch: ',ch
  ;print,'XPRINT: ratio: ',ratio
endif

if keyword_set(file) then flags=['0','0','1','0','0']
if keyword_set(noorientation) then flags(1)='0'
if sdep() EQ 'WINDOWS' then flags(2)='0'
if keyword_set(printer) then xprintstr.PrinterName=Printer
if keyword_set(psfile) then xprintstr.FileName=psfile

XscrMenu,xprintstr,group=group,wtitle='Xprint' ,ACTION=action,/INTERPRET, $
TITLES=titles,/NOTYPE,FLAGS=flags,FIELDLEN=30, $
get_frame=frame1,set_frame=frame0
frame0 = frame1

if action NE 'DO' then return
;
; text file
;
str = xprintstr
IF keyword_set(file) then BEGIN
 if sdep() EQ 'WINDOWS' then  $
   command='print '+file else $
   command='lp -d'+strcompress(xprintstr.PrinterName,/REM)+' '+file
 message,/info,'Executing: '+command
 spawn,command
 return
END
if (xprintstr.color(0) EQ 1) then begin
  command = 'phaser'
  message,/info,command
  tmp = execute(command)
endif else begin
  command="set_plot,'ps'"
  message,/info,command
  tmp = execute(command)
endelse
if (xprintstr.Destination(0) EQ 2) then begin
  command='Device,/encapsulated '
  message,/info,command
  tmp = execute(command)
endif else if (xprintstr.Destination(0) EQ 1) then begin
  command='Device,encapsulated=0 '
  message,/info,command
  tmp = execute(command)
endif
if (xprintstr.Orientation(0) EQ 0) then begin
  command='Device,/portrait '
  message,/info,command
  tmp = execute(command)
endif else begin
  command='Device,/landscape'
  message,/info,command
  tmp = execute(command)
endelse
;
if not(keyword_set(NoResize)) then begin
  ;print,'XPRINT: set_char = ch * !d.x_size'
  device, set_char = ch * !d.x_size  ;Proportional char size (aspect = same)
  ;print,'XPRINT: device,xsize = !d.y_size/1000. * '+strcompress(ratio,/rem)
  device,xsize = !d.y_size/1000. * ratio
endif


if (xprintstr.Destination(0) EQ 0) then $
  ; change the file name to avoid deleting previous xprint.ps files.
  command = 'device,encapsulated=0,filename='+"'xprintmp.ps'" else $
  command = 'device,encapsulated=0,filename='+"'"+$
	strcompress(xprintstr.FileName)+"'"
message,/info,command
tmp = execute(command)
;
; if buffer is set, then execute it
;
;print,'ks buffer = ',keyword_set(buffer)
if (fix(keyword_set(buffer)) EQ 1) then  begin
  if (n_elements(buffer) eq 1) then begin
    message,/info,'......... executing buffer ..............'
    tmp = execute(buffer(0))
  endif else begin
    message,/info,'......... executing buffer ..............'
    for ih=0,n_elements(buffer)-1 do begin
       ;print,'<><> executing: ',buffer(ih)
       tmp = execute(buffer(ih)) 
    endfor
  endelse
endif
command = 'device,/close'
message,/info,command
tmp = execute(command)
command = "set_plot,'"+olddevice+"'"
message,/info,command
tmp = execute(command)
;
if (xprintstr.Destination(0) EQ 0) then begin
  if sdep() EQ 'WINDOWS' then $
    command='print xprintmp.ps' else $
    command='lp -d'+strcompress(xprintstr.PrinterName,/REM)+' xprintmp.ps'
  message,/info,'Executing: '+command
  spawn,command
  if sdep() EQ 'WINDOWS' then command='del xprintmp.ps' else $
    command='/bin/rm -f xprintmp.ps'
  wait,1.0
  message,/info,'Executing: '+command
  spawn,command
endif 
if (xprintstr.Destination(0) EQ 3) then begin
  if (xprintstr.Orientation(0) EQ 1) then tmp = '-swap ' else tmp = ''
  command='ghostview '+tmp+xprintstr.FileName
  message,/info,'Executing: '+command
  spawn,command
  if sdep() EQ 'WINDOWS' then command='del '+xprintstr.FileName else $
    command='/bin/rm -f '+xprintstr.FileName
  wait,1.0
  message,/info,'Executing: '+command
  spawn,command
endif 
;
END
