function xplot_defaults,inpstring
;
; ONLY FOR INTERNAL USE OF XPLOT (NOT DOCUMENTED)
;
; define defaults (customized for xplot). 
; Warning: some initial parameters are defined in several variables!!!
;
; Modification history:
;     97-08-27 srio@esrf.fr Makes the structures anonymous (for assuring
;     compatibility between the backup files between different Xplot
;     versions). Added MESH option.
;     97-09-10 srio@esrf.fr add wids tag to strcontrols
;     97-10-16 srio@esrf.fr fixes a bug Ymin=Ymax
;     97-10-22 srio@esrf.fr xplot_defaults may be customized with the 
;		file defined in the XPLOT_DEFAULTS environment variable.
;
on_error,2

inpstring = STRLOWCASE(inpstring)

case inpstring of
  'xpdt': begin
	sysvar_old = $
	['!p.charsize = ' + strcompress(!p.charsize,/rem), $
	'!p.ticklen = ' + strcompress(!p.ticklen,/rem), $
	'!x.range = ' + vect2string(!x.range), $
	'!y.range = ' + vect2string(!y.range), $
	'!x.style = ' + strcompress(!x.style, /rem), $
	'!y.style = ' + strcompress(!y.style, /rem), $
	'!p.background = ' + strcompress(!p.background, /rem), $
	'!p.color = ' + strcompress(!p.color, /rem) ]

	sysvardef = $
	['!p.charsize = ' + strcompress(!p.charsize,/rem), $
	'!p.ticklen = ' + strcompress(!p.ticklen,/rem), $
	'!x.range = ' + vect2string(!x.range), $  ; check with xptd_limits
	'!y.range = ' + vect2string(!y.range), $  ; check with xptd_limits
	'!x.style = 1', $                         ; check with xptd_limits
	'!y.style = 1', $                         ; check with xptd_limits
	'!p.background = 0', +$ ; strcontrols
	'!p.color = 255']       ; strcontrols
	
;	out = { XPDT, $
	xpdt = { $
	Xcol:0L , Ycol:0L, $
	Connect:0L, Psym:0L, Linestyle:0L, Kind:1L, $
	Thick:1.0, Nfiles:0L, FileName:' ', Font:'0', $
	Shift:[0.0,0.0], ErrPlot:[0,0], Infile:' ', $
	sysvar_old:sysvar_old, sysvar:sysvardef, $
	zoompixmap:0L,zoom_on:0,$
	zoomsel:[0.,0.,0.,0.], axis2:[0.,0.,0.,0.],$
;	mesh:{ MESH, flag:['0','NO','YES'],col:2,$
	mesh:{ flag:['0','NO','YES'], $
	     kind:['0','lines','surface','contour'], $
	     split:['0','Each N points','Using a "label" column'],$
	     points:10, col:2,$
	     keywords:''}  }
      end
  'xpdt_limits': xpdt_limits = $
;	{ XPDT_LIMITS, Xmin:!x.range(0), Xmax:!x.range(1), $
	{ Xmin:!x.range(0), Xmax:!x.range(1), $
	Xstyle:['0','Exact','Extend','No axis','No box','No zero'],$
	Ymin:!y.range(0), Ymax:!y.range(1), $
	Ystyle:['0','Exact','Extend','No axis','No box','No zero'] }
  'xpdt_titles': xpdt_titles = $
;	{ XPDT_TITLES, Title:' ', Xtitle:' ', Ytitle:' '}
	{ Title:' ', Xtitle:' ', Ytitle:' '}
  'strcontrols': strcontrols = $
;	{ XPSTRCONTROLS, connect:0L, symbol:0L,LineStyle:0L,Axis:0L,$
	{ connect:0L, symbol:0L,LineStyle:0L,Axis:0L,$
	Ticks:0L, Thickness:1.0,CharSize:1.0,Font:0,BackGround:0, $
	Axiscolor:255, Color:255, $
        wids:{Main:0L, Connect:0L, Symbol:0L, Linestyle:0L, Axis:0L,$
                Ticks:0L, Font:0L, Thickness:0L, CharSize:0L, $
                BackGround:0L, Axiscolor:0L, Color:0L} }

  ; NOTE: if changing this structure, change also flags and titles in
  ; xplot_evaluate!!
  'xpevaluate': xpevaluate = $
;	{ XPevaluate, $
	{  $
	Expression_x:'Cx = Ax*1.0', $
	Expression_y:'Cy = Ay*1.0', $
	nset:['0','1','2'], $
	set1:'current set', $
	set2:' ', $
	save_as:['0','No','Yes'], $
	filename:'xplot.dat', $
	over:['0','No','Yes'] }


  ; NOTE: if changing this structure, change also flags and titles in
  ; xplot_columnoper!!
  'xpcolumnoper': xpcolumnoper = $
;	{ XPcolumnoper, $
	{  $
	command:'col2*col1', $
	to:['0','Append new column','Overwrite existing column',$
		'New Xplot window'], $
	outcol:'2'}
  ; NOTE: if changing this structure, change also flags and titles in
  ; xplot_event!!
  'xpconvolution': xpconvolution = $
;	{ XPconvolution, $
	{ $
	METHOD: ['0','Convolution','Correlation'] ,$
	TYPE: ['0','Auto convolution/correlation', $
		   'with a Gaussian or/and Lorentzian',$
		   'with data from external file'] , $
	FILENAME: '' , $
	NORMALIZATION: ['2','No','To the first set','To the second set',$
			   'To both sets'], $
	VOIGT_RATIO:0.0,$
	VOIGT_FWHM:0.1,$
	OVER: ['0','No','Yes'], $
	WRITE: ['0','No','Yes'], $
	FILEOUT: 'xplot.dat', CALCULATION:['0','FFT','Intregrals'] }

;  ; NOTE: if changing this structure, change also flags and titles in
;  ; xplot_event!!
;  'xpcorrelation': out = $
;;	{ XPcorrelation, $
;	{ $
;	TYPE: ['0','Auto-correlation', $
;		'Correlation with data from external file'] , $
;	FILENAME: '' , $
;	NORMALIZATION: ['1','No','Yes'], $
;	WRITE: ['1','Yes','No'], $
;	FILEOUT: 'xplot.dat' }

  'www': www = {www:'netscape http://www.esrf.fr/computing/expg/subgroups/theory/idl/xplot/xplot.html'}
  'version': version = {version:'2.5.2'}
  'math_routines': math_routines = {math_routines:'Moment:Deriv:Int_Tabulated'+$
       ':Conv2:Conv:Infl:Smooth:Poly_Smooth:Interpol:Spline:LinFit:LadFit'+$
       ':PolyFitW:SVDfit:Gauss_Fit:GaussFit:Curvefit1:PowellFit'}
  else: out = 0
endcase




;
; update values with values in
; files .xplot_defaults in a directory in !PATH
;
file = getenv('XPLOT_DEFAULTS')
if file EQ '' then goto,out
tmp = checkfile(file)
if tmp NE 1 then goto,out
openr,Unit,file,/GET_LUN
command = ''
while (not(eof(Unit))) do begin
  readf,Unit,command
  nn = strparse(command,'.',list)
  if strupcase(inpstring) EQ strupcase(strcompress(list(0))) then begin
  ;print,'***'+command+'***'
  tmp = execute(command)
  endif
endwhile
free_lun,Unit
;message,/info,'Defaults from file: '+file+'
;
; return
;
out:
out = 0
command = 'out = '+inpstring
;print,command 
tmp = execute(command)
return,out
end
