;-------------------------------------------------------------
;+
; NAME:
;       XGetFile
; PURPOSE:
;       Widget based file name input 
; CATEGORY:
; CALLING SEQUENCE:
;       out = xgetfile()
; INPUTS:
;	none
; KEYWORD PARAMETERS:
;       Keywords:
;         WTITLE=   Widget title text (def="XGetFile").
;         TITLE=   Widget label text.
;         /WAIT  means wait for returned result.
;	  DEFAULT= default file name 
;         WRITE=   if set, set title as 'Select File to Read'
;         READ=   if set, set title as 'Select File to Write'
; OUTPUTS:
;       out: a string containing the file name
; COMMON BLOCKS:
; NOTES:
; MODIFICATION HISTORY:
;       M. Sanchez del Rio, Feb 27, 1995
;
;-
;-------------------------------------------------------------
 
	pro xgetfile_event, ev
 
	widget_control, ev.top, get_uval=save
	widget_control, ev.id, get_uval=name
 
;	if name eq 'TEXT' then begin
;        endif

	if name eq 'OK' then begin
	  widget_control, ev.top, get_uval=wids
          widget_control, save.ids, get_val=text
	  widget_control, save.keep, set_uval=text(0)
	  widget_control, ev.top, /dest
	endif
 
	if name eq 'CANCEL' then begin
	  widget_control, save.keep, set_uval=save.text
	  widget_control, ev.top, /dest
	endif
 
	if name eq 'BROWSE' then begin
          tmp=pickfile(read=save.read,write=save.write)
          if tmp ne '' then $
           widget_control, save.ids, set_val=tmp
	endif
 
	return
	end
 
;
;
;
 
	function xgetfile, wtitle=wtitle, title=title, group=group,$
            wait=wait, read=read, write=write, default=default
 
	if n_elements(title) eq 0 then title=''
	if n_elements(wait) eq 0 then wait=0
        if n_elements(wtitle) eq 0 then wtitle='XGetFile'
        if keyword_set(read) then title='Select File to Read:' else read=0
        if keyword_set(write) then title='Select File to Write:' else write=0
        if keyword_set(default) then out=default else out=''
 
	;------  Lay out widget  ----------
	top = widget_base(/column,title=wtitle)
	buttons = widget_base(top, /row)
	b_ok = widget_button(buttons, val='OK',uval='OK')
	b_cancel = widget_button(buttons, val='Cancel',uval='CANCEL')
	b_browse = widget_button(buttons, val='Browse',uval='BROWSE')
	id = widget_label(top,xsize=20,ysize=1,val=title)
	idtxt = widget_text(top,/edit,xsize=20,ysize=1,val=out,$
          uval='TEXT')
 
	;------  Package and store needed info  ------------
        keep=widget_base()
        save = { text:out, ids:idtxt, keep:keep, read:read, write:write }
	widget_control, top, set_uval=save
 
	;------  realize widget  -----------
        save = { text:out, ids:idtxt, keep:keep }
	widget_control, top, /real
 
	;------  Event loop  ---------------
	xmanager, 'xgetfile', top,  modal=wait,  group=group
 
	;------  Get result  ---------------
	widget_control, keep, get_uval=out
 
	return,out
	end
