; Copyright (c) 1991, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
; Copyright (c) 1993-1997,  European Synchrotron Radiation Facility
;	Unauthorized reproduction prohibited.

;
;====================================================================
;
PRO XDispFile1_evt, event
;COMMON XDISPLAYFILE_DATA,textfile,filebase,rmflag

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy



WIDGET_CONTROL, GET_UVALUE = retval, event.id

IF(retval EQ "SOFTEXIT") THEN BEGIN
	widget_control,state.wids.modal_old,get_uvalue=text
	widget_control,state.wids.modal,set_uvalue=text
	widget_control,state.wids.modal_old,set_uvalue='SOFTEXIT'
	WIDGET_CONTROL, event.top, /DESTROY
	return
ENDIF
IF(retval EQ "EXIT") THEN BEGIN
	if state.rmflag then begin
	   if sdep() EQ 'UNIX' then command = '/bin/rm -f '+state.textfile $
		else command = 'del '+state.textfile
	   message,/info,'Executing: '+command
	   spawn,command
	endif
	WIDGET_CONTROL, event.top, /DESTROY
	return
ENDIF
IF(retval EQ "PRINTING") THEN BEGIN
		widget_control,state.wids.text,get_value=tmp
		print_ascii,tmp,GROUP=event.top
ENDIF

IF(retval EQ "Resize") THEN BEGIN
		widget_control,state.wids.text, $
		scr_xsize=event.x-38,scr_ysize=event.y-66
ENDIF

IF(retval EQ "EDIT") and keyword_set(state.wids.modal)  THEN BEGIN
	widget_control,state.wids.text,get_value=a
	widget_control,state.wids.modal,set_uvalue=a
ENDIF

IF(retval EQ "LOADFILE") THEN BEGIN
	file = pickfile(group= event.top, /read, /must_exist)
	;help,file
	if strcompress(file) EQ '' then goto,out
	a = read_textfile(file)
	widget_control,state.wids.text,set_value=a
; if added 98/03/14
	if Widget_Info(state.wids.modal,/Valid) then $
	  widget_control,state.wids.modal,set_uvalue=a
	
ENDIF
IF(retval EQ "HelpCurrent") THEN BEGIN
	help1 = state.help
	if n_elements(help1) EQ 1 then $
	    itmp = execute(help1) else $
	    Xdisplayfile1,text=help1,group=event.top,Title=$
		'Help on current text'
ENDIF
IF(retval EQ "Help") THEN BEGIN
	widget_control,event.id,get_value=tmp
	xhelp,tmp,GROUP=event.top
ENDIF
out:
Widget_Control, stateid, set_UValue=state, /No_Copy
END
;
;====================================================================
;
PRO XDisplayFile1, filename, title = TITLE, GROUP = GROUP, WIDTH = WIDTH, $
	HEIGHT = HEIGHT, TEXT = TEXT, FONT = font, REMOVE = remove, $
	NOSCROLL = noscroll, modal = modal, HELP = help, ACTION = action
;+
; 
; NAME: 
;	XDISPLAYFILE1
;
; PURPOSE:
;	A fancy version of IDL's xdisplayfile. It allows saving, printing
;	and editing the text and resizing the window.
;
;	Display an ASCII text file using widgets and the widget manager.
;
; CATEGORY:
;	Widgets.
;
; CALLING SEQUENCE:
;	XDISPLAYFILE1, Filename
;
; INPUTS:
;     Filename:	A scalar string that contains the filename of the file
;		to display.  The filename can include a path to that file.
;
; KEYWORD PARAMETERS:
;	FONT:   The name of the font to use.  If omitted use the default
;		font.
;	GROUP:	The widget ID of the group leader of the widget.  If this 
;		keyword is specified, the death of the group leader results in
;		the death of XDISPLAYFILE.
;
;	HEIGHT:	The number of text lines that the widget should display at one
;		time.  If this keyword is not specified, 18 lines is the 
;		default.
;
;	TEXT:	A string or string array to be displayed in the widget
;		instead of the contents of a file.  This keyword supercedes
;		the FILENAME input parameter. A numerical array is also
;		accepted as TEXT input (which is converted to string).
;
;	TITLE:	A string to use as the widget title rather than the file name 
;		or "XDisplayFile".
;
;	WIDTH:	The number of characters wide the widget should be.  If this
;		keyword is not specified, 80 characters is the default.
;
;	REMOVE:	when set to 1, remove the file when quitting Xdisplayfile
;	MODAL:	when set to a non-zero value, starts xdisplayfile1 in
;		modal mode. The (modified) text is teturned in the TEXT keyword.
;	HELP  = Creates a new help entry in the Help menu.
;		Set it to variable with either a string or string-vector.
;		Depending on which one is chosen, the functionaly is different:
;		1) A string is interpreted as a command to be executed. i.e. 
;		   XdisplayFile1,text='how are you?',help="print,'socorro'" 
;		   will print "socorro" on your terminal when "help on
;		   current text" is pressed.
;		2) A string-vector is interpreted as a text to be displayed. 
;		   i.e. XdisplayFile1,text='how are you?',help=['help','me'] 
;		   will open a window with a 2-lines text (help me) when 
;		   pressing help.
;		clicking on the "Help" button.
;
; OUTPUTS:
;	No explicit outputs.  A file viewing widget is created.
;	It may create a new file or temporary files then using the 
;	File/Save As... or File/Print... menus.
;
; SIDE EFFECTS:
;	Triggers the XMANAGER if it is not already in use. It may remove
;	the input file if /REMOVE keyword is selected
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Open a file and create a widget to display its contents.
;
; MODIFICATION HISTORY:
;	Initial version by Steve Richards, December 1990
;	Graceful error recovery, DMS, Feb, 1992.
;	93-11-23 M. Sanchez del Rio adds the Print Button and
;		expand the array dimension for the ESRF version only.
;	94-01-25 M. Sanchez del Rio adds the REMOVE keyword
;	94-02-14 MSR renames from XdisplayFile to XdisplayFile1
;	96-07-29 MSR (srio@esrf.fr) changes printing -> print_ascii
;	96-08-13 MSR (srio@esrf.fr) removes limitation in 10000 lines.
;		Removes common block. Cosmetics, resizing, menu bar, etc.
;		TEXT accepts numerical arrays.
;	96-09-24 MSR (srio@esrf.fr) adds MODAL mode.
;	97-01-13 MSR (srio@esrf.fr) removed the xdf_getfile functions
;		and uses read_textfile function instead. Default HEIGHT=18.
;	97-03-25 MSR (srio@esrf.fr) adds /no_block keyword to xmanager
;		for version NE 4.
;	97-10-11 MSR (srio@esrf.fr) adds help keyword and duplicates the 
;		Quit option (Quit and accept and Quit and discard) when
;		both TEXT and MODAL keywords are set.
;		Renames XDISPFILE_EVT to XDISPFILE1_EVT
;	98-04-13 MSR (srio@esrf.fr) fixes a buf when opening files in non-modal.
;-

IF(NOT(KEYWORD_SET(filename))) THEN filename = ''
IF(NOT(KEYWORD_SET(TITLE))) THEN TITLE = filename	;use the defaults if
IF(NOT(KEYWORD_SET(HEIGHT))) THEN HEIGHT = 18		;the keywords were not
IF(NOT(KEYWORD_SET(WIDTH))) THEN WIDTH = 80		;passed in
IF(NOT(KEYWORD_SET(REMOVE))) THEN rmflag = 0 ELSE rmflag = 1
IF(NOT(KEYWORD_SET(title))) THEN title='XDisplayFile1'
IF KEYWORD_SET(noscroll) THEN scroll = 0 else scroll = 1
textfile = filename
IF(NOT(KEYWORD_SET(HELP))) THEN help = 0 

IF(NOT(KEYWORD_SET(TEXT)))THEN BEGIN
     a = read_textfile(filename) 
     if n_elements(a) eq 1 and a(0) eq '' then a=$
	['Error opening/reading file :'+filename,$
	'Use File/Load File... menu to load a text file.']
ENDIF ELSE BEGIN
  if type(text) eq 7 then a=text else begin
     nn = n_elements(text(*,0))
     a = string(text(0,*))
     if nn GT 1 then for i=1,nn-1 do a = a+string(text(i,*))
  endelse
  ;a = TEXT
ENDELSE

filebase = WIDGET_BASE(TITLE = TITLE, $			;create the base
		/COLUMN, $
		SPACE = 20, $
		XPAD = 20, $
		YPAD = 20,MBAR=wMenuBar,/TLB_SIZE_EVENTS,UVALUE='Resize')

wbase = widget_base(filebase) ; to store state

if keyword_set(modal) then wmodal = widget_base(uval=a) $
	else wmodal=0L; to store text 
if keyword_set(modal) and keyword_set(text) then $
        wmodal_old = widget_base(uval=a)  else wmodal_old=0L; to store initial text 


wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Load File...', Uvalue= 'LOADFILE')
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Print.../Save as...', Uvalue= 'PRINTING')
  if keyword_set(TEXT) and keyword_set(MODAL) then begin
    wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit and discard changes', $
	Uvalue= 'SOFTEXIT',/SEPARATOR)
    wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit and accept changes', $
	Uvalue= 'EXIT')
  endif else begin
    wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'EXIT',/SEPARATOR)
  endelse
wHelpMenu =  WIDGET_BUTTON(wMenuBar, VALUE='Help', /help)
  if keyword_set(help) then $
  wtmp=WIDGET_BUTTON(wHelpMenu, VALUE='on current text', Uvalue= 'HelpCurrent')
  wtmp=WIDGET_BUTTON(wHelpMenu, VALUE='xdisplayfile1', Uvalue= 'Help')



IF n_elements(font) gt 0 then $
 filetext = WIDGET_TEXT(wbase, $			;create a text widget
		XSIZE = WIDTH, $			;to display the file's
		YSIZE = HEIGHT, $			;contents
		SCROLL=scroll, FONT = font, $
		VALUE = a,/edit,UVALUE='EDIT',/all_events) $
ELSE filetext = WIDGET_TEXT(wbase, $			;create a text widget
		XSIZE = WIDTH, $			;to display the file's
		YSIZE = HEIGHT, $			;contents
		SCROLL=scroll, $
		VALUE = a,/edit,UVALUE='EDIT',/all_events)


WIDGET_CONTROL, filebase, /REALIZE			;instantiate the widget

wids = { text:filetext, modal:wmodal, modal_old:wmodal_old}
state = { textfile:textfile, rmflag:rmflag, help:help, wids:wids}
widget_control,Widget_Info(filebase,/Child),set_uvalue=state,/no_copy

if sdep(/vs) eq '4' then begin
Xmanager, "XDisplayFile", $				;register it with the
		filebase, $				;widget manager
		GROUP_LEADER = GROUP, $
		EVENT_HANDLER = "XDispFile1_evt" ,modal=modal
endif else begin 
Xmanager, "XDisplayFile", $				;register it with the
		filebase, $				;widget manager
		GROUP_LEADER = GROUP, $
		EVENT_HANDLER = "XDispFile1_evt" ,modal=modal,/NO_BLOCK
endelse

if keyword_set(wmodal) then  begin
   widget_control,wmodal,get_uvalue=text,/destroy
   if keyword_set(wmodal_old) then begin
     widget_control,wmodal_old,get_uvalue=tmp,/destroy
     if tmp(0) EQ 'SOFTEXIT' then ACTION='DONT' ELSE ACTION='DO'
   endif
endif

END  ;--------------------- procedure XDisplayFile1 ----------------------------
