FUNCTION VECT2STRING,a
;+
; FUNCTION VECT2STRING,a
; writes a vector "a" into a string in the IDL vector format, i.e
; [a0,a1,a2,...]
;-
dum = size(a)
type =  dum(dum(0) + 1)
nelem = n_elements(a)

result = '['
if type EQ 7 then begin   ; string case
  for i=0,nelem-2 do begin
     result = result  + "'" +  a(i) + "'" +  ','
  endfor
  result = result  + "'" + a(nelem-1) + "'" + ']'
endif else begin         ; numerical case
  for i=0,nelem-2 do begin
     result = result  + strcompress(a(i),/remove_all) + ','
  endfor
  result = result  + strcompress(a(nelem-1),/remove_all) + ']'
endelse
;
return,result
end
