pro TEXTWINDOW_EVENT,event
; 
widget_control, event.top, GET_UVALUE = state 
widget_control, event.id,  GET_UVALUE = eventuval

CASE eventuval OF
        'EXIT': BEGIN
                WIDGET_CONTROL,event.top,/DESTROY
                return
                END
        'PRINT': print_ascii,state.data,group=event.top
ENDCASE
;widget_control, event.top, SET_UVALUE = state, /NO_COPY
END




pro TEXTWINDOW , textarray, XSIZE=XSIZE, YSIZE=YSIZE, TITLE=TITLE, $
    GROUP=group,NO_BLOCK=no_block
;+
; NAME:
;	TEXTWINDOW
; PURPOSE:
;	To display a text in a window
; CATEGORY:
;	Widgets
; CALLING SEQUENCE:
;	TEXTWINDOW,text,keywords
; INPUTS:
;	text= a string array with the text to display
; OPTIONAL INPUT PARAMETERS:
; KEYWORD PARAMETERS:
;		TITLE = widget title
;		XSIZE = the horizontal size of the main window in 
;			characters (default: 80)
;		YSIZE = the vertical size of the main window in 
;			characters (default: number of text lines)
;		GROUP = id of the parent widget
;		NO_BLOCK = when set, starts xmanager with the NO_BLOCK kw.
; OUTPUTS:
;	interactive created a window
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE;
;	Straightforward
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, Feb 1995
;	97-11-13 srio@esrf.fr adds the NO_BLOCK kwyword.
;-
on_error,2

if not(keyword_set(title)) then title='TextWindow'
if not(keyword_set(xsize)) then xsize = 80
if not(keyword_set(ysize)) then ysize = n_elements(textarray)

textbase=WIDGET_BASE(TITLE=title,/COLUMN,SPACE=15)
;m_items = [     '"Done"    EXIT', '"Print"   PRINT' ]
mmenu = xpdmenu1(['"Done"    EXIT','"Print"   PRINT'], textbase)

textwidget=WIDGET_TEXT(textbase,VALUE=textarray,xsize=xsize,YSIZE=ysize)
state = { mmenu:mmenu, textwidget:textwidget, data:textarray}
WIDGET_CONTROL,textbase,/NO_COPY,/REALIZE,SET_UVAL=state
if keyword_set(no_block) then $
  XMANAGER,'textwindow',textbase,GROUP_LEADER=group,/NO_BLOCK else $
  XMANAGER,'textwindow',textbase,GROUP_LEADER=group
end
