PRO split_rou,file,verbose=verbose

;+
; NAME:
;	SPLIT_ROU
; PURPOSE:
;	Reads an IDL source file and splits it in many files, one for
;	each function or procedure.
; CATEGORY:
;	Utilities.
; CALLING SEQUENCE:
;	split_rou,file
; INPUTS:
;	file: the source file
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;	VERBOSE: When set, explain verbosely the splitting process.
; OUTPUTS:
;	Creates many files.
; PROCEDURE:
;	String managment
;
; MODIFICATION HISTORY:
;	Created MAR-1997 by M. Sanchez del Rio (srio@esrf.fr) (c)ESRF
;
;-


if sdep() EQ 'UNIX' then command='cp ' else command='copy '
spawn,command+file+' '+file+'.BAK' 
message,/info,'File '+file+' copied to '+file+'.BAK'

a0=read_textfile(file)
a1 = a0 ;(where(a0 NE ''))
atmp = strcompress(a1)
index_s = [0]
names = ['']
for i=0L,n_elements(atmp)-1 do begin
  line = strupcase(atmp(i))
  tmp0 = (strpos(line,'FUNCTION '))(0) 
  tmp1 = (strpos(line,'PRO ') )(0)
  if tmp0 EQ 0 or tmp1 EQ 0 then begin
    index_s=[index_s,i]
    line = strsubstitute(line,' ',',')
    tmp = strparse(line,',',list)
    names = [names,strlowcase(list(1))]
    if keyword_set(verbose) then $
      print,'Routine '+strlowcase(list(1))+' found starting at line '+$
      strcompress(i+1,/rem)
  endif
endfor
names = names(1:n_elements(names)-1)
index_s_old = index_s
index_s = index_s_old(1:n_elements(index_s_old)-1)
index_s(0) = 0 ; to force starting from the file start.

index_e = index_s-1
index_e = [index_e(1:n_elements(index_e)-1),n_elements(a1)-1]
if keyword_set(verbose) then begin
  print,'starting indeces: ',index_s
  print,'ending indeces: ',index_e
  help,names
  help,index_s
  help,index_e
endif

if n_elements(names) NE n_elements(index_s) then message,'Bad file.'
openw,unit1,'split_rou_back.sh',/get_lun
printf,unit1,'#!/bin/sh'
for i=0,n_elements(names)-1 do begin
  openw,unit,names(i)+'.pro',/get_lun
  tmp = a1(index_s(i):index_e(i))
  for j=0,n_elements(tmp)-1 do printf,unit,tmp(j)
  free_lun,unit
  print,'File '+names(i)+'.pro written to disk.'
  if i EQ 0 then printf,unit1,'cp '+names(i)+'.pro '+file else $
                 printf,unit1,'cat '+names(i)+'.pro >> '+file
endfor
free_lun,unit1
spawn,'chmod +x split_rou_back.sh'
message,/info,'Succesfully ended.'
message,/info,'use the created file split_rou_back.sh to rebuild the file.'
end


