
function read_textfile,filename,buffer=buffer


;+
; 
; NAME: 
;	READ_TEXTFILE
;
; PURPOSE:
;	Reads a text (ascii) file and stores result in a string array.
;
; CATEGORY:
;	Utilities.
;
; CALLING SEQUENCE:
;	text = READ_TEXTFILE('Filename')
;
; INPUTS:
;     Filename:	A scalar string that contains the filename of the file
;		to read.  The filename can include a path to that file.
;
; OUTPUTS:
;    Text: a string array with the text.
;
; KEYWORD PARAMETERS:
;	BUFFER: the number of lines in the buffer for reading the 
;		first file block. By default it uses Buffer=10000. 
;		For files with more that 10000 lines, the lecture is
;		slow because the buffer is then redefined for each 
;		additional line.  Defining Buffer >= nlines the speed 
;		is optimised.
;
;
; RESTRICTIONS:
;	Slow for big files. See BUFFER keyword to speed it up.
;
; PROCEDURE:
;	Straightforward. Based on a function in xdisplayfile1.
;
; MODIFICATION HISTORY:
;	Written By Manuel Sanchez del Rio (srio@esrf.fr), January 13 1997
;	97-03-18 MSR adds buffer keyword and users temporary() function.
;
;-
on_error,2

OPENR, unit, filename, /GET_LUN, ERROR=i		;open the file and then
if keyword_set(buffer) then buffer=long(buffer) else buffer=10000L
if i lt 0 then begin		;OK?
	message,/info,'Error reading file: '+filename
	a=''
endif else begin
	  a = strarr(buffer)
	  i = 0L
	  c = ''
	  while not eof(unit) do begin
		readf,unit,c
		;avoid limitation of max num of lines.
		if i le buffer-1 then a(i) = c else a=[temporary(a),c]
		i = i + 1
		endwhile
	  a = temporary(a(0:i-1))
	  FREE_LUN, unit				;free the file unit.
endelse
return,a
end
