;+
; NAME:
;	PRINTING
;
; PURPOSE:
;	This procedure prints a text or some graphics to the printer or
;		to file
;
; CATEGORY:
;	general utility
;
; CALLING SEQUENCE:
;	PRINTING, Keyword_parameters
; INPUTS:
;	Inputs are got from common blocks and keyword parameters.
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	IMAGECOMMAND:	In case of printing of graphics, you have to
;			store the draw commands in this vector of strings.
;			In case of text you have to omit this keyword.
;
;	DATA:	The data to be printed. For text it is only a string or
;		a vector of strings. For graphics it is usually a matrix
;		which stores the data used by the commands 'IMAGECOMMAND'.
;
;	NOTYPE:	If you set this keyword you will not be able to choose
;		between 'Portait' and 'Landscape' printing, i.e. the
;		buttons for setting it will not appear.
;		It is worth using always in case of printing text. 
;
;	GROUP:	The widget ID of the group leader widget.
;	COLOR:	When set to 1, then set the ps device for color output
;		by using the PHASER procedure
;	FILE:	name of a file on disk to be printed. Example
;		PRINTING,FILE='a.dat',/NOTYPE
;
; OUTPUTS:
;	Normally: the printed text or graphics
;	If you print to file: the file
;	The routine modifies the variables of the printdefaults common
;	block.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;	printdefaults:	These variables are for communicating between the
;			calling program and the procedure about some
;			default values.
;	printingblock
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;	You can use this routine if the 'IMAGECOMMAND' commands use
;	only one variable whose name has to be data. The program gets
;	the value if you set the DATA keyword. The other values have
;	to be transferred as constants.
;
; PROCEDURE:
;
; EXAMPLE:
;	Printing an image stored in the matrix img by using the surface
;	command. The values greater than maxval will not appear.
;
;	On display we would use the next command:
;		'surface,data, MAX_VALUE=maxval
;
;	For printing we use the next:
;
;	buffer=strarr(1)
;	buffer(0)='surface,data, MAX_VALUE='+str(maxval)
;	printing,IMAGECOMMAND=buffer,DATA=img
;
; MODIFICATION HISTORY:
; 	Written by:	Szabolcs Kesmarki, July 1993.
;	93-11-18 M. Sanchez del Rio adds default common block variables
;			and adds the COLOR keyword
;	93-11-23 M. Sanchez del Rio adds FILE keyword
;	95-04-10 Roger J. Dejus, added call to XOP_DEFAULTS if PRINTER
;                is not defined, XFD/APS.
;	96-01-17 MSR, if PRINTER is not defined, call getsysprinter()
;-

pro printing_event,event

COMMON printingblock,data, pcommand, printbase, prnamefield, $
  typebuttons, tofilebuttons, color, gfile
COMMON printdefaults,defaultfilename,defaultprname,defaulttype,defaulttofile

WIDGET_CONTROL,event.id,GET_UVALUE=eventuval
CASE eventuval OF
	'PRINTOK':BEGIN
		WIDGET_CONTROL,prnamefield,GET_VALUE=name
;
; Printing text file
;
                IF ((pcommand(0) EQ '0') AND (gfile NE '')) THEN BEGIN         
		      command = 'lp -d'+ $ 
			strcompress(name,/rem)+' '+gfile
		      print,'PRINTING: '+command
		      SPAWN,command
		ENDIF ELSE BEGIN
		  WIDGET_CONTROL,tofilebuttons, GET_VALUE=defaulttofile
		  name=name(0)
		  IF pcommand(0) EQ '0' THEN BEGIN	; Printing text
			  IF defaulttofile EQ 0 THEN BEGIN
				  filename='idl.ps'    ; !! TEXT FILE!!
				  defaultprname=name
			  ENDIF ELSE BEGIN
				  filename=name
				  defaultfilename=name
			  ENDELSE
			  openw,unit,filename,/get_lun ;Printing the 
						       ; text into the file
			  printf,unit,data
			  free_lun,unit
			  IF defaulttofile EQ 0 THEN BEGIN
				  ; Printing to printer: 
				  ; using lp UNIX command	
				  spawn,'lp -d'+ $
				  strcompress(defaultprname,/rem)+ $
				  ' idl.ps'
				  spawn,'/bin/rm -f /tmp/idl.ps'
			  ENDIF
		  ENDIF  ELSE BEGIN	; Printing graphics
			  WIDGET_CONTROL,typebuttons,GET_VALUE=defaulttype
			  ; the output is a postscript file
			  IF (color EQ 1) THEN PHASER ELSE  SET_PLOT,'ps'
			  CASE defaulttype OF
				  0:	device,/portrait
				  1:	device,/landscape
			  ENDCASE
			  ; Every elements of pcommand is executed
			  elementnum=n_elements(pcommand)-1
			  FOR i=0,elementnum DO temp=execute(pcommand(i))
			  ; the output is the screen again
			  device,/close
			  set_plot,'x'
			  IF defaulttofile EQ 0 THEN BEGIN
				  ; Printing to printer: using lp UNIX command
				  defaultprname=name
				  spawn,'lp -d'+ $
				  strcompress(defaultprname,/rem)+ $
				  ' idl.ps'
				  ; Removing idl.ps file
				  spawn,'/bin/rm -f idl.ps'			
			  ENDIF ELSE BEGIN
				  ; Printing to file: renaming the file to 
				  ; the desired name defaultfilename=name
				  spawn,'/bin/mv -f idl.ps '+ $
				  strcompress(defaultfilename,/rem)
			  ENDELSE		
		  ENDELSE
		ENDELSE
		WIDGET_CONTROL,printbase,/DESTROY
		END
	'PRINTCANCEL':WIDGET_CONTROL,printbase,/DESTROY
	; If the tofilebuttons were touched, the name in the prnamefield
	; has to be changed from defaultfilename to defaultprname or vica versa
	'TOFILE':	BEGIN
			WIDGET_CONTROL,tofilebuttons, GET_VALUE=tofile
			IF tofile EQ 0 $
			  THEN WIDGET_CONTROL, prnamefield,  $
			  SET_VALUE=defaultprname $
			ELSE WIDGET_CONTROL, prnamefield, $
			  SET_VALUE=defaultfilename
			END
ENDCASE
END
;------------------------------------------------------------------------
pro printing, IMAGECOMMAND=command, DATA=qdata, GROUP=group, $
NOTYPE=notype,COLOR=pcolor, FILE=ffile
;type=0 if no type selection
;	1,if type=portrait
;	2,if type=landscape
;
;
;	creates a 'Print' pop-up window
;	register printing_event as an event handler

COMMON printingblock, data, pcommand, printbase, prnamefield, $
  typebuttons, tofilebuttons, color, gfile
COMMON printdefaults, defaultfilename, defaultprname, defaulttype, defaulttofile

IF xregistered("printing") EQ 0 THEN $	; It can be started if
BEGIN					; it has not been started yet

IF KEYWORD_SET(command) EQ 0 THEN command='0'
IF KEYWORD_SET(notype) EQ 0 THEN notype=0
IF KEYWORD_SET(qdata) EQ 0 THEN qdata=''
IF NOT(KEYWORD_SET(ffile)) THEN gfile='' ELSE gfile=ffile
IF KEYWORD_SET(pcolor) THEN color=pcolor ELSE color=0 
data=qdata & pcommand=command
;
; if defaultfilename, defaultprname, defaulttype, defaulttofile
; are undefined, sets it
;
dsize=size(defaultfilename)
if dsize(n_elements(dsize)-2) EQ 0 THEN defaultfilename='/tmp/idl.ps'
dsize=size(defaultprname)
;if dsize(n_elements(dsize)-2) EQ 0 THEN defaultprname='a4bc222'

IF dsize(n_elements(dsize)-2) EQ 0 THEN defaultprname = GETSYSPRINTER(/VERBOSE)
dsize=size(defaulttype)
if dsize(n_elements(dsize)-2) EQ 0 THEN defaulttype=0
dsize=size(defaulttofile)
if dsize(n_elements(dsize)-2) EQ 0 THEN defaulttofile=0
;
; Creating of the widgets:
;
printbase=WIDGET_BASE(TITLE='Print', SPACE=15, /COLUMN)
IF defaulttofile EQ 0 THEN val=defaultprname ELSE val=defaultfilename
prnamefield=CW_FIELD(printbase,TITLE='Printer or file name:',$
  VALUE=val, /FRAME)

type_items=['Portrait','Landscape']
IF notype EQ 0 THEN BEGIN
	typebuttons=CW_BGROUP(printbase, type_items, UVALUE='TYPE', $
	  /EXCLUSIVE, /ROW)
	WIDGET_CONTROL,typebuttons, SET_VALUE=defaulttype
	END

IF NOT(KEYWORD_SET(ffile)) THEN BEGIN
    tofile_items=['Printer',' File ']
    tofilebuttons=CW_BGROUP(printbase, tofile_items, UVALUE='TOFILE', $
      /EXCLUSIVE, /ROW)	
    WIDGET_CONTROL,tofilebuttons , SET_VALUE=defaulttofile
ENDIF

XMENU, ['  OK   ','Cancel'], printbase, UVALUE=['PRINTOK', $
  'PRINTCANCEL'], SPACE=10, /ROW
WIDGET_CONTROL,printbase,/REALIZE

XMANAGER,'printing',printbase,GROUP_LEADER=group
ENDIF
END
