
;+
; NAME:
;	PRINT_ASCII
;
; PURPOSE:
;	This procedure prints a text (to the printer or to a file).
;
; CATEGORY:
;	general utility
;
; CALLING SEQUENCE:
;	PRINT_ASCII [, text, Keyword_parameters] 
; INPUTS:
;
; OPTIONAL INPUTS:
;	Text =  s string array with the text to be printed.
;	
; KEYWORD PARAMETERS:
;	FILE:	A file name to be printed. If this keyword is
;		set, then PRINT_ASCII will print the file and it
;		will ignore the optional input "text".
;			In case of text you have to omit this keyword.
;	GROUP:	The widget ID of the group leader widget.
;
; OUTPUTS:
;	Normally: the printed text or file.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;	print_ascii: command (the printing command). This common block
;		is used to initialize the print_ascii command in
;		succesive calls.
;
; SIDE EFFECTS:
;	when optional input "text" is used, print_ascii dumps its
;	contents in a file 'print_text.txt' in the current directory
;	prior to be sent to the	printer. This  file is removed once
;	printer. Note that the user has to have writing permission
;	in the current directory in order to allow printing.
;
; RESTRICTIONS:
;
; PROCEDURE:
;
; EXAMPLE:
;	1) Printing a text:
;	print_ascii,['This is my text','line2','line3']
;	2) Printing a file:
;	print_ascii,file = 'filename'
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) on 96/07/10
;		(print_ascii together with xprint makes printing obsolete.)
;	96-08-13 MSR (srio@esrf.fr) makes a loop to dump file lines
;		instead of dumping the full text.
;	96-09-20 MSR (srio@esrf.fr) adds hint text for appending to a file.
;	97-02-21 MSR (srio@esrf.fr) ports to Windows95.
;	97-10-27 MSR (srio@esrf.fr) sdep() used.
;-

pro print_ascii_event,event
COMMON printascii, command

on_error,2

Widget_Control, event.id, get_UValue=eventUValue

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
;if eventuvalue EQ 'COMMAND' then return


;help,eventuvalue
case eventuvalue of
  'CANCEL':begin
        widget_control,/destroy,event.top
        return
        end
  'OK':begin
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state, /No_Copy

	widget_control,state.wids.command,get_value=tmp
	command = tmp(0)
	if state.ifile EQ 0 then begin
	  if sdep() EQ 'WINDOWS' then file = 'pr_ascii.txt' else $
		file = 'print_ascii.txt'
	  message,/info,'Dumping text into file '+file
	  openw,Unit,file,/get_lun
	  for ii=0,n_elements(state.text)-1 do printf,Unit,state.text(ii)
	  free_lun,Unit
	endif else file = state.file
	command1 = strsubstitute(command,'%F',' '+file+' ')
	message,/info,'Executing: '+command1  & spawn,command1
	if state.ifile EQ 0 then begin
	  if sdep() EQ 'WINDOWS' then command1='del '+file else $
		command1 = '/bin/rm '+file
	  message,/info,'Executing: '+command1 & spawn,command1
	endif
        widget_control,/destroy,event.top
        return
        end
   else:
endcase

END
;------------------------------------------------------------------------
pro print_ascii, text, FILE=FILE, GROUP=group

COMMON printascii, command

IF xregistered("print_ascii") THEN return
if n_elements(command) EQ 0 then begin
  PrinterName = GetSysPrinter(/Verbose)
  if sdep() EQ 'WINDOWS' then command='c:\windows\notepad %F' else $
	command = 'cat %F | lp -d'+PrinterName
endif

if n_elements(text) EQ 0 then text = ''
if keyword_set(file) then ifile = 1 else ifile = 0
if n_elements(file) EQ 0 then file = ''
;
; Creating of the widgets:
;
base = widget_base(/COLUMN,TITLE='Print ASCII')

Bbox = widget_base(base,/Row,/FRAME)
tmp = widget_label(Bbox,VALUE='Printing command: ')
Bcommand = widget_text(Bbox,VALUE=command,XSIZE=30,/EDIT) ;,UVALUE='COMMAND')

Bbox = widget_base(base,/Row,/FRAME)
tmp = widget_button(Bbox,value='Cancel',UVALUE='CANCEL')
tmp = widget_button(Bbox,value='OK',UVALUE='OK')

Bbox = widget_base(base,/Col,/FRAME)
tmp = widget_label(Bbox,value='Hints: ')
tmp = widget_label(Bbox,/align_left, $
	value='%F is the text file to be printed or manipulated. ')

tmp = widget_label(Bbox,value='Examples: ')
if sdep() EQ 'WINDOWS' then begin 
tmp = widget_label(Bbox,/align_left, value=$
  "'c:\windows\notepad %F' (to send the text to Windows-Notepad)")
  tmp = widget_label(Bbox,/align_left, $
	value="'type %F > tmp.lis' (to create a text file)")
  tmp = widget_label(Bbox,/align_left, $
	value="'type %F >> tmp.lis' (to append to a text file)")
endif else begin
  tmp = widget_label(Bbox,/align_left, $
	value="'cat %F | lp' (to send the text to printer)")
  tmp = widget_label(Bbox,/align_left, $
	value="'cat %F > tmp.lis' (to create a text file)")
  tmp = widget_label(Bbox,/align_left, $
	value="'cat %F >> tmp.lis' (to append to a text file)")
  tmp = widget_label(Bbox,/align_left, $
	value="'a2ps %F | lp' (to use a2ps formatting program)")
endelse

wids = {command:Bcommand}
state = { wids:wids, text:text, ifile:ifile, file:file}
widget_control,Widget_Info(base,/Child),set_uvalue=state

widget_control,base,/REALIZE
XMANAGER,'print_ascii',base,GROUP_LEADER=group
END
