Function matr2coor,z,x,y,switch=switch
;+
; NAME:
;	MATR2COOR
;
; PURPOSE:
;	This function stores in a 3-column matrix (fltarr(3,N)) the
;	coordinates (x,y,z) of a surface given in z [,x,y] (z is
;	a 2-dimensional array, y and z are 1-dimensional arrays).
;	For the resulting variable, column 0 is x, 1 is y and 2 is z
;
; CATEGORY:
;	general utilities.
;
; CALLING SEQUENCE:
;	result = matr2coor(z [,x,y])
;
; INPUTS:
;	z: the surface array
;
; OPTIONAL INPUTS:
;	x: the surface x-values
;	y: the surface y-values
;	
; KEYWORD PARAMETERS:
;	SWITCH: if set, switch the x <-> y arrays.
;
; OUTPUTS:
;	result: a fltarr(3,N)
;
; PROCEDURE:
;	Straightforward.
;
; RESTRICTIONS
;	WARNING: dimensions must be coherents (Nz = Nx * Ny)
;
; SEE ALSO
;	coor2matr
; EXAMPLE:
;		resul = matr2coor( dist(30) )
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio 
;	April 4, 1997
;-
on_error,2
if n_params() EQ 1 then begin
  x = findgen(n_elements(z(*,0)))
  y = findgen(n_elements(z(0,*)))
endif
if (n_elements(y)*n_elements(x) ne n_elements(z)) then begin
  message,/info,'Error. Data gridding is not regular. Abort.'
  return,0
endif

tmp = fltarr(3,n_elements(z))
if keyword_set(switch) then begin
  x1=y
  y1=x
endif else begin
  x1=x
  y1=y
endelse
;
; retabulate the array
;
i=0L
for j=0L,n_elements(x1)-1 do begin
  for k=0L,n_elements(y1)-1 do begin
    tmp(0,i) = x1(j)
    tmp(1,i) = y1(k)
    tmp(2,i) =  z(j,k)
    i=i+1
  endfor
endfor
return,tmp
end

