function make_str,text,file=file,header=header
;
; makes an idl structure from data in a text string.
;
; limitations: beware of the maximum string length for a command
; and the max number of tags of the structure:.
;

;+
; NAME:
;
; PURPOSE:
;	This function creates an structure (anonymous) from information in 
;	either a string array or in a file.
;	If a string array is selected, each line contains two or three fields
;	separated by "|". Fists field is the initialization value, second field
;	is the tag name, and third field is the value. When third fields is
;	missing, the value is set equal to the initialization value.
;	When a file is selected, a number of comment lines plus N lines with
;	the same arrangements are used.
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	result = make_str(text)
;
; INPUTS:
;	text: the text (string array) or the file name.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;       FILE: when set, "text" is interpreted as file name.
;	HEADER=n; The number of header lines in the file (only valid when
;		FILE is set).
;
; OUTPUTS:
;	The structure
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	text = ['0.7 | a',"'Its me again...' | b"]
;	help,/str,make_str(text)
;	** Structure <34d740>, 2 tags, length=12, refs=1:
;	   A               FLOAT          0.700000
;	   B               STRING    'Its me again...'
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 97-04-07
;	97/11/04  srio@esrf.fr removes the limitation in 255 characters
;		for the structure definition by using create_struct().
;	
;-
on_error,2
if keyword_set(file) then begin
  a=read_textfile(text)
  ; remove header comment lines
  if keyword_set(header) then a=a(header:n_elements(a)-1) 
endif else a=text

n=n_elements(a)
tag_descript = strarr(n)
tagnames = strarr(n)
tagvalues = strarr(n)
tagflags=intarr(n)
for i=0,n-1 do begin
  nn=strparse(a(i),'|',list)
  if (nn EQ 2 OR nn EQ 1) then begin
    tag_descript(i)=list(0)
    tagnames(i)=list(1)
    if nn EQ 2 then begin
      tagvalues(i)=list(2) 
      tagflags(i)=1
    endif else begin
      tagvalues(i)=list(0)
    endelse
  endif
endfor
;
; creates the structure with the initialization values
;
out=0
;command="out={"
;if n GE 2 then for i=0,n-2 do command=command+tagnames(i)+$
;  ":"+tag_descript(i)+","
;command=command+tagnames(n-1)+":"+tagvalues(n-1)+"}"
;itmp=execute(command)
command="out=create_struct('"+strcompress(tagnames(0),/rem)+"',"+tag_descript(0)+")"
;print,'**'+command+'**'
itmp=execute(command)
if itmp NE 1 then begin
  message,/info,'Error executing: '+command
  return,0
endif
if n GE 2 then for i=1,n-1 do begin
  command = "out=create_struct(out,'"+strcompress(tagnames(i),/rem)+"',"+tag_descript(i)+")"
  ;print,'**'+command+'**'
  itmp=execute(command)
  if itmp NE 1 then begin
    message,/info,'Error executing: '+command
    return,0
  endif
endfor

;
; place the tagvalues (when different from init values) in the structure.
;
index = where(tagflags EQ 1)
if n_elements(index) EQ 1 and index(0) EQ -1 then return,out
;for i=0,n-1 do begin
for i=0,n_elements(index)-1 do begin
  command='out.'+tagnames(index(i))+'='+tagvalues(index(i))
  ;print,command
  itmp=execute(command)
  if itmp NE 1 then begin
    message,/info,'Error executing: '+command
    return,0
  endif
endfor
return,out
end
