function HISTOGRAMW2,arr1,arr2,wei,binsizex=p_binsizex, $
binsizey=p_binsizey, XRANGE=p_xrange, YRANGE=p_yrange, $
input=hy,xval=xval,yval=yval,nbinsx=nbinsx,nbinsy=nbinsy
;+
; NAME:
;	HISTOGRAMW2
; PURPOSE:
;	Same as HISTOGRAM, but weighted by wei array and bidimensional.
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	a= HISTOGRAMW2(arr1,arr2,wei,keywords)
; INPUTS:
;	ARR1 name of the array with data
;	ARR2 name of the array with data
; OPTIONAL INPUT PARAMETERS:
;	WEI name of the array with weigths 
; KEYWORD PARAMETERS:
;       BINSIZEX = bx :  binsize along x-axis.
;       BINSIZEY = by :  binsize along y-axis.
;       XRANGE = [x_min,x_max]
;       YRANGE = [y_min,y_max]
;	INPUT = 
;       Set this keyword to a named variable that contains an array to be added
;       to the output of HISTOGRAM. The density function of Array is added to
;       the existing contents of INPUT and returned as the result. The array is
;       converted to longword type if necessary and must have at least as many
;       elements as are required to form the histogram.
;       Multiple histograms can be efficiently accumulated by specifying partial
;       sums via this keyword.
;       [XY]VAL
;       Set this keyword to a named variable that contains an array with the
;       x(abscissas) or/and y(ordinates) values for the histogram
;       NBINS[XY]
;       Set this keyword to a number of bins  desired for the plot. If
;       this keyword is set, the respective binsize[xy] kw is irrelevant.
;
; OUTPUTS:
;	Density function of ARR (bidimensional)
; OPTIONAL OUTPUT PARAMETERS:
;	Same as HISTOGRAM.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble Feb 1992
;	95-02-08 MSR renames histogramw3->histogramw2 & cosmetics
;	96-05-14 MSR speeds it up. Adds INPUT, NBINS[XY] and
;		[XY]VAL keywords.
;-
on_error,2

if n_params() EQ 2 then wei = replicate(1.,n_elements(arr1))
if ( (n_elements(arr1) ne n_elements(arr2)) or $
     (n_elements(arr1) ne n_elements(wei)) ) then begin
    print,' array dimensions not compatible.' 
    return,0
    endif
;
; set limits
;
if keyword_set(p_xrange) then xrange = p_xrange else $
                              xrange = [min(arr1),max(arr1)]
if keyword_set(p_yrange) then yrange = p_yrange else $
                              yrange = [min(arr2),max(arr2)]
;
; new data considering limits
help,arr1
help,arr2
;if keyword_set(p_xrange) then begin
;  flg = where( (arr1 GE xrange(0)) AND (arr1 LE xrange(1)) )
;  if n_elements(flg) GT 1 then begin
;    arr1 = arr1(flg)
;    arr2 = arr2(flg)
;  endif
;endif
if (keyword_set(p_xrange) OR keyword_set(p_yrange)) then begin
  flg = where( (arr1 GE xrange(0)) AND (arr1 LE xrange(1)) $
   AND (arr2 GE yrange(0)) AND (arr2 LE yrange(1)) )
  if n_elements(flg) GT 1 then begin
    arr1 = arr1(flg)
    arr2 = arr2(flg)
    wei = wei(flg)
  endif
endif
nelem=n_elements(arr1)
if n_params() EQ 2 then wei = replicate(1.,nelem)
;
; set bins
;
if keyword_set(p_binsizex) then binsizex = p_binsizex else binsizex = 1
if keyword_set(p_binsizey) then binsizey = p_binsizey else binsizey = 1
;nbinsx = fix( .9999 + ((xrange(1) - xrange(0)) /binsizex))
;nbinsy = fix( .9999 + ((yrange(1) - yrange(0)) /binsizey))
;nbinsy = round( (yrange(1) - yrange(0)) /binsizey )

if keyword_set(nbinsx) then begin
  binsizex = xrange(1)-xrange(0)/nbinsx
endif else begin
  nbinsx = round( (xrange(1) - xrange(0)) /binsizex )
endelse

if keyword_set(nbinsy) then begin
  binsizey = yrange(1)-yrange(0)/nbinsy
endif else begin
  nbinsy = round( (yrange(1) - yrange(0)) /binsizey )
endelse

print,'HISTOGRAMW2: bins in x and y: ',nbinsx,nbinsy
print,'HISTOGRAMW2: bin size in x and y: ',binsizex,binsizey
;
; calculate histogram
;
if n_elements(hy) EQ 0 then hy = fltarr (nbinsx,nbinsy) ; if not input set
hwx_arr = fix( (arr1-xrange(0))/binsizex ) < (nbinsx-1)
hwy_arr = fix( (arr2-yrange(0))/binsizey ) < (nbinsy-1)
for ii=0L,nelem-1 do begin
  hwx = hwx_arr(ii)
  hwy = hwy_arr(ii)
  hy(hwx,hwy) = hy(hwx,hwy) + wei(ii)
endfor
if n_elements(xval) NE 0 then $
  xval = xrange(0)+findgen(nbinsx)/(nbinsx-1)*(xrange(1)-xrange(0))
if n_elements(yval) NE 0 then $
  yval = yrange(0)+findgen(nbinsy)/(nbinsy-1)*(yrange(1)-yrange(0))
return, hy
end
