;+
; NAME:
;	CW_Toolbar
;
; PURPOSE:
;       This function creates a toolbar with buttons that can hold
;	bitmaps.
;       It also has a comment-line or tip-tool, which explains the function of 
;	a single button when the mouse is positioned on the button.
;
; CATEGORY:
;       Compound Widget
;
; CALLING SEQUENCE:
;       Result = CW_Toolbar(parent)
;
;
; INPUTS:
;
;
; OPTIONAL INPUTS:
;       Parent:         The ID of the parent widget.
;	
; KEYWORD PARAMETERS:
;
;       UVALUE: array of values which specify the USER_VALUE for each single 
;		button.
;       VALUE: array of structures (one structure for each button)
;		containing three tags: label, icon and help.
;		Label is a text with the button label. Icon is a file
;		(with its complete path) with a bitmap icon. If the icon
;		option is chosen, then the label tag is irrelevant.
;		Help is the text or tip to be displayed when the mouse 
;		is positiones on the button.
;       FRAME:  Specifies the width of the frame to be drawn around
;               the base.
;       ROW:    When set, the buttons will be arranged in rows (default).
;       COLUMN: When set, the buttons will be arranged in columns.
;       EVENT_FUCT:  a name of fuction that will process the events (when
;		pushing the mouse on the buttons).
;       EVENT_PRO:  a name of procedure that will process the events (when
;		pushing the mouse on the buttons).
;       SIZE_BITMAP:  size of the icon bitmaps in times the original size.
;
; OUTPUTS:
;	The ID of the created widget is returned.
;
; EXAMPLE:
; 	Use this program to test cw_toolbar:
;
;	PRO toolbar_event,event
;	widget_control,event.id,get_uvalue=uval
;	help,uvar
;	widget_control,event.top,get_uvalue=state
;	
;	if not(keyword_set(uval)) then return
;	if strcompress(uval,/rem) EQ 'QUIT' then $
;		Widget_Control,event.top,/Destroy
;	END
;	;
;	PRO toolbar, Group=group
;	; 
;	; Create widgets
;	;
;	wbase=widget_base(/col,Title='toolbar')
;	
;	
;	;structure for a single button
;	but={label:'', icon:'', help:''}
;	; define 3 buttons
;	my_buttons=replicate(but,3)
;	path='/usr/local/rsi/idl_5/resource/X11/lib/X11/app-defaults/bitmaps/'
;	
;	my_buttons.icon=path+['new.xbm','open.xbm','save.xbm']
;	my_buttons.label=['new','open','save']
;	my_buttons.help=['New File','Open File','Save File']
;	b_uval=['NEW','OPEN','SAVE']
;	
;	wid=cw_toolbar(wbase,value=my_buttons,event_pro='toolbar_event',$
;	UVAL=B_uval )
;	
;	wtmp = widget_button(wbase,value='Quit',UValue='QUIT')
;	 
;	wstate=widget_base(wbase) ; to store state
;	state={wid:wid}
;	
;	widget_control,wbase,/realize,set_uvalue=state
;	xmanager, 'toolbar', wbase, GROUP=group, /No_Block
;	
;	end
;
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (98/03/04) base on a draft 
;		version from Christoph Michetschlaeger (12/04/1997).
;
;-


Function cw_toolbar_showtext,my_message,OFFSET=offset,Group=group

  if n_params() EQ 0 then my_message='?'
  if not(keyword_set(offset)) then offset=[0,0]

  tlb = widget_base(/Col,TLB_FRAME_ATTR=1+2+4+8+16,$
   XOFFSET=offset(0),YOFFSET=offset(1),GROUP=group)
  wtmp = widget_label(tlb,Value=my_message)
  widget_control,tlb,/realize
  return,tlb
end

;
;===============================================================================;
Pro CW_Toolbar_Set,id,value

child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy


FOR i=0,n_elements(value)-1 DO BEGIN
    ic = (value.icon)(i)
    ;print,'icon: ',ic
    if strcompress(ic,/rem) NE '' then begin
      READ_X11_BITMAP, ic, image
      ;image_x=4
      ;image_y=28 
      ;image=Congrid(image,image_X,image_y)   
      nx=n_elements(image(*,0))
      ny=n_elements(image(0,*))
      image = Congrid(image,(state.size_bitmap>1)*nx,(state.size_bitmap>1)*ny)
      wtmp=Widget_Button(state.wids.buttons,Value=image, $ 
        UValue=i , Tracking_Events=1)
    endif else begin
      ic = (value.label)(i)
      wtmp=Widget_Button(state.wids.buttons,Value=ic, $ 
        UValue=i , Tracking_Events=1)
    endelse
ENDFOR

out:
if Widget_Info(child,/Valid) then $
  Widget_Control, child, Set_UValue=state, /No_Copy

End
;
;===============================================================================;
Function CW_Toolbar_Get,id
;print,'In CW_Toolbar_Get...'

child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy
out = state.value
Widget_Control, child, Set_UValue=state, /No_Copy
Return,out

End

;
;===============================================================================;
Function CW_Toolbar_Event,event


stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

name=Tag_Names(event,/Structure_Name)
IF name EQ 'WIDGET_TRACKING' THEN BEGIN
  index=0
  if event.enter EQ 1 then begin
    Widget_Control,event.id, Get_Uvalue=index
  
    widget_control,event.id,tlb_get_offset=aa1
    wtmp = cw_toolbar_showtext((state.value.help)(index),offset=aa1+[0,-30],$
	Group=state.wids.cw_tlb) ;event.id)
    state.wids.aux=wtmp
  endif else begin
    if Widget_Info(state.wids.aux,/Valid) then $
	Widget_Control,state.wids.aux,/destroy
  endelse
ENDIF ELSE BEGIN
  if Widget_Info(state.wids.aux,/Valid) then $
	Widget_Control,state.wids.aux,/destroy
  if strcompress(state.event_funct,/rem) EQ '' and  $
     strcompress(state.event_pro,/rem) EQ '' then goto,out
  Widget_Control,event.id, Get_Uvalue=index
  ret = {ID:event.id, TOP:event.top, HANDLER:event.top, $
    SELECT:index }
  if n_elements(state.uval) GT 1 then begin
    buval = state.uval(index)
    widget_control,event.id,get_uvalue=tmp
    widget_control,event.id,set_uvalue=buval
    if strcompress(state.event_funct,/rem) NE '' then $
	tmp=CALL_FUNCTION(state.event_funct,ret)
    if strcompress(state.event_pro,/rem) NE '' then $
	CALL_PROCEDURE,state.event_Pro,ret
    widget_control,event.id,set_uvalue=tmp
  endif else begin
    if strcompress(state.event_funct,/rem) NE '' then $
	tmp=CALL_FUNCTION(state.event_funct,ret)
    if strcompress(state.event_pro,/rem) NE '' then $
	CALL_PROCEDURE,state.event_Pro,ret
  endelse

ENDELSE

out:
if Widget_Info(stateid,/Valid) then $
  Widget_Control, stateid, Set_UValue=state, /No_Copy
return,0
END

;
;===============================================================================;
Function CW_Toolbar,parent, UValue=uval, Value=Init_Value, $
  Column=Column, Row=Row, Frame=Frame, $
  Event_Funct=event_funct,Event_Pro=Event_Pro,$
  Size_bitmap=size_bitmap

on_error,2

IF (not(Keyword_Set(Column)) AND not(Keyword_Set(Row))) THEN Row=1

IF (not(Keyword_Set(event_funct))) THEN event_funct=''
IF (not(Keyword_Set(event_pro))) THEN event_pro=''
IF (not(Keyword_Set(size_bitmap))) THEN size_bitmap=0

If N_Elements(uval) EQ 0 THEN uval = 0

cw_tlb = Widget_Base(parent, Frame=Frame, $
   Column=1, $
   Event_Func='CW_ToolBar_Event',$
   Pro_Set_Value='CW_ToolBar_Set', $
   Func_Get_Value='CW_ToolBar_Get')


wbuttons = widget_base(cw_tlb,Row=Row,Column=Column) ; also to store the state


wids={ cw_tlb:cw_tlb, buttons:wbuttons, aux:0L }
state={ wids:wids, event_funct:event_funct, event_pro:event_pro, $
  value:init_value, uval:uval, size_bitmap:size_bitmap}

stateid = Widget_Info(cw_tlb,/Child)
Widget_Control, stateid, Set_UValue=state, /No_Copy
;
if keyword_set(init_value) then widget_control,cw_tlb,set_value=init_value

Return,cw_tlb
END
