PRO copy_structure,str_in,str_out

;+
; NAME:
;	COPY_STRUCTURE
;
; PURPOSE:
;	This procedures copies whith the same tag-names the tags from 
;	an input-structure to an output-structure.
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	copy_structure,str_in,str_out
;
; INPUTS:
;	str_in: the input structure
;	str_out: the output structure
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	The modified structure
;
; SIDE EFFECTS:
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	a={x:10,y:90} & c={x:10, y:0, z:80}
;	copy_structure,a,c
;	help,/str,c
;	** Structure <31fc30>, 3 tags, length=6, refs=1:
;	   X               INT             10
;	   Y               INT             90
;	   Z               INT             80
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 97-04-07
;	97-08-27 srio@esrf.fr make the copy recurrent (a tag type can
;		also be a structure).
;	
;-

if type(str_in) NE 8 or type(str_out) ne 8 then begin
  message,/info,'Error: An input parameter is not an structure.  Quitting.'
  return
endif

tmp=0
tmp_out=0

tagnames = tag_names(str_in)
for i=0,n_elements(tagnames)-1 do begin
  command = ' tmp = str_in.'+tagnames(i)
  itmp = execute(command)
  if itmp NE 1 then message,/info,'Error in executing: '+command
  if type(tmp) EQ 8 then begin   ; the tag is a structure
    command = ' tmp_out = str_out.'+tagnames(i)
    itmp = execute(command)
    if itmp NE 1 then message,/info,'Error in executing: '+command
    copy_structure,tmp,tmp_out
    command = ' str_out.'+tagnames(i)+' = tmp_out'
    itmp = execute(command)
    if itmp NE 1 then message,/info,'Error in executing: '+command
  endif else begin
    command = 'str_out.'+tagnames(i)+' = str_in.'+tagnames(i)
    itmp = execute(command)
    if itmp NE 1 then message,/info,'Error copying stucture tag: '+tagnames(i)
  endelse
endfor
end

