PRO coor2matr,in_data,z,x,y,switch=switch,sorted=sort
; coor2matr.pro,in_data,z,x,y,switch=switch
;
; if SWITCH is set, then col 0 is interpreted as y and 1 as y
; WARNING: gridding must be regular!
;
; MSR 94/03/02
; MSR 97/01/10 changes variable "inp" by "in_data", because inp is an idl
; reserved word in idl/windows
;

;+
; NAME:
;	COOR2MATR
;
; PURPOSE:
;	converts the format of a surface in in_data=fltarr(3,npts) where
;	column 0 is x, 1 is y and 2 is z, in three variables
;	x=fltarr(nptsx), y=fltarr(nptsy) and z=fltarr(nptsx,xptsy)
;
; CATEGORY:
;	general utilities.
;
; CALLING SEQUENCE:
;	coor2matr,in_data,z,x,y
;
; INPUTS:
;	in_data: a array [3,N] with the (x,y,z) coordinates of the
;	surface
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	SWITCH: if set, switch the x <-> y arrays.
;	SORTED: 0 (defaults) the points may not be sorted.
;	      1 The input array are sorted in x and y. In such a case
;		the converting algorithm is faster.
;
; OUTPUTS:
;	z,x,y: the resulting arrays (2-dim, 1-dim and 1-dimensional,
;		respectively).
;
; PROCEDURE:
;	Straightforward.
;
; RESTRICTIONS
;	WARNING: gridding must be regular, but not necessary equi-spaced.
;
; SEE ALSO
;	matr2coor
; EXAMPLE:
;	This small program will create and display an eighth of sphere
;		in_data = fltarr(3,100)
;		k=0
;		for i=0,9 do for j=0,9 do begin
;		in_data(0,k) = i
;		in_data(1,k) = j
;		in_data(2,k) = sqrt( 10.0^2 - i^2 - j^2)
;		k=k+1
;		endfor
;		coor2matr,in_data,z,x,y
;		surface,z,x,y
;		end
;
; MODIFICATION HISTORY:
; MSR 94/03/02
; 	Written by:	M. Sanchez del Rio  94/03/02
;	97-01-10 srio@esrf.fr changes variable "inp" by "in_data", because 
;		inp is an idl reserved word in idl/windows
;	97-04-03 srio@esrf.fr adds doc.
;	97-05-14 srio@esrf.fr adds sorted keyword.
;-
on_error,2
;
; sort in function of the first column
;
if not(keyword_set(SWITCH)) then begin
  xdata = in_data(0,*)  &  ydata = in_data(1,*)
endif else begin
  xdata = in_data(1,*)  &  ydata = in_data(0,*)
endelse
;
x= xdata(sorpurge(xdata))
y= ydata(sorpurge(ydata))
nx = n_elements(x)
ny = n_elements(y)
print,'elements of data : ',n_elements(in_data(0,*))
print,'elements of x : ',n_elements(x)
print,'elements of y : ',n_elements(y)
if (nx*ny ne n_elements(in_data(0,*))) then begin
  message,/info,'Warning: Data gridding is not regular.'
endif
;
;
; retabulate the array
;
z = fltarr(nx,ny)
if keyword_set(sort) then begin
  zdata = in_data(2,*)
  if total(xdata(0:n_elements(x)-1) - x) EQ 0 then begin
    message,/info,'x array replicated'
    for j=0,n_elements(y)-1 do begin
       z(*,j) = zdata(where(ydata eq y(j)))
    endfor
  endif else if total(ydata(0:n_elements(y)-1)-y) EQ 0 then begin
    message,/info,'y array replicated'
    for j=0,n_elements(x)-1 do begin
       z(j,*) = zdata(where(xdata eq x(j)))
    endfor
  endif else begin
    message,/info,'Error: Input array is not sorted. Ignoring keyword.'
    goto,not_sorted
  endelse

endif else begin
  not_sorted:
  ;for i=0,nx*ny-1 do begin
  for i=0,n_elements(in_data(0,*))-1 do begin
    ;search x and y
    for ix=0,nx-1 do begin
      for iy=0,ny-1 do begin
        if ((x(ix) eq xdata(i)) and (y(iy) eq ydata(i))) then begin
	  z(ix,iy) = in_data(2,i)
	  GOTO,out
        endif
      endfor
    endfor
    print,'COOR2MATR: Error, value not found for index: ',i
    out:
  endfor
endelse
;
return
end

