FUNCTION checkfile,file,VERBOSE=verbose

;+
; NAME:
;	CHECKFILE
; PURPOSE:
;	Checks if a file exists. Returns 1 if file exists, 0 if doesn't
; CATEGORY:
;	File manipulation.
; CALLING SEQUENCE:
;	Result = CHECKFILE ( FILE [, keywords])
; INPUTS:
;    FILE 
;	String with the file name.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;    VERBOSE
;	If set, print the error message.
; OUTPUTS:
;	Returns a  1 if file exists, 0 if doesn't
; OPTIONAL OUTPUT PARAMETERS:
;    None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Uses catch to catch the error when opening the file.
; MODIFICATION HISTORY:
;	Created NOV-1995 by M. Sanchez del Rio (srio@esrf.fr) (c) ESRF
;	MSR 95/10/31 adds Verbose kw
;-

; checks if the file exists
; FUNCTION checkfile,file
; returns 0 if the file does not exist (or cannot be read) and 
; 1 if it exists
; MSR Nov 1995
; MSR 95/10/31 adds Verbose kw
;
on_error,2
catch, error
if error NE 0 then begin
  if keyword_set(VERBOSE) then print,'CHECKFILE: cannot open file: ',file
  return,0
endif
openr,unit,file,/get_lun
free_lun,unit
return,1
end


