PRO HandleList1, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  data = info.ptr
  Widget_Control, event.id,  get_UValue = options1
  
  CASE options1[event.index] OF
    'Structure factors' : BEGIN
      (*data)[0] = 'Yes'
    END
    
    'Intensities' : BEGIN
      (*data)[0] = 'No'
    END
  ENDCASE
  
  Widget_Control, event.top, set_UValue = info, /no_copy
END




PRO HandleList2, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  data = info.ptr
  Widget_Control, event.id,  get_UValue = options2
  
  options2 = ['Approximated beta', $
              'Exact beta (bulk only)', $
              'Poisson (bulk only)', 	$
              'Exponent (bulk only)', $
              'Gaussian (bulk only)', $
              'Linear (bulk only)', $
              'Cosine (bulk only)']
  
  CASE options2[event.index] OF
    'Approximated beta' : BEGIN
      (*data)[12] = 'Approx'
    END
    
    'Exact beta (bulk only)' : BEGIN
      (*data)[12] = 'Exact'
    END
    
    'Poisson (bulk only)' : BEGIN
      (*data)[12] = 'Poisson'
    END
    
    'Exponent (bulk only)' : BEGIN
      (*data)[12] = 'Exponent'
    END
    
    'Gaussian (bulk only)' : BEGIN
      (*data)[12] = 'Gaussian'
    END
    
    'Linear (bulk only)' : BEGIN
      (*data)[12] = 'Linear'
    END
    
    'Cosine (bulk only)' : BEGIN
      (*data)[12] = 'Cosine'
    END
  ENDCASE
  
  Widget_Control, event.top, set_UValue = info, /no_copy
END




;-------------------------------------------------------------- 
; Set_Rod_Events
;--------------------------------------------------------------
PRO Set_Rod_Events, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  Widget_Control, event.id,  get_value = value
  data = info.ptr
  CASE value OF
    'OK' : 	BEGIN
      Widget_Control, info.t2ID, get_value=temp
      (*data)[1] = temp[0]
      Widget_Control, info.t3ID, get_value=temp
      (*data)[2] = temp[0]
      Widget_Control, info.t4ID, get_value=temp
      (*data)[3] = temp[0]
      Widget_Control, info.t5ID, get_value=temp
      (*data)[4] = temp[0]
      Widget_Control, info.t6ID, get_value=temp
      (*data)[5] = temp[0]
      Widget_Control, info.t7ID, get_value=temp
      (*data)[6] = temp[0]
      Widget_Control, info.t8ID, get_value=temp
      (*data)[7] = temp[0]
      Widget_Control, info.t9ID, get_value=temp
      (*data)[8] = temp[0]
      Widget_Control, info.t10ID, get_value=temp
      (*data)[9] = temp[0]
      Widget_Control, info.t11ID, get_value=temp
      (*data)[10] = temp[0]
      Widget_Control, info.t12ID, get_value=temp
      (*data)[11] = temp[0]
      Widget_Control, event.top, /Destroy
    END
  ENDCASE
  IF Widget_Info (event.top, /valid_ID) THEN $
    Widget_Control, event.top, set_UValue = info, /no_copy
END




;-------------------------------------------------------------- 
; Set_Rod
;--------------------------------------------------------------

PRO Set_Rod, ptr, Group = group
  tlb   = Widget_Base (title = 'Set ROD Calculations', $
                       column = 1, TLB_FRAME_ATTR = 1, group_leader = group, /modal)
  
  base_1 = Widget_Base (tlb, row=1)
  options1 = ['Structure factors', 'Intensities']
  l1 = Widget_Label (base_1, value = 'Use', xsize=260)
  t1 = Widget_DropList (base_1, Value = options1, $
                        Event_Pro = 'HandleList1', Uvalue = options1)
  
  base_2 = Widget_Base (tlb, row=1)
  l2  = Widget_Label (base_2, value = 'Start value of l:', xsize=260)
  t2  = Widget_Text  (base_2, Value = (*ptr)[1], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_3 = Widget_Base (tlb, row=1)
  l3  = Widget_Label (base_3, value = 'End value of l:', xsize=260)
  t3  = Widget_Text  (base_3, Value = (*ptr)[2], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_4 = Widget_Base (tlb, row=1)
  l4  = Widget_Label (base_4, value = 'Number of points on rod:', xsize=260)
  t4  = Widget_Text  (base_4, Value = (*ptr)[3], $
                      All_Events=1, Editable=0, Event_Pro='Integer_Only')
  base_5 = Widget_Base (tlb, row=1)
  l5  = Widget_Label (base_5, value = 'Attenuation factor of beam:', xsize=260)
  t5  = Widget_Text  (base_5, Value = (*ptr)[4], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_6 = Widget_Base (tlb, row=1)
  l6  = Widget_Label (base_6, value = 'Roughness parameter beta:', xsize=260)
  t6  = Widget_Text  (base_6, Value = (*ptr)[5], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_7 = Widget_Base (tlb, row=1)
  l7  = Widget_Label (base_7, value = 'L-value of nearest Bragg peak:', xsize=260)
  t7  = Widget_Text  (base_7, Value = (*ptr)[6], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_8 = Widget_Base (tlb, row=1)
  l8  = Widget_Label (base_8, value = 'Number of layers in bulk unit cell:', xsize=260)
  t8  = Widget_Text  (base_8, Value = (*ptr)[7], $
                      All_Events=1, Editable=0, Event_Pro='Integer_Only')
  base_9 = Widget_Base (tlb, row=1)
  l9  = Widget_Label (base_9, value = 'Scale factor of theory:', xsize=260)
  t9  = Widget_Text  (base_9, Value = (*ptr)[8], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_10 = Widget_Base (tlb, row=1)
  l10 = Widget_Label (base_10, value = 'Fraction of surface with 1st unit cell:', xsize=260)
  t10 = Widget_Text  (base_10, Value = (*ptr)[9], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_11 = Widget_Base (tlb, row=1)
  l11 = Widget_Label (base_11, value = 'Fraction of surface with 2nd unit cell:', xsize=260)
  t11 = Widget_Text  (base_11, Value = (*ptr)[10], $
                      All_Events=1, Editable=0, Event_Pro='Float_Only')
  base_12 = Widget_Base (tlb, row=1)
  l12 = Widget_Label (base_12, value = 'Number of atoms in 2nd unit cell:', xsize=260)
  t12 = Widget_Text  (base_12, Value = (*ptr)[11], $
                      All_Events=1, Editable=0, Event_Pro='Integer_Only')
  base_13 = Widget_Base (tlb, row=1)
  options2 = ['Approximated beta', $
              'Exact beta (bulk only)', $
              'Poisson (bulk only)', 	$
              'Exponent (bulk only)', $
              'Gaussian (bulk only)', $
              'Linear (bulk only)', $
              'Cosine (bulk only)']
  l13 = Widget_Label (base_13, value = '(Temporary) roughness mode calculation:', xsize=260)
  t13 = Widget_DropList (base_13, Value = options2, $
                         Event_Pro = 'HandleList2', Uvalue = options2)
  
  
  buttonok = Widget_Button (tlb, xsize=80, Value = 'OK')
  
  info = {t1ID:t1, $
          t2ID:t2, $
          t3ID:t3, $
          t4ID:t4, $
          t5ID:t5, $
          t6ID:t6, $
          t7ID:t7, $
          t8ID:t8, $
          t9ID:t9, $
          t10ID:t10, $
          t11ID:t11, $
          t12ID:t12, $
          t13ID:t13, $
          ptr:ptr}
  
  Widget_Control, tlb, set_UValue = info, /no_copy
  Widget_Control, tlb, /Realize
  
  IF (*ptr)[0] EQ 'No' THEN $
    Widget_Control, t1, Set_Droplist_Select = 1
  
  CASE (*ptr)[12] OF
    'Approx' : BEGIN
      Widget_Control, t13, Set_Droplist_Select = 0
    END

    'Exact' : BEGIN
      Widget_Control, t13, Set_Droplist_Select = 1
    END
    
    'Poisson' : BEGIN
      Widget_Control, t13, Set_Droplist_Select = 2
    END
    
    'Exponent' : BEGIN
      Widget_Control, t13, Set_Droplist_Select = 3
    END
    
    'Gaussian' : BEGIN
      Widget_Control, t13, Set_Droplist_Select = 4
    END
    
    'Linear' : BEGIN
      Widget_Control, t13, Set_Droplist_Select = 5
    END
    
    'Cosine' : BEGIN
      Widget_Control, t13, Set_Droplist_Select = 6
    END
  ENDCASE
  
  XManager, 'Set_Rod', tlb, Event='Set_Rod_Events'
END
