PRO HandleList1_Par, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  table= info.ptr1
  data = info.ptr2
  Widget_Control, event.id,  get_UValue = options1

  options1 = ['1', '2', '3', '4', '5', '6', '7', '8']

  CASE options1[event.index] OF
    '1' : BEGIN
      (*data)[0] = '1'
    END

    '2' : BEGIN
      (*data)[0] = '2'
    END

    '3' : BEGIN
      (*data)[0] = '3'
    END

    '4' : BEGIN
      (*data)[0] = '4'
    END

    '5' : BEGIN
      (*data)[0] = '5'
    END

    '6' : BEGIN
      (*data)[0] = '6'
    END

    '7' : BEGIN
      (*data)[0] = '7'
    END

    '8' : BEGIN
      (*data)[0] = '8'
    END
  ENDCASE

  IF (*data)[2] EQ 'YES' THEN BEGIN
    Widget_Control, info.tableID, get_Value = *table
    FOR i = 1, fix((*data)[0]), 1 DO $
      (*table)[4,i-1] = 1/float((*data)[0])
    Widget_Control, info.tableID, set_Value = *table
  ENDIF

  Widget_Control, event.top, set_UValue = info, /no_copy
END




PRO HandleList2_Par, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  data = info.ptr2
  Widget_Control, event.id,  get_UValue = options2

  options2 = ['YES', 'NO']

  CASE options2[event.index] OF
    'YES' : BEGIN
      (*data)[1] = 'YES'
    END

    'NO' : BEGIN
      (*data)[1] = 'NO'
    END
  ENDCASE

  Widget_Control, event.top, set_UValue = info, /no_copy
END




PRO HandleList3_Par, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  table = info.ptr1
  data  = info.ptr2
  Widget_Control, event.id,  get_UValue = options3

  options3 = ['YES', 'NO']

  CASE options3[event.index] OF
    'YES' : BEGIN
      (*data)[2] = 'YES'

      Widget_Control, info.tableID, get_Value = *table
      FOR i = 1, fix((*data)[0]), 1 DO $
        (*table)[4,i-1] = 1/float((*data)[0])
      Widget_Control, info.tableID, set_Value = *table
    END

    'NO' : BEGIN
      (*data)[2] = 'NO'
    END
  ENDCASE

  Widget_Control, event.top, set_UValue = info, /no_copy
END




;--------------------------------------------------------------
; Set_Par_Events
;--------------------------------------------------------------
PRO Set_Par_Events, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  Widget_Control, event.id,  get_value = value
  CASE value OF
    'OK' : 	BEGIN
      Widget_Control, event.top, /Destroy
    END
  ENDCASE

  IF Widget_Info (event.top, /valid_ID) THEN $
    Widget_Control, event.top, set_UValue = info, /no_copy
END




;--------------------------------------------------------------
; Table_Events
;--------------------------------------------------------------
PRO Table_Events_Par, event
  Widget_Control, event.top, get_UValue = info, /no_copy
  data = info.ptr1
  Widget_Control, info.tableID, get_Value=*data
  Widget_Control, event.top, set_UValue = info, /no_copy
END




;--------------------------------------------------------------
; Set_Par
;--------------------------------------------------------------

PRO Set_Par, ptr1, ptr2, Group = group
  tlb   = Widget_Base (title = 'Set Domain Paramters', $
                       column = 1, TLB_FRAME_ATTR = 1, group_leader = group, /modal)

  table = Widget_Table (tlb, xsize=5, y_scroll_size=8, value=(*ptr1), $
                        /Editable, /All_Events, /Scroll, UValue='Table', $
                        column_labels=['11', '12', '21', '22', 'Occupancy'], $
                        row_labels=['1','2','3','4','5','6','7','8'], $
                        Event_Pro='Table_Events_Par')

  dbase1 = Widget_Base (tlb, row=1)
  dbase2 = Widget_Base (tlb, row=1)
  dbase3 = Widget_Base (tlb, row=1)

  options1 = ['1', '2', '3', '4', '5', '6', '7', '8']
  options2 = ['YES', 'NO']
  options3 = ['YES', 'NO']

  l1 = Widget_Label (dbase1, xsize=300, value = 'Number of rotational surface domains:')
  t1 = Widget_DropList (dbase1, Value = options1, $
                        Event_Pro = 'HandleList1_Par', Uvalue = options1)

  l2 = Widget_Label (dbase2, xsize=300, value = 'Include fractional-order Miller indices:')
  t2 = Widget_DropList (dbase2, Value = options2, $
                        Event_Pro = 'HandleList2_Par', Uvalue = options2)

  l3 = Widget_Label (dbase3, xsize=300, value = 'All domains equally occupied:')
  t3 = Widget_DropList (dbase3, Value = options3, $
                        Event_Pro = 'HandleList3_Par', Uvalue = options3)

  buttonok = Widget_Button (tlb, Value = 'OK')

  info = {t1ID:t1, $
          t2ID:t2, $
          t3ID:t3, $
          tableID:table, $
          ptr1:ptr1, $
          ptr2:ptr2}

  Widget_Control, tlb, set_UValue = info, /no_copy
  Widget_Control, tlb, /Realize

  CASE strtrim((*ptr2)[0],2) OF
    '1' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 0
    END

    '2' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 1
    END

    '3' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 2
    END

    '4' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 3
    END

    '5' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 4
    END

    '6' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 5
    END

    '7' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 6
    END

    '8' : BEGIN
      Widget_Control, t1, Set_Droplist_Select = 7
    END
  ENDCASE

  CASE (*ptr2)[1] OF
    'YES' : BEGIN
      Widget_Control, t2, Set_Droplist_Select = 0
    END

    'NO' : BEGIN
      Widget_Control, t2, Set_Droplist_Select = 1
    END
  ENDCASE

  CASE (*ptr2)[2] OF
    'YES' : BEGIN
      Widget_Control, t3, Set_Droplist_Select = 0
    END

    'NO' : BEGIN
      Widget_Control, t3, Set_Droplist_Select = 1
    END
  ENDCASE

  XManager, 'Set_Par', tlb, Event='Set_Par_Events'
END
