;-------------------------------------------------------------- 
; ROD_Profile_Events
;--------------------------------------------------------------
PRO RODProfile_Events, event
Widget_Control, event.top, get_UValue = info, /no_copy
Widget_Control, event.id,  get_value = value
data = info.ptr
CASE value OF
'OK' : 	BEGIN
		Widget_Control, info.indexhID, get_value=temp
		digit = float (temp)
		(*data).data_1 = digit[0]
		Widget_Control, info.indexkID, get_value=temp
		digit = float (temp)
		(*data).data_2 = digit[0]
		Widget_Control, event.top, /Destroy
       	END
ENDCASE
END




;-------------------------------------------------------------- 
; ROD_Profile
;--------------------------------------------------------------

PRO RODProfile, ptr, Group = group
tlb   = Widget_Base (title = 'Calculate ROD Profile', $
                     column = 1, TLB_FRAME_ATTR = 1, group_leader = group, /modal)

hbase   = Widget_Base  (tlb, row=1)
indexht = Widget_Label (hbase, value='Miller index h', xsize=100)
indexh  = Widget_Text  (hbase, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                        Value= strtrim(string((*ptr).data_1),2))

kbase   = Widget_Base  (tlb, row=1)
indexkt = Widget_Label (kbase, value='Miller index k', xsize=100)
indexk  = Widget_Text  (kbase, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                        Value= strtrim(string((*ptr).data_2),2))

buttonok = Widget_Button (tlb, xsize=80, Value = 'OK')

info = {indexhID:indexh, indexkID:indexk, ptr:ptr}
Widget_Control, tlb, set_UValue = info, /no_copy
Widget_Control, tlb, /Realize
XManager, 'RODProfile', tlb, Event='RODProfile_Events'
END
