;--------------------------------------------------------------
; BackToMain
;--------------------------------------------------------------

PRO BackToMain, info
  handler = info.ptr
  buffer = info.bufptr

  IF strtrim((*handler).string,2) EQ 'PAT.FIT.PAR>' THEN BEGIN
    (*handler).string = 'break'
    *buffer = [ *buffer, (*handler).string]
    com_put, handler
    com_get, handler, info.outputID, no_output = 1
  ENDIF

  WHILE strtrim((*handler).string, 2) NE 'ROD>' DO BEGIN
    (*handler).string = 'return'
    *buffer = [ *buffer, (*handler).string]
    com_put, handler
    com_get, handler, info.outputID, no_output = 1
  ENDWHILE
END




;--------------------------------------------------------------
; Patterson
;--------------------------------------------------------------

PRO Patterson, handler
  IF !version.os_family EQ 'unix' THEN BEGIN
    prefix = ''
  END ELSE BEGIN
    prefix = 'c:\'
  END

	text = read_textfile(prefix + 'pat.dat')
	n_rows = size(text)
	n_rows = n_rows[1] - 1
	line = text[1]
	result = str_sep (line, ' ')
	n_cols = size(result)
	n_cols = n_cols[1]

	data = fltarr(n_cols,n_rows)

	n_realcolumns = 0
	FOR i = 1, n_rows - 1, 1 DO BEGIN
		line = text[i]
		result = str_sep(line, ' ')
		n_entries = size(result)
		n_entries = n_entries[1]
		IF n_entries EQ n_cols THEN BEGIN
			n_realcolumns = n_realcolumns + 1
			data[*,i] = result
		ENDIF
	ENDFOR

	data2 = fltarr (n_realcolumns,n_rows-2)
	data2 = data[0:n_realcolumns-1,1:n_rows-2]

	maximum = max (data2)
	minimum = min (data2)
	levels = fltarr(20)
	FOR i = 0, 19, 1 DO $
		levels[i] = minimum + i * (maximum - minimum) / 19

	IF minimum NE maximum THEN BEGIN
		data = {data:data2, levels:levels}
		xwindow, buffer = 'contour, data.data, levels=data.levels, C_Linestyle = (data.levels LT 0.0)', data=data
	ENDIF

  openw, a_unit, prefix + "pat.dat", /get_lun, /delete
  close, a_unit
  free_lun, a_unit

END




;--------------------------------------------------------------
; Contour
;--------------------------------------------------------------
;
; handler : pointer to generic data from the RODGUI program.

PRO Contour_Rod, handler
  IF !version.os_family EQ 'unix' THEN BEGIN
    prefix = ''
  END ELSE BEGIN
    prefix = 'c:\'
  END

  text = read_textfile (prefix + 'contour.plot')
  n_lines = size(text)
  xmin = 0.0
  xmax = 0.0
  ymin = 0.0
  ymax = 0.0

  FOR i = 0, n_lines[1] - 3, 1 DO BEGIN
		line = text[i]
		result = str_sep (line,' ')
		x = double(result[0])
		y = double(result[1])
		r = double(result[2])
		IF (x-r) LT xmin THEN xmin = (x-r)
		IF (x+r) GT xmax THEN xmax = (x+r)
		IF (y-r) LT ymin THEN ymin = (y-r)
		IF (y+r) GT ymax THEN ymax = (y+r)
	ENDFOR

	line = text[n_lines[1]-1]
	result = str_sep (line, ' ')
	IF result[0] LT xmin THEN xmin = result[0]
	IF result[6] LT xmin THEN xmin = result[6]
	IF result[1] LT ymin THEN ymin = result[1]
	IF result[3] LT ymin THEN ymin = result[3]
	IF result[2] GT xmax THEN xmax = result[2]
	IF result[4] GT xmax THEN xmax = result[4]
	IF result[5] GT ymax THEN ymax = result[5]
	IF result[7] GT ymax THEN ymax = result[7]

	buffer = 'plot, [' + string(xmin) + ',' $
					 + string(xmax) + '],[' $
					 + string(ymin) + ',' $
					 + string(ymax) + '],/nodata'

	i = 0
	line = text[i]
	WHILE line NE 'The unit cell:' DO BEGIN
		result = str_sep (line,' ')

		CASE result[3] OF
			'180' : BEGIN
								temp = 'circle, center=[' + result[0] + ',' $
  													+ result[1] + '],radius=' $
														+ result[2] + ',color=' $
														+ result[3] + ', semi = 0'
							END

			'181' : BEGIN
								temp = 'circle, center=[' + result[0] + ',' $
													 + result[1] + '],radius=' $
													 + result[2] + ',color=' $
													 + result[3] + ', semi = 1'
							END

			'121' : BEGIN
								temp = 'circle, center=[' + result[0] + ',' $
													 + result[1] + '],radius=' $
													 + result[2] + ',color=' $
													 + result[3] + ', semi = 2'
							END
			ELSE:
		ENDCASE

		buffer = [buffer, temp]

		i = i + 1
		line = text[i]
	ENDWHILE

	i = i + 1
	line = text[i]

	result = str_sep (line, ' ')

	temp = 'plots, [' + string(double(result[0])) + ',' $
										+ string(double(result[2])) + ',' $
										+ string(double(result[4])) + ',' $
										+ string(double(result[6])) + ',' $
										+ string(double(result[8])) + '],[' $
										+ string(double(result[1])) + ',' $
										+ string(double(result[3])) + ',' $
										+ string(double(result[5])) + ',' $
										+ string(double(result[7])) + ',' $
										+ string(double(result[9])) + ']'
	buffer = [buffer, temp]
	xwindow, buffer = buffer, group = (*handler).top

  openw, a_unit, prefix + "contour.plot", /get_lun, /delete
  close, a_unit
  free_lun, a_unit
END




;--------------------------------------------------------------
; PLOTTING
;--------------------------------------------------------------
;
; handler : pointer to generic data from the RODGUI program.
;	Used in order to check whether a xplot windows exists.

PRO Plotting, handler
  temp = 0L
  IF NOT(XREGISTERED('xplot')) THEN BEGIN
    xplot, p = p, group = (*handler).top, /no_block
    (*handler).plotID = p
  ENDIF

  plottype = ''
  xtitle   = ''
  ytitle   = ''
  title    = ''
  errors = 0

  IF !version.os_family EQ 'unix' THEN BEGIN
    prefix = ''
  END ELSE BEGIN
    prefix = 'c:\'
  END

  CASE (*handler).string OF
    'Plotting...Logarithmic XY Plot' : BEGIN
      data = rascii (prefix + 'rodgui.plot', header = h)
      res = size(data)
      data = data[0:1,0:res[2]-1]
    END

    'Plotting...Normal XY Plot' : BEGIN
      data = rascii (prefix + 'rodgui.plot', header = h)
      res = size(data)
      data = data[0:1,0:res[2]-1]
    END

    'Plotting...Normal XY + Errors Plot' : BEGIN
      data = rascii (prefix + 'rodgui_errors.plot', header = h)
      res = size(data)
      data = data[0:3,0:res[2]-1]
      errors = 1
    END

    'Plotting...Logarithmic Overlay XY Plot' : BEGIN
      data = rascii (prefix + 'rodgui_overlay.plot', header = h)
      res = size(data)
      data = data[0:1,0:res[2]-1]
    END

    'Plotting...Normal Overlay XY Plot' : BEGIN
      data = rascii (prefix + 'rodgui_overlay.plot', header = h)
      res = size(data)
      data = data[0:1,0:res[2]-1]
    END

    ELSE: BEGIN
      CASE (*handler).andreplot OF
        '1': BEGIN
          data = rascii (prefix + 'rodgui1.plot', header = h)
          res = size(data)
          data = data[0:1,0:res[2]-1]
        END

        '2': BEGIN
          data = rascii (prefix + 'rodgui2.plot', header = h)
          res = size(data)
          data = data[0:1,0:res[2]-1]
        END

        '3': BEGIN
          data = rascii (prefix + 'rodgui3.plot', header = h)
          res = size(data)
          data = data[0:1,0:res[2]-1]
          (*handler).andreplot = 1
        END

      ENDCASE
    END
  ENDCASE

	CASE h[0] OF
		'#XLOG' : BEGIN
								title = '2'
							END

		'#YLOG' : BEGIN
								title = '1'
			        END

		'#XYLOG' : BEGIN
								title = '3'
							END

		ELSE : 		BEGIN
								title = '0'
							END
	ENDCASE

  lines = n_elements(data[0,*])

  counter = 0
  breaks = 0
  xmin = 1000.0
  xmax = -1000.0
  ymin = 1000.0
  ymax = -1000.0
  FOR i = 0, res[2] - 2, 1 DO BEGIN

    IF data[0,i] LT xmin THEN xmin = data[0,i]
    IF data[0,i] GT xmax THEN xmax = data[0,i]

    IF data[1,i] LT ymin THEN ymin = data[1,i]
    IF data[1,i] GT ymax THEN ymax = data[1,i]

    IF data[0,i] GE data[0,i+1] THEN $
      IF counter EQ 0 THEN BEGIN
      breaks = i
      counter = 1
    ENDIF ELSE BEGIN
      breaks = [breaks, i]
    ENDELSE
  ENDFOR
  breaks = [breaks, lines-1]

	IF title EQ '0' THEN BEGIN
  	ymin = ymin - (ymax - ymin) / 10
  	ymax = ymax + (ymax - ymin) / 10
  ENDIF

  CASE (*handler).string OF
    'Plotting...Logarithmic XY Plot' : BEGIN
      xplot_cleardata, (*handler).plotID
      exist1 = checkfile (prefix + 'rodgui_errors.plot')
      exist2 = checkfile (prefix + 'rodgui_overlay.plot')
      IF exist1 EQ 1 OR exist2 EQ 1 THEN $
        xplot_controls_action, (*handler).plotID, psymsign='1', psymbol='3', norefresh = 1, kind = title $
      ELSE $
        xplot_controls_action, (*handler).plotID, psymsign='0', psymbol='0', norefresh = 1, kind = title

      xplot_setlimits, (*handler).plotID, xrange=[xmin>1E-10, xmax>1E-10], $
      																		yrange=[ymin>1E-10, ymax>1E-10], norefresh = 1
    END

    'Plotting...Normal XY Plot' : BEGIN
      xplot_cleardata, (*handler).plotID
      exist1 = checkfile (prefix + 'rodgui_errors.plot')
      exist2 = checkfile (prefix + 'rodgui_overlay.plot')
      IF exist1 EQ 1 OR exist2 EQ 1 THEN $
        xplot_controls_action, (*handler).plotID, psymsign='1', psymbol='3', norefresh = 1, kind = title $
      ELSE $
        xplot_controls_action, (*handler).plotID, psymsign='0', psymbol='0', norefresh = 1, kind = title

      xplot_setlimits, (*handler).plotID, xrange=[xmin,xmax], yrange=[ymin,ymax], norefresh = 1
    END

    'Plotting...Normal XY + Errors Plot' : BEGIN
      exist1 = 0
      xplot_cleardata, (*handler).plotID
      xplot_controls_action, (*handler).plotID, psymsign='1', psymbol='3', norefresh = 1, kind = title
      xplot_setlimits, (*handler).plotID, xrange=[xmin,xmax], yrange=[ymin,ymax], norefresh = 1
    END

    'Plotting...Logarithmic Overlay XY Plot' : BEGIN
      exist1 = 0
      xplot_controls_action, (*handler).plotID, psymsign='0', psymbol='0', norefresh = 1, kind = title
    END

    'Plotting...Normal Overlay XY Plot' : BEGIN
      exist1 = 0
      xplot_controls_action, (*handler).plotID, psymsign='0', psymbol='0', norefresh = 1, kind = title
    END

    'Plotting...Andre 1. Logarithmic Overlay XY Plot': BEGIN
      exist1 = 0
      xplot_cleardata, (*handler).plotID
      xplot_controls_action, (*handler).plotID, psymsign='1', psymbol='3', norefresh = 1, kind = title
      xplot_setlimits, (*handler).plotID, xrange=[xmin>1E-10,xmax>1E-10], $
      																		yrange=[ymin>1E-10,ymax>1E-10], norefresh = 1
    END

    'Plotting...Andre 1. Normal Overlay XY Plot': BEGIN
      exist1 = 0
      xplot_cleardata, (*handler).plotID
      xplot_controls_action, (*handler).plotID, psymsign='1', psymbol='3', norefresh = 1, kind = title
      xplot_setlimits, (*handler).plotID, xrange=[xmin,xmax], yrange=[ymin,ymax], norefresh = 1
    END

    ELSE: BEGIN
      exist1 = 0
      xplot_controls_action, (*handler).plotID, psymsign='1', psymbol='3', norefresh = 1, kind = title
      xplot_setlimits, (*handler).plotID, xrange=[xmin,xmax], yrange=[xmin,xmax], norefresh = 1
    END
  ENDCASE


  IF exist1 EQ 0 THEN BEGIN
    FOR i = 0, n_elements(breaks) - 2, 1 DO BEGIN
      IF i EQ n_elements (breaks) - 2 THEN norefresh = 0 ELSE norefresh = 1

      IF errors EQ 1 THEN BEGIN
        xplot_loadfile,  (*handler).plotID, data[0:3,breaks[i]+1:breaks[i+1]], plotname='0', norefresh = 1
        xplot_errorbars, (*handler).plotID, 3, 4, norefresh = 1
        xplot_changecol, (*handler).plotID, ycol = 2, norefresh = norefresh
      END ELSE BEGIN
        xplot_loadfile, (*handler).plotID, data[0:1,breaks[i]+1:breaks[i+1]], plotname='0', norefresh = norefresh
      ENDELSE
      xplot_savecurrent, (*handler).plotID
    ENDFOR
  ENDIF

  CASE (*handler).string OF
    'Plotting...Logarithmic XY Plot' : BEGIN
      openw, a_unit, prefix + "rodgui.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
    END

    'Plotting...Normal XY Plot' : BEGIN
      openw, a_unit, prefix + "rodgui.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
    END

    'Plotting...Normal XY + Errors Plot' : BEGIN
      openw, a_unit, prefix + "rodgui_errors.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
    END

   'Plotting...Logarithmic Overlay XY Plot' : BEGIN
     openw, a_unit, prefix + "rodgui_overlay.plot", /get_lun, /delete
     close, a_unit
     free_lun, a_unit
    END

    'Plotting...Normal Overlay XY Plot' : BEGIN
      openw, a_unit, prefix + "rodgui_overlay.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
    END

    'Plotting...Andre 3. Normal Overlay XY Plot': BEGIN
      openw, a_unit, prefix + "rodgui1.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
      openw, a_unit, prefix + "rodgui2.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
      openw, a_unit, prefix + "rodgui3.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
    END

    'Plotting...Andre 3. Logarithmic Overlay XY Plot': BEGIN
      openw, a_unit, prefix + "rodgui1.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
      openw, a_unit, prefix + "rodgui2.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
      openw, a_unit, prefix + "rodgui3.plot", /get_lun, /delete
      close, a_unit
      free_lun, a_unit
    END

    ELSE:
  ENDCASE

END




;--------------------------------------------------------------
; RODGUI_EVENTS
;--------------------------------------------------------------

PRO RodGUI_Events, event

  catch, error_status
  IF error_status NE 0 THEN BEGIN
    itmp = Dialog_Message (/Error, Dialog_Parent = event.top, $
                           'Error found: ' + !err_string)

      does_exist = checkfile (readyname)
      IF does_exist EQ 1 THEN BEGIN
        openw, a_unit, readyname, /get_lun, /delete
        close, a_unit
        free_lun, a_unit
      ENDIF
      does_exist = checkfile (outname)
      IF does_exist EQ 1 THEN BEGIN
        openw, a_unit, outname, /get_lun, /delete
        close, a_unit
        free_lun, a_unit
      ENDIF
      does_exist = checkfile (outtemp)
      IF does_exist EQ 1 THEN BEGIN
        openw, a_unit, outtemp, /get_lun, /delete
        close, a_unit
        free_lun, a_unit
      ENDIF
      does_exist = checkfile (inname)
      IF does_exist EQ 1 THEN BEGIN
        openw, a_unit, inname, /get_lun, /delete
        close, a_unit
        free_lun, a_unit
      ENDIF

    catch, /cancel

    IF n_elements(info) NE 0 THEN Widget_Control, infoID, set_UValue = info, /no_copy
    RETURN
  ENDIF

  infoID = Widget_Info (event.top, /Child)
  Widget_Control, infoID, get_UValue=info, /no_copy
  Widget_Control, event.id, get_uvalue=value
  handler = info.ptr
  buffer = info.bufptr

  IF !version.os_family EQ 'unix' THEN BEGIN
    alcname   = 'plot.alc'
    inname    = 'input.rod'
    outname   = 'output.rod'
    outtemp   = 'output.tmp'
    readyname = 'ready.rod'
  ENDIF ELSE BEGIN
    alcname   = 'c:\plot.alc'
    inname    = 'c:\input.rod'
    outname   = 'c:\output.rod'
    outtemp   = 'c:\output.tmp'
    readyname = 'c:\ready.rod'
  ENDELSE

  CASE value OF
    'SAVEFILE' : BEGIN
      BackToMain, info
      (*handler).string = 'parameters'
      com_put, handler
      com_get, handler, info.outputID
    END

    'QUIT' : BEGIN
      openw, a_unit, alcname, /get_lun, /delete
      close, a_unit
      free_lun, a_unit
      openw, a_unit, outname, /get_lun, /delete
      close, a_unit
      free_lun, a_unit

      IF (*handler).status NE 'Starting' THEN BEGIN
        erg = dialog_message ('Do you want to save the current settings to default?', $
                              /question, /cancel, dialog_parent = event.top)
        IF strlowcase(erg) EQ 'yes' THEN BEGIN
          BackToMain, info
          (*handler).string = 'parameters'
          com_put, handler
          com_get, handler, info.outputID
        ENDIF
      ENDIF

      go_on = 1
      IF (*handler).status NE 'Starting' THEN $
        IF strlowcase(erg) EQ 'cancel' THEN go_on = 0

      IF go_on EQ 1 THEN BEGIN
        IF !version.os_family EQ 'unix' THEN BEGIN
          spawn, 'echo $LOGNAME', username
          spawn, 'ps -fu ' + username + ' | grep rod', result
          lines = n_elements(result)
          FOR i = 0, lines - 1, 1 DO BEGIN
            temp = strpos(result[i], 'rod.', 45)
            IF temp NE -1 THEN BEGIN
              number = strmid (result[i], 9, 5)
              spawn, 'kill -9 ' + number
            ENDIF
          ENDFOR
        ENDIF
        Widget_Control, event.top, /Destroy
      ENDIF
    END

    'CLEAR' :	BEGIN
      Widget_Control, info.outputID, set_Value = '', /no_newline
      Widget_Control, info.inputID, set_Value = ''
    END

    'CLRLOG' :	BEGIN
      *buffer = ['']
    END

    'SHOWLOG' :	BEGIN
      helpgui, handler, *buffer, group = event.top
    END

    'EXECLOG' :	BEGIN
      Widget_Control, /hourglass
      FOR i=0, n_elements(*buffer)-1, 1 DO BEGIN
        (*handler).string = (*buffer)[i]
        temp = strtrim((*handler).string, 2)
        temp = strlowcase(strmid(temp,0,3))
        CASE temp OF
          'r d' : BEGIN
            (*handler).data_read[0] = 1
            IF (*handler).data_read[1] EQ 1 OR (*handler).data_read[2] EQ 1 THEN $
              Widget_Control, info.allID, Sensitive = 1

            result = str_sep ((*handler).string, ' ')
            (*handler).datafile = result[n_elements(result)-1]

          END
          'r f' : BEGIN
            Widget_Control, info.rodID,        Sensitive = 1
            Widget_Control, info.rangeID,      Sensitive = 1
            Widget_Control, info.qrangeID,     Sensitive = 1
            Widget_Control, info.twoatomsID,   Sensitive = 1
            Widget_Control, info.threeatomsID, Sensitive = 1
            Widget_Control, info.leffecID,     Sensitive = 1
            Widget_Control, info.roughID,      Sensitive = 1
            Widget_Control, info.perrorID,     sensitive = 1
            Widget_Control, info.pbulkID,      sensitive = 1
            Widget_Control, info.psurfID,      sensitive = 1
            Widget_Control, info.psumID,       sensitive = 1
            Widget_Control, info.pallID,       sensitive = 1
            Widget_Control, info.pdataID,      sensitive = 1
            Widget_Control, info.pbothID,      sensitive = 1
            Widget_Control, info.pftheoryID,   sensitive = 1
            Widget_Control, info.pfdataID,     sensitive = 1
            Widget_Control, info.pfbothID,     sensitive = 1
	      	Widget_Control, info.pmoriginalID, sensitive = 1
     		Widget_Control, info.pmrefinedID,  sensitive = 1
  	   		Widget_Control, info.pmbothID,     sensitive = 1
   		 	Widget_Control, info.pmlargeID,    sensitive = 1
   		 	Widget_Control, info.pdpattersonID, sensitive = 1
   		 	Widget_Control, info.ptpattersonID, sensitive = 1
   		 	Widget_Control, info.pdifferenceID, sensitive = 1
   		 	Widget_Control, info.pelectronID,   sensitive = 1
   		 	Widget_Control, info.pexp_densID,   sensitive = 1

            IF !version.os_family EQ 'unix' THEN $
              Widget_Control, info.atomsID,      sensitive = 1

            (*handler).data_read[1] = 1
            IF (*handler).data_read[2] EQ 1 THEN (*handler).data_read[2] = 0
            IF (*handler).data_read[0] EQ 1 THEN $
              Widget_Control, info.allID, Sensitive = 1

            result = str_sep ((*handler).string, ' ')
            (*handler).fitfile = result[n_elements(result)-1]
          END

          'r b' : BEGIN
            Widget_Control, info.rodID,        Sensitive = 1
            Widget_Control, info.rangeID,      Sensitive = 1
            Widget_Control, info.qrangeID,     Sensitive = 1
            Widget_Control, info.twoatomsID,   Sensitive = 1
            Widget_Control, info.threeatomsID, Sensitive = 1
            Widget_Control, info.leffecID,     Sensitive = 1
            Widget_Control, info.roughID,      Sensitive = 1
            Widget_Control, info.perrorID,     sensitive = 1
            Widget_Control, info.pbulkID,      sensitive = 1
            Widget_Control, info.psurfID,      sensitive = 1
            Widget_Control, info.psumID,       sensitive = 1
            Widget_Control, info.pallID,       sensitive = 1
            Widget_Control, info.pdataID,      sensitive = 1
            Widget_Control, info.pbothID,      sensitive = 1
            Widget_Control, info.pftheoryID,   sensitive = 1
            Widget_Control, info.pfdataID,     sensitive = 1
            Widget_Control, info.pfbothID,     sensitive = 1
	      	Widget_Control, info.pmoriginalID, sensitive = 1
     		Widget_Control, info.pmrefinedID,  sensitive = 1
  	   		Widget_Control, info.pmbothID,     sensitive = 1
   		 	Widget_Control, info.pmlargeID,    sensitive = 1
   		 	Widget_Control, info.pdpattersonID, sensitive = 1
   		 	Widget_Control, info.ptpattersonID, sensitive = 1
   		 	Widget_Control, info.pdifferenceID, sensitive = 1
   		 	Widget_Control, info.pelectronID,   sensitive = 1
   		 	Widget_Control, info.pexp_densID,   sensitive = 1

            (*handler).data_read[2] = 1
            IF (*handler).data_read[1] EQ 1 THEN $
              Widget_Control, info.paraID, Sensitive = 1
            IF (*handler).data_read[0] EQ 1 THEN $
              Widget_Control, info.allID, Sensitive = 1

            result = str_sep ((*handler).string, ' ')
            (*handler).bulkfile = result[n_elements(result)-1]
         END

         'r p' : BEGIN
           result = str_sep ((*handler).string, ' ')
           (*handler).parafile = result[n_elements(result)-1]
         END

         ELSE :
        ENDCASE
        com_put, handler
        com_get, handler, info.outputID
      ENDFOR
    END

    'LOADLOG' : 	BEGIN
      pick = dialog_Pickfile (/Read, $
                              filter = '*.mcr', /fix_filter, /noconfirm, /must_exist)
      IF pick NE '' THEN BEGIN
        *buffer = read_textfile (pick)
      END

    END

    'SAVELOG' : 	BEGIN
      pick = dialog_Pickfile (/Write, $
                              filter = '*.mcr', /fix_filter)
      IF pick NE '' THEN BEGIN
        openw, lun, pick, /get_lun
        FOR i=0, n_elements(*buffer)-1, 1 DO BEGIN
          printf, lun, (*buffer)[i]
        ENDFOR
        free_lun, lun
      END
    END

    'LISTBULK' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list bulk'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTSURFACE' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list surface'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID

    END

    'LISTINTERFERENCE' : BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list sum'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTALL' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list all'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTDATA' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list data'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTSMODEL' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list smodel'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTBMODEL' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list bmodel'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTFIT' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list fit'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTCOMPARE' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list compare'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTPARAMETERS' : BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list parameters'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTSYMMETRY' : BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'list symmetry'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = ''
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
    END

    'LISTROD' : BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'set calc list'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      Widget_Control, info.outputid, set_Value = 'ROD>', /append
      BackToMain, info
     END

     'LISTSYM' : BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'set symmetry list'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      Widget_Control, info.outputid, set_Value = 'ROD>', /append
      BackToMain, info
    END

    'LISTPAR' : BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'set domain list'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      Widget_Control, info.outputid, set_Value = 'ROD>', /append
      BackToMain, info
    END

    'SETROD' : BEGIN
      BackToMain, info
      temp=''
      data = strarr(13)
      (*handler).string = 'set calc list'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: set calc', /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, text=temp, no_output=1

      IF temp[0] EQ 'Use structure factors' THEN $
        data[0]= 'Yes' $
      ELSE $
        data[0] = 'No'

      FOR i = 1, 11, 1 DO BEGIN
        res = str_sep (temp[i], ' ')
        index = size(res)
        data[i] = res[index[1]-1]
      ENDFOR

      res = str_sep(temp[12], ': ')
      CASE res[1] OF
        'Approximated beta' : BEGIN
          data[12] = 'Approx'
        END
        'Exact beta (bulk only)' : BEGIN
          data[12] = 'Exact'
        END
        'Poisson (bulk only)' : BEGIN
          data[12] = 'Poisson'
        END
        'Exponential (bulk only)' : BEGIN
          data[12] = 'Exponent'
        END
        'Gaussian (bulk only)' : BEGIN
          data[12] = 'Gaussian'
        END
        'Linear (bulk only)' : BEGIN
          data[12] = 'Linear'
        END
        'Cosine (bulk only)' : BEGIN
          data[12] = 'Cosine'
        END
      ENDCASE

      ptr = Ptr_New (data)
      Set_Rod, ptr, group = (*handler).top
      (*handler).string = $
        ' structure ' 	+ (*ptr)[0] + $
        ' lstart ' 	+ (*ptr)[1] + $
        ' lend ' 	+ (*ptr)[2] + $
        ' npoints ' 	+ (*ptr)[3] + $
        ' atten ' 	+ (*ptr)[4] + $
        ' beta ' 	+ (*ptr)[5] + $
        ' lbragg ' 	+ (*ptr)[6] + $
        ' nlayers ' 	+ (*ptr)[7] + $
        ' scale ' 	+ (*ptr)[8] + $
        ' sfraction ' 	+ (*ptr)[9] + $
        ' s2fraction '  + (*ptr)[10] + $
        ' nsurf2 ' 	+ (*ptr)[11] + $
        ' roughness ' 	+ (*ptr)[12]

      Ptr_Free, ptr
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output = 1
      Widget_Control, info.outputid, set_Value = 'ROD>', /append
      BackToMain, info
    END

    'SETSYM' : BEGIN
      BackToMain, info
      temp=''
      (*handler).string = 'set symmetry list'
       Widget_Control, info.outputID, set_Value = 'Equivalent command: set symmetry', /append
	  *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, text=temp, no_output=1
      temp = str_sep (temp[0], ' ')
      data = temp[n_elements(temp) - 1]

      ptr = Ptr_New (data)
      Set_Sym, ptr, group = (*handler).top

			print, (*ptr)

      CASE (*ptr) OF
			'1' : BEGIN
			      	(*handler).string = 'P1'
						END
			'2' : BEGIN
			      	(*handler).string = 'P2'
						END
			'3' : BEGIN
		  		    (*handler).string = 'PM'
						END
			'4' : BEGIN
		  		    (*handler).string = 'PG'
						END
			'5' : BEGIN
		  		    (*handler).string = 'CM'
						END
			'6' : BEGIN
		  		    (*handler).string = 'P2MM'
						END
			'7' : BEGIN
		  		    (*handler).string = 'P2MG'
						END
			'8' : BEGIN
		  		    (*handler).string = 'P2GG'
						END
			'9' : BEGIN
		  		    (*handler).string = 'C2MM'
						END
			'10' : BEGIN
		  		    (*handler).string = 'P4'
						END
			'11' : BEGIN
		  		    (*handler).string = 'P4MM'
						END
			'12' : BEGIN
		  		    (*handler).string = 'P4GM'
						END
			'13' : BEGIN
		  		    (*handler).string = 'P3'
						END
			'14' : BEGIN
		  		    (*handler).string = 'P3M1'
						END
			'15' : BEGIN
		  		    (*handler).string = 'P31M'
						END
			'16' : BEGIN
		  		    (*handler).string = 'P6'
						END
			'17' : BEGIN
		  		    (*handler).string = 'P6MM'
						END
			ELSE: BEGIN
							(*handler).string = (*ptr)
						END
      ENDCASE

      Ptr_Free, ptr
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output = 1
      Widget_Control, info.outputid, set_Value = 'ROD>', /append
      BackToMain, info
    END

    'SETPAR' : BEGIN
      BackToMain, info
      temp = ''
      (*handler).string = 'set domain list'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: set domain', /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, text=temp, no_output=1

      data = fltarr (5, 8)
      data_temp = fltarr(4)
      i = 1
      line = temp[i]
      WHILE strmid(line, 0, 1) EQ ' ' DO BEGIN
        line = strtrim (line, 2)

        length = 0
        blank = 0
        k = 0
        FOR j = 0, 2 , 1 DO BEGIN
          WHILE (strmid(line, k, 1) NE ' ') DO BEGIN
            k = k + 1
            length = length + 1
          ENDWHILE
          data_temp[j] = strmid (line, blank, length)
          WHILE (strmid (line, k, 1) EQ ' ') DO $
            k = k + 1
          blank = k
          length = 0
        ENDFOR
        data_temp[3] = strmid (line, blank, strlen(line) - blank)

        data[0,i-1] = data_temp[0]
        data[1,i-1] = data_temp[1]
        data[2,i-1] = data_temp[2]
        data[3,i-1] = data_temp[3]

        i = i + 1
        line = temp[i]
      END
      ndomains = i - 1

      result = str_sep (line, ' ')
      indices = ''
      indices = result [n_elements(result) - 1]
      i = i + 1
      line = temp[i]
      result = str_sep (line, ' ')
      equal = ''
      equal = result [n_elements(result) - 1]

      i = i + 1
      FOR j = i, i + ndomains - 1, 1 DO BEGIN
        line = temp[j]
        result = str_sep (line, '  ')
        data[4, j - i] = result [n_elements(result) - 1]
      ENDFOR

      ptr1 = Ptr_New (data)
      text = strarr(3)
      text[0] = string (ndomains)
      text[1] = indices
      text[2] = equal
      ptr2 = Ptr_New (text)

      Set_Par, ptr1, ptr2, group = (*handler).top

      (*handler).string = 'ndomains ' + (*ptr2)[0] + $
        ' fractional ' + (*ptr2)[1] + $
        ' equal ' + (*ptr2)[2] + ' '

      datastring = ''
      FOR i = 1, min([4,fix((*ptr2)[0])]), 1 DO BEGIN
        datastring = datastring + 'matrix ' + strtrim(string(i),2) + ' ' + ' ' + $
          strtrim(string((*ptr1)[0,i-1]),2) + ' ' + $
          strtrim(string((*ptr1)[1,i-1]),2) + ' ' + $
          strtrim(string((*ptr1)[2,i-1]),2) + ' ' + $
          strtrim(string((*ptr1)[3,i-1]),2) + ' '
      END
      (*handler).string = (*handler).string + datastring
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output = 1

      datastring = ''
      FOR i = 5, (*ptr2)[0], 1 DO BEGIN
        datastring = datastring + 'matrix ' + strtrim(string(i),2) + ' ' + ' ' + $
          strtrim(string((*ptr1)[0,i-1]),2) + ' ' + $
          strtrim(string((*ptr1)[1,i-1]),2) + ' ' + $
          strtrim(string((*ptr1)[2,i-1]),2) + ' ' + $
          strtrim(string((*ptr1)[3,i-1]),2) + ' '
      END
      (*handler).string = strtrim(datastring,2)
      if (*handler).string NE '' THEN BEGIN
      	*buffer = [ *buffer, (*handler).string]
      	com_put, handler
      	com_get, handler, info.outputID, no_output = 1
      ENDIF

      IF (*ptr2)[2] EQ 'NO' THEN BEGIN
        datastring = ''
        FOR i = 1, (*ptr2)[0], 1 DO BEGIN
          datastring = datastring + 'occ ' + strtrim(string(i),2) + ' ' + strtrim(string((*ptr1)[4,i-1]),2) + ' '
        END
        (*handler).string = datastring
        com_put, handler
        com_get, handler, info.outputID, no_output = 1
      ENDIF

      Ptr_Free, ptr1
      Ptr_Free, ptr2
      Widget_Control, info.outputid, set_Value = 'ROD>', /append
      BackToMain, info
    END

    'CALCRODPROFILE' : BEGIN
      BackToMain, info
      temp=''
      data = {data_1:0.0, data_2:0.0}
      (*handler).string = 'calc rod'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, text=temp, no_output=1
      data.data_1 = float(strtrim(temp[0]))
      data.data_2 = float(strtrim(temp[1]))
      ptr = Ptr_New (data)
      RodProfile, ptr, group = (*handler).top
      Widget_Control, /hourglass
      (*handler).string = (*ptr).data_1
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_2
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      Ptr_Free, ptr
      com_get, handler, info.outputID
    END

    'CALCRANGE' : 	BEGIN
      BackToMain, info
      temp = ''
      data = {data_1:0.0, data_2:0.0, data_3:0.0, data_4:0.0, data_5:0.0, data_6:0.0, data_7:0.0}
      (*handler).string = 'calc range'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, text=temp, no_output=1
      data.data_1 = float(strtrim(temp[0]))
      data.data_2 = float(strtrim(temp[1]))
      data.data_3 = float(strtrim(temp[2]))
      data.data_4 = float(strtrim(temp[3]))
      data.data_5 = float(strtrim(temp[4]))
      data.data_6 = float(strtrim(temp[5]))
      data.data_7 = float(strtrim(temp[6]))
      ptr = Ptr_New (data)
      Range, ptr, group = (*handler).top
      Widget_Control, /hourglass
      (*handler).string = (*ptr).data_1
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_2
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_3
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_4
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_5
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_6
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_7
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      Ptr_Free, ptr
      com_get, handler, info.outputID
    END

    'CALCQRANGE' : 	BEGIN
      BackToMain, info
      temp = ''
      data = {data_1:0.0, data_2:0.0, data_3:0.0, data_4:0.0}
      (*handler).string = 'calc qrange'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, text=temp, no_output=1
      data.data_1 = float(strtrim(temp[0]))
      data.data_2 = float(strtrim(temp[1]))
      data.data_3 = float(strtrim(temp[2]))
      data.data_4 = float(strtrim(temp[3]))
      ptr = Ptr_New (data)
      QRange, ptr, group = (*handler).top
      Widget_Control, /hourglass
      (*handler).string = (*ptr).data_1
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_2
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_3
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_4
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      Ptr_Free, ptr
      com_get, handler, info.outputID
    END

    'CALCALL' :	BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'calc data'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      com_get, handler, info.outputID
    END

    'CALC2ATOMS' : 	BEGIN
      BackToMain, info
      data = {data_1:1, data_2:2}
      (*handler).string = 'calc distance'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      ptr = Ptr_New (data)
      Atoms2, ptr, group = (*handler).top
      Widget_Control, /hourglass
      (*handler).string = (*ptr).data_1
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_2
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      Ptr_Free, ptr
      com_get, handler, info.outputID
    END

    'CALC3ATOMS' : 	BEGIN
      BackToMain, info
      data = {data_1:1, data_2:2, data_3:3}
      (*handler).string = 'calc angle'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      ptr = Ptr_New (data)
      Atoms3, ptr, group = (*handler).top
      Widget_Control, /hourglass
      (*handler).string = (*ptr).data_1
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_2
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      (*handler).string = (*ptr).data_3
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      Ptr_Free, ptr
      com_get, handler, info.outputID
    END

    'CALCLEFFECTIVE' : BEGIN
      BackToMain, info
      data = {data_1:0}
      (*handler).string = 'calc leffective'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID, no_output=1
      ptr = Ptr_New (data)
      Leffective, ptr, group = (*handler).top
      Widget_Control, /hourglass
      (*handler).string = (*ptr).data_1
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      Ptr_Free, ptr
      com_get, handler, info.outputID
    END

    'CALCROUGHNESS' : BEGIN
      BackToMain, info
      Widget_Control, /hourglass
      (*handler).string = 'calc roughness'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, info.outputID, set_Value = 'Calculating ...', /append
      com_get, handler, info.outputID
    END

    'HELP' :	BEGIN
      temp=''
      (*handler).string = 'help'
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      com_put, handler
      com_get, handler, info.outputID, text=temp, no_output=1

      i = n_elements(temp)
      IF NOT(XREGISTERED('HelpGUI')) THEN BEGIN
        helpgui, handler, temp[0:i-2], group = (*handler).top
      ENDIF ELSE BEGIN
        Widget_Control, (*handler).helpID, /Destroy
        helpgui, handler, temp[0:i-2], group = (*handler).top
      ENDELSE
    END

    'BUG' : BEGIN
      description = ['']
      ptr_des = Ptr_New (description)
      data = {do_it:1, ptr_text:ptr_des}
      ptr = Ptr_New (data)

      bug, ptr, group = (*handler).top

      IF (*ptr).do_it EQ 1 THEN BEGIN
        openw, a_unit, 'bug_report', /get_lun
        lines = n_elements (*ptr_des)
        FOR i = 0, lines - 1, 1 DO $
          printf, a_unit, (*ptr_des)[i]
        printf, a_unit, 'The Buffer:'
        FOR i = 0, n_elements(*buffer) - 1, 1 DO $
          printf, a_unit, (*buffer)[i]
        close, a_unit

        spawn, 'cat bug_report | mailx -s BUG_REPORT wilms@esrf.fr'
        spawn, 'cat bug_report | mailx -s BUG_REPORT srio@esrf.fr'
      ENDIF
      Ptr_Free, ptr
      Ptr_Free, ptr_des
    END

    'MANUAL' : BEGIN
	ds = sdep(/ds)
	command = 'netscape -install '+getenv('ROD_HOME')+ds+'www'+ds+'index.html'
        action=0
        xedit,command,infotext='Command to open WWW browser: ',action=action,$
          text = ' ',Title='WWW conection'
        if action NE 'CANCEL' then begin
          message,/Info,'Executing: '+command
          spawn,command
	endif
    END

    'RESIZE' : 	BEGIN
      Widget_Control, info.outputID, scr_xsize=event.x-38, scr_ysize=event.y-66
      Widget_Control, info.inputID,  scr_xsize=event.x-56
    END

    'LOADDATA' : 	BEGIN
      BackToMain, info
      pick = dialog_Pickfile (/Read, $
                              filter = '*.dat', /noconfirm, /must_exist)
      IF pick NE '' THEN BEGIN
        Widget_Control, info.outputID, set_Value = 'Loading ...', /append
        pick = strmid (pick, 0, strlen(pick)-4)
        (*handler).datafile = pick
        pick = 'r d ' + pick
        (*handler).string = pick
        Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
        *buffer = [ *buffer, (*handler).string]
        com_put, handler
        com_get, handler, info.outputID

        (*handler).data_read[0] = 1

        IF (*handler).data_read[1] EQ 1 OR (*handler).data_read[2] EQ 1 THEN $
          Widget_Control, info.allID, Sensitive = 1
      ENDIF
    END

    'LOADFIT' : 	BEGIN
      BackToMain, info
      pick = dialog_Pickfile (/Read, $
                              filter = '*.fit', /noconfirm, /must_exist)
      IF pick NE '' THEN BEGIN
        Widget_Control, info.outputID, set_Value = 'Loading ...', /append
        pick = strmid (pick, 0, strlen(pick)-4)
        (*handler).fitfile = pick
        pick = 'r f ' + pick
        (*handler).string = pick
        Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
        *buffer = [ *buffer, (*handler).string]
        com_put, handler
        com_get, handler, info.outputID

        Widget_Control, info.rodID,        Sensitive = 1
        Widget_Control, info.rangeID,      Sensitive = 1
        Widget_Control, info.qrangeID,     Sensitive = 1
        Widget_Control, info.twoatomsID,   Sensitive = 1
        Widget_Control, info.threeatomsID, Sensitive = 1
        Widget_Control, info.leffecID,     Sensitive = 1
        Widget_Control, info.roughID,      Sensitive = 1
        Widget_Control, info.perrorID,     sensitive = 1
        Widget_Control, info.pbulkID,      sensitive = 1
        Widget_Control, info.psurfID,      sensitive = 1
        Widget_Control, info.psumID,       sensitive = 1
        Widget_Control, info.pallID,       sensitive = 1
        Widget_Control, info.pdataID,      sensitive = 1
        Widget_Control, info.pbothID,      sensitive = 1
        Widget_Control, info.pftheoryID,   sensitive = 1
        Widget_Control, info.pfdataID,     sensitive = 1
        Widget_Control, info.pfbothID,     sensitive = 1
        Widget_Control, info.pmoriginalID, sensitive = 1
      	Widget_Control, info.pmrefinedID,  sensitive = 1
      	Widget_Control, info.pmbothID,     sensitive = 1
      	Widget_Control, info.pmlargeID,    sensitive = 1
      	Widget_Control, info.pdpattersonID, sensitive = 1
  	    Widget_Control, info.ptpattersonID, sensitive = 1
    	Widget_Control, info.pdifferenceID, sensitive = 1
     	Widget_Control, info.pelectronID,   sensitive = 1
     	Widget_Control, info.pexp_densID,   sensitive = 1

        IF !version.os_family EQ 'unix' THEN $
          Widget_Control, info.atomsID,      sensitive = 1

        (*handler).data_read[1] = 1
        IF (*handler).data_read[2] EQ 1 THEN (*handler).data_read[2] = 0
        IF (*handler).data_read[0] EQ 1 THEN $
          Widget_Control, info.allID, Sensitive = 1
      ENDIF
    END

    'LOADSURFACE' :	BEGIN
      BackToMain, info
      pick = dialog_Pickfile (/Read, $
                              filter = '*.sur', /noconfirm, /must_exist)
      IF pick NE '' THEN BEGIN
        Widget_Control, info.outputID, set_Value = 'Loading ...', /append
        pick = strmid (pick, 0, strlen(pick)-4)
        (*handler).surffile = pick
        pick = 'r s ' + pick
        (*handler).string = pick
        Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
        *buffer = [ *buffer, (*handler).string]
        com_put, handler
        com_get, handler, info.outputID
      ENDIF
    END

    'LOADBULK' : 	BEGIN
      BackToMain, info
      pick = dialog_Pickfile (/Read, $
                              filter = '*.bul', /noconfirm, /must_exist)
      IF pick NE '' THEN BEGIN
        Widget_Control, info.outputID, set_Value = 'Loading ...', /append
        pick = strmid (pick, 0, strlen(pick)-4)
        (*handler).bulkfile = pick
        pick = 'r b ' + pick
        (*handler).string = pick
        Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
        *buffer = [ *buffer, (*handler).string]
        com_put, handler
        com_get, handler, info.outputID

        Widget_Control, info.rodID,        Sensitive = 1
        Widget_Control, info.rangeID,      Sensitive = 1
        Widget_Control, info.qrangeID,     Sensitive = 1
        Widget_Control, info.twoatomsID,   Sensitive = 1
        Widget_Control, info.threeatomsID, Sensitive = 1
        Widget_Control, info.leffecID,     Sensitive = 1
        Widget_Control, info.roughID,      Sensitive = 1
        Widget_Control, info.perrorID,     sensitive = 1
        Widget_Control, info.pbulkID,      sensitive = 1
        Widget_Control, info.psurfID,      sensitive = 1
        Widget_Control, info.psumID,       sensitive = 1
        Widget_Control, info.pallID,       sensitive = 1
        Widget_Control, info.pdataID,      sensitive = 1
        Widget_Control, info.pbothID,      sensitive = 1
        Widget_Control, info.pftheoryID,   sensitive = 1
        Widget_Control, info.pfdataID,     sensitive = 1
        Widget_Control, info.pfbothID,     sensitive = 1
        Widget_Control, info.pmoriginalID, sensitive = 1
      	Widget_Control, info.pmrefinedID,  sensitive = 1
      	Widget_Control, info.pmbothID,     sensitive = 1
      	Widget_Control, info.pmlargeID,    sensitive = 1
      	Widget_Control, info.pdpattersonID, sensitive = 1
  	    Widget_Control, info.ptpattersonID, sensitive = 1
    	Widget_Control, info.pdifferenceID, sensitive = 1
     	Widget_Control, info.pelectronID,   sensitive = 1
     	Widget_Control, info.pexp_densID,   sensitive = 1

        (*handler).data_read[2] = 1
        IF (*handler).data_read[1] EQ 1 THEN $
          Widget_Control, info.paraID, Sensitive = 1
        IF (*handler).data_read[0] EQ 1 THEN $
          Widget_Control, info.allID, Sensitive = 1
      ENDIF
    END

    'LOADPARAMETERS' : BEGIN
      BackToMain, info
      pick = dialog_Pickfile (/Read, $
                              filter = '*.par', /noconfirm, /must_exist)
      IF pick NE '' THEN BEGIN
        Widget_Control, info.outputID, set_Value = 'Loading ...', /append
        pick = strmid (pick, 0, strlen(pick)-4)
        (*handler).parafile = pick
        pick = 'r p ' + pick
        (*handler).string = pick
        Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
        *buffer = [ *buffer, (*handler).string]
        com_put, handler
        com_get, handler, info.outputID
      ENDIF
    END

    'EDITDATA' : BEGIN
      dat_editor, group = event.top
    END

    'EDITFIT' : BEGIN
      fit_editor, group = event.top
    END

    'EDITBULK' : BEGIN
      bul_editor, group = event.top
    END

    'EDITPARAMETERS' : BEGIN
      par_editor, group = event.top
    END

    'PLOTATOMS' : BEGIN
      data = {data_1:1, data_2:1}
      ptr = Ptr_New (data)
      AtomPlot, ptr, group = (*handler).top

      name = (*handler).fitfile + '.fit'
      text = read_textfile (name)
      n_atoms =  n_elements(text) - 1
      i = 0
      WHILE strmid (text[i], 0, 1) EQ '#' DO BEGIN
        n_atoms = n_atoms - 1
        i = i + 1
      END
      i = i + 1

      A = {data, name:'', x:0.0, y:0.0, z:0.0}
      atoms = REPLICATE (A, n_atoms*(*ptr).data_1*(*ptr).data_2)

      current = 0
      WHILE i LT n_elements(text) DO BEGIN
        j = 0
        line = text[i]
        WHILE j LT strlen(line) - 2 DO BEGIN
          IF strmid(line,j,1) EQ ' ' AND strmid(line,j+1,1) EQ ' ' THEN BEGIN
            length = strlen(line)
            line = strmid(line, 0, j+1) + strmid(line,j+2,length-1)
            j = j - 1
          ENDIF
          j = j+ 1
        END
        result = str_sep (line, ' ')
        atoms[current].name = result[0]
        atoms[current].x = result[1]
        atoms[current].y = result[6]
        atoms[current].z = result[11]

        i = i + 1
        current = current + 1
      END
      openw, a_unit, 'plot.alc', /get_lun
      printf, a_unit, format = '(I5," ATOMS,     0 BONDS,     0 CHARGES, TEMP")', $
        n_atoms*(*ptr).data_1*(*ptr).data_2

      i = 1
      FOR x = 0, (*ptr).data_1 - 1, 1 DO BEGIN
        FOR y = 0, (*ptr).data_2 - 1, 1 DO BEGIN
          FOR k = 0, n_atoms - 1, 1 DO BEGIN
            printf, a_unit, format ='(I5," ",A2,"     ",F7.5,"  ",F7.5,"  ",F7.5)', $
              i , atoms[k].name, atoms[k].x + x, atoms[k].y + y, atoms[k].z
            i = i + 1
          END
        END
      END

      close, a_unit
      free_lun, a_unit

      rasmol_home = getenv('RASMOL_HOME')
      spawn, rasmol_home + 'rasmol -alchemy ' + 'plot.alc'
      Ptr_Free, ptr
    END

    'PLOTERROR' : BEGIN
      BackToMain, info
      IF (*handler).perror EQ 0 THEN BEGIN
        (*handler).string = "plot err y"
        Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
        *buffer = [ *buffer, (*handler).string]
        com_put, handler
        com_get, handler, info.outputID, no_output = 1
        Widget_Control, info.outputid, set_Value = 'Plotting Errors set to TRUE', /append
        Widget_Control, info.outputid, set_Value = 'ROD>', /append
        (*handler).perror = 1
      ENDIF ELSE BEGIN
        (*handler).string = "plot err n"
        Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
        *buffer = [ *buffer, (*handler).string]
        com_put, handler
        com_get, handler, info.outputID, no_output = 1
        Widget_Control, info.outputid, set_Value = 'Plotting Errors set to FALSE', /append
        Widget_Control, info.outputid, set_Value = 'ROD>', /append
        (*handler).perror = 0
      ENDELSE
      BackToMain, info
    END

    'PLOTBULK' : BEGIN
      BackToMain, info
      (*handler).string = "plot bulk p"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTSURFACE' : BEGIN
      BackToMain, info
      (*handler).string = "plot surf p"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTSUM' : BEGIN
      BackToMain, info
      (*handler).string = "plot sum p"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTALL' : BEGIN
      BackToMain, info
      (*handler).string = "plot all"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTDATA' : BEGIN
      BackToMain, info
      (*handler).string = "plot data"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTBOTH' : BEGIN
      BackToMain, info
      (*handler).string = "plot both"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTFTHEORY' : BEGIN
      BackToMain, info
      (*handler).string = "plot ftheory"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTFDATA' : BEGIN
      BackToMain, info
      (*handler).string = "plot fdata"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTFBOTH' : BEGIN
      BackToMain, info
      (*handler).string = "plot fboth"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTMORIGINAL' : BEGIN
      BackToMain, info
      (*handler).string = "plot moriginal"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTMREFINED' : BEGIN
      BackToMain, info
      (*handler).string = "plot mrefined"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTMBOTH' : BEGIN
      BackToMain, info
      (*handler).string = "plot mboth"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTMLARGE' : BEGIN
      data = {data_1:1, data_2:1}
      ptr = Ptr_New (data)
      AtomPlot, ptr, group = (*handler).top

      BackToMain, info
      (*handler).string = "plot mlarge " + strtrim(string((*ptr).data_1),2) + " " + strtrim(string((*ptr).data_2),2)
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
      Ptr_Free, ptr
    END

    'PLOTDPATTERSON' : BEGIN
      BackToMain, info
      (*handler).string = "plot dpatterson"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTTPATTERSON' : BEGIN
      BackToMain, info
      (*handler).string = "plot tpatterson"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTDIFFERENCE' : BEGIN
      BackToMain, info
      (*handler).string = "plot difference"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTELECTRON' : BEGIN
      BackToMain, info
      (*handler).string = "plot electron"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

    'PLOTEXP_DENS' : BEGIN
      BackToMain, info
      (*handler).string = "plot exp_dens"
      Widget_Control, info.outputID, set_Value = 'Equivalent command: ' + (*handler).string, /append
      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      com_get, handler, info.outputID
      BackToMain, info
    END

		'ABOUT' : BEGIN
			result = Dialog_Message (['RODGUI', $
																'written by Andre Wilms', $
																'e-mail address: wilms@comline.de', $
																' ', $
																' ', $
																'using ROD', $
																'written by Elias Vlieg', $
																'e-mail address: vlieg@sci.kun.nl'], $
																/Information, $
																title = 'About RODGUI', $
																DIALOG_PARENT = (*handler).top)
		END

	'STARTCOM' : 	BEGIN
      IF (*handler).status EQ 'Starting' THEN BEGIN
        Widget_Control, info.inputID, Editable=1
        (*handler).status = 'Sending'
      ENDIF

      Widget_Control, info.saveID,   Sensitive = 1
      Widget_Control, info.startID,  Sensitive = 0
      Widget_Control, info.showlogID,Sensitive = 1
      Widget_Control, info.execlogID,Sensitive = 1
      Widget_Control, info.clrlogID, Sensitive = 1
      Widget_Control, info.loadlogID,Sensitive = 1
      Widget_Control, info.savelogID,Sensitive = 1
      Widget_Control, info.dataID,   Sensitive = 1
      Widget_Control, info.fitID,    Sensitive = 1
      Widget_Control, info.surfID,   Sensitive = 1
      Widget_Control, info.bulkID,   Sensitive = 1
      Widget_Control, info.helpID,   Sensitive = 1

      IF !version.os_family EQ 'unix' THEN BEGIN
	      Widget_Control, info.abortID,  Sensitive = 1
        Widget_Control, info.bugID,    Sensitive = 1
			ENDIF

      Widget_Control, info.setrodID,     sensitive = 1
      Widget_Control, info.setsymID,     sensitive = 1
      Widget_Control, info.setparID,     sensitive = 1
      Widget_Control, info.lrodID,       sensitive = 1
      Widget_Control, info.lsymID,       sensitive = 1
      Widget_Control, info.lparID,       sensitive = 1
      Widget_Control, info.lbulkID,  	 	 sensitive = 1
      Widget_Control, info.lsurfID,      sensitive = 1
      Widget_Control, info.lsumID,       sensitive = 1
      Widget_Control, info.lallID,       sensitive = 1
      Widget_Control, info.ldataID,      sensitive = 1
      Widget_Control, info.lsmodelID,    sensitive = 1
      Widget_Control, info.lbmodelID,    sensitive = 1
      Widget_Control, info.lfitID,       sensitive = 1
      Widget_Control, info.lcompID,      sensitive = 1
      Widget_Control, info.lparamID,     sensitive = 1
      Widget_Control, info.lsymmID,      sensitive = 1

      IF !version.os_family EQ 'UNIX' THEN BEGIN
        does_exist = checkfile (outname)
        IF does_exist EQ 1 THEN BEGIN
          openw, a_unit, outname, /get_lun, /delete
          close, a_unit
          free_lun, a_unit
        ENDIF

        does_exist = checkfile (outtemp)
        IF does_exist EQ 1 THEN BEGIN
          openw, a_unit, outtemp, /get_lun, /delete
          close, a_unit
          free_lun, a_unit
        ENDIF
      ENDIF

      IF !version.os_family EQ 'Windows' THEN BEGIN
        does_exist = checkfile (readyname)
        IF does_exist EQ 1 THEN BEGIN
          openw, a_unit, readyname, /get_lun, /delete
          close, a_unit
          free_lun, a_unit
        ENDIF
      ENDIF

      IF !version.os_family EQ 'unix' THEN BEGIN

        spawn, 'echo $LOGNAME', username
        spawn, 'ps -fu ' + username + ' | grep rod', result
        lines = n_elements(result)
        FOR i = 0, lines - 1, 1 DO BEGIN
          temp = strpos(result[i], 'rod.', 45)
          IF temp NE -1 THEN BEGIN
            number = strmid (result[i], 9, 5)
            spawn, 'kill -9 ' + number
          ENDIF
        ENDFOR

	rod_home = getenv('ROD_HOME')
        spawn, rod_home + "/rod.`" +rod_home+ "/rod_os` &"
        com_get, handler, info.outputID


      ENDIF ELSE BEGIN
        com_get, handler, info.outputID
      ENDELSE

      IF (*handler).status EQ 'Finished' THEN $
        Widget_Control, info.inputID, Editable=0
    END

    'ABORTCOM' : 	BEGIN
      Widget_Control, info.outputID, set_Value = '', /no_newline
      Widget_Control, info.inputID, set_Value = ''
      (*handler).string=''
      (*handler).status='Starting'
      (*handler).data_read = 0
      *buffer = ['']

      Widget_Control, info.saveID,   Sensitive = 0
      Widget_Control, info.startID,  Sensitive = 1
      Widget_Control, info.abortID,  Sensitive = 0
      Widget_Control, info.showlogID,Sensitive = 0
      Widget_Control, info.execlogID,Sensitive = 0
      Widget_Control, info.clrlogID, Sensitive = 0
      Widget_Control, info.loadlogID,Sensitive = 0
      Widget_Control, info.savelogID,Sensitive = 0
      Widget_Control, info.dataID,   Sensitive = 0
      Widget_Control, info.fitID,    Sensitive = 0
      Widget_Control, info.surfID,   sensitive = 0
      Widget_Control, info.bulkID,   Sensitive = 0
      Widget_Control, info.paraID,   Sensitive = 0
      Widget_Control, info.helpID,   Sensitive = 0
      Widget_Control, info.setrodID,     Sensitive = 0
      Widget_Control, info.setsymID,     Sensitive = 0
      Widget_Control, info.setparID,     Sensitive = 0
      Widget_Control, info.rodID,        Sensitive = 0
      Widget_Control, info.rangeID,      Sensitive = 0
      Widget_Control, info.qrangeID,     Sensitive = 0
      Widget_Control, info.allID,        Sensitive = 0
      Widget_Control, info.twoatomsID,   Sensitive = 0
      Widget_Control, info.threeatomsID, Sensitive = 0
      Widget_Control, info.leffecID,     Sensitive = 0
      Widget_Control, info.roughID,      Sensitive = 0
      Widget_Control, info.lrodID,       Sensitive = 0
      Widget_Control, info.lsymID,       Sensitive = 0
      Widget_Control, info.lparID,       Sensitive = 0
      Widget_Control, info.lbulkID,  	   sensitive = 0
      Widget_Control, info.lsurfID,      sensitive = 0
      Widget_Control, info.lsumID,       sensitive = 0
      Widget_Control, info.lallID,       sensitive = 0
      Widget_Control, info.ldataID,      sensitive = 0
      Widget_Control, info.lsmodelID,    sensitive = 0
      Widget_Control, info.lbmodelID,    sensitive = 0
      Widget_Control, info.lfitID,       sensitive = 0
      Widget_Control, info.lcompID,      sensitive = 0
      Widget_Control, info.lparamID,     sensitive = 0
      Widget_Control, info.lsymmID,      sensitive = 0
      Widget_Control, info.perrorID,     sensitive = 0
      Widget_Control, info.pbulkID,      sensitive = 0
      Widget_Control, info.psurfID,      sensitive = 0
      Widget_Control, info.psumID,       sensitive = 0
      Widget_Control, info.pallID,       sensitive = 0
      Widget_Control, info.pdataID,      sensitive = 0
      Widget_Control, info.pbothID,      sensitive = 0
      Widget_Control, info.pftheoryID,   sensitive = 0
      Widget_Control, info.pfdataID,     sensitive = 0
      Widget_Control, info.pfbothID,     sensitive = 0
      Widget_Control, info.pmoriginalID, sensitive = 0
      Widget_Control, info.pmrefinedID,  sensitive = 0
      Widget_Control, info.pmbothID,     sensitive = 0
      Widget_Control, info.pmlargeID,    sensitive = 0
      Widget_Control, info.pdpattersonID, sensitive = 0
      Widget_Control, info.ptpattersonID, sensitive = 0
      Widget_Control, info.pdifferenceID, sensitive = 0
      Widget_Control, info.pelectronID,   sensitive = 0
      Widget_Control, info.pexp_densID,   sensitive = 0

      IF !version.os_family EQ 'unix' THEN BEGIN
        Widget_Control, info.bugID,    Sensitive = 0
        Widget_Control, info.atomsID,  Sensitive = 0

        spawn, 'echo $LOGNAME', username
        spawn, 'ps -fu ' + username + ' | grep rod', result
        lines = n_elements(result)
        FOR i = 0, lines - 1, 1 DO BEGIN
          temp = strpos(result[i], 'rod.', 45)
          IF temp NE -1 THEN BEGIN
            number = strmid (result[i], 9, 5)
            spawn, 'kill -9 ' + number
          ENDIF
        ENDFOR

      ENDIF

      openw, a_unit, alcname, /get_lun, /delete
      close, a_unit
      free_lun, a_unit
    END

    'INPUT' : BEGIN
      temp = ''
      Widget_Control, event.id, get_Value = temp
      Widget_Control, info.outputID, set_Value = temp, /append
      temp = temp[0]
      (*handler).string = temp

      *buffer = [ *buffer, (*handler).string]
      com_put, handler
      Widget_Control, event.id, set_Value = ''
      com_get, handler, info.outputID
    END

    ELSE :
  ENDCASE

  IF Widget_Info (event.top, /valid_ID) THEN BEGIN
    infoID = Widget_Info (event.top, /Child)
    Widget_Control, infoID, set_UValue=info, /no_copy
  ENDIF
END




;--------------------------------------------------------------
; RODGUI
;--------------------------------------------------------------

PRO RodGUI,Group=group
	IF (!d.n_colors GT 256) THEN device, decomposed = 0

  tmp = getenv ('ROD_HOME')
  IF tmp EQ '' THEN BEGIN
	if getenv('XOP_HOME') NE '' then begin
	    ds = sdep(/ds)
	    setenv, 'ROD_HOME='+getenv('XOP_HOME')+ds+ 'extensions'+ds+'RODGUI'
	endif else begin
	    tmp = Dialog_Message(/Error,Dialog_Parent=group, $
	   'Environment variable ROD_HOME (or XOP_HOME) must be set')
	    return
	endelse
  ENDIF

  tlb   = Widget_Base (title = 'ROD - Graphical User Interface', $
                       column = 1, base_align_left = 1, MBar = MenuBar, $
                       TLB_SIZE_EVENTS = 1, UValue = 'RESIZE')
  infos = Widget_Base (tlb)

  FileMenu = WIDGET_BUTTON(MenuBar,      VALUE='RODGui', /MENU)
  bsave  = WIDGET_BUTTON(FileMenu, 	 VALUE='Save Settings', 	UValue='SAVEFILE')
  bclear = WIDGET_BUTTON(FileMenu, 	 VALUE='Clear output window', 	UValue='CLEAR', /Separator)
  bquit  = WIDGET_BUTTON(FileMenu, 	 VALUE='Quit', 			UValue='QUIT', /Separator)
  ConnectionMenu = WIDGET_BUTTON(MenuBar, VALUE='Connection', /MENU)
  bstart = WIDGET_BUTTON(ConnectionMenu, VALUE='Start', 		UValue='STARTCOM')

  IF !version.os_family EQ 'unix' THEN BEGIN
  	babort = WIDGET_BUTTON(ConnectionMenu, VALUE='Abort', 		UValue='ABORTCOM')
  ENDIF

  bloadlog=WIDGET_BUTTON(ConnectionMenu, VALUE='Load Macro File',       UValue='LOADLOG', /Separator)
  bsavelog=WIDGET_BUTTON(ConnectionMenu, VALUE='Save Macro File',       UValue='SAVELOG')
  bexeclog=WIDGET_BUTTON(ConnectionMenu, VALUE='Execute Macro File',    UValue='EXECLOG')
  bshowlog=WIDGET_BUTTON(ConnectionMenu, VALUE='Show Macro File',       UValue='SHOWLOG')
  bclrlog =WIDGET_BUTTON(ConnectionMenu, VALUE='Clear Macro File',	UValue='CLRLOG')
  RodMenu = WIDGET_BUTTON(MenuBar, 	 VALUE='File', 			/MENU)
  bdata = WIDGET_BUTTON(RodMenu, 	 VALUE='Load Data File', 	UValue='LOADDATA')
  bfit  = WIDGET_BUTTON(RodMenu, 	 VALUE='Load Fit File', 	UValue='LOADFIT')
  bsurf = WIDGET_BUTTON(RodMenu, 	 VALUE='Load Surface File', 	UValue='LOADSURFACE')
  bbulk = WIDGET_BUTTON(RodMenu, 	 VALUE='Load Bulk File', 	UValue='LOADBULK')
  bpara = WIDGET_BUTTON(RodMenu, 	 VALUE='Load Parameters File', 	UValue='LOADPARAMETERS')
  bedata = WIDGET_BUTTON(RodMenu, 	 VALUE='Data File Editor', 	UValue='EDITDATA', /Separator)
  befit  = WIDGET_BUTTON(RodMenu, 	 VALUE='Fit File Editor', 	UValue='EDITFIT')
  bebulk = WIDGET_BUTTON(RodMenu, 	 VALUE='Bulk File Editor', 	UValue='EDITBULK')
  bepara = WIDGET_BUTTON(RodMenu, 	 VALUE='Parameters File Editor',UValue='EDITPARAMETERS')
  CalculationMenu = WIDGET_BUTTON(MenuBar,VALUE='Calculate',		/MENU)
  bsetrod = WIDGET_BUTTON(CalculationMenu,VALUE='Set Calculation Parameters', UValue='SETROD')
  bsetsym = WIDGET_BUTTON(CalculationMenu,VALUE='Set Space Group Symmetry',   UValue='SETSYM')
  bsetpar = WIDGET_BUTTON(CalculationMenu,VALUE='Set Domain Parameters',      UValue='SETPAR')
  brod    = WIDGET_BUTTON(CalculationMenu, VALUE='Rod profile', 	      UValue='CALCRODPROFILE', /Separator)
  brange  = WIDGET_BUTTON(CalculationMenu, VALUE="F's for range of h and k",  UValue='CALCRANGE')
  bqrange = WIDGET_BUTTON(CalculationMenu, VALUE="F's within q-max", 	      UValue='CALCQRANGE')
  ball    = WIDGET_BUTTON(CalculationMenu, VALUE="F's for all data points",   UValue='CALCALL')
  b2atoms = WIDGET_BUTTON(CalculationMenu, VALUE='The distance between 2 atoms', UValue='CALC2ATOMS')
  b3atoms = WIDGET_BUTTON(CalculationMenu, VALUE='Bond angle between 3 atoms',   UValue='CALC3ATOMS')
  bleffec = WIDGET_BUTTON(CalculationMenu, VALUE='Effective l from slit width',  UValue='CALCLEFFECTIVE')
  brough  = WIDGET_BUTTON(CalculationMenu, VALUE='Roughness in atomic layers',   UValue='CALCROUGHNESS')
  ListMenu= WIDGET_BUTTON(MenuBar, 		VALUE='List',			/MENU)
  blrod   = WIDGET_BUTTON(ListMenu,   VALUE='Calculation Parameters', UValue='LISTROD')
  blsym   = WIDGET_BUTTON(ListMenu,   VALUE='Space Group Symmetry',   UValue='LISTSYM')
  blpar   = WIDGET_BUTTON(ListMenu,   VALUE='Domain Parameters',      UValue='LISTPAR')
  blbulk  = WIDGET_BUTTON(ListMenu, 	VALUE='Bulk contribution', 	    UValue='LISTBULK', /Separator)
  blsurf  = WIDGET_BUTTON(ListMenu, 	VALUE='Surface contribution', 	UValue='LISTSURFACE')
  blsum   = WIDGET_BUTTON(ListMenu, 	VALUE='Interference sum of bulk and sum', UValue='LISTINTERFERENCE')
  blall   = WIDGET_BUTTON(ListMenu, 	VALUE='Above three values', 		UValue='LISTALL')
  bldata  = WIDGET_BUTTON(ListMenu, 	VALUE='Structure factor data', 	UValue='LISTDATA')
  blsmodel= WIDGET_BUTTON(ListMenu, 	VALUE='Surface model', 			    UValue='LISTSMODEL')
  blbmodel= WIDGET_BUTTON(ListMenu, 	VALUE='Bulk model', 			  		UValue='LISTBMODEL')
  blfit   = WIDGET_BUTTON(ListMenu, 	VALUE='Fitting model for surface structure', 		UValue='LISTFIT')
  blcomp  = WIDGET_BUTTON(ListMenu, 	VALUE='Comparison between data and theory',  		UValue='LISTCOMPARE')
  blparam = WIDGET_BUTTON(ListMenu, 	VALUE='Values of fit parameters', 	     				UValue='LISTPARAMETERS')
  blsymm  = WIDGET_BUTTON(ListMenu, 	VALUE='Symmetry-equivalent reflections of data',UValue='LISTSYMMETRY')

  PlotMenu= WIDGET_BUTTON(MenuBar,       VALUE='Plot', /MENU)

  IF !version.os_family EQ 'unix' THEN BEGIN
    batoms  = WIDGET_BUTTON(PlotMenu,     VALUE='Atoms',                         UValue='PLOTATOMS')
    bperror = WIDGET_BUTTON(PlotMenu,     VALUE='Plot Errors On/Off',            UValue='PLOTERROR', /Separator)
    bpbulk  = WIDGET_BUTTON(PlotMenu,     VALUE='Bulk contribution (against l)', UValue='PLOTBULK', /Separator)
  ENDIF ELSE BEGIN
    bperror = WIDGET_BUTTON(PlotMenu,     VALUE='Plot Errors On/Off',            UValue='PLOTERROR')
    bpbulk  = WIDGET_BUTTON(PlotMenu,     VALUE='Bulk contribution (against l)', UValue='PLOTBULK', /Separator)
  ENDELSE

  bpsurf   = WIDGET_BUTTON(PlotMenu,     VALUE='Surface contribution (against l)',     UValue='PLOTSURFACE')
  bpsum    = WIDGET_BUTTON(PlotMenu,     VALUE='Interference sum of bulk and surface', UValue='PLOTSUM')
  bpall    = WIDGET_BUTTON(PlotMenu,     VALUE='Above three curves',                   UValue='PLOTALL')
  bpdata   = WIDGET_BUTTON(PlotMenu,     VALUE='Rod data (against l)',                 UValue='PLOTDATA')
  bpboth   = WIDGET_BUTTON(PlotMenu,     VALUE='Data plus calculated interference sum', UValue='PLOTBOTH')
  bpftheory= WIDGET_BUTTON(PlotMenu,     VALUE='Theoretical Structure Factors',  				UValue='PLOTFTHEORY', /Separator)
  bpfdata  = WIDGET_BUTTON(PlotMenu,     VALUE='Experimental Structure Factors',  			UValue='PLOTFDATA')
  bpfboth  = WIDGET_BUTTON(PlotMenu,     VALUE='Theoretical And Experimental Factors',  UValue='PLOTFBOTH')
  bpmoriginal= WIDGET_BUTTON(PlotMenu,     VALUE='Original Structure Model',  					UValue='PLOTMORIGINAL', /Separator)
  bpmrefined = WIDGET_BUTTON(PlotMenu,     VALUE='Refined Structure Model',  					  UValue='PLOTMREFINED')
  bpmboth    = WIDGET_BUTTON(PlotMenu,     VALUE='Original And Refined Structure Model',UValue='PLOTMBOTH')
  bpmlarge     = WIDGET_BUTTON(PlotMenu,   VALUE='Several Unit Cells Of Refined Model', UValue='PLOTMLARGE')
  bpdpatterson = WIDGET_BUTTON(PlotMenu,   VALUE='Patterson Function Of Experimental Data',      UValue='PLOTDPATTERSON', /Separator)
  bptpatterson = WIDGET_BUTTON(PlotMenu,   VALUE='Patterson Of Theroretical Structure Factors',  UValue='PLOTTPATTERSON')
  bpdifference = WIDGET_BUTTON(PlotMenu,   VALUE='Electron Density Difference Map',              UValue='PLOTDIFFERENCE')
  bpelectron   = WIDGET_BUTTON(PlotMenu,   VALUE='Electron Density Map Of Model',                UValue='PLOTELECTRON')
  bpexp_dens   = WIDGET_BUTTON(PlotMenu,   VALUE='Electron Density Map Of Experimental Factors', UValue='PLOTEXP_DENS')

  HelpMenu= WIDGET_BUTTON(MenuBar,	VALUE='Help', /MENU, /HELP)
	babout  = WIDGET_BUTTON(HelpMenu,	VALUE='About RODGUI',			UValue='ABOUT')
  bhelp   = WIDGET_BUTTON(HelpMenu,	VALUE='Help',			UValue='HELP')

  IF !version.os_family EQ 'unix' THEN BEGIN
    bbug    = WIDGET_BUTTON(HelpMenu,	VALUE='Bug Report',		UValue='BUG')
    bmanual = WIDGET_BUTTON(HelpMenu,	VALUE='Manual',		        UValue='MANUAL')

    toutput    = Widget_Label  (tlb, value = 'Output window:')
    output     = Widget_Text   (tlb, xsize = 80, ysize = 20, /scroll)
    tinput     = Widget_Label  (tlb, value = 'Enter commands:')
    input      = Widget_Text   (tlb, xsize = 80, UValue='INPUT')
  ENDIF ELSE BEGIN
    toutput    = Widget_Label  (tlb, font='Courier*10', value = 'Output window:')
    output     = Widget_Text   (tlb, font='Courier*10', xsize = 80, ysize = 20, /scroll)
    tinput     = Widget_Label  (tlb, font='Courier*10', value = 'Enter commands:')
    input      = Widget_Text   (tlb, font='Courier*10', xsize = 80, UValue='INPUT')
  ENDELSE

  Widget_Control, bsave,   sensitive = 0

  IF !version.os_family EQ 'unix' THEN BEGIN
	  Widget_Control, babort,  sensitive = 0
	ENDIF

  Widget_Control, bshowlog,sensitive = 0
  Widget_Control, bexeclog,sensitive = 0
  Widget_Control, bclrlog, sensitive = 0
  Widget_Control, bloadlog,sensitive = 0
  Widget_Control, bsavelog,sensitive = 0
  Widget_Control, bdata,   sensitive = 0
  Widget_Control, bfit,    sensitive = 0
  Widget_Control, bsurf,   sensitive = 0
  Widget_Control, bbulk,   sensitive = 0
  Widget_Control, bpara,   sensitive = 0
  Widget_Control, bhelp,   sensitive = 0
  Widget_Control, bsetrod, sensitive = 0
  Widget_Control, bsetsym, sensitive = 0
  Widget_Control, bsetpar, sensitive = 0
  Widget_Control, brod,    sensitive = 0
  Widget_Control, brange,  sensitive = 0
  Widget_Control, bqrange, sensitive = 0
  Widget_Control, ball,    sensitive = 0
  Widget_Control, b2atoms, sensitive = 0
  Widget_Control, b3atoms, sensitive = 0
  Widget_Control, bleffec, sensitive = 0
  Widget_Control, brough,  sensitive = 0
  Widget_Control, blrod,   sensitive = 0
  Widget_Control, blsym,   sensitive = 0
  Widget_Control, blpar,   sensitive = 0
  Widget_Control, blbulk,  sensitive = 0
  Widget_Control, blsurf,  sensitive = 0
  Widget_Control, blsum,   sensitive = 0
  Widget_Control, blall,   sensitive = 0
  Widget_Control, bldata,  sensitive = 0
  Widget_Control, blsmodel,sensitive = 0
  Widget_Control, blbmodel,sensitive = 0
  Widget_Control, blfit,   sensitive = 0
  Widget_Control, blcomp,  sensitive = 0
  Widget_Control, blparam, sensitive = 0
  Widget_Control, blsymm,  sensitive = 0
  Widget_Control, bperror, sensitive = 0
  Widget_Control, bpbulk,  sensitive = 0
  Widget_Control, bpsurf,  sensitive = 0
  Widget_Control, bpsum,   sensitive = 0
  Widget_Control, bpall,   sensitive = 0
  Widget_Control, bpdata,  sensitive = 0
  Widget_Control, bpboth,  sensitive = 0
  Widget_Control, bpftheory, sensitive = 0
  Widget_Control, bpfdata,   sensitive = 0
  Widget_Control, bpfboth,   sensitive = 0
  Widget_Control, bpmoriginal, sensitive = 0
  Widget_Control, bpmrefined,  sensitive = 0
  Widget_Control, bpmboth,     sensitive = 0
  Widget_Control, bpmlarge,    sensitive = 0
  Widget_Control, bpdpatterson, sensitive = 0
  Widget_Control, bptpatterson, sensitive = 0
  Widget_Control, bpdifference, sensitive = 0
  Widget_Control, bpelectron,   sensitive = 0
  Widget_Control, bpexp_dens,   sensitive = 0

  IF !version.os_family EQ 'unix' THEN BEGIN
    Widget_Control, batoms,  sensitive = 0
    Widget_Control, bbug,    sensitive = 0
  ENDIF

  handler = {top:tlb, $
             filename:'rod', $
             datafile:'', $
             fitfile:'', $
             bulkfile:'', $
             surffile:'', $
             parafile:'', $
             unit_number:0, $
             string:'quit', $
             error:0, $
             status:'Starting', $
             plotID:0L, $
             helpID:0L, $
             data_read:[0,0,0], $
             secondplot:'', $
             andreplot:1, $
             perror:0}

  ptr = Ptr_New (handler)

  buffer = ['']

  bufptr = Ptr_New (buffer)

  IF !version.os_family EQ 'unix' THEN BEGIN

    info = {saveID:bsave, $
            quitID:bquit, $
            startID:bstart, $
            abortID:babort, $
            showlogID:bshowlog, $
            clrlogID:bclrlog, $
            execlogID:bexeclog, $
            loadlogID:bloadlog, $
            savelogID:bsavelog, $
            dataID:bdata, $
            fitID:bfit, $
            surfID:bsurf, $
            bulkID:bbulk, $
            paraID:bpara, $
            helpID:bhelp, $
            bugID:bbug, $
            setrodID:bsetrod, $
            setsymID:bsetsym, $
            setparID:bsetpar, $
            rodID:brod, $
            rangeID:brange, $
            qrangeID:bqrange, $
            allID:ball, $
            twoatomsID:b2atoms, $
            threeatomsID:b3atoms, $
            leffecID:bleffec, $
            roughID:brough, $
            lrodID:blrod, $
            lsymID:blsym, $
            lparID:blpar, $
            lbulkID:blbulk, $
            lsurfID:blsurf, $
            lsumID:blsum, $
            lallID:blall, $
            ldataID:bldata, $
            lsmodelID:blsmodel, $
            lbmodelID:blbmodel, $
            lfitID:blfit, $
            lcompID:blcomp, $
            lparamID:blparam, $
            lsymmID:blsymm, $
            atomsID:batoms, $
            perrorID:bperror, $
            pbulkID:bpbulk, $
            psurfID:bpsurf, $
            psumID:bpsum, $
            pallID:bpall, $
            pdataID:bpdata, $
            pbothID:bpboth, $
            pftheoryID:bpftheory, $
            pfdataID:bpfdata, $
            pfbothID:bpfboth, $
            pmoriginalID:bpmoriginal, $
            pmrefinedID:bpmrefined, $
            pmbothID:bpmboth, $
            pmlargeID:bpmlarge, $
            pdpattersonID:bpdpatterson, $
            ptpattersonID:bptpatterson, $
            pdifferenceID:bpdifference, $
            pelectronID:bpelectron, $
            pexp_densID:bpexp_dens, $
            outputID:output, $
            inputID:input, $
            ptr:ptr, $
            bufptr:bufptr}
  ENDIF ELSE BEGIN
    info = {saveID:bsave, $
            quitID:bquit, $
            startID:bstart, $
            showlogID:bshowlog, $
            clrlogID:bclrlog, $
            execlogID:bexeclog, $
            loadlogID:bloadlog, $
            savelogID:bsavelog, $
            dataID:bdata, $
            fitID:bfit, $
            surfID:bsurf, $
            bulkID:bbulk, $
            paraID:bpara, $
            helpID:bhelp, $
            setrodID:bsetrod, $
            setsymID:bsetsym, $
            setparID:bsetpar, $
            rodID:brod, $
            rangeID:brange, $
            qrangeID:bqrange, $
            allID:ball, $
            twoatomsID:b2atoms, $
            threeatomsID:b3atoms, $
            leffecID:bleffec, $
            roughID:brough, $
            lrodID:blrod, $
            lsymID:blsym, $
            lparID:blpar, $
            lbulkID:blbulk, $
            lsurfID:blsurf, $
            lsumID:blsum, $
            lallID:blall, $
            ldataID:bldata, $
            lsmodelID:blsmodel, $
            lbmodelID:blbmodel, $
            lfitID:blfit, $
            lcompID:blcomp, $
            lparamID:blparam, $
            lsymmID:blsymm, $
            perrorID:bperror, $
            pbulkID:bpbulk, $
            psurfID:bpsurf, $
            psumID:bpsum, $
            pallID:bpall, $
            pdataID:bpdata, $
            pbothID:bpboth, $
            pftheoryID:bpftheory, $
            pfdataID:bpfdata, $
            pfbothID:bpfboth, $
            pmoriginalID:bpmoriginal, $
            pmrefinedID:bpmrefined, $
            pmbothID:bpmboth, $
            pmlargeID:bpmlarge, $
            pdpattersonID:bpdpatterson, $
            ptpattersonID:bptpatterson, $
            pdifferenceID:bpdifference, $
            pelectronID:bpelectron, $
            pexp_densID:bpexp_dens, $
            outputID:output, $
            inputID:input, $
            ptr:ptr, $
            bufptr:bufptr}
  ENDELSE

  Widget_Control, Widget_Info (tlb, /Child), set_UValue=info, /no_copy
  Widget_Control, tlb, /Realize
  XManager, 'RodGUI', tlb, Event='RodGUI_Events', Group=group
  Ptr_Free, ptr
  Ptr_Free, bufptr
END
