PRO load_par, name, info
  b1data  = info.b1data
  b2data  = info.b2data
  dispdata= info.dispdata
  scale	  = info.scale
  beta	  = info.beta
  surf	  = info.surffrac
  occ1	  = info.occupancy1
  occ2	  = info.occupancy2
  comment = info.commentdata
  
  text = read_textfile(name)
  text = strtrim (text, 2)
  res = size(text)
  n_comments = 0
  i = 0
  WHILE strmid(text[i], 0, 1) EQ '!' DO BEGIN
    IF i EQ 0 THEN $
      *comment = text[i] $
    ELSE $
      *comment = [*comment, text[i]]
    n_comments = n_comments + 1
    i = i + 1
  ENDWHILE
  
  k = n_comments + 1
  lin = text[k]
  i = 0
  WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
    i = i + 1                   ;		
  WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
    i = i + 1
  blank = i
  length = 0
  FOR j = 0, 2, 1 DO BEGIN
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
      i = i + 1
      length = length + 1
    ENDWHILE
    (*scale)[j] = float(strmid(lin, blank, length))
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    blank = i
    length = 0
  ENDFOR
  (*scale)[3] = 0.0
  IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
    (*scale)[3] = 1.0
  
  k = k + 1
  lin = text[k]
  i = 0
  WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
    i = i + 1
  WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
    i = i + 1
  blank = i
  length = 0
  FOR j = 0, 2, 1 DO BEGIN
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
      i = i + 1
      length = length + 1
    ENDWHILE
    (*beta)[j] = float(strmid(lin, blank, length))
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    blank = i
    length = 0
  ENDFOR
  (*beta)[3] = 0.0
  IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
    (*beta)[3] = 1.0
  
  k = k + 1
  lin = text[k]
  blank=0
  i = 0
  WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
    i = i + 1                   ;		
  WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
    i = i + 1
  blank = i
  length = 0
  FOR j = 0, 2, 1 DO BEGIN
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
      i = i + 1
      length = length + 1
    ENDWHILE
    (*surf)[j] = float(strmid(lin, blank, length))
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    blank = i
    length = 0
  ENDFOR
  (*surf)[3] = 0.0
  IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
    (*surf)[3] = 1.0
  
  k = k + 1
  start = k
  lin = text[k]
  WHILE strmid(text[k],0,1) EQ 'd' DO k = k + 1
  rows = k - start
  
  (*dispdata) = fltarr(4, rows)
  index = 0
  FOR k = start, rows + start - 1, 1 DO BEGIN
    i = 0
    lin = text[k]
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    
    blank = i
    length = 0
    FOR j = 0, 2, 1 DO BEGIN
      WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
        i = i + 1
        length = length + 1
      ENDWHILE
      (*dispdata)[j,index] = float(strmid(lin, blank, length))
      WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
        i = i + 1
      blank = i
      length = 0
    ENDFOR
    (*dispdata)[3, index] = 0.0
    IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
      (*dispdata)[3, index] = 1.0
    index = index + 1
  ENDFOR  
  
  start = k
  lin = text[k]
  WHILE strmid(text[k],0,2) EQ 'b1' DO k = k + 1
  rows = k - start
  
  (*b1data) = fltarr(4, rows)
  index = 0
  FOR k = start, rows + start - 1, 1 DO BEGIN
    i = 0
    lin = text[k]
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    
    blank = i
    length = 0
    FOR j = 0, 2, 1 DO BEGIN
      WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
        i = i + 1
        length = length + 1
      ENDWHILE
      (*b1data)[j,index] = float(strmid(lin, blank, length))
      WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
        i = i + 1
      blank = i
      length = 0
    ENDFOR
    (*b1data)[3, index] = 0.0
    IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
      (*b1data)[3, index] = 1.0
    index = index + 1   
  ENDFOR
  
  start = k
  lin = text[k]
  WHILE strmid(text[k],0,2) EQ 'b2' DO k = k + 1
  rows = k - start
  
  (*b2data) = fltarr(4, rows)
  index = 0
  FOR k = start, rows + start - 1, 1 DO BEGIN
    i = 0
    lin = text[k]
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    
    blank = i
    length = 0
    FOR j = 0, 2, 1 DO BEGIN
      WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
        i = i + 1
        length = length + 1
      ENDWHILE
      (*b2data)[j,index] = float(strmid(lin, blank, length))
      WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
        i = i + 1
      blank = i
      length = 0
    ENDFOR
    (*b2data)[3, index] = 0.0
    IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
      (*b2data)[3, index] = 1.0
    index = index + 1   
  ENDFOR 
  
  lin = text[k]
  i = 0
  WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
    i = i + 1		
  WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
    i = i + 1
  WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
    i = i + 1		
  WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
    i = i + 1
  blank = i
  length = 0
  FOR j = 0, 2, 1 DO BEGIN
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
      i = i + 1
      length = length + 1
    ENDWHILE
    (*occ1)[j] = float(strmid(lin, blank, length))
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    blank = i
    length = 0
  ENDFOR
  (*occ1)[3] = 0.0
  IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
    (*occ1)[3] = 1.0    
  
  k = k + 1
  info.occ2 = 0
  IF n_elements(text) NE k + 1 THEN BEGIN
    info.occ2 = 1
    k = k + 1
    lin = text[k]
    blank=0
    i = 0
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1                 ;		
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO $
      i = i + 1		
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    blank = i
    length = 0
    FOR j = 0, 2, 1 DO BEGIN
      WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
        i = i + 1
        length = length + 1
      ENDWHILE
      (*occ2)[j] = float(strmid(lin, blank, length))
      WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
        i = i + 1
      blank = i
      length = 0
    ENDFOR
    (*occ2)[3] = 0.0
    IF (strmid (lin, blank, strlen(lin) - blank)) EQ 'YES' THEN $
      (*occ2)[3] = 1.0   
  ENDIF
END




PRO write_par, name, info
  b1data  = info.b1data
  b2data  = info.b2data
  dispdata= info.dispdata
  scale	  = info.scale
  beta	  = info.beta
  surf	  = info.surffrac
  occ1	  = info.occupancy1
  occ2	  = info.occupancy2
  comment = info.commentdata
  
  Widget_Control, info.b1ID, Set_Table_Select=[-1,-1,-1,-1]
  Widget_Control, info.b1ID, get_Value=*b1data
  Widget_Control, info.b2ID, Set_Table_Select=[-1,-1,-1,-1]
  Widget_Control, info.b2ID, get_Value=*b2data
  Widget_Control, info.dispID, Set_Table_Select=[-1,-1,-1,-1]
  Widget_Control, info.dispID, get_Value=*dispdata
  
  Widget_Control, info.scale1ID, get_Value = res
  (*scale)[0] = (float(res))[0] 
  Widget_Control, info.scale2ID, get_Value = res
  (*scale)[1] = (float(res))[0] 
  Widget_Control, info.scale3ID, get_Value = res
  (*scale)[2] = (float(res))[0] 
  Widget_Control, info.scale4ID, get_Value = res
  (*scale)[3] = (float(res))[0] 
  Widget_Control, info.beta1ID, get_Value = res
  (*beta)[0] = (float(res))[0] 
  Widget_Control, info.beta2ID, get_Value = res
  (*beta)[1] = (float(res))[0] 
  Widget_Control, info.beta3ID, get_Value = res
  (*beta)[2] = (float(res))[0] 
  Widget_Control, info.beta4ID, get_Value = res
  (*beta)[3] = (float(res))[0] 
  Widget_Control, info.surf1ID, get_Value = res
  (*surf)[0] = (float(res))[0] 
  Widget_Control, info.surf2ID, get_Value = res
  (*surf)[1] = (float(res))[0] 
  Widget_Control, info.surf3ID, get_Value = res
  (*surf)[2] = (float(res))[0] 
  Widget_Control, info.surf4ID, get_Value = res
  (*surf)[3] = (float(res))[0] 
  Widget_Control, info.occ11ID, get_Value = res
  (*occ1)[0] = (float(res))[0] 
  Widget_Control, info.occ12ID, get_Value = res
  (*occ1)[1] = (float(res))[0] 
  Widget_Control, info.occ13ID, get_Value = res
  (*occ1)[2] = (float(res))[0] 
  Widget_Control, info.occ14ID, get_Value = res
  (*occ1)[3] = (float(res))[0] 
  IF info.occ2 EQ 1 THEN BEGIN
    Widget_Control, info.occ21ID, get_Value = res
    (*occ2)[0] = (float(res))[0] 
    Widget_Control, info.occ22ID, get_Value = res
    (*occ2)[1] = (float(res))[0] 
    Widget_Control, info.occ23ID, get_Value = res
    (*occ2)[2] = (float(res))[0] 
    Widget_Control, info.occ24ID, get_Value = res
    (*occ2)[3] = (float(res))[0] 
  ENDIF 
  
  openw, a_unit, name, /get_lun
  lines = n_elements (*comment)
  FOR i = 0, lines - 1, 1 DO $
    printf, a_unit, (*comment)[i]
  printf, a_unit, 'set par'
  
  string = 'NO'
  IF (*scale)[3] NE 0.0 THEN string = 'YES'
  printf, a_unit, format = '("scale          ",F7.4," ",F7.4," ",F7.4," ",A0)', $
    (*scale)[0], (*scale)[1], (*scale)[2], string
  
  string = 'NO'
  IF (*beta)[3] NE 0.0 THEN string = 'YES'
  printf, a_unit, format = '("beta           ",F7.4," ",F7.4," ",F7.4," ",A0)', $
    (*beta)[0], (*beta)[1], (*beta)[2], string
  
  string = 'NO'
  IF (*scale)[3] NE 0.0 THEN string = 'YES'
  printf, a_unit, format = '("surffrac       ",F7.4," ",F7.4," ",F7.4," ",A0)', $
    (*surf)[0], (*surf)[1], (*surf)[2], string
  
  res = size(*dispdata)
  FOR i = 0, res[2] - 1, 1 DO BEGIN
    string = 'NO'
    IF (*dispdata)[3,i] NE 0.0 THEN string = 'YES'
    printf, a_unit, format = '("displace    ",I2," ",F7.4," ",F7.4," ",F7.4," ",A0)', $
      i + 1, (*dispdata)[0,i], (*dispdata)[1,i], (*dispdata)[2,i], string
  ENDFOR
  
  res = size(*b1data)
  FOR i = 0, res[2] - 1, 1 DO BEGIN
    string = 'NO'
    IF (*b1data)[3,i] NE 0.0 THEN string = 'YES'
    printf, a_unit, format = '("b1          ",I2," ",F7.4," ",F7.4," ",F7.4," ",A0)', $
      i + 1, (*b1data)[0,i], (*b1data)[1,i], (*b1data)[2,i], string
  ENDFOR
  
  res = size(*b2data)
  FOR i = 0, res[2] - 1, 1 DO BEGIN
    string = 'NO'
    IF (*b2data)[3,i] NE 0.0 THEN string = 'YES'
    printf, a_unit, format = '("b2          ",I2," ",F7.4," ",F7.4," ",F7.4," ",A0)', $
      i + 1, (*b2data)[0,i], (*b2data)[1,i], (*b2data)[2,i], string
  ENDFOR
  
  string = 'NO'
  IF (*occ1)[3] NE 0.0 THEN string = 'YES'   
  printf, a_unit, format = '("occupancy    1 ",F7.4," ",F7.4," ",F7.4," ",A0)', $
    (*occ1)[0], (*occ1)[1], (*occ1)[2], string
  
  IF info.occ2 EQ 1 THEN BEGIN
    string = 'NO'
    IF (*occ2)[3] NE 0.0 THEN string = 'YES'   
    printf, a_unit, format = '("occupancy    2 ",F7.4," ",F7.4," ",F7.4," ",A0)', $
      (*occ2)[0], (*occ2)[1], (*occ2)[2], string
  ENDIF
  
  printf, a_unit, 'return return'
  close, a_unit  
END





PRO Par_Editor_Events, event
  infoID = Widget_Info (event.top, /Child)
  Widget_Control, infoID, get_UValue=info, /no_copy
  Widget_Control, event.id, get_uvalue=value
  b1data  = info.b1data
  b2data  = info.b2data
  dispdata= info.dispdata
  scale	  = info.scale
  beta	  = info.beta
  surf	  = info.surffrac
  occ1	  = info.occupancy1
  occ2	  = info.occupancy2
  comment = info.commentdata
  handler = info.ptr

  CASE value OF
    'LOAD' : BEGIN
      filename = dialog_Pickfile (/Read, $
                                  filter = '*.par', /noconfirm, /must_exist)
      IF filename NE '' THEN BEGIN
        Widget_Control, event.top, TLB_Set_Title= 'PARAMETERS Files Editor - ' + filename
        (*handler).filename = filename
        info.loaded = 1
        load_par, strtrim(filename, 2), info
        
        res = size(*b1data)
        Widget_Control, info.b1ID, table_Ysize = res[2]
        Widget_Control, info.b1ID, set_Value = *b1data, Use_Table_Select = [0,0,4,res[1]-1]
        
        res = size(*b2data)
        Widget_Control, info.b2ID, table_Ysize = res[2]
        Widget_Control, info.b2ID, set_Value = *b2data, Use_Table_Select = [0,0,4,res[1]-1]
        
        res = size(*dispdata)
        Widget_Control, info.dispID, table_Ysize = res[2]
        Widget_Control, info.dispID, set_Value = *dispdata, Use_Table_Select = [0,0,4,res[1]-1]

        Widget_Control, info.scale1ID, 	set_Value = strtrim(string((*scale)[0]),2)
        Widget_Control, info.scale2ID, 	set_Value = strtrim(string((*scale)[1]),2)
        Widget_Control, info.scale3ID, 	set_Value = strtrim(string((*scale)[2]),2)
        Widget_Control, info.scale4ID, 	set_Value = strtrim(string((*scale)[3]),2)
        
        Widget_Control, info.beta1ID, 	set_Value = strtrim(string((*beta)[0]),2)
        Widget_Control, info.beta2ID, 	set_Value = strtrim(string((*beta)[1]),2)
        Widget_Control, info.beta3ID, 	set_Value = strtrim(string((*beta)[2]),2)
        Widget_Control, info.beta4ID, 	set_Value = strtrim(string((*beta)[3]),2)
        
        Widget_Control, info.surf1ID, 	set_Value = strtrim(string((*surf)[0]),2)
        Widget_Control, info.surf2ID, 	set_Value = strtrim(string((*surf)[1]),2)
        Widget_Control, info.surf3ID, 	set_Value = strtrim(string((*surf)[2]),2)
        Widget_Control, info.surf4ID, 	set_Value = strtrim(string((*surf)[3]),2)
        
        Widget_Control, info.occ11ID, 	set_Value = strtrim(string((*occ1)[0]),2)
        Widget_Control, info.occ12ID, 	set_Value = strtrim(string((*occ1)[1]),2)
        Widget_Control, info.occ13ID, 	set_Value = strtrim(string((*occ1)[2]),2)
        Widget_Control, info.occ14ID, 	set_Value = strtrim(string((*occ1)[3]),2)
        
        IF info.occ2 EQ 1 THEN BEGIN
          Widget_Control, info.occ21ID, 	set_Value = strtrim(string((*occ2)[0]),2)
          Widget_Control, info.occ22ID, 	set_Value = strtrim(string((*occ2)[1]),2)
          Widget_Control, info.occ23ID, 	set_Value = strtrim(string((*occ2)[2]),2)
          Widget_Control, info.occ24ID, 	set_Value = strtrim(string((*occ2)[3]),2)
        ENDIF ELSE BEGIN
          Widget_Control, info.occ21ID, 	set_Value = '---'
          Widget_Control, info.occ22ID, 	set_Value = '---'
          Widget_Control, info.occ23ID, 	set_Value = '---'
          Widget_Control, info.occ24ID, 	set_Value = '---' 
        ENDELSE
         
        Widget_Control, info.scale1ID, /Editable
        Widget_Control, info.scale2ID, /Editable
        Widget_Control, info.scale3ID, /Editable
        Widget_Control, info.scale4ID, /Editable
        
        Widget_Control, info.beta1ID, /Editable
        Widget_Control, info.beta2ID, /Editable
        Widget_Control, info.beta3ID, /Editable
        Widget_Control, info.beta4ID, /Editable
        
        Widget_Control, info.surf1ID, /Editable
        Widget_Control, info.surf2ID, /Editable
        Widget_Control, info.surf3ID, /Editable
        Widget_Control, info.surf4ID, /Editable
        
        Widget_Control, info.occ11ID, /Editable
        Widget_Control, info.occ12ID, /Editable
        Widget_Control, info.occ13ID, /Editable
        Widget_Control, info.occ14ID, /Editable
        
        IF info.occ2 EQ 1 THEN BEGIN
          Widget_Control, info.occ21ID, /Editable
          Widget_Control, info.occ22ID, /Editable
          Widget_Control, info.occ23ID, /Editable
          Widget_Control, info.occ24ID, /Editable
        ENDIF
        
        Widget_Control, info.commentID, set_Value = *comment
        Widget_Control, info.commentID,	/Editable
        Widget_Control, info.saveID,   	Sensitive = 1
        Widget_Control, info.saveasID, 	Sensitive = 1
        Widget_Control, info.origID, 	Sensitive = 1
     ENDIF
    END
    
    'SAVE' : BEGIN
      write_par, (*handler).filename, info
    END
    
    'SAVEAS' : BEGIN
      filename = dialog_Pickfile (/Write, $
                                  filter = '*.par', /fix_filter)
      IF filename NE '' THEN BEGIN
        Widget_Control, event.top, TLB_Set_Title= 'PARAMETERS Files Editor - ' + filename
        (*handler).filename = filename
        
        write_par, (*handler).filename, info
      ENDIF
    END	
    
    'QUIT' : BEGIN
      Ptr_Free, info.b1data
      Ptr_Free, info.b2data
      Ptr_Free, info.dispdata
      Ptr_Free, info.scale
      Ptr_Free, info.beta
      Ptr_Free, info.surffrac
      Ptr_Free, info.occupancy1
      Ptr_Free, info.occupancy2
      Ptr_Free, info.commentdata
      Widget_Control, event.top, /Destroy
    END
    
    'PAR' : BEGIN
      xdisplayfile, (*handler).filename, width=90, group=event.top
    END
    
    ELSE :
  ENDCASE
  
  IF Widget_Info (event.top, /valid_ID) THEN BEGIN
    infoID = Widget_Info (event.top, /Child)
    Widget_Control, infoID, set_UValue=info, /no_copy
  ENDIF
END




PRO par_editor, Group=group
  tlb   = Widget_Base (title = 'PARAMETERS Files Editor', $
                       column = 1, base_align_left = 1, MBar = MenuBar, $
                       TLB_Frame_Attr = 1)
  infos = Widget_Base (tlb)
  
  FileMenu   = WIDGET_BUTTON(MenuBar,   VALUE='File', 	/MENU)
  bload      = WIDGET_BUTTON(FileMenu,  VALUE='Load Parameters File', 	UValue='LOAD')
  bsave      = WIDGET_BUTTON(FileMenu, 	VALUE='Save', 			UValue='SAVE')
  bsaveas    = WIDGET_BUTTON(FileMenu, 	VALUE='Save as ...', 		UValue='SAVEAS')
  bquit      = WIDGET_BUTTON(FileMenu, 	VALUE='Quit', 			UValue='QUIT', /Separator)
  WindowMenu = WIDGET_BUTTON(MenuBar, 	VALUE='Window',	/MENU)
  borig      = WIDGET_BUTTON(WindowMenu,VALUE='Show Parameters File',	UValue='PAR')
  
  upper = Widget_Base (tlb, row=1)
  
  disp_base = Widget_Base (upper, column = 1)
  dispt  = Widget_Label (disp_base, value = 'Displacement:')
  
  disp = Widget_Table (disp_base, xsize=4, y_scroll_size=9, column_widths=[70,70,70,70], $
                       /Editable, /All_Events, /Scroll, UValue='Table', $ 
                       column_labels=['X', 'Y', 'Z', 'si'], format='(F7.4)')
  
  extra_base = Widget_Base (upper, column = 1)
  extrat = Widget_Label (extra_base, value = 'Extra parameters:')
  
  scale_base = Widget_Base (extra_base, row=1)
  scalet = Widget_Label (scale_base, scr_xsize=100, scr_ysize=10, value = 'Scale factor:')
  
  scale1b = Widget_Base  (scale_base, column=1)
  scale1t = Widget_Label (scale1b, scr_ysize=10, value='First')
  scale1e = Widget_Text  (scale1b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                          xsize=8, value='')
  
  scale2b = Widget_Base  (scale_base, column=1)
  scale2t = Widget_Label (scale2b, scr_ysize=10, value='Second')
  scale2e = Widget_Text  (scale2b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                          xsize=8, value='')
  
  scale3b = Widget_Base  (scale_base, column=1)
  scale3t = Widget_Label (scale3b, scr_ysize=10, value='Third')
  scale3e = Widget_Text  (scale3b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                          xsize=8, value='')
  
  scale4b = Widget_Base  (scale_base, column=1)
  scale4t = Widget_Label (scale4b, scr_ysize=10, value='Fourth')
  scale4e = Widget_Text  (scale4b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                          xsize=8, value='')
  
  beta_base = Widget_Base (extra_base, row=1)
  betat = Widget_Label (beta_base, scr_xsize=100, scr_ysize=10, value = 'Beta parameter:')
  
  beta1b = Widget_Base  (beta_base, column=1)
  beta1t = Widget_Label (beta1b, scr_ysize=10, value='First')
  beta1e = Widget_Text  (beta1b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                         xsize=8, value='')
  
  beta2b = Widget_Base  (beta_base, column=1)
  beta2t = Widget_Label (beta2b, scr_ysize=10, value='Second')
  beta2e = Widget_Text  (beta2b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                         xsize=8, value='')
  
  beta3b = Widget_Base  (beta_base, column=1)
  beta3t = Widget_Label (beta3b, scr_ysize=10, value='Third')
  beta3e = Widget_Text  (beta3b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                         xsize=8, value='')
  
  beta4b = Widget_Base  (beta_base, column=1)
  beta4t = Widget_Label (beta4b, scr_ysize=10, value='Fourth')
  beta4e = Widget_Text  (beta4b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                         xsize=8, value='')
  
  surffrac_base = Widget_Base (extra_base, row=1)
  surffract = Widget_Label (surffrac_base, scr_xsize=100, scr_ysize=10, value = 'Surface fraction:')
  
  surffrac1b = Widget_Base  (surffrac_base, column=1)
  surffrac1t = Widget_Label (surffrac1b, scr_ysize=10, value='First')
  surffrac1e = Widget_Text  (surffrac1b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                             xsize=8, value='')
  
  surffrac2b = Widget_Base  (surffrac_base, column=1)
  surffrac2t = Widget_Label (surffrac2b, scr_ysize=10, value='Second')
  surffrac2e = Widget_Text  (surffrac2b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                             xsize=8, value='')
  
  surffrac3b = Widget_Base  (surffrac_base, column=1)
  surffrac3t = Widget_Label (surffrac3b, scr_ysize=10, value='Third')
  surffrac3e = Widget_Text  (surffrac3b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                             xsize=8, value='')
  
  surffrac4b = Widget_Base  (surffrac_base, column=1)
  surffrac4t = Widget_Label (surffrac4b, scr_ysize=10, value='Fourth')
  surffrac4e = Widget_Text  (surffrac4b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                             xsize=8, value='')
  
  occupancy1_base = Widget_Base (extra_base, row=1)
  occupancy1t = Widget_Label (occupancy1_base, scr_xsize=100, scr_ysize=10, value = 'Occupancy 1:')
  
  occupancy11b = Widget_Base  (occupancy1_base, column=1)
  occupancy11t = Widget_Label (occupancy11b, scr_ysize=10, value='First')
  occupancy11e = Widget_Text  (occupancy11b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  occupancy12b = Widget_Base  (occupancy1_base, column=1)
  occupancy12t = Widget_Label (occupancy12b, scr_ysize=10, value='Second')
  occupancy12e = Widget_Text  (occupancy12b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  occupancy13b = Widget_Base  (occupancy1_base, column=1)
  occupancy13t = Widget_Label (occupancy13b, scr_ysize=10, value='Third')
  occupancy13e = Widget_Text  (occupancy13b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  occupancy14b = Widget_Base  (occupancy1_base, column=1)
  occupancy14t = Widget_Label (occupancy14b, scr_ysize=10, value='Fourth')
  occupancy14e = Widget_Text  (occupancy14b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  occupancy2_base = Widget_Base (extra_base, row=1)
  occupancy2t = Widget_Label (occupancy2_base, scr_xsize=100, scr_ysize=10, value = 'Occupancy 2:')
  
  occupancy21b = Widget_Base  (occupancy2_base, column=1)
  occupancy21t = Widget_Label (occupancy21b, scr_ysize=10, value='First')
  occupancy21e = Widget_Text  (occupancy21b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  occupancy22b = Widget_Base  (occupancy2_base, column=1)
  occupancy22t = Widget_Label (occupancy22b, scr_ysize=10, value='Second')
  occupancy22e = Widget_Text  (occupancy22b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  occupancy23b = Widget_Base  (occupancy2_base, column=1)
  occupancy23t = Widget_Label (occupancy23b, scr_ysize=10, value='Third')
  occupancy23e = Widget_Text  (occupancy23b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  occupancy24b = Widget_Base  (occupancy2_base, column=1)
  occupancy24t = Widget_Label (occupancy24b, scr_ysize=10, value='Fourth')
  occupancy24e = Widget_Text  (occupancy24b, All_Events=1, Editable=0, Event_Pro='Float_Only', $
                               xsize=8, value='')
  
  lower = Widget_Base (tlb, row=1)
  
  b1_base = Widget_Base (lower, column = 1)
  b1t = Widget_Label (b1_base, value = 'B1:')
  b1  = Widget_Table (b1_base, xsize=4, y_scroll_size=6, column_widths=[80,80,80,80], $
                      /Editable, /All_Events, /Scroll, UValue='Table', $ 
                      column_labels=['X', 'Y', 'Z', 'si'], format='(F7.4)')
  
  b2_base = Widget_Base (lower, column = 1)
  b2t = Widget_Label (b2_base, value = 'B2:')
  b2  = Widget_Table (b2_base, xsize=4, y_scroll_size=6, column_widths=[80,80,80,80], $
                      /Editable, /All_Events, /Scroll, UValue='Table', $ 
                      column_labels=['X', 'Y', 'Z', 'si'], format='(F7.4)')
  
  commentt    = Widget_Label  (tlb, value = 'Comment:')
  comment     = Widget_Text   (tlb, xsize = 103, ysize = 2, UValue='COMMENT', /scroll)
  
  handler = {filename:'rod', $
             topaste :	-1, $
             left	:	-1, $
             top	:	-1, $
             right	:	-1, $
             bottom	:	-1}
  
  ptr = Ptr_New (handler)
  
  b1data = 0
  b1ptr = Ptr_New (b1data)
  
  b2data = 0
  b2ptr = Ptr_New (b2data)
  
  dispdata = 0
  dispptr = Ptr_New (dispdata)
  
  scale    = [0.0, 0.0, 0.0, 0.0]
  scaleptr = Ptr_New (scale)
  
  beta    = [0.0, 0.0, 0.0, 0.0]
  betaptr = Ptr_New (beta)
  
  surffrac   = [0.0, 0.0, 0.0, 0.0]
  surffracptr = Ptr_New (surffrac)
  
  occupancy1    = [0.0, 0.0, 0.0, 0.0]
  occupancy1ptr = Ptr_New (occupancy1)
  
  occupancy2    = [0.0, 0.0, 0.0, 0.0]
  occupancy2ptr = Ptr_New (occupancy2)
  
  commentdata = 0
  commentptr = Ptr_New (commentdata)
  
  info = {loadID:bload, $
          saveID:bsave, $
          saveasID:bsaveas, $
          origID:borig, $
          b1ID:b1, $
          b2ID:b2, $
          dispID:disp, $
          scale1ID:scale1e, $
          scale2ID:scale2e, $
          scale3ID:scale3e, $
          scale4ID:scale4e, $
          beta1ID:beta1e, $
          beta2ID:beta2e, $
          beta3ID:beta3e, $
          beta4ID:beta4e, $
          surf1ID:surffrac1e, $
          surf2ID:surffrac2e, $
          surf3ID:surffrac3e, $
          surf4ID:surffrac4e, $
          occ11ID:occupancy11e, $
          occ12ID:occupancy12e, $
          occ13ID:occupancy13e, $
          occ14ID:occupancy14e, $
          occ21ID:occupancy21e, $
          occ22ID:occupancy22e, $
          occ23ID:occupancy23e, $
          occ24ID:occupancy24e, $
          commentID:comment, $
          b1data:b1ptr, $
          b2data:b2ptr, $
          dispdata:dispptr, $
          scale:scaleptr, $
          beta:betaptr, $
          surffrac:surffracptr, $
          occupancy1:occupancy1ptr, $
          occupancy2:occupancy2ptr, $
          commentdata:commentptr, $
          ptr:ptr, $
          occ2:0, $
          loaded:0}
  
  Widget_Control, bsave,   Sensitive = 0
  Widget_Control, bsaveas, Sensitive = 0
  Widget_Control, borig,   Sensitive = 0
  
  Widget_Control, Widget_Info (tlb, /Child), set_UValue=info, /no_copy
  Widget_Control, tlb, /Realize
  XManager, 'Par_Editor', tlb, Event='Par_Editor_Events', Group_leader=group, /No_Block
END
