Function One_of, a_, b_, c_, d_, e_, f_, g_, h_, value = val

;+
; NAME:
;	ONE_OF
; PURPOSE:
;	Called with up to 8 variables A_ through H_ , ONE_OF checks which 
;	variable is defined (only one is supposed to be).
; CATEGORY:
;	Programming.
; CALLING SEQUENCE:
;	Result = ONE_OF( A_ [,B_, ... H_] [, VALUE = VAL])
; INPUTS:
;    A_ through H_
;	Arbitrary, all are optional.
; OPTIONAL INPUT PARAMETERS:
;	See above.
; KEYWORD PARAMETERS:
;    VALUE
;	Optional output, see below.
; OUTPUTS:
;	Returns the serial number (range 0 through 7) of the defined variable,
;	or -1 if none is defined.  If more than one variable is defined, ONE_OF
;	issues an error message and returns to the main level.
; OPTIONAL OUTPUT PARAMETERS:
;    VALUE
;	The name of the variable to receive the value of the single defined
;	variable, or a null string if none is defined.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	Currently ONE_OF is restricted to a maximum of 8 variables.  If needed,
;	the number can be increased.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	Created 15-JUL-1991 by Mati Meron.
;	Modified 30-JUL-1991 by Mati Meron.  The dependence of the original 
;	code on the EXECUTE system routine has been eliminated in order to 
;	assure compatibility with the OUTPUT routine.
;-

    on_error, 1
    count = 0
    exnum = -1
    val = ''

    if n_elements(a_) ne 0 then begin
	count = 1
	exnum = 0
	val = a_
    endif
    if n_elements(b_) ne 0 then begin
	if count eq 1 then goto, too_many
	count = 1
	exnum = 1
	val = b_
    endif
    if n_elements(c_) ne 0 then begin
	if count eq 1 then goto, too_many
	count = 1
	exnum = 2
	val = c_
    endif
    if n_elements(d_) ne 0 then begin
	if count eq 1 then goto, too_many
	count = 1
	exnum = 3
	val = d_
    endif
    if n_elements(e_) ne 0 then begin
	if count eq 1 then goto, too_many
	count = 1
	exnum = 4
	val = e_
    endif
    if n_elements(f_) ne 0 then begin
	if count eq 1 then goto, too_many
	count = 1
	exnum = 5
	val = f_
    endif
    if n_elements(g_) ne 0 then begin
	if count eq 1 then goto, too_many
	count = 1
	exnum = 6
	val = g_
    endif
    if n_elements(h_) ne 0 then begin
	if count eq 1 then goto, too_many
	count = 1
	exnum = 7
	val = h_
    endif
    return, exnum

    too_many:
    val = ''
    message, 'Only one variable may be defined!'

end
