;-------------------------------------------------------------- 
; HELPGUI_EVENTS
;--------------------------------------------------------------

PRO HelpGUI_Events, event
infoID = Widget_Info (event.top, /Child)
Widget_Control, infoID, get_UValue=info, /no_copy
Widget_Control, event.id, get_uvalue=value

CASE value OF
'RESIZE' : 	BEGIN
			Widget_Control, info.outputID, scr_xsize=event.x-38, scr_ysize=event.y-66
		END

'QUIT' :	BEGIN
			Widget_Control, event.top, /Destroy
		END
ELSE :
ENDCASE
IF Widget_Info (event.top, /valid_ID) THEN BEGIN
	infoID = Widget_Info (event.top, /Child)
	Widget_Control, infoID, set_UValue=info, /no_copy
ENDIF
END




;-------------------------------------------------------------- 
; HELPGUI
;--------------------------------------------------------------
;
; handler : pointer to data from the RodGUI. The ID of the toplevelbase
;	from this widget will be stored there.
;
; data : array of strings to be displayed in the output window

PRO HelpGUI, handler, data, Group = group
tlb   = Widget_Base (title = 'RodGUI Text Window', $
	    column = 1, TLB_SIZE_EVENTS = 1, UValue = 'RESIZE')
infos = Widget_Base (tlb)
output     = Widget_Text   (tlb, xsize = 80, ysize = 20, /scroll)
bquit	   = Widget_Button (tlb, Value='Quit', UValue='QUIT')

(*handler).helpID = tlb
info = {outputID:output}
Widget_Control, Widget_Info (tlb, /Child), set_UValue=info, /no_copy
Widget_Control, tlb, /Realize, xoffset=50, yoffset=50
Widget_Control, output, set_Value = data
XManager, 'HelpGUI', tlb, Event='HelpGUI_Events', Group_Leader = group
END
