; Writes down the values of one single to a string array
;
PRO fit_get_values, text, values, number
  blank=0
  length=0
  i=0
  text = strtrim(text,2) 
  values = sindgen (number)
  FOR j = 0, number - 2, 1 DO BEGIN
    WHILE (strmid(text, i, 1) NE ' ') DO BEGIN
      i = i + 1
      length = length + 1
    ENDWHILE
    values[j] = strmid (text, blank, length)
    WHILE (strmid (text, i, 1) EQ ' ') DO $
      i = i + 1
    blank = i
    length = 0
  ENDFOR
  values[number-1] = strmid (text, blank, strlen(text) - blank)
END




; Fills the datastrct structure with with the corresponding
; values of every single row.
;
PRO fit_fill_values, datastrct, text, counter, info
  k = 0
  res =  size(text)
  
  IF info.occ2 EQ 1 THEN BEGIN
    FOR i = res[1] - counter, res[1] - 1, 1 DO BEGIN
      fit_get_values, text[i], values, 20
      datastrct.data[k] = {value, values[0], $
                           float(values[1]), $
                           float(values[2]), $
                           fix(values[3]), $
                           float(values[4]), $
                           fix(values[5]), $
                           float(values[6]), $
                           float(values[7]), $
                           fix(values[8]), $
                           float(values[9]), $
                           fix(values[10]), $
                           float(values[11]), $
                           float(values[12]), $
                           fix(values[13]), $
                           float(values[14]), $
                           fix(values[15]), $
                           fix(values[16]), $
                           fix(values[17]), $
                           fix(values[18]), $
                           fix(values[19])}
      k = k + 1
    ENDFOR
  ENDIF ELSE BEGIN
    FOR i = res[1] - counter, res[1] - 1, 1 DO BEGIN
      fit_get_values, text[i], values, 19
      datastrct.data[k] = {value, values[0], $
                           float(values[1]), $
                           float(values[2]), $
                           fix(values[3]), $
                           float(values[4]), $
                           fix(values[5]), $
                           float(values[6]), $
                           float(values[7]), $
                           fix(values[8]), $
                           float(values[9]), $
                           fix(values[10]), $
                           float(values[11]), $
                           float(values[12]), $
                           fix(values[13]), $
                           float(values[14]), $
                           fix(values[15]), $
                           fix(values[16]), $
                           fix(values[17]), $
                           fix(values[18])}
      k = k + 1
    ENDFOR
  ENDELSE
END




PRO fit_check_occ2, text, number_of_values
  i = 0
  text = strtrim(text, 2)
  WHILE (text[i] EQ '#') DO i = i + 1
  res = text[i]
  i = 0
  number_of_values = 0
  WHILE i LT strlen(res) DO BEGIN
    WHILE (strmid(res, i, 1) NE ' ') AND (i LT strlen(res)) DO BEGIN
      i = i + 1
    ENDWHILE
    WHILE (strmid(res, i, 1) EQ ' ') AND (i LT strlen(res)) DO BEGIN
      i = i + 1
    ENDWHILE
    number_of_values = number_of_values + 1
  ENDWHILE
END




; Reads the fit file and looks for comment lines
; and the six initial values for a, b, c, ...
;
PRO read_fit, name, datastrct, text, counter
  comment = datastrct.commentptr
  
  text = read_textfile (name)
  n_lines = n_elements(text)
  n_comments = 0
  i = 0
  WHILE strmid(text[i], 0, 1) EQ '#' DO BEGIN
    IF i EQ 0 THEN $
      *comment = text[i] $
    ELSE $
      *comment = [*comment, text[i]]
    n_comments = n_comments + 1
    i = i + 1
  ENDWHILE
  
  fit_get_values, text[i], values, 6
  datastrct.a     = float(values[0])
  datastrct.b     = float(values[1])
  datastrct.c     = float(values[2])
  datastrct.alpha = float(values[3])
  datastrct.beta  = float(values[4])
  datastrct.gamma = float(values[5])
  
  counter = n_lines - i - 1
END




; Writes the content of the datastrct structure to a file.
;
PRO write_fit, name, datastrct, info
  comment = datastrct.comment
  
  openw, a_unit, name, /get_lun
  
  lines = n_elements (comment)
  FOR i = 0, lines - 1, 1 DO $
    printf, a_unit, (comment)[i]
  
  printf, a_unit, format = '(F8.4, " ", F8.4, " ", F8.4, " ", F8.4, " ", F8.4, " ", F8.4)', $
    datastrct.a, datastrct.b, datastrct.c, $
    datastrct.alpha, datastrct.beta, datastrct.gamma
  
  res = size (datastrct.data)
  IF info.occ2 EQ 1 THEN BEGIN
    FOR i = 0, res[1] - 1, 1 DO BEGIN
      printf, a_unit, format = '(A0," ",F7.5," ",F7.5," ",I0," ",F7.5," ",I0," ",F7.5," ",F7.5," ",I0," ",F7.5," ",I0," ",F7.5," ",F7.5," ",I0," ",F7.5," ",I0, " ", I0, " ", I0, " ", I0, " ", I0)', datastrct.data[i].a, $
        datastrct.data[i].x, datastrct.data[i].x1, datastrct.data[i].x2, datastrct.data[i].x3, datastrct.data[i].x4, $
        datastrct.data[i].y, datastrct.data[i].y1, datastrct.data[i].y2, datastrct.data[i].y3, datastrct.data[i].y4, $
        datastrct.data[i].z, datastrct.data[i].z1, datastrct.data[i].z2, datastrct.data[i].z3, datastrct.data[i].z4, $
        datastrct.data[i].s1, datastrct.data[i].s2, datastrct.data[i].s3, datastrct.data[i].s4
    ENDFOR
  ENDIF ELSE BEGIN
    FOR i = 0, res[1] - 1, 1 DO BEGIN
      printf, a_unit, format = '(A0," ",F7.5," ",F7.5," ",I0," ",F7.5," ",I0," ",F7.5," ",F7.5," ",I0," ",F7.5," ",I0," ",F7.5," ",F7.5," ",I0," ",F7.5," ",I0, " ", I0, " ", I0, " ", I0)', datastrct.data[i].a, $
        datastrct.data[i].x, datastrct.data[i].x1, datastrct.data[i].x2, datastrct.data[i].x3, datastrct.data[i].x4, $
        datastrct.data[i].y, datastrct.data[i].y1, datastrct.data[i].y2, datastrct.data[i].y3, datastrct.data[i].y4, $
        datastrct.data[i].z, datastrct.data[i].z1, datastrct.data[i].z2, datastrct.data[i].z3, datastrct.data[i].z4, $
        datastrct.data[i].s1, datastrct.data[i].s2, datastrct.data[i].s3
    ENDFOR
  ENDELSE
  close, a_unit
END




; Loads the fit file and builds a datastructure to 
; hold every data entry of the fit file.
;
PRO load_fit, name, datastrct, info
  comment = ['']
  commentptr = Ptr_New (comment)
  
  datastrct = {commentptr : commentptr, $
               a       : 0.0, $
               b       : 0.0, $
               c       : 0.0, $
               alpha   : 0.0, $
               beta    : 0.0, $
               gamma   : 0.0}
  
  text = ''
  read_fit, name, datastrct, text, counter
  fit_check_occ2, name, info.occ2
  
  IF info.occ2 EQ 1 THEN BEGIN
    data = replicate ({value, a : '', $
                       x  : 0.0, $
                       x1 : 0.0, $
                       x2 : 0, $
                       x3 : 0.0, $
                       x4 : 0, $
                       y  : 0.0, $
                       y1 : 0.0, $
                       y2 : 0, $
                       y3 : 0.0, $
                       y4 : 0, $
                       z  : 0.0, $
                       z1 : 0.0, $
                       z2 : 0, $
                       z3 : 0.0, $
                       z4 : 0, $
                       s1 : 0, $ 
                       s2 : 0, $
                       s3 : 0, $
                       s4 : 0}, counter)
  END ELSE BEGIN
    data = replicate ({value, a : '', $
                       x  : 0.0, $
                       x1 : 0.0, $
                       x2 : 0, $
                       x3 : 0.0, $
                       x4 : 0, $
                       y  : 0.0, $
                       y1 : 0.0, $
                       y2 : 0, $
                       y3 : 0.0, $
                       y4 : 0, $
                       z  : 0.0, $
                       z1 : 0.0, $
                       z2 : 0, $
                       z3 : 0.0, $
                       z4 : 0, $
                       s1 : 0, $ 
                       s2 : 0, $
                       s3 : 0}, counter)
  ENDELSE
  
  datastrct = {comment : *commentptr, $
               a       : datastrct.a, $
               b       : datastrct.b, $
               c       : datastrct.c, $
               alpha   : datastrct.alpha, $
               beta    : datastrct.beta, $
               gamma   : datastrct.gamma, $
               data    : data}
  
  fit_fill_values, datastrct, text, counter, info
  Ptr_Free, commentptr
END




PRO fit_update_data, struc, table, rowlabels, info
  res = size(*table)
  FOR i = 0, res[2] - 1, 1 DO BEGIN
    (*struc).data[i].a = (*rowlabels)[i]
    (*struc).data[i].x = (*table)[0,i]
    (*struc).data[i].y = (*table)[1,i]
    (*struc).data[i].z = (*table)[2,i]
  ENDFOR
  
  Widget_Control, info.aID, get_Value = res
  (*struc).a = (float(res))[0]
  Widget_Control, info.bID, get_Value = res
  (*struc).b = (float(res))[0]
  Widget_Control, info.cID, get_Value = res
  (*struc).c = (float(res))[0]
  Widget_Control, info.alphaID, get_Value = res
  (*struc).alpha = (float(res))[0]
  Widget_Control, info.betaID, get_Value = res
  (*struc).beta = (float(res))[0]
  Widget_Control, info.gammaID, get_Value = res
  (*struc).gamma = (float(res))[0]
  Widget_Control, info.comment, get_Value = res
  
  *struc = {comment : res, $
            a       : (*struc).a, $
            b       : (*struc).b, $
            c       : (*struc).c, $	
            alpha   : (*struc).alpha, $
            beta    : (*struc).beta, $
            gamma   : (*struc).gamma, $
            data    : (*struc).data}
END




PRO Fit_Table_Events, event
  infoID = Widget_Info (event.top, /Child)
  Widget_Control, infoID, get_UValue=info, /no_copy
  
  IF info.loaded EQ 1 THEN BEGIN
    
    handler = info.ptr
    struc   = info.struc
    
    CASE event.type OF
      4 : 	BEGIN
        (*handler).left   = event.sel_left
        (*handler).top    = event.sel_top
        (*handler).right  = event.sel_right
        (*handler).bottom = event.sel_bottom
        
        Widget_Control, info.labelID, Sensitive = 0
        Widget_Control, info.copyID,  Sensitive = 0
        
        IF (*handler).left NE -1L THEN BEGIN
          IF (*handler).top EQ (*handler).bottom THEN $
            Widget_Control, info.labelID, Sensitive = 1
          Widget_Control, info.copyID,  Sensitive = 1
        ENDIF
        
        IF (*handler).save_it EQ 1 THEN BEGIN
          Widget_Control, info.x1ID, get_Value = res
          (*struc).data[(*handler).old].x1 = (float(res))[0]
          Widget_Control, info.x2ID, get_Value = res
          (*struc).data[(*handler).old].x2 = (fix(res))[0]
          Widget_Control, info.x3ID, get_Value = res
          (*struc).data[(*handler).old].x3 = (float(res))[0]
          Widget_Control, info.x4ID, get_Value = res
          (*struc).data[(*handler).old].x4 = (fix(res))[0]
          Widget_Control, info.y1ID, get_Value = res
          (*struc).data[(*handler).old].y1 = (float(res))[0]
          Widget_Control, info.y2ID, get_Value = res
          (*struc).data[(*handler).old].y2 = (fix(res))[0]
          Widget_Control, info.y3ID, get_Value = res
          (*struc).data[(*handler).old].y3 = (float(res))[0]
          Widget_Control, info.y4ID, get_Value = res
          (*struc).data[(*handler).old].y4 = (fix(res))[0]
          Widget_Control, info.z1ID, get_Value = res
          (*struc).data[(*handler).old].z1 = (float(res))[0]
          Widget_Control, info.z2ID, get_Value = res
          (*struc).data[(*handler).old].z2 = (fix(res))[0]
          Widget_Control, info.z3ID, get_Value = res
          (*struc).data[(*handler).old].z3 = (float(res))[0]
          Widget_Control, info.z4ID, get_Value = res
          (*struc).data[(*handler).old].z4 = (fix(res))[0]
          Widget_Control, info.s1ID, get_Value = res
          (*struc).data[(*handler).old].s1 = (fix(res))[0]
          Widget_Control, info.s2ID, get_Value = res
          (*struc).data[(*handler).old].s2 = (fix(res))[0]
          Widget_Control, info.s3ID, get_Value = res
          (*struc).data[(*handler).old].s3 = (fix(res))[0]
          IF info.occ2 EQ 1 THEN BEGIN
            Widget_Control, info.s4ID, get_Value = res
            (*struc).data[(*handler).old].s4 = (fix(res))[0]
          ENDIF
        ENDIF
        
        IF (*handler).top EQ (*handler).bottom AND (*handler).top GE 0 THEN BEGIN
          Widget_Control, info.x1ID, set_Value = strtrim(string((*struc).data[(*handler).top].x1),2)
          Widget_Control, info.x2ID, set_Value = strtrim(string((*struc).data[(*handler).top].x2),2)
          Widget_Control, info.x3ID, set_Value = strtrim(string((*struc).data[(*handler).top].x3),2)
          Widget_Control, info.x4ID, set_Value = strtrim(string((*struc).data[(*handler).top].x4),2)
          Widget_Control, info.y1ID, set_Value = strtrim(string((*struc).data[(*handler).top].y1),2)
          Widget_Control, info.y2ID, set_Value = strtrim(string((*struc).data[(*handler).top].y2),2)
          Widget_Control, info.y3ID, set_Value = strtrim(string((*struc).data[(*handler).top].y3),2)
          Widget_Control, info.y4ID, set_Value = strtrim(string((*struc).data[(*handler).top].y4),2)
          Widget_Control, info.z1ID, set_Value = strtrim(string((*struc).data[(*handler).top].z1),2)
          Widget_Control, info.z2ID, set_Value = strtrim(string((*struc).data[(*handler).top].z2),2)
          Widget_Control, info.z3ID, set_Value = strtrim(string((*struc).data[(*handler).top].z3),2)
          Widget_Control, info.z4ID, set_Value = strtrim(string((*struc).data[(*handler).top].z4),2)
          Widget_Control, info.s1ID, set_Value = strtrim(string((*struc).data[(*handler).top].s1),2)
          Widget_Control, info.s2ID, set_Value = strtrim(string((*struc).data[(*handler).top].s2),2)
          Widget_Control, info.s3ID, set_Value = strtrim(string((*struc).data[(*handler).top].s3),2)
          IF info.occ2 EQ 1 THEN BEGIN
            Widget_Control, info.s4ID, set_Value = strtrim(string((*struc).data[(*handler).top].s3),2)
          ENDIF ELSE BEGIN
            Widget_Control, info.s4ID, set_Value = '---'
          ENDELSE
          Widget_Control, info.x1ID, All_Text_Events=1
          Widget_Control, info.x2ID, All_Text_Events=1
          Widget_Control, info.x3ID, All_Text_Events=1
          Widget_Control, info.x4ID, All_Text_Events=1
          Widget_Control, info.y1ID, All_Text_Events=1
          Widget_Control, info.y2ID, All_Text_Events=1
          Widget_Control, info.y3ID, All_Text_Events=1
          Widget_Control, info.y4ID, All_Text_Events=1
          Widget_Control, info.z1ID, All_Text_Events=1
          Widget_Control, info.z2ID, All_Text_Events=1
          Widget_Control, info.z3ID, All_Text_Events=1
          Widget_Control, info.z4ID, All_Text_Events=1
          Widget_Control, info.s1ID, All_Text_Events=1
          Widget_Control, info.s2ID, All_Text_Events=1
          Widget_Control, info.s3ID, All_Text_Events=1
          IF info.occ2 EQ 1 THEN $
            Widget_Control, info.s4ID, All_Text_Events=1
          (*handler).save_it = 1
          (*handler).old = (*handler).top
        ENDIF ELSE BEGIN
          Widget_Control, info.x1ID, set_Value = ''
          Widget_Control, info.x2ID, set_Value = ''
          Widget_Control, info.x3ID, set_Value = ''
          Widget_Control, info.x4ID, set_Value = ''
          Widget_Control, info.y1ID, set_Value = ''
          Widget_Control, info.y2ID, set_Value = ''
          Widget_Control, info.y3ID, set_Value = ''
          Widget_Control, info.y4ID, set_Value = ''
          Widget_Control, info.z1ID, set_Value = ''
          Widget_Control, info.z2ID, set_Value = ''
          Widget_Control, info.z3ID, set_Value = ''
          Widget_Control, info.z4ID, set_Value = ''
          Widget_Control, info.s1ID, set_Value = ''
          Widget_Control, info.s2ID, set_Value = ''
          Widget_Control, info.s3ID, set_Value = ''
          IF info.occ2 EQ 1 THEN BEGIN
            Widget_Control, info.s4ID, set_Value = ''
          ENDIF ELSE BEGIN
            Widget_Control, info.s4ID, set_Value = '---'
          ENDELSE
          Widget_Control, info.x1ID, All_Text_Events=0
          Widget_Control, info.x2ID, All_Text_Events=0
          Widget_Control, info.x3ID, All_Text_Events=0
          Widget_Control, info.x4ID, All_Text_Events=0
          Widget_Control, info.y1ID, All_Text_Events=0
          Widget_Control, info.y2ID, All_Text_Events=0
          Widget_Control, info.y3ID, All_Text_Events=0
          Widget_Control, info.y4ID, All_Text_Events=0
          Widget_Control, info.z1ID, All_Text_Events=0
          Widget_Control, info.z2ID, All_Text_Events=0
          Widget_Control, info.z3ID, All_Text_Events=0
          Widget_Control, info.z4ID, All_Text_Events=0
          Widget_Control, info.s1ID, All_Text_Events=0
          Widget_Control, info.s2ID, All_Text_Events=0
          Widget_Control, info.s3ID, All_Text_Events=0
          IF info.occ2 EQ 1 THEN $
            Widget_Control, info.s4ID, All_Text_Events=0
          (*handler).save_it = 0
        ENDELSE
      END
      ELSE : 
    ENDCASE
    
  ENDIF
  
  IF Widget_Info (event.top, /valid_ID) THEN BEGIN
    infoID = Widget_Info (event.top, /Child)
    Widget_Control, infoID, set_UValue=info, /no_copy
  ENDIF
END




PRO fit_bigger, info, paste = paste
  handler   = info.ptr
  struc	    = info.struc
  table     = info.tabledata
  rowlabels = info.labels
  
  Widget_Control, info.tableID, get_Value=*table
  res = size(*table)
  
  IF info.occ2 EQ 1 THEN BEGIN
    ndata = replicate ({value, a : '', $
                        x  : 0.0, $
                        x1 : 0.0, $
                        x2 : 0, $
                        x3 : 0.0, $
                        x4 : 0, $
                        y  : 0.0, $
			y1 : 0.0, $
			y2 : 0, $
			y3 : 0.0, $
			y4 : 0, $
			z  : 0.0, $
			z1 : 0.0, $
			z2 : 0, $
			z3 : 0.0, $
			z4 : 0, $
			s1 : 0, $ 
			s2 : 0, $
			s3 : 0, $
                        s4 : 0}, res[2])
  ENDIF ELSE BEGIN
    ndata = replicate ({value, a : '', $
                        x  : 0.0, $
                        x1 : 0.0, $
                        x2 : 0, $
			x3 : 0.0, $
			x4 : 0, $
			y  : 0.0, $
			y1 : 0.0, $
			y2 : 0, $
			y3 : 0.0, $
			y4 : 0, $
			z  : 0.0, $
			z1 : 0.0, $
			z2 : 0, $
			z3 : 0.0, $
			z4 : 0, $
			s1 : 0, $ 
			s2 : 0, $
			s3 : 0}, res[2])
  ENDELSE
  FOR i = 0, res[2] - 2, 1 DO BEGIN
    ndata[i].a = (*struc).data[i].a
    ndata[i].x = (*struc).data[i].x
    ndata[i].x1 = (*struc).data[i].x1
    ndata[i].x2 = (*struc).data[i].x2
    ndata[i].x3 = (*struc).data[i].x3
    ndata[i].x4 = (*struc).data[i].x4
    ndata[i].y = (*struc).data[i].y
    ndata[i].y1 = (*struc).data[i].y1
    ndata[i].y2 = (*struc).data[i].y2
    ndata[i].y3 = (*struc).data[i].y3
    ndata[i].y4 = (*struc).data[i].y4
    ndata[i].z = (*struc).data[i].z
    ndata[i].z1 = (*struc).data[i].z1
    ndata[i].z2 = (*struc).data[i].z2
    ndata[i].z3 = (*struc).data[i].z3
    ndata[i].z4 = (*struc).data[i].z4
    ndata[i].s1 = (*struc).data[i].s1
    ndata[i].s2 = (*struc).data[i].s2
    ndata[i].s3 = (*struc).data[i].s3
    IF info.occ2 EQ 1 THEN $
      ndata[i].s4 = (*struc).data[i].s4
  ENDFOR
  
  IF NOT(keyword_set(paste)) THEN BEGIN
    ndata[res[2]-1].a = (*rowlabels)[res[2]-1]
    ndata[res[2]-1].x = 0.0
    ndata[res[2]-1].x1 = 0.0
    ndata[res[2]-1].x2 = 0
    ndata[res[2]-1].x3 = 0.0
    ndata[res[2]-1].x4 = 0
    ndata[res[2]-1].y = 0.0
    ndata[res[2]-1].y1 = 0.0
    ndata[res[2]-1].y2 = 0
    ndata[res[2]-1].y3 = 0.0
    ndata[res[2]-1].y4 = 0
    ndata[res[2]-1].z = 0.0
    ndata[res[2]-1].z1 = 0.0
    ndata[res[2]-1].z2 = 0
    ndata[res[2]-1].z3 = 0.0
    ndata[res[2]-1].z4 = 0
    ndata[res[2]-1].s1 = 0
    ndata[res[2]-1].s2 = 0
    ndata[res[2]-1].s3 = 0
    IF info.occ2 EQ 1 THEN $
      ndata[res[2]-1].s4 = 0
  ENDIF ELSE BEGIN
    IF paste EQ -1 THEN paste = 0
    ndata[res[2]-1].a = (*rowlabels)[paste]
    ndata[res[2]-1].x  = (*struc).data[paste].x
    ndata[res[2]-1].x1 = (*struc).data[paste].x1
    ndata[res[2]-1].x2 = (*struc).data[paste].x2
    ndata[res[2]-1].x3 = (*struc).data[paste].x3
    ndata[res[2]-1].x4 = (*struc).data[paste].x4
    ndata[res[2]-1].y  = (*struc).data[paste].y
    ndata[res[2]-1].y1 = (*struc).data[paste].y1
    ndata[res[2]-1].y2 = (*struc).data[paste].y2
    ndata[res[2]-1].y3 = (*struc).data[paste].y3
    ndata[res[2]-1].y4 = (*struc).data[paste].y4
    ndata[res[2]-1].z  = (*struc).data[paste].z
    ndata[res[2]-1].z1 = (*struc).data[paste].z1
    ndata[res[2]-1].z2 = (*struc).data[paste].z2
    ndata[res[2]-1].z3 = (*struc).data[paste].z3
    ndata[res[2]-1].z4 = (*struc).data[paste].z4
    ndata[res[2]-1].s1 = (*struc).data[paste].s1
    ndata[res[2]-1].s2 = (*struc).data[paste].s2
    ndata[res[2]-1].s3 = (*struc).data[paste].s3
    IF info.occ2 EQ 1 THEN $
      ndata[res[2]-1].s4 = (*struc).data[paste].s4
    
    (*table)[0,res[2]-1] = (*table)[0,paste]
    (*table)[1,res[2]-1] = (*table)[1,paste]
    (*table)[2,res[2]-1] = (*table)[2,paste]
    Widget_Control, info.tableID, set_Value=*table
    
  ENDELSE
  
  (*struc) = { comment : (*struc).comment, $
               a       : (*struc).a, $
               b       : (*struc).b, $
               c       : (*struc).c, $
               alpha   : (*struc).alpha, $
               beta    : (*struc).beta, $
               gamma   : (*struc).gamma, $
               data    : ndata}
END




PRO fit_smaller, info
  handler   = info.ptr
  struc	  = info.struc
  table     = info.tabledata
  rowlabels = info.labels
  
  Widget_Control, info.tableID, get_Value=*table
  res = size(*table)
  
  IF info.occ2 EQ 1 THEN BEGIN
    ndata = replicate ({value, a : '', $
                        x  : 0.0, $
                        x1 : 0.0, $
                        x2 : 0, $
			x3 : 0.0, $
			x4 : 0, $
			y  : 0.0, $
			y1 : 0.0, $
			y2 : 0, $
			y3 : 0.0, $
			y4 : 0, $
			z  : 0.0, $
			z1 : 0.0, $
			z2 : 0, $
			z3 : 0.0, $
			z4 : 0, $
			s1 : 0, $ 
			s2 : 0, $
			s3 : 0, $
			s4 : 0}, res[2])
  ENDIF ELSE BEGIN
    ndata = replicate ({value, a : '', $
                        x  : 0.0, $
                        x1 : 0.0, $
			x2 : 0, $
			x3 : 0.0, $
			x4 : 0, $
			y  : 0.0, $
			y1 : 0.0, $
			y2 : 0, $
			y3 : 0.0, $
			y4 : 0, $
			z  : 0.0, $
			z1 : 0.0, $
			z2 : 0, $
			z3 : 0.0, $
			z4 : 0, $
			s1 : 0, $ 
			s2 : 0, $
			s3 : 0}, res[2])
  ENDELSE
  
  j = 0
  FOR i = 0, res[2] - 1, 1 DO BEGIN
    WHILE j GE info.firstrow AND j LE info.lastrow DO $
      j = j + 1
    
    ndata[i].a  = (*struc).data[j].a
    ndata[i].x  = (*struc).data[j].x
    ndata[i].x1 = (*struc).data[j].x1
    ndata[i].x2 = (*struc).data[j].x2
    ndata[i].x3 = (*struc).data[j].x3
    ndata[i].x4 = (*struc).data[j].x4
    ndata[i].y  = (*struc).data[j].y
    ndata[i].y1 = (*struc).data[j].y1
    ndata[i].y2 = (*struc).data[j].y2
    ndata[i].y3 = (*struc).data[j].y3
    ndata[i].y4 = (*struc).data[j].y4
    ndata[i].z  = (*struc).data[j].z
    ndata[i].z1 = (*struc).data[j].z1
    ndata[i].z2 = (*struc).data[j].z2
    ndata[i].z3 = (*struc).data[j].z3
    ndata[i].z4 = (*struc).data[j].z4
    ndata[i].s1 = (*struc).data[j].s1
    ndata[i].s2 = (*struc).data[j].s2
    ndata[i].s3 = (*struc).data[j].s3
    IF info.occ2 EQ 1 THEN $
      ndata[i].s4 = (*struc).data[j].s4
    j = j + 1
  ENDFOR
  
  (*struc) = { comment : (*struc).comment, $
               a       : (*struc).a, $
               b       : (*struc).b, $
               c       : (*struc).c, $
               alpha   : (*struc).alpha, $
               beta    : (*struc).beta, $
               gamma   : (*struc).gamma, $
               data    : ndata}
END



PRO Fit_Editor_Events, event
  infoID = Widget_Info (event.top, /Child)
  Widget_Control, infoID, get_UValue=info, /no_copy
  Widget_Control, event.id, get_uvalue=value
  handler   = info.ptr
  struc	    = info.struc
  table     = info.tabledata
  rowlabels = info.labels
  
  CASE value OF
    'LOAD' : BEGIN
      filename = dialog_Pickfile (/Read, $
                                  filter = '*.fit', /noconfirm, /must_exist)
      IF filename NE '' THEN BEGIN
        (*handler).filename = filename
        info.loaded = 1
        load_fit, strtrim (filename, 2), *struc, info
        Widget_Control, event.top, TLB_Set_Title= 'FIT Files Editor - ' + filename
        
        Widget_Control, info.aID, 	set_Value = strtrim(string((*struc).a),2)
        Widget_Control, info.bID, 	set_Value = strtrim(string((*struc).b),2)
        Widget_Control, info.cID, 	set_Value = strtrim(string((*struc).c),2)
        Widget_Control, info.alphaID, 	set_Value = strtrim(string((*struc).alpha),2)
        Widget_Control, info.betaID, 	set_Value = strtrim(string((*struc).beta),2)
        Widget_Control, info.gammaID, 	set_Value = strtrim(string((*struc).gamma),2)
        Widget_Control, info.comment,	set_Value = (*struc).comment
        
        res = size ((*struc).data)
        *table = fltarr (3, res[1])
        *rowlabels = strarr(res[1])			
        
        FOR i = 0, res[1]-1, 1 DO BEGIN
          (*table)[0,i]   = (*struc).data[i].x
          (*table)[1,i]   = (*struc).data[i].y
          (*table)[2,i]   = (*struc).data[i].z
          (*rowlabels)[i] = (*struc).data[i].a
        ENDFOR
        
        tres = size(*table)
        Widget_Control, info.tableID, Table_XSize=3
        Widget_Control, info.tableID, Table_YSize=res[1]
        Widget_Control, info.tableID, Row_Labels = *rowlabels
        Widget_Control, info.tableID, set_Value = *table, Use_Table_Select = [0,0,2,tres[2]-1]
        Widget_Control, info.tableID, /Editable
        
        Widget_Control, info.saveID, 	Sensitive = 1
        Widget_Control, info.saveasID,	Sensitive = 1
        Widget_Control, info.origID,	Sensitive = 1
        Widget_Control, info.newrID,	Sensitive = 1
        Widget_Control, info.delrID,	Sensitive = 1
        
        Widget_Control, info.aID,    All_Text_Events = 1
        Widget_Control, info.bID,    All_Text_Events = 1
        Widget_Control, info.cID,    All_Text_Events = 1
        Widget_Control, info.alphaID,All_Text_Events = 1
        Widget_Control, info.betaID, All_Text_Events = 1
        Widget_Control, info.gammaID,All_Text_Events = 1
      ENDIF
    END
    
    'SAVE' : BEGIN
      pseudoEvent = {Widget_Table_Cell_Sel, ID:info.tableID, Top:event.top, Handler:0L, $
                     Type:4, sel_left:-1L, sel_top:-1L, sel_right:-1L, sel_bottom:-1L}
      infoID = Widget_Info (event.top, /Child)
      Widget_Control, infoID, set_UValue=info, /no_copy
      Fit_Table_Events, pseudoEvent				
      infoID = Widget_Info (event.top, /Child)
      Widget_Control, infoID, get_UValue=info, /no_copy
      
      Widget_Control, info.tableID, Set_Table_Select=[-1,-1,-1,-1]
      Widget_Control, info.tableID, get_Value=*table
      fit_update_data, struc, table, rowlabels, info
      write_fit, (*handler).filename, *struc, info
    END
    
    'SAVEAS' : BEGIN
      filename = dialog_Pickfile (/Write, $
                                  filter = '*.fit', /fix_filter)
      IF filename NE '' THEN BEGIN
        (*handler).filename = filename
        pseudoEvent = {Widget_Table_Cell_Sel, ID:info.tableID, Top:event.top, Handler:0L, $
                       Type:4, sel_left:-1L, sel_top:-1L, sel_right:-1L, sel_bottom:-1L}
        infoID = Widget_Info (event.top, /Child)
        Widget_Control, infoID, set_UValue=info, /no_copy
        Fit_Table_Events, pseudoEvent				
        infoID = Widget_Info (event.top, /Child)
        Widget_Control, infoID, get_UValue=info, /no_copy
        
        Widget_Control, info.tableID, Set_Table_Select=[-1,-1,-1,-1]
        Widget_Control, info.tableID, get_Value=*table
        fit_update_data, struc, table, rowlabels, info
        write_fit, (*handler).filename, *struc, info
        Widget_Control, event.top, TLB_Set_Title= 'FIT Files Editor - ' + filename
      ENDIF
    END	
    
    'QUIT' : BEGIN
      Ptr_Free, info.ptr
      Ptr_Free, info.struc
      Ptr_Free, info.tabledata
      Ptr_Free, info.labels
      Widget_Control, event.top, /Destroy
    END
    
    'ATOM' : BEGIN
      data = (*struc).data[(*handler).top].a
      xedit, Text='Name for atom', data, action=action
      
      IF action EQ 'OK' THEN BEGIN
        Widget_Control, info.tableID, get_value=temp	
        result = size(temp)
        IF (*handler).top EQ 0 THEN $
          *rowlabels = [ data, (*rowlabels)[1:result[2]-1] ]
        IF (*handler).top EQ result[2]-1 THEN $
          *rowlabels = [ (*rowlabels)[0:result[2]-2], data ]
        IF (*handler).top NE 0 AND (*handler).top NE result[2]-1 THEN $
          *rowlabels = [ (*rowlabels)[0:(*handler).top-1], data, (*rowlabels)[(*handler).top+1:result[2]-1] ]
        Widget_Control, info.tableID, Row_Labels = *rowlabels
      ENDIF
    END
    
    'FILE' : BEGIN
      xdisplayfile, (*handler).filename, width=90, group=event.top
    END
    
    'NEWR' : BEGIN
      data='New Row'
      xedit, Text='Name for the new atom', data, action=action
      IF action EQ 'OK' THEN BEGIN
        Widget_Control, info.delrID, Sensitive = 1
        *rowlabels = [*rowlabels, data]
        *rowlabels = strtrim(*rowlabels, 2)
        Widget_Control, info.tableID, insert_rows = 1
        Widget_Control, info.tableID, Row_Labels = *rowlabels
        
        fit_bigger, info
      ENDIF
    END
    
    'DELR' : BEGIN
      Widget_Control, info.tableID, get_value=temp	
      old = size(temp)
      IF (*handler).left NE -1L THEN BEGIN
        IF NOT ((*handler).top EQ 0 AND (*handler).bottom EQ old[2]-1) THEN BEGIN
          info.firstrow = (*handler).top
          info.lastrow = (*handler).bottom
          Widget_Control, info.tableID, /Delete_Rows
          Widget_Control, info.tableID, get_value=temp	
          result = size(temp)
          if result[0] EQ 1 THEN result[2] = 1
          
          IF old[2] NE result[2] THEN BEGIN
            IF (*handler).top NE 0 AND (*handler).bottom NE old[2]-1 THEN $
              *rowlabels = [ (*rowlabels)[0:(*handler).top - 1] , (*rowlabels)[(*handler).bottom + 1 : old[2] - 1] ]
            IF (*handler).top EQ 0 AND (*handler).bottom NE old[2]-1 THEN $
              *rowlabels = [(*rowlabels)[(*handler).bottom + 1 : old[2] - 1] ]
            IF (*handler).top NE 0 AND (*handler).bottom EQ old[2]-1 THEN $
              *rowlabels = [(*rowlabels)[0:(*handler).top - 1] ]
            
            IF result[0] EQ 1 THEN Widget_Control, info.delrID, Sensitive = 0
          ENDIF
          
          fit_smaller, info
          (*handler).save_it = 0
        ENDIF
      ENDIF
    END
    
    'COPY' : BEGIN
      (*handler).topaste = (*handler).top
      IF (*handler).topaste EQ 0 THEN (*handler).topaste = -1
      Widget_Control, info.pasteID, Sensitive = 1
    END
    
    'PASTE' : BEGIN
      Widget_Control, info.delrID, Sensitive = 1
      IF (*handler).topaste EQ -1 THEN (*handler).topaste = 0
      *rowlabels = [*rowlabels, (*rowlabels)[(*handler).topaste]]
      *rowlabels = strtrim(*rowlabels, 2)
      Widget_Control, info.tableID, insert_rows = 1
      Widget_Control, info.tableID, Row_Labels = *rowlabels
      
      IF (*handler).topaste EQ 0 THEN (*handler).topaste = -1
      fit_bigger, info, paste = (*handler).topaste
    END
    
    ELSE :
    
  ENDCASE
  
  IF Widget_Info (event.top, /valid_ID) THEN BEGIN
    infoID = Widget_Info (event.top, /Child)
    Widget_Control, infoID, set_UValue=info, /no_copy
  ENDIF
END




PRO fit_editor, Group=group
  tlb   = Widget_Base (title = 'FIT Files Editor', $
                       column = 1, base_align_left = 1, MBar = MenuBar, $
                       TLB_Frame_Attr = 1)
  infos = Widget_Base (tlb)
  
  FileMenu   = WIDGET_BUTTON(MenuBar, 	VALUE='File', 	/MENU)
  bload    = WIDGET_BUTTON(FileMenu, 	VALUE='Load Fit File', 		UValue='LOAD')
  bsave    = WIDGET_BUTTON(FileMenu, 	VALUE='Save', 			UValue='SAVE')
  bsaveas  = WIDGET_BUTTON(FileMenu, 	VALUE='Save as ...', 		UValue='SAVEAS')
  bquit    = WIDGET_BUTTON(FileMenu, 	VALUE='Quit', 			UValue='QUIT', /Separator)
  EditMenu   = WIDGET_BUTTON(MenuBar, 	VALUE='Edit',	/MENU)
  bnewr    = WIDGET_BUTTON(EditMenu, 	VALUE='New Row', 		UValue='NEWR')
  bdelr    = WIDGET_BUTTON(EditMenu,	VALUE='Delete Selected Row(s)', UValue='DELR')
  bcopy    = WIDGET_BUTTON(EditMenu, 	VALUE='Copy Row', 		UValue='COPY', /Separator)
  bpaste   = WIDGET_BUTTON(EditMenu,	VALUE='Paste Row', 		UValue='PASTE')
  blabel   = WIDGET_BUTTON(EditMenu,	VALUE='Rename Atom', 		UValue='ATOM', /Separator)
  WindowMenu = WIDGET_BUTTON(MenuBar, 	VALUE='Window',	/MENU)
  borig    = WIDGET_BUTTON(WindowMenu,	VALUE='Show Fit File', 		UValue='FILE')
  
  
  tablebase = Widget_Base (tlb, base_align_left=1, column=2)
  
  table = Widget_Table (tablebase, xsize=3, $
                        /Editable, /All_Events, /Scroll, UValue='Table', $ 
                        column_labels=['X Start', 'Y Start', 'Z Start'], $
                        Event_Pro = 'Fit_Table_Events')
  
  table1 = Widget_Base (tablebase, column = 2)
  
  table11 = Widget_Base(table1, row=1)
  at = Widget_Label (table11, value = 'A:', scr_xsize=80)
  a = Widget_Text   (table11, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                     xsize = 8, UValue='A')
  
  table12 = Widget_Base(table1, row=1)
  bt = Widget_Label (table12, value = 'B:', scr_xsize=80)
  b = Widget_Text   (table12, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                     xsize = 8, UValue='B')
  
  table13 = Widget_Base(table1, row=1)
  ct = Widget_Label (table13, value = 'C:', scr_xsize=80)
  c = Widget_Text   (table13, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                     xsize = 8, UValue='C')
  
  table14 = Widget_Base(table1, row=1)
  alphat = Widget_Label (table14, value = 'Alpha:', scr_xsize=80)
  alpha = Widget_Text   (table14, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                         xsize = 8, UValue='ALPHA')
  
  table15 = Widget_Base(table1, row=1)
  betat = Widget_Label (table15, value = 'Beta:', scr_xsize=80)
  beta = Widget_Text   (table15, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                        xsize = 8, UValue='BETA')
  
  table16 = Widget_Base(table1, row=1)
  gammat = Widget_Label (table16, value = 'Gamma:', scr_xsize=80)
  gamma = Widget_Text   (table16, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                         xsize = 8, UValue='GAMMA')
  
  extra = Widget_Base (tlb, column = 4)
  
  extra1 = Widget_Base (extra, column = 1)
  
  extra11 = Widget_Base(extra1, row=1)
  x1t = Widget_Label (extra11, value = 'XConst.:', scr_xsize=80)
  x1 = Widget_Text   (extra11, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='X1')
  
  extra12 = Widget_Base(extra1, row=1)
  x2t = Widget_Label (extra12, value = 'XDisp.:', scr_xsize=80)
  x2 = Widget_Text   (extra12, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='X2')
  
  extra13 = Widget_Base(extra1, row=1)
  x3t = Widget_Label (extra13, value = 'X2Const.:', scr_xsize=80)
  x3 = Widget_Text   (extra13, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='X3')
  
  extra14 = Widget_Base(extra1, row=1)
  x4t = Widget_Label (extra14, value = 'X2Disp.:', scr_xsize=80)
  x4 = Widget_Text   (extra14, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='X4')
  
  extra2 = Widget_Base (extra, column = 1)
  
  extra21 = Widget_Base(extra2, row=1)
  y1t = Widget_Label (extra21, value = 'YConst.:', scr_xsize=80)
  y1 = Widget_Text   (extra21, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='Y1')
  
  extra22 = Widget_Base(extra2, row=1)
  y2t = Widget_Label (extra22, value = 'YDisp.:', scr_xsize=80)
  y2 = Widget_Text   (extra22, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='Y2')
  
  extra23 = Widget_Base(extra2, row=1)
  y3t = Widget_Label (extra23, value = 'Y2Const.:', scr_xsize=80)
  y3 = Widget_Text   (extra23, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='Y3')
  
  extra24 = Widget_Base(extra2, row=1)
  y4t = Widget_Label (extra24, value = 'Y2Disp.:', scr_xsize=80)
  y4 = Widget_Text   (extra24, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='Y4')
  
  extra3 = Widget_Base (extra, column = 1)
  
  extra31 = Widget_Base(extra3, row=1)
  z1t = Widget_Label (extra31, value = 'ZConst.:', scr_xsize=80)
  z1 = Widget_Text   (extra31, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='Z1')
  
  extra32 = Widget_Base(extra3, row=1)
  z2t = Widget_Label (extra32, value = 'ZDisp.:', scr_xsize=80)
  z2 = Widget_Text   (extra32, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='Z2')
  
  extra33 = Widget_Base(extra3, row=1)
  z3t = Widget_Label (extra33, value = 'Z2Const.:', scr_xsize=80)
  z3 = Widget_Text   (extra33, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='Z3')
  
  extra34 = Widget_Base(extra3, row=1)
  z4t = Widget_Label (extra34, value = 'Z2Disp.:', scr_xsize=80)
  z4 = Widget_Text   (extra34, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='Z4')
  
  extra4 = Widget_Base (extra, column = 1)
  
  extra41 = Widget_Base(extra4, row=1)
  s1t = Widget_Label (extra41, value = 'B1:', scr_xsize=80)
  s1 = Widget_Text   (extra41, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='S1')
  
  extra42 = Widget_Base(extra4, row=1)
  s2t = Widget_Label (extra42, value = 'B2:', scr_xsize=80)
  s2 = Widget_Text   (extra42, Editable = 0, All_Events=0, Event_Pro='Integer_Only', $
                      xsize = 8, UValue='S2')
  
  extra43 = Widget_Base(extra4, row=1)
  s3t = Widget_Label (extra43, value = 'Occ. 1:', scr_xsize=80)
  s3 = Widget_Text   (extra43, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='S3')
  
  extra44 = Widget_Base(extra4, row=1)
  s4t = Widget_Label (extra44, value = 'Occ. 2:', scr_xsize=80)
  s4 =  Widget_Text  (extra44, Editable = 0, All_Events=0, Event_Pro='Float_Only', $
                      xsize = 8, UValue='S4')
  
  commentt    = Widget_Label  (tlb, value = 'Comment:')
  comment     = Widget_Text   (tlb, xsize = 80, ysize = 2, UValue='COMMENT', /scroll)
  
  
  handler = {filename:  'rod', $
             save_it: 	0, $
             old:	-1, $
             topaste:	-1, $
             left:	-1, $
             top:	-1, $
             right:	-1, $
             bottom:	-1}
  
  ptr = Ptr_New (handler)
  
  datastruct = 0
  struc = Ptr_New (datastruct)
  
  tabledata = 0
  tableptr = Ptr_New (tabledata)
  
  rowlabels = ['']
  labels = Ptr_New (rowlabels)
  
  info = {loadID:bload, $
          saveID:bsave, $
          saveasID:bsaveas, $
          copyID:bcopy, $
          pasteID:bpaste, $
          newrID:bnewr, $
          delrID:bdelr, $
          labelID:blabel, $
          origID:borig, $
          x1ID:x1, $
          x2ID:x2, $
          x3ID:x3, $
          x4ID:x4, $
          y1ID:y1, $
          y2ID:y2, $
          y3ID:y3, $
          y4ID:y4, $
          z1ID:z1, $
          z2ID:z2, $
          z3ID:z3, $
          z4ID:z4, $
          s1ID:s1, $
          s2ID:s2, $
          s3ID:s3, $
          s4ID:s4, $
          aID:a, $
          bID:b, $
          cID:c, $
          alphaID:alpha, $
          betaID:beta, $
          gammaID:gamma, $
          tableID:table, $
          comment:comment, $
          tabledata:tableptr, $
          labels:labels, $
          ptr:ptr, $
          struc:struc, $
          firstrow:0, $
          lastrow:0, $
          loaded:0, $
          occ2:0}
  
  Widget_Control, bsave,  Sensitive = 0
  Widget_Control, bsaveas,Sensitive = 0
  Widget_Control, bnewr,  Sensitive = 0
  Widget_Control, bdelr,  Sensitive = 0
  Widget_Control, bcopy,  Sensitive = 0
  Widget_Control, bpaste, Sensitive = 0
  Widget_Control, blabel, Sensitive = 0
  Widget_Control, borig,  Sensitive = 0
  
  Widget_Control, table, column_Widths = Widget_Info (table, /column_widths)
  Widget_Control, Widget_Info (tlb, /Child), set_UValue=info, /no_copy
  Widget_Control, tlb, /Realize
  XManager, 'Fit_Editor', tlb, Event='Fit_Editor_Events', Group_leader=group, /No_Block
END
