Pro Ellipse, center = cent, radii = rd, rotate = rot, degrees = deg, $
    linestyle = lins, thick = thi, color = col, fill = fil, $
    device = dev, normal = nor, semi = semi

;+
; NAME:
;	ELLIPSE
; PURPOSE:
;	Draws an ellipse, around CENTER, with radii given by RADII, optionally
;	rotating it by angle ROT.  The drawing is done in the currently
;	defined plot area.  DATA coordinate system is assumed unless specified
;	otherwise by one of the keywords /DEVICE or /NORMAL.
; CATEGORY:
;	General Graphics.
; CALLING SEQUENCE:
;	ELLIPSE, CENTER = CENT, RADII = RD, [, optional keywords]
; INPUTS:
;	None
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;    CENTER
;	2 dimensional vector, ellipse center location, format [x,y], mandatory.
;    RADII
;	2 dimensional vector, contains the x and y radii (in order), mandatory.
;    ROTATE
;	Optional.  Angle of rotation in the mathematical positive direction.
;	Assumed in radians, unless DEGREES is set.
;    /DEGREES
;	Specifies tha the rotation angle is given in degrees.
;    /FILL
;	causes the ellipse to be filled with a solid pattern.
;    COLOR
;	Standard IDL plotting interpretation.
;    /DEVICE
;	Ditto.
;    LINESTYLE
;	Ditto.
;    /NORMAL
;	Ditto.
;    THICK
;	Ditto.
;    SEMI plots a left-semicircle instead of a circle.
; OUTPUTS:
;	None.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	If the DATA coordinate system is used and the plot area is defined with
;	nonlinear (logarithmic) axes, the shape won't look like an ellipse.
; PROCEDURE:
;	Uses calls to DEFAULT, ONE_OF, SHAPE_TRANS and SHAPE_COCON from MIDL.
;	Generates a (2,N) array containing a sufficient number of ellipse
;	points to yield a smooth curve.  N is variable, depending both on the
;	ellipse size and on the pixel size of the current output device.
; MODIFICATION HISTORY:
;	Created 15-JUL-1991 by Mati Meron.
;	Modified 15-OCT-1991 by Mati Meron.  Added keyword COLOR.
;	Modified 15-DEC-1991 by Mati Meron.  Added size and device dependence
;	of the number of plot points.
;	Modified 15-OCT-1992 by Mati Meron.  Added rotation.
;-

    on_error, 1
    posib = ['DATA', 'DEVICE', 'NORMAL']
    sor = posib(1 + One_of(dev,nor))

    rsor = transpose([[[0,rd(0)] + cent(0)], [[0,rd(1)] + cent(1)]])
    rdev = Shape_cocon(rsor, from = sor, to = 'dev')
    npoints = 4*(1 + fix(!pi/4*sqrt(max(abs(rdev(*,1) - rdev(*,0))))))

	  CASE semi OF
		'0' : BEGIN
						tem = 2*!pi/npoints*[indgen(npoints),0]
					END
		'1' : BEGIN
						tem = !pi/(npoints-1)*[indgen(npoints),0]+(!pi/2.0)
					END
		'2' : BEGIN
						tem = (!pi)/(npoints-1)*[indgen(npoints),0]+(!pi*1.5)
					END
		END

    elli = transpose([[cent(0) + rd(0)*cos(tem)], [cent(1) + rd(1)*sin(tem)]])
    if n_elements(rot) ne 0 then elli = Shape_trans(elli,rot,degrees= deg,/cent)

    if keyword_set(fil) then polyfill, elli, device = dev, normal = nor, $
    color = Default(col,!p.color) $
    else plots, elli, device= dev, normal= nor, color= Default(col,!p.color), $
    linestyle = Default(lins,0), thick = Default(thi,1)

    return
end
