;+
; NAME:
;					COM_PUT
; PURPOSE:
;					used for communication between C code (ROD) and
;					IDL user interface (RODGUI)
; CATEGORY:
;					communication
; CALLING SEQUENCE:
;					COM_PUT, structure
; INPUTS:
;					structure with one data field called: string
; OUTPUTS:
;					writes a file with the string of structure.string
;					into a file
; MODIFICATION HISTORY:
;	Created 1997,98 by Andre Wilms (new email address will be: wilms@comline.de)
;-

PRO com_put, handler

	;choose the right filename (system dependent)
  IF !version.os_family EQ 'unix' THEN BEGIN
	  input_name = "input.rod"
	  ready_name = "ready.rod"
  ENDIF ELSE BEGIN
	  input_name = "c:\input.rod"
	  ready_name = "c:\ready.rod"
  ENDELSE

	;wait for the (former) input file to be deleted by the C program
  does_exist = checkfile (input_name)
  WHILE does_exist EQ 1 DO BEGIN
    wait, 0.01
    does_exist = checkfile (input_name)
  ENDWHILE

  IF !version.os_family EQ 'unix' THEN BEGIN
  	;write string to the file
    command = 'echo ' + (*handler).string + ' > input.rod'
    spawn, command
	ENDIF ELSE BEGIN
		;for the windows version, an input and a ready file is written
		;to the harddisk. when the input file is finished, the ready file
		;gets written. the C program reads the file vice versa, that is
		;first the ready file and then the input file. this is necessary
		;to make sure that the input file is already closed by this IDL
		;routine when the C code tries to read it.
    openw, a_unit, 'c:\input.rod', /get_lun
    printf, a_unit, (*handler).string
    close, a_unit
    free_lun, a_unit
  ENDELSE

  does_exist = checkfile (ready_name)
  WHILE does_exist EQ 1 DO BEGIN
    wait, 0.01
    does_exist = checkfile (ready_name)
  ENDWHILE

  IF !version.os_family EQ 'unix' THEN BEGIN
    command = 'echo ' + (*handler).string + ' > ready.rod'
    spawn, command
  ENDIF ELSE BEGIN
    openw, a_unit, 'c:\ready.rod', /get_lun
    printf, a_unit, 'ready'
    close, a_unit
    free_lun, a_unit
  ENDELSE

  (*handler).status = 'Sending'
END
