;+
; NAME:
;					COM_GET
; PURPOSE:
;					used for communication between C code (ROD) and
;					IDL user interface (RODGUI)
; CATEGORY:
;					communication
; CALLING SEQUENCE:
;					COM_GET, structure, id
; INPUTS:
;					structure	: with one necessary data field called string
;					id				: widget id of the output window where the text
;											has to be displayed
; KEYWORD PARAMETERS:
;					text			: string array of the text that has to be displayed
;					no_output : if set to 1, no output will be made

; OUTPUTS:
; 				none.
; MODIFICATION HISTORY:
;	Created 1997,98 by Andre Wilms (new email address will be: wilms@comline.de)
;-

PRO com_get, handler, id, text=text, no_output=no_output

	;choose the right filename (system dependent)
  IF !version.os_family EQ 'unix' THEN $
    name = 'output.rod' $
  ELSE $
    name = 'c:\output.rod'

	;wait until the C program has written the output file
	;that this function wants to read.
  does_exist = checkfile (name)

  WHILE does_exist EQ 0 DO BEGIN
    wait, 0.01
    does_exist = checkfile (name)
  ENDWHILE

  text = read_textfile (name)

	;delete output file after saving its text into a
	;variable
  openw, a_unit, name, /get_lun, /delete
  close, a_unit
  free_lun, a_unit

  temp = strarr (n_elements(text))

  j = 0
  FOR i = 0, n_elements(text) - 1, 1 DO BEGIN
    (*handler).string = text[i]
    (*handler).string = strtrim ((*handler).string)
		;check whether the current line of the output text
		;should be displayed on the screen
    output = 1
    IF i GT 1 THEN $
      IF strmid((*handler).string, 0, 1) EQ '*' THEN output = 0
    IF NOT(keyword_set(no_output)) AND output EQ 1 THEN $
      temp[j] = (*handler).string

		;if current line is the start of a plotting routine
		;call the plotting function (of rodgui.pro)
    IF strmid((*handler).string,0,11) EQ 'Plotting...' THEN BEGIN
      IF (*handler).secondplot EQ 'Plotting!' THEN $
        (*handler).secondplot = 'yes' $
      else $
        (*handler).secondplot = 'Plotting!'
      Plotting, handler
    ENDIF ELSE BEGIN
      (*handler).secondplot = 'no'

      ;call contour plot functions if the current line of
      ;the output text introduces a contour plot
      IF (*handler).string EQ 'Contour...' THEN $
      	Contour_Rod, handler
      IF (*handler).string EQ '...Contour' THEN $
      	Patterson, handler
    ENDELSE

    IF output EQ 1 THEN j = j + 1
  ENDFOR

	;display text on the screen if no_output keyword isn't set
  IF NOT(keyword_set(no_output)) THEN BEGIN
    Widget_Control, id, set_Value = temp[0:j-1], /append
    IF !version.os_family NE 'unix' THEN BEGIN
      Widget_Control, id, get_Value = temp
      Widget_Control, id, Set_Text_Top_Line = n_Elements (temp)
    ENDIF
  ENDIF

END