Pro Circle, center = cen, radius = prad, x_radius = xrad, y_radius = yrad, $
    linestyle = lins, thick = thi, color = col, fill = fil, $
    device = dev, normal = nor, semi = semi

;+
; NAME:
;	CIRCLE
; PURPOSE:
; 	Draws a circle, around CENTER, with radius given by RADIUS, X_RADIUS,
;	or Y_RADIUS.  The drawing is done in the currently defined plot area.
;	One and ONLY ONE of the three radius values MUST be provided.  RADIUS
;	and X_RADIUS are equivalent.  DATA coordinates are used unless one of
;	the keywords /DEVICE or /NORMAL is set.  The circle is drawn so as to
;	appear visually as a circle, regardless of the coordinates used.
; CATEGORY:
;	General Graphics.
; CALLING SEQUENCE:
;	CIRCLE, CENTER = C, {RADIUS=R, X_RADIUS=XR, Y_RADIUS = YR} [, keywords]
; INPUTS:
;	None.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;    CENTER
;	Two dimensional vector, circle center location, mandatory.
;    RADIUS							|
;	Scalar, value of radius (measured in the X direction).	| One
;    X_RADIUS							| and only one
;	Scalar, value of radius (measured in the X direction).	| must be
;    Y_RADIUS							| provided.
;	Scalar, value of radius (measured in the Y direction).	|
;    /FILL
;	causes the circle to be filled with a solid pattern.
;    COLOR
;	Standard IDL plotting interpretation.
;    /DEVICE
;	Ditto.
;    LINESTYLE
;	Ditto.
;    /NORMAL
;	Ditto.
;    THICK
;	Ditto.
; OUTPUTS:
;	None.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Uses calls to ONE_OF and COO_CONV from MIDL.  Converts all parameters
;	to device coordinates and calls ELLIPSE (also from MIDL) to do the
;	actual plotting.
; MODIFICATION HISTORY:
;	Created 15-JUL-1991 by Mati Meron.
;	Modified 15-OCT_1991 by Mati Meron.  Added keyword COLOR.
;-

    on_error, 1
    rnum = One_of(xrad,yrad,prad, value = rad) mod 2
    if rnum eq -1 then message, 'Missing radius!'

    posib = ['DATA', 'DEVICE', 'NORMAL']
    sor = posib(1 + One_of(dev,nor))

    tem = [cen(rnum),cen(rnum) + rad]
    tem = Coo_conv(tem, axis = rnum, from = sor, to = 'DEVICE')
    rad = tem(1) - tem(0)

    x = Coo_conv(cen(0), axis = 'X', from = sor, to = 'DEVICE')
    y = Coo_conv(cen(1), axis = 'Y', from = sor, to = 'DEVICE')

    Ellipse, center = [x,y], radii = [rad,rad], /device, $
    linestyle = lins, thick = thi, color = col, fill = fil, semi = semi

    return
end
