PRO load_bul, name, info
  table   = info.tabledata
  comment = info.commentdata
  label   = info.labeldata
  para	  = info.paradata
  
  text = read_textfile(name)
  res = size(text)
  n_comments = 0
  i = 0
  WHILE strmid(text[i], 0, 1) EQ '#' DO BEGIN
    IF i EQ 0 THEN $
      *comment = text[i] $
    ELSE $
      *comment = [*comment, text[i]]
    n_comments = n_comments + 1
    i = i + 1
  ENDWHILE
  
  lin = strtrim(text[i],2)
  blank=0
  length=0
  i=0
  
  FOR j = 0, 4, 1 DO BEGIN
    WHILE (strmid(lin, i, 1) NE ' ') DO BEGIN
      i = i + 1
      length = length + 1
    ENDWHILE
    (*para)[j] = strmid (lin, blank, length)
    WHILE (strmid (lin, i, 1) EQ ' ') DO $
      i = i + 1
    blank = i
    length = 0
  ENDFOR
  (*para)[5] = strmid (lin, blank, strlen(lin) - blank)
  
  (*table) = fltarr(4, res[1] - n_comments - 1)
  (*label) = strarr(res[1] - n_comments - 1)
  
  FOR k = n_comments + 1, res[1] - 1, 1 DO BEGIN
    lin = strtrim(text[k],2)
    blank=0
    length=0
    i = 0
    
    WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
      i = i + 1                 ;		
      length = length + 1
    ENDWHILE
    (*label)[k - n_comments - 1] = strmid(lin, blank, length)
    WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
      i = i + 1
    blank = i
    length = 0
    FOR j = 0, 2, 1 DO BEGIN
      WHILE (strmid(lin, i, 1) NE ' ') AND (strmid(lin, i, 1) NE string(byte(9))) DO BEGIN
        i = i + 1
        length = length + 1
      ENDWHILE
      (*table)[j,k - n_comments - 1] = float(strmid(lin, blank, length))
      WHILE (strmid (lin, i, 1) EQ ' ') OR (strmid(lin, i, 1) EQ string(byte(9))) DO $
        i = i + 1
      blank = i
      length = 0
    ENDFOR
    (*table)[3, k - n_comments - 1] = float(strmid (lin, blank, strlen(lin) - blank))
  ENDFOR
END




PRO write_bul, name, info
  table   = info.tabledata
  comment = info.commentdata
  label	= info.labeldata
  para	= info.paradata
  
  Widget_Control, info.tableID, Set_Table_Select=[-1,-1,-1,-1]
  Widget_Control, info.tableID, get_Value=*table
  
  Widget_Control, info.aID, 	get_Value=res
  (*para)[0] = float(res[0])
  Widget_Control, info.bID, 	get_Value=res
  (*para)[1] = float(res[0])
  Widget_Control, info.cID, 	get_Value=res
  (*para)[2] = float(res[0])
  Widget_Control, info.alphaID, get_Value=res
  (*para)[3] = float(res[0])
  Widget_Control, info.betaID, 	get_Value=res
  (*para)[4] = float(res[0])
  Widget_Control, info.gammaID, get_Value=res
  (*para)[5] = float(res[0])
  
  openw, a_unit, name, /get_lun
  
  lines = n_elements (*comment)
  FOR i = 0, lines - 1, 1 DO $
    printf, a_unit, (*comment)[i]
  
  printf, a_unit, format = '(F8.4, " ", F8.4, " ", F8.4, " ", F8.4, " ", F8.4, " ", F8.4)', $
    (*para)[0], (*para)[1], (*para)[2], (*para)[3], (*para)[4], (*para)[5] 
  
  res = size(*table)
  FOR i = 0, res[2] - 1, 1 DO BEGIN
    printf, a_unit, format = '(A0," ",F10.5," ",F10.5," ",F10.5," ",I0)', $
      (*label)[i], (*table)[0,i], (*table)[1,i], (*table)[2,i], fix((*table)[3,i])
  ENDFOR
  close, a_unit
END




PRO bul_bigger, info, paste = paste
  handler   = info.ptr
  table     = info.tabledata
  
  Widget_Control, info.tableID, get_Value=*table
  res = size(*table)
  
  IF keyword_set(paste) THEN BEGIN
    IF paste EQ -1 THEN paste = 0
    (*table)[0,res[2]-1] = (*table)[0,paste]
    (*table)[1,res[2]-1] = (*table)[1,paste]
    (*table)[2,res[2]-1] = (*table)[2,paste]
    (*table)[3,res[2]-1] = (*table)[3,paste]
  ENDIF ELSE BEGIN
    (*table)[0,res[2]-1] = 0.0
    (*table)[1,res[2]-1] = 0.0
    (*table)[2,res[2]-1] = 0.0 
    (*table)[3,res[2]-1] = 0.0 
  ENDELSE
  Widget_Control, info.tableID, set_Value=*table
END




PRO Bul_Table_Events, event
  infoID = Widget_Info (event.top, /Child)
  Widget_Control, infoID, get_UValue=info, /no_copy
  handler   = info.ptr
  table     = info.tabledata
  comment	  = info.commentdata
  
  CASE event.type OF
    4 : 	BEGIN
      (*handler).left   = event.sel_left
      (*handler).top    = event.sel_top
      (*handler).right  = event.sel_right
      (*handler).bottom = event.sel_bottom
      
      Widget_Control, info.copyID,  Sensitive = 0
      Widget_Control, info.delrID,  Sensitive = 0
      Widget_Control, info.multiID, Sensitive = 0
      
      IF (*handler).left NE -1 THEN BEGIN
        IF (*handler).left EQ (*handler).right THEN $
          Widget_Control, info.multiID,  Sensitive = 1
      ENDIF
      
      IF (*handler).top NE -1 THEN BEGIN
        Widget_Control, info.delrID,  Sensitive = 1
        IF (*handler).top EQ (*handler).bottom THEN $
          Widget_Control, info.copyID,  Sensitive = 1
      ENDIF
    END
    
    ELSE :
  ENDCASE
  
  IF Widget_Info (event.top, /valid_ID) THEN BEGIN
    infoID = Widget_Info (event.top, /Child)
    Widget_Control, infoID, set_UValue=info, /no_copy
  ENDIF
END




PRO Bul_Editor_Events, event
  infoID = Widget_Info (event.top, /Child)
  Widget_Control, infoID, get_UValue=info, /no_copy
  Widget_Control, event.id, get_uvalue=value
  handler   = info.ptr
  table     = info.tabledata
  comment   = info.commentdata
  label     = info.labeldata
  para	    = info.paradata
  
CASE value OF
  'LOAD' : BEGIN
    filename = dialog_Pickfile (/Read, $
                                filter = '*.bul', /noconfirm, /must_exist)
    IF filename NE '' THEN BEGIN
      Widget_Control, event.top, TLB_Set_Title= 'BULK Files Editor - ' + filename
      (*handler).filename = filename
      info.loaded = 1
      load_bul, strtrim(filename, 2), info
      res = size(*table)
      Widget_Control, info.tableID, table_Ysize = res[2]
      Widget_Control, info.tableID, set_Value = *table, Use_Table_Select = [0,0,4,res[1]-1]
      Widget_Control, info.tableID, Row_Labels = (*label)
      Widget_Control, info.commentID, set_Value = *comment
      Widget_Control, info.aID, 	set_Value = strtrim(string((*para)[0]),2)
      Widget_Control, info.bID, 	set_Value = strtrim(string((*para)[1]),2)
      Widget_Control, info.cID, 	set_Value = strtrim(string((*para)[2]),2)
      Widget_Control, info.alphaID, 	set_Value = strtrim(string((*para)[3]),2)
      Widget_Control, info.betaID, 	set_Value = strtrim(string((*para)[4]),2)
      Widget_Control, info.gammaID, 	set_Value = strtrim(string((*para)[5]),2)
      
      Widget_Control, info.saveID,   Sensitive = 1
      Widget_Control, info.saveasID, Sensitive = 1
      Widget_Control, info.newrID,   Sensitive = 1
      Widget_Control, info.origID,   Sensitive = 1
      Widget_Control, info.pasteID,  Sensitive = 0
      
      Widget_Control, info.aid,       All_Text_Events = 1
      Widget_Control, info.bid,       All_Text_Events = 1
      Widget_Control, info.cid,       All_Text_Events = 1
      Widget_Control, info.alphaID,   All_Text_Events = 1
      Widget_Control, info.betaID,    All_Text_Events = 1
      Widget_Control, info.gammaID,   All_Text_Events = 1
      Widget_Control, info.commentID, All_Text_Events = 1
    ENDIF
  END
  
  'SAVE' : BEGIN
    write_bul, (*handler).filename, info
  END
  
  'SAVEAS' : BEGIN
    filename = dialog_Pickfile (/Write, $
                                filter = '*.bul', /fix_filter)
    IF filename NE '' THEN BEGIN
      Widget_Control, event.top, TLB_Set_Title= 'BULK Files Editor - ' + filename
      (*handler).filename = filename
      
      write_bul, (*handler).filename, info
    ENDIF
  END	
  
  'QUIT' : BEGIN
    Ptr_Free, info.ptr
    Ptr_Free, info.tabledata
    Ptr_Free, info.commentdata
    Ptr_Free, info.tabledata
    Ptr_Free, info.paradata
    Widget_Control, event.top, /Destroy
  END
  
  'BULK' : BEGIN
    xdisplayfile, (*handler).filename, width=90, group=event.top
  END
  
  'NEWR' : BEGIN
    Widget_Control, info.tableID, insert_rows = 1
    bul_bigger, info
  END
  
  'DELR' : BEGIN
    Widget_Control, info.tableID, get_value=temp	
    old = size(temp)
    IF (*handler).left NE -1L THEN BEGIN
      IF NOT ((*handler).top EQ 0 AND (*handler).bottom EQ old[2]-1) THEN BEGIN
        Widget_Control, info.tableID, /Delete_Rows
        Widget_Control, info.tableID, get_value=temp	
        result = size(temp)
        if result[0] EQ 1 THEN result[2] = 1
        
        IF old[2] NE result[2] THEN BEGIN
          IF (*handler).top NE 0 AND (*handler).bottom NE old[2]-1 THEN $
            *label = [ (*label)[0:(*handler).top - 1] , (*label)[(*handler).bottom + 1 : old[2] - 1] ]
          IF (*handler).top EQ 0 AND (*handler).bottom NE old[2]-1 THEN $
            *label = [(*label)[(*handler).bottom + 1 : old[2] - 1] ]
          IF (*handler).top NE 0 AND (*handler).bottom EQ old[2]-1 THEN $
            *label = [(*label)[0:(*handler).top - 1] ]
          
          IF result[0] EQ 1 THEN $
            Widget_Control, info.delrID, Sensitive = 0
        ENDIF
      ENDIF
    ENDIF
  END
  
  'COPY' : BEGIN
    (*handler).topaste = (*handler).top
    IF (*handler).topaste EQ 0 THEN (*handler).topaste = -1
    Widget_Control, info.pasteID, Sensitive = 1
  END
  
  'PASTE' : BEGIN
    Widget_Control, info.delrID, Sensitive = 1
    Widget_Control, info.tableID, insert_rows = 1
    Widget_Control, info.tableID, get_value=temp	
    old = size(temp)
    IF (*handler).topaste EQ -1 THEN (*handler).topaste = 0
    (*label) = [(*label), (*label)[(*handler).topaste]]
    Widget_Control, info.tableID, Row_Labels = (*label)
    IF (*handler).topaste EQ 0 THEN (*handler).topaste = -1
    bul_bigger, info, paste = (*handler).topaste
  END
  
  'MULTIPLY' : BEGIN
    data = {data_1:1.0}
    ptr = Ptr_New (data)
    Multiply, ptr, group = event.top
    value = (*ptr).data_1
    Widget_Control, info.tableID, get_Value=(*table)
    res = size(*table)
    (*table)[(*handler).left, *] = (*table)[(*handler).left, *] * value
    Widget_Control, info.tableID, set_Value=(*table)
  END
  
  
  ELSE :
  
ENDCASE

IF Widget_Info (event.top, /valid_ID) THEN BEGIN
  infoID = Widget_Info (event.top, /Child)
  Widget_Control, infoID, set_UValue=info, /no_copy
ENDIF
END




PRO bul_editor, Group=group
  tlb   = Widget_Base (title = 'BULK Files Editor', $
                       column = 1, base_align_left = 1, MBar = MenuBar, $
                       TLB_Frame_Attr = 1)
  infos = Widget_Base (tlb)
  
  FileMenu   = WIDGET_BUTTON(MenuBar, 	VALUE='File', 	/MENU)
  bload    = WIDGET_BUTTON(FileMenu, 	VALUE='Load Bulk File', 	UValue='LOAD')
  bsave    = WIDGET_BUTTON(FileMenu, 	VALUE='Save', 			UValue='SAVE')
  bsaveas  = WIDGET_BUTTON(FileMenu, 	VALUE='Save as ...', 		UValue='SAVEAS')
  bquit    = WIDGET_BUTTON(FileMenu, 	VALUE='Quit', 			UValue='QUIT', $
                           /Separator)
  EditMenu   = WIDGET_BUTTON(MenuBar, 	VALUE='Edit',	/MENU)
  bnewr    = WIDGET_BUTTON(EditMenu, 	VALUE='New Row', 		UValue='NEWR')
  bdelr    = WIDGET_BUTTON(EditMenu,	VALUE='Delete Selected Row(s)', UValue='DELR')
  bcopy    = WIDGET_BUTTON(EditMenu, 	VALUE='Copy Row', 		UValue='COPY', $
                           /Separator)
  bpaste   = WIDGET_BUTTON(EditMenu,	VALUE='Paste Row', 		UValue='PASTE')
  bmulti   = WIDGET_BUTTON(EditMenu,	VALUE='Multiply column', 	UValue='MULTIPLY', $
                           /Separator)
  WindowMenu = WIDGET_BUTTON(MenuBar, 	VALUE='Window',	/MENU)
  borig    = WIDGET_BUTTON(WindowMenu,	VALUE='Show Bulk File',	 	UValue='BULK')


  tablebase = Widget_Base (tlb, column=2)
  
  table = Widget_Table (tablebase, xsize=4, y_scroll_size=10, $
                        /Editable, /All_Events, /Scroll, UValue='Table', $ 
                        column_labels=['X', 'Y', 'Z', 'si'], $
                        Event_Pro = 'Bul_Table_Events')
  
  parabase = Widget_Base (tablebase, column = 1)
  
  table1 = Widget_Base(parabase, row=1)
  at = Widget_Label (table1, value = 'A:', scr_xsize=80)
  a  = Widget_Text  (table1, Editable=0, All_Events=0, Event_Pro='Float_Only', $
                     xsize = 8, UValue='A')
  
  table2 = Widget_Base(parabase, row=1)
  bt = Widget_Label (table2, value = 'B:', scr_xsize=80)
  b  = Widget_Text  (table2, Editable=0, All_Events=0, Event_Pro='Float_Only', $
                     xsize = 8, UValue='B')
  
  table3 = Widget_Base(parabase, row=1)
  ct = Widget_Label (table3, value = 'C:', scr_xsize=80)
  c  = Widget_Text  (table3, Editable=0, All_Events=0, Event_Pro='Float_Only', $
                     xsize = 8, UValue='C')
  
  table4 = Widget_Base  (parabase, row=1)
  alphat = Widget_Label (table4, value = 'Alpha:', scr_xsize=80)
  alpha  = Widget_Text  (table4, Editable=0, All_Events=0, Event_Pro='Float_Only', $
                         xsize = 8, UValue='ALPHA')
  
  table5 = Widget_Base  (parabase, row=1)
  betat  = Widget_Label (table5, value = 'Beta:', scr_xsize=80)
  beta   = Widget_Text  (table5, Editable=0, All_Events=0, Event_Pro='Float_Only', $
                         xsize = 8, UValue='BETA')
  
  table6 = Widget_Base  (parabase, row=1)
  gammat = Widget_Label (table6, value = 'Gamma:', scr_xsize=80)
  gamma  = Widget_Text  (table6, Editable=0, All_Events=0, Event_Pro='Float_Only', $
                         xsize = 8, UValue='GAMMA')
  
  commentt    = Widget_Label  (tlb, value = 'Comment:')
  comment     = Widget_Text   (tlb, xsize = 80, ysize = 2, UValue='COMMENT', /scroll)
  
  handler = {filename:'rod', $
             topaste :	-1, $
             left:	-1, $
             top:	-1, $
             right:	-1, $
             bottom:	-1}
  
  ptr = Ptr_New (handler)
  
  labeldata = 0
  labelptr = Ptr_New (labeldata)
  
  tabledata = 0
  tableptr = Ptr_New (tabledata)
  
  commentdata = 0
  commentptr = Ptr_New (commentdata)
  
  paradata = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
  paraptr = Ptr_New (paradata)
  
  info = {loadID:bload, $
          saveID:bsave, $
          saveasID:bsaveas, $
          copyID:bcopy, $
          pasteID:bpaste, $
          newrID:bnewr, $
          delrID:bdelr, $
          multiID:bmulti, $
          origID:borig, $
          tableID:table, $
          commentID:comment, $
          aID:a, $
          bID:b, $
          cID:c, $
          alphaID:alpha, $
          betaID:beta, $
          gammaID:gamma, $
          tabledata:tableptr, $
          commentdata:commentptr, $
          labeldata:labelptr, $
          paradata:paraptr, $
          ptr:ptr, $
          loaded:0}
  
  Widget_Control, bsave,  Sensitive = 0
  Widget_Control, bsaveas,Sensitive = 0
  Widget_Control, bnewr,  Sensitive = 0
  Widget_Control, bdelr,  Sensitive = 0
  Widget_Control, bcopy,  Sensitive = 0
  Widget_Control, bpaste, Sensitive = 0
  Widget_Control, bmulti, Sensitive = 0
  Widget_Control, borig,  Sensitive = 0
  
  Widget_Control, table, column_Widths = Widget_Info (table, /column_widths)
  Widget_Control, Widget_Info (tlb, /Child), set_UValue=info, /no_copy
  Widget_Control, tlb, /Realize
  XManager, 'Bul_Editor', tlb, Event='Bul_Editor_Events', Group_leader=group, /No_Block
END
