Function Arreq, arr1, arr2, warn = wn, novalue = nov

;+
; NAME:
;	ARREQ
; PURPOSE:
;	Compares arrays for equality.  The arrays qualify as equal if:
;	    1) They are of the same general type (num., char., or struct.).
;	    2) Number of dimensions is the same.
;	    3) Size of each dimension is the same.
;	    4) Respective elements are equal.
; CATEGORY:
;	Mathematical Function (general).
; CALLING SEQUENCE:
;	Result = ARREQ( ARR1, ARR2 [, /WARN])
; INPUTS:
;    ARR1, ARR2
;	Arrays, type and number of dimensions arbitrary.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;    /WARN
;	If set, a warning message is issued for incompatible data types.
;    /NOVALUE
;	If set, only number of elements and structure are compared.
; OUTPUTS:
;	Returns 1 if the arrays are equal, 0 otherwise.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Uses the SIZE function to obtain information about the arrays.  
;	Compares, in order, data types, number of dimensions, size of each 
;	dimension and (unless NOVALUE is set) individual elements.
; MODIFICATION HISTORY:
;	Created 15-JUL-1991 by Mati Meron.
;-

    fsiz = size(arr1)
    ssiz = size(arr2)
    if fsiz(0) eq ssiz(0) then ndim = fsiz(0) else return, 0b
    ftyp = fsiz(ndim + 1)
    styp = ssiz(ndim + 1)
    if (ftyp ge 7 or styp ge 7) and (ftyp ne styp) then begin
	if keyword_set(wn) then message, 'Incompatible data types!', /continue
	return, 0b
    endif
    for i = 1, ndim do if fsiz(i) ne ssiz(i) then return, 0b

    if keyword_set(nov) then return, 1b else return, min(arr1 eq arr2)
end
