C  CONTROL BLOCK FOR THE DEVICE-DEPENDENT AREA EXTENSION FOR THE
C  TEKTRONIX 4207 DISPLAY TERMINAL IN A FULLY INTERACTIVE MODE.
      SAVE          /UGWE00/
C  NUMBER OF CHARACTERS IN THE OUTPUT BUFFER.
      INTEGER       DDXZ1
      PARAMETER     (DDXZ1=1024)
C  X AND Y LIMITS OF COORDINATES IN THE TERMINAL SPACE.
      INTEGER       DDXZ2,DDXZ3
      PARAMETER     (DDXZ2=4095,DDXZ3=3132)
C  NUMBER OF WORDS IN A SEGMENT TABLE ENTRY.
      INTEGER       DDXZ4
      PARAMETER     (DDXZ4=3)
C  CONTROL BLOCK LENGTH.
      INTEGER       DDXZZ
      PARAMETER     (DDXZZ=294)
C  THE DECLARATION OF THE COMMON BLOCK.
      COMMON        /UGWE00/
     X              DDXID,
     X              DDXB1,DDXS2,
     X              DDXBF,DDXBM,DDXBN,
     X              DDXPE,DDXNE,DDXME,
     X              DDXPP,DDXPS,DDXPL,
     X              DDXSC,DDXST,DDXX1,
     X              DDXIS,DDXIP,
     X              DDXLR,DDXNO,
     X              DDXBC,
     X              DDXCI,DDXCC,DDXCL,DDXCD,DDXCA,DDXCZ,DDXCP,
     X              DDXFF,DDXOP,DDXX2,DDXMM,
     X              DDXRM,DDXX3,
     X              DDXDL,DDXTL,DDXBL,DDXDC,
     X              DDXIO,DDXHT,DDXHQ
C  DEVICE-DEPENDENT AREA EXTENSION IDENTIFICATION.
      CHARACTER*8   DDXID
C  POINTER TO SUBROUTINE UGB001.
      INTEGER       DDXB1
C  POINTER TO SUBROUTINE UGWE02.
      INTEGER       DDXS2
C  THE INPUT/OUTPUT BUFFER.
      CHARACTER*(DDXZ1) DDXBF
C  MAXIMUM NUMBER OF CHARACTERS THAT WILL FIT INTO THE INPUT/OUTPUT
C  BUFFER.
      INTEGER       DDXBM
C  NUMBER OF CHARACTERS CURRENTLY IN THE INPUT/OUTPUT BUFFER.
      INTEGER       DDXBN
C  POINTER TO THE SEGMENT TABLE.  EACH ENTRY IN THIS TABLE CONTAINS
C  DDXZ4 WORDS.  THE MEANING OF EACH WORD IS:
C    1  EXTERNAL IDENTIFICATION OF THE SEGMENT.
C    2  INCLUDE/OMIT STATUS (0 MEANS INCLUDE, 1 MEANS OMIT).
C    3  PICK/NOPICK STATUS (0 MEANS NOPICK, 1 MEANS PICK).
      INTEGER       DDXPE
C  CURRENT NUMBER OF SEGMENTS IN THE SEGMENT TABLE.
      INTEGER       DDXNE
C  MAXIMUM NUMBER OF SEGMENTS THAT CAN BE PUT INTO THE SEGMENT TABLE.
      INTEGER       DDXME
C  THE PHYSICAL PICK CONTROL UNIT:
C     1  MEANS JOYDISK,
C    65  MEANS MOUSE,
C     9  MEANS TABLET ON PORT 0, AND
C    17  MEANS TABLET ON PORT 1.
      INTEGER       DDXPP
C  THE PHYSICAL STROKE CONTROL UNIT:
C    66  MEANS MOUSE,
C    10  MEANS TABLET ON PORT 0, AND
C    18  MEANS TABLET ON PORT 1.
      INTEGER       DDXPS
C  THE PHYSICAL LOCATOR CONTROL UNIT:
C     0  MEANS JOYDISK,
C    64  MEANS MOUSE,
C     8  MEANS TABLET ON PORT 0, AND
C    16  MEANS TABLET ON PORT 1.
      INTEGER       DDXPL
C  SIGNATURE CHARACTERS, IN COMPUTER AND TERMINAL FORMAT, AND PADDING.
      CHARACTER*3   DDXSC,DDXST
      CHARACTER*2   DDXX1
C  INCLUDE/OMIT STATE OF CURRENT SEGMENT:
C    0 MEANS INCLUDE, AND
C    1 MEANS OMIT.
      INTEGER       DDXIS
C  PICK/NOPICK STATE OF CURRENT SEGMENT:
C    0 MEANS NOPICK, AND
C    1 MEANS PICK.
      INTEGER       DDXIP
C  LOW RESOLUTION FLAG:
C    0 MEANS USE HIGH RESOLUTION, AND
C    1 MEANS USE LOW RESOLUTION.
      INTEGER       DDXLR
C  NO OPTIMIZATION FLAG:
C    0 MEANS DO THE OPTIMIZATION, AND
C    1 MEANS DO NOT DO THE OPTIMIZATION.
      INTEGER       DDXNO
C  THE BLINK COLOR:
C    0 MEANS ALL COLORS, AND
C    1...7 MEANS WHITE...CYAN.
      INTEGER       DDXBC
C  CURRENT PICK IDENTIFICATION.
      INTEGER       DDXCI
C  CURRENT LINE AND MARKER COLOR INDEX.
      INTEGER       DDXCC
C  CURRENT LINE TYPE.
      INTEGER       DDXCL
C  CURRENT TEXT COLOR INDEX.
      INTEGER       DDXCD
C  CURRENT TEXT ANGLE.
      INTEGER       DDXCA
C  CURRENT TEXT SIZE.
      INTEGER       DDXCZ
C  CURRENT FILL PATTERN.
      INTEGER       DDXCP
C  FIRST END POINT FLAG:
C    .TRUE.  MEANS THIS IS THE FIRST OF A GROUP OF END POINTS, AND
C    .FALSE. MEANS IT IS NOT.
      LOGICAL       DDXFF
C  LAST POSITIONING ORDER AND PADDING.
      CHARACTER*5   DDXOP
      CHARACTER*3   DDXX2
C  MARKER MODE FLAG:
C    0 MEANS NOT IN MARKER MODE, AND
C    1 MEANS IN MARKER MODE.
      INTEGER       DDXMM
C  RETURN MODE FOR TERMINAL AND PADDING.
      CHARACTER*1   DDXRM
      CHARACTER*3   DDXX3
C  ACTUAL NUMBER OF LINES ON THE DISPLAY SCREEN.
      INTEGER       DDXDL
C  TOP USABLE LINE ON THE DISPLAY SCREEN.
      INTEGER       DDXTL
C  BOTTOM USABLE LINE ON THE DISPLAY SCREEN.
      INTEGER       DDXBL
C  ACTUAL NUMBER OF CHARACTERS IN A LINE ON THE DISPLAY SCREEN.
      INTEGER       DDXDC
C  INPUT/OUTPUT IDENTIFICATION VALUE.
      INTEGER       DDXIO
C  HIBERNATION FLAG FOR INTERVAL TIMER.
      INTEGER       DDXHT
C  HIBERNATION FLAG FOR INPUT/OUTPUT PROCESSOR.
      INTEGER       DDXHQ
C  THE FOLLOWING ARRAY OVERLAYS THE ENTIRE DDA EXTENSION.
      INTEGER       DDXRY(DDXZZ)
      EQUIVALENCE   (DDXRY(1),DDXID)
