C  CONTROL BLOCK FOR THE DEVICE-DEPENDENT AREA FOUNDATION.
      SAVE          /UGA003/
C  MAXIMUM NUMBER OF INTERACTIVE CONTROLS.
      INTEGER       DDAZ1
      PARAMETER     (DDAZ1=8)
C  MAXIMUM KEYBOARD STRING LENGTH.
      INTEGER       DDAZ2
      PARAMETER     (DDAZ2=128)
C  NUMBER OF ITEMS IN THE BUTTON ARRAY.
      INTEGER       DDAZ3
      PARAMETER     (DDAZ3=2)
C  MAXIMUM NUMBER OF STROKE SEGMENTS.
      INTEGER       DDAZ4
      PARAMETER     (DDAZ4=128)
C  MAXIMUM NUMBER OF SHIELDS.
      INTEGER       DDAZ5
      PARAMETER     (DDAZ5=4)
C  NUMBER OF WORDS IN THE DEVICE-DEPENDENT AREA FOUNDATION.
      INTEGER       DDAZZ
      PARAMETER     (DDAZZ=224)
C  THE DECLARATION OF THE COMMON BLOCK.
      COMMON        /UGA003/
     X              DDAID,DDALG,DDAPA,DDALX,DDAPX,DDACX,
     X              DDAAI,DDAAT,DDAAC,DDAAN,
     X              DDAIL,DDADM,DDADF,DDAIC,DDABC,
     X              DDAKX,DDAKY,DDAKS,DDAKN,DDAKF,
     X              DDABF,
     X              DDASL,DDAST,DDASN,
     X              DDABD,DDABE,DDABX,DDABY,
     X              DDADS,DDADD,DDADX,DDADY,DDADA,
     X              DDAWA,DDAWS,DDAWD,DDAWX,DDAWY,DDATR,
     X              DDASA,DDASF,DDASH,
     X              DDA3D,DDA3V,
     X              DDA3W,DDA3O,DDA3E,DDA3U,DDA3N,
     X              DDA3M,DDA3P,DDA3T,
     X              DDAXV,DDAXO,DDAXE,DDAXU,DDAXN,
     X              DDAFW
C  DEVICE-DEPENDENT AREA FOUNDATION IDENTIFICATION.
      CHARACTER*8   DDAID
C  NUMBER OF WORDS IN THE DDA FOUNDATION.
      INTEGER       DDALG
C  POINTER TO THE ALLOCATED BLOCK FOR THE DDA FOUNDATION.
      INTEGER       DDAPA
C  NUMBER OF WORDS IN THE DEVICE-DEPENDENT EXTENSION OF THE DDA.
      INTEGER       DDALX
C  POINTER TO THE ALLOCATED BLOCK FOR THE DEVICE-DEPENDENT
C  EXTENSION OF THE DDA.
      INTEGER       DDAPX
C  POINTER TO THE ACTUAL COMMON BLOCK FOR THE DEVICE-DEPENDENT
C  EXTENSION.
      INTEGER       DDACX
C  INDEX OF THE DEVICE IN THE MCA'S LIST OF OPEN DEVICES.
      INTEGER       DDAAI
C  DEVICE TYPE AS SPECIFIED IN SUBROUTINE UGOPEN.
      CHARACTER*8   DDAAT
C  POINTER TO DEVICE-DEPENDENT SUBROUTINE.
      INTEGER       DDAAC
C  NAME OF DEVICE-DEPENDENT SUBROUTINE.
      CHARACTER*8   DDAAN
C  INTERACTION LEVEL OF DEVICE:
C    1 MEANS NON-INTERACTIVE,
C    2 MEANS SLAVE-DISPLAY, AND
C    3 MEANS FULLY INTERACTIVE.
      INTEGER       DDAIL
C  DRAWING MEDIUM PROPERTIES:
C    1 MEANS NON-ERASABLE MEDIUM,
C    2 MEANS RASTER-SCAN DEVICE, AND
C    3 MEANS REFRESH DISPLAY DEVICE.
      INTEGER       DDADM
C  DISPLAY DIMENSION:
C    2 FOR A TWO-DIMENSIONAL DEVICE, AND
C    3 FOR A THREE-DIMENSIONAL DEVICE.
      INTEGER       DDADF
C  INTERACTIVE CONTROLS FLAGS; THE ENTRIES IN THE ARRAY REFER TO
C  THE FOLLOWING CONTROL UNITS:
C    1 KEYBOARD,
C    2 PICK,
C    3 BUTTON,
C    4 STROKE,
C    5 LOCATOR, AND
C    6 VALUATOR.
C  ANY ADDITIONAL ENTRIES ARE NOT USED.  THE VALUES OF THE
C  ENTRIES ARE:
C    0 MEANS NOT AVAILABLE ON THE DEVICE, AND
C    1 MEANS AVAILABLE ON THE DEVICE EXCEPT FOR BUTTON AND
C      VALUATOR WHERE THE VALUE GIVES THE NUMBER OF BUTTONS OR
C      VALUATORS RESPECTIVELY.
      INTEGER       DDAIC(DDAZ1)
C  ENABLED INTERACTIVE CONTROLS; THE ENTRIES IN THE ARRAY ARE
C  THE SAME AS THE PRECEDING ARRAY.  THE VALUES ARE:
C    0 MEANS DISABLED, AND
C    + MEANS ENABLED.
      INTEGER       DDABC(DDAZ1)
C  KEYBOARD X AND Y COORDINATES.
      INTEGER       DDAKX,DDAKY
C  KEYBOARD CHARACTER STRING.
      CHARACTER*(DDAZ2) DDAKS
C  KEYBOARD CHARACTER STRING LENGTH.
      INTEGER       DDAKN
C  KEYBOARD UPPER CASE TRANSLATION FLAG:
C    0 MEANS TRANSLATE LOWER CASE TO UPPER CASE, AND
C    1 MEANS DO NOT TRANSLATE LOWER CASE TO UPPER CASE.
      INTEGER       DDAKF
C  BUTTON FLAGS:
C    0 BIT MEANS LIGHT IS OFF, AND
C    1 BIT MEANS LIGHT IS ON.
      INTEGER*4     DDABF(DDAZ3)
C  MAXIMUM STROKE LENGTH AS A RATIO OF FULL SCREEN (PRECISION IS
C  (32,30)).
      INTEGER       DDASL
C  MAXIMUM STROKE TIME (IN HUNDREDTHS OF A SECOND).
      INTEGER       DDAST
C  STROKE TABLE LENGTH.
      INTEGER       DDASN
C  BASIC TWO-DIMENSIONAL DRAWING AREA.
      INTEGER       DDABD(2,2)
C  EXTENSION POSSIBILITIES:
C    0 MEANS NO EXTENSION IS POSSIBLE, AND
C    1 MEANS EXTENSION IS POSSIBLE.
      INTEGER       DDABE(2,2)
C  CENTIMETERS PER RASTER UNIT IN THE X AND Y DIRECTION.
      REAL          DDABX,DDABY
C  DRAWING SPACE LIMITS.
      REAL          DDADS(2,2)
C  DRAWING SPACE DEVICE LIMITS.
      INTEGER       DDADD(2,2)
C  CENTIMETERS PER UNIT IN THE X AND Y DIRECTION IN THE DRAWING
C  SPACE.
      REAL          DDADX,DDADY
C  AFFINITY VALUE.
      REAL          DDADA
C  TWO-DIMENSIONAL VIEW PORT LIMITS.
      REAL          DDAWA(2,2)
C  TWO-DIMENSIONAL WINDOW LIMITS.
      REAL          DDAWS(2,2)
C  TWO-DIMENSIONAL WINDOW DEVICE LIMITS.
      INTEGER       DDAWD(2,2)
C  CENTIMETERS PER UNIT IN THE X AND Y DIRECTION IN THE VIEW
C  PORT.
      REAL          DDAWX,DDAWY
C  AUXILIARY TWO-DIMENSIONAL TRANSFORMATION DATA.
      REAL          DDATR(8)
C  NUMBER OF CURRENTLY ACTIVE SHIELDS.
      INTEGER       DDASA
C  FLAGS FOR ACTIVE SHIELDS:
C    0 MEANS SHIELD IS NOT AVAILABLE, AND
C    1 MEANS SHIELD IS AVAILABLE.
      INTEGER       DDASF(DDAZ5)
C  SHIELD DEFINITIONS.
      REAL          DDASH(2,2,DDAZ5)
C  BASIC THREE-DIMENSIONAL DRAWING VOLUME.
      INTEGER       DDA3D(3,2)
C  THREE-DIMENSIONAL VIEW PORT.
      REAL          DDA3V(2,2)
C  THREE-DIMENSIONAL WORLD VOLUME.
      REAL          DDA3W(3,2)
C  THREE-DIMENSIONAL OBJECT VOLUME.
      REAL          DDA3O(3,2)
C  THREE-DIMENSIONAL EYE POINT.
      REAL          DDA3E(3)
C  THREE-DIMENSIONAL UP DIRECTION.
      REAL          DDA3U(3)
C  THREE-DIMENSIONAL PROJECTION FLAG:
C    0.0 MEANS PARALLEL PROJECTION, AND
C     +  MEANS NEAR SCISSORING VALUE FOR A POINT PROJECTION.
      REAL          DDA3N
C  THE PROJECTION MATRIX.
      REAL          DDA3M(3,4)
C  EQUATION OF THE NEAR SCISSORING PLANE.
      REAL          DDA3P(4)
C  AUXILIARY THREE-DIMENSIONAL TRANSFORMATION DATA.
      REAL          DDA3T(24)
C  THREE-DIMENSIONAL VIEW PORT IN DEVICE UNITS.
      INTEGER       DDAXV(2,2)
C  THREE-DIMENSIONAL OBJECT VOLUME IN DEVICE UNITS.
      INTEGER       DDAXO(3,2)
C  THREE-DIMENSIONAL EYE POINT IN DEVICE UNITS.
      INTEGER       DDAXE(3)
C  THREE-DIMENSIONAL UP DIRECTION IN DEVICE UNITS (PRECISION IS
C  (32,30)).
      INTEGER       DDAXU(3)
C  THREE-DIMENSIONAL PROJECTION FLAG IN DEVICE UNITS:
C    0 MEANS PARALLEL PROJECTION, AND
C    + MEANS NEAR SCISSORING VALUE FOR A POINT PROJECTION
C      (PRECISION IS (32,30)).
      INTEGER       DDAXN
C  INITIAL WRITE GIVEN FLAG:
C    0 MEANS FIRST GRAPHIC SEGMENT HAS NOT BEEN WRITTEN, AND
C    1 MEANS FIRST GRAPHIC SEGMENT HAS BEEN WRITTEN.
      INTEGER       DDAFW
C  THE FOLLOWING ARRAY OVERLAYS THE ENTIRE DDA FOUNDATION.
      INTEGER       DDARY(DDAZZ)
      EQUIVALENCE   (DDARY(1),DDAID)
