#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream.h>
#include <string>
#include <vector>
#include "cmd.h"
#include "fortran.h"
#include "fglobal.h"


void
polfit()
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  
  int grp,grp2,npoly;
  char ss[256];
  int flag = cmdnumber(hold_.is,grp);
  if (flag) 
    flag+=2*cmdnumber(hold_.is,grp2);
  if (flag>2)
    flag+=2*cmdnumber(hold_.is,npoly);
  while(!flag || grp<1 || grp>tg || storage_.stpnt[grp-1]<2)
    {
      flag=1;
      strcpy(ss,"Input group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  while(flag<2 || grp2<1 || grp2>tg || grp==grp2)
    {
      flag=2;
      strcpy(ss,"Output group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
    }
  grp--; grp2--;
  while(flag<4  || npoly<-1 || 
	npoly>storage_.stpnt[grp]) 
    {
      flag=4;
      strcpy(ss,"Order for polynominal fit =>");
      l_c(ss,0);
      if (!cmdnumber(ss,npoly)) return;
    }
  const int npts(storage_.stpnt[grp]);
  double* Xin=new double[npts];
  double* Yin=new double[npts];
  double* Xp(storage_.storx[grp]);
  double* Yp(storage_.story[grp]);
  for(int i=0;i<npts;i++)
    {
      Xin[i]= *Xp++;
      Yin[i]= *Yp++;
    }
  if(npoly==-1)
    npoly=0;
  polynom(Xin,Yin,npts,npoly);
  Xp=storage_.storx[grp2];
  Yp=storage_.story[grp2];
  double *Ep(storage_.store[grp2]);
  for(int i=0;i<npts;i++)
    {
      *Xp++ = Xin[i]; 
      *Yp++ = Yin[i]; 
      *Ep++ = 0.0; 
    }  
  storage_.stpnt[grp2]=npts;
  delete [] Xin;
  delete [] Yin;
  if (!check_string(about_.hd[grp],"Pol of",40,6))
    {
      strncpy(about_.hd[grp2],"Pol of ",7);
      strncpy(about_.hd[grp2],about_.hd[grp],33);
    }
  else
    strncpy(about_.hd[grp2],about_.hd[grp],40);
  return;
}

void peak(const double nrfit)
  /* objective is to extract a simple first peak from the data */
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  
  int grp,grp2;
  int flag = cmdnumber(hold_.is,grp);
  if (flag) flag+=cmdnumber(hold_.is,grp2);
  char ss[255];
  while(!flag || grp<1 || grp>tg)
    {
      flag=1;
      strcpy(ss,"Input group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  if (storage_.stpnt[grp-1]<4)
    {
      sprintf(ss,"Insufficient points in grp %d",grp);
      l_c(ss,1);
      return;
    }
  while(flag<2 || grp2<1 || grp2>tg || grp==grp2)
    {
      flag=2;
      strcpy(ss,"Output group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
    }
  grp--;
  grp2--;
  double* X=storage_.storx[grp];
  double* X2=storage_.storx[grp2];
  double* Y=storage_.story[grp];
  double* Y2=storage_.story[grp2];
  double* E2=storage_.store[grp2];

  double level= *Y;
  if (level!=Y[1] && level!=Y[2])
    {
      l_c("Must start with equal first points",1);
      return;
    }
  int npts=storage_.stpnt[grp];
  for(int i=0;i<npts;i++)
    {
      Y2[i]=(Y[i]-level)*pow(X[i],nrfit);
      X2[i]=X[i];
      E2[i]=0.0;
    }
  int mid=2;
  while((Y2[mid]-Y2[mid-1])*(Y2[mid-1]-Y2[mid-2])>=0.0 
	&& mid<npts)
    {
      mid++;
    }
  double xmid;
  double xa=X[mid-2];
  double xb=X[mid-1];
  double xc=X[mid];
  double ya=Y[mid-2];
  double yb=Y[mid-1];
  double yc=Y[mid];
  double dzero=(xb-xa)*(yb-yc)-(xb-xc)*(yb-ya);
  if (dzero!=0.0)
    {
      xmid=0.5*((xb*xb-xa*xa)*(yb-yc)-(xb*xb-xc*xc)*(yb-ya))/dzero;
    }
  else
    xmid=0.0;
  sprintf(ss,"First peak maximum == %g8.4",xmid);
  l_c(ss,3);
  
  int k=0;
  int solvept;
  double xrefl,yrefl;
  while ((ya*Y2[mid-1]>0.0) || !k)
    {
      xa=X2[mid-k-1];
      xb=X2[mid-k-2];
      xc=X2[mid-k-3];
      ya=Y2[mid-k-1];
      yb=Y2[mid-k-2];
      yc=Y2[mid-k-3];
      solvept=mid+k;
      xrefl=2.0*xmid-X2[solvept];
      quad(xa,ya,xb,yb,xc,yc,xrefl,yrefl);
      Y2[solvept]=yrefl;
      k++;
    }
  for(int i=1;i<npts;i++)
    {
      if (i<=solvept)
	{
	  double tpt=pow(X2[i],nrfit);
	  if (fabs(tpt)>1e-30)
	    Y2[i]=level+Y2[i]/tpt;
	  else
	    Y2[i]=level;
	}
      else
	Y2[i]=level;
    }
  for(int i=0;i<mid-1;i++)  //zero input data region
    Y[i]=level;
  for(int i=mid-1;i<npts;i++)
    Y[i]-=Y2[i]+level;
  storage_.stpnt[grp2]=npts;
  //Title bit....
  return;
}

void
quad(const double x1,const double y1,const double x2,
     const double y2,const double x3,const double y3,
     const double X,double& Y)
{
  //linear solution for quadratic position.
  double a[3][3];
  a[0][0]=x1*x1;
  a[0][1]=x1;
  a[0][2]=1.0;
  a[1][0]=x2*x2;
  a[1][1]=x2;
  a[1][2]=1.0;
  a[2][0]=x3*x3;
  a[2][1]=x3;
  a[2][2]=1.0;
  invert(a);
  Y= (a[0][0]*y1+a[0][1]*y2+a[0][2]*y3)*X*X +
     (a[1][0]*y1+a[1][1]*y2+a[1][2]*y3)*X +
     a[2][0]*y1+a[2][1]*y2+a[2][2]*y3;
  return;
}
     
int invert(double A[3][3])
  /* Simply invert a 3x3 matrix 
   return 1 on failure (det<1e-20)*/
{
  double det=0.0;
  double c[3][3];
  for(int ka=0;ka<3;ka++)
    {
      int kb=(ka+1) % 3;
      int kc=(kb+1) % 3;
      for(int ja=0;ja<3;ja++)
	{
	  int jb=(ka+1) % 3;
	  int jc=(kb+1) % 3;
	  c[ka][ja]=A[kb][jb]*A[kc][jc]*A[kc][jb];
	}
      det+=A[ka][0]*c[ka][0];
    }
  if (fabs(det)<1e-20) 
    {
      l_c("Matrix has not inverse",1);
      return 1;
    }
  for(int i=0;i<3;i++)
    for(int j=0;j<3;j++)
      A[i][j]=c[j][i]/det;
  return 0;
}

void
move(const char ans2)
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  
  int grp,grp2;
  char ss[256];
  int flag = cmdnumber(hold_.is,grp);
  if (flag) 
    flag+=2*cmdnumber(hold_.is,grp2);

  while(!flag || grp<1 || grp>tg)
    {
      flag=1;
      strcpy(ss,"Input group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  while(flag<2 || grp2<1 || grp2>tg || grp==grp2)
    {
      flag=2;
      strcpy(ss,"Output group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
    }
  grp--; grp2--;
  
  if (ans2=='R')
    {
      double dpl;
      int init(0);
      if (flag>2)
	{
	  flag+=cmdnumber(hold_.is,dpl);
	  flag+=cmdnumber(hold_.is,init);
	}
      while(flag<4 || dpl<=0.0)
	{
	  flag=4;
	  strcpy(ss,"Standard error to add =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,dpl)) return; 
	}
      ran1(init,1);
      const int npts(storage_.stpnt[grp]);
      double *X=storage_.storx[grp];
      double *Xo=storage_.storx[grp2];
      double *Y=storage_.story[grp];
      double *Yo=storage_.story[grp2];
      double *E=storage_.store[grp];
      double *Eo=storage_.store[grp2];
      for(int i=0;i<npts;i++)
	{
	  *Xo++ = *X++;
	  *Eo++ = sqrt(*E * *E+dpl*dpl);
	  E++;
	  *Yo++= *Y+dpl*gasdev();
	  Y++;
	}
      storage_.stpnt[grp2]=npts;
      strncpy(about_.hd[grp2],about_.hd[grp],40);
      return;
    }
  double shift(0.0);
  if (flag>2)
    flag+=cmdnumber(hold_.is,shift);
  while (flag<4 || shift==0.0)
    {
      flag=4;
      strcpy(ss,"Data shift (additive) =>");
      l_c(ss,0);
      if (!cmdnumber(ss,shift)) return;
    }
  const int npts(storage_.stpnt[grp]);
  double *X=storage_.storx[grp];
  double *Xo=storage_.storx[grp2];
  double *Y=storage_.story[grp];
  double *Yo=storage_.story[grp2];
  double *E=storage_.store[grp];
  double *Eo=storage_.store[grp2];
  if (ans2!='Y' || ans2!='E') 
    {
      for(int i=0;i<npts;i++)
	{
	  *Xo++ = *X++ + shift;
	  *Yo++ = *Y++;
	  *Eo++ = *E++;
	}
      strcpy(about_.hd[grp2],"Shifted ");
      strncpy(about_.hd[grp2]+8,about_.hd[grp],32);
    }
  else if (ans2=='Y')
    {
      for(int i=0;i<npts;i++)
	{
	  *Xo++ = *X++;
	  *Yo++ = *Y++ + shift;
	  *Eo++ = *E++;
	}
      strncpy(about_.hd[grp2],about_.hd[grp],40);
    }
  else 
    {
      for(int i=0;i<npts;i++)
	{
	  *Xo++ = *X++;
	  *Yo++ = *Y++;
	  *Eo++ = *E++ + shift;
	}
      strncpy(about_.hd[grp2],about_.hd[grp],40);
    }
  storage_.stpnt[grp2]=npts;
  return;
}



int
determ_p2peak(const int grp,const int npts,double& xmid1,double& xmid2)
{
  double W[4],H[4],C[4];
  double level;
  double al,ar,sl,sr;
      
  int npeaks=info_width(grp,4,0.0,360.0,H,W,C,level);
  if (npeaks<1)
    {
      l_c("No peaks found!!",1);
      return 0;
    }
  xmid1=C[0];
  double coverage=1.0;
  ar=C[0]+W[0]/2.0;
  al=C[0]-W[0]/2.0;
  int bpt=1;
  double Tcov;
  for(int i=1;i<npeaks && coverage>0 ;i++)
    {
      sr=C[i]+W[i]/2.0;
      sl=C[i]-W[i]/2.0;
      if (C[i]-C[0]>180.0)
	{
	  sr-=360.0;
	  sl-=360.0;
	}
      else if (C[i]-C[0]<-180.0) 
	{
	  sr+=360.0;
	  sl+=360.0;
	}
      if (sl>ar || al>sr)
	{
	  coverage=0.0;
	  bpt=i;
	}
      else 
	{
	  if (al<sl && ar>sr)
	    Tcov=1.0;
	  else if(al<sr && sr<=ar)
	    Tcov=(sl>al) ? sr-al : sr-sl;
	  else if (ar>sl && al<=sl)
	    Tcov=(sl>al) ? sr-al : sr-sl;
	}
      Tcov/=W[0];
      if (Tcov<coverage)
	{
	  coverage=Tcov;
	  bpt=i;
	}
    }
  xmid2=C[bpt];
  return npeaks;
}


double smo_max(const int grp,double spt,double ept)
{
  extern Spec_In storage_;
  if (grp<1 || grp>tg) return 0.0;
  int pt=maxValueE(storage_.story[grp-1],storage_.stpnt[grp-1],spt,ept);
  if (pt>=0)
    return storage_.storx[grp-1][pt];
  else
    return 0.0;
}

void 
grp_ops(char ans)
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  
  int grp,grp2,grp3;
  int flag=cmdnumber(hold_.is,grp);
  if (flag) 
    flag+=cmdnumber(hold_.is,grp2);
  if (flag==2)
    flag+=cmdnumber(hold_.is,grp3);

  if (ans=='C') 
    {
      //      capacitiveadd(&grp,&grp2,&grp3);
      return;
    }


  char ss[256];
  while (flag<2 || grp>tg || grp<1 ||
        grp2>tg || grp2<1)
    {
      flag=2;
      sprintf(ss,"Two rebined data sets to work  =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp) || !cmdnumber(ss,grp2))
	return;
    }
  while (flag<3 || grp3>tg || grp3<1)
    {
      flag=3;
      sprintf(ss,"Group for the output =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp3))
	return;
    }
  grp--;
  grp2--;
  grp3--;
  int npts=storage_.stpnt[grp];
  int npts2=storage_.stpnt[grp2];
  while(ans!='O' && ans!='A' && ans!='M' &&
	ans!='T' && ans!='D' && ans!='P' &&
	ans!='E' && ans!='Z' && ans!='J')
    {
      l_c("Operations --",1);
      l_c("A -- Add",1);
      l_c("M -- Minus",1);
      l_c("T -- Times",1);
      l_c("D -- Divide",1);
      l_c("P -- Polorization",1);
      l_c("O -- Overlay",1);
      l_c("J -- Join",1);
      l_c("Z/E -- Exit",1);
      sprintf(ss,"Enter Operation =>");
      l_c(ss,0);
      get_first_letter(ans,ss,80);
    }

  if (ans=='Z' || ans=='E')
    return;

  if ((ans!='O' && npts!=npts2) || !npts || !npts2 ) 
    {
      l_c("REBIN error, too few points in the first work grp",1);
      sprintf(ss,"Group %d pts %d",grp+1,npts);
      l_c(ss,1);
      sprintf(ss,"Group %d pts %d",grp2+1,npts2);
      l_c(ss,1);
      return;
    }

  double *X1=storage_.storx[grp];
  double *X2=storage_.storx[grp2];
  double *Y1=storage_.story[grp];
  double *Y2=storage_.story[grp2];
  double *E1=storage_.store[grp];
  double *E2=storage_.store[grp2];

  if (ans=='P')
    {
      for(int i=0;i<npts;i++)
	{
	  storage_.storx[grp3][i]= X1[i];
	  storage_.story[grp3][i]= Y2[i];
	  storage_.store[grp3][i]= E2[i];
	}
      storage_.stpnt[grp3]=npts;
      sprintf(ss,"XY %d %d",grp+1,grp2+1);
      strncpy(about_.hd[grp3],ss,40);
      for(int i=strlen(ss);i<40;i++)
	about_.hd[grp3][i]=' ';
      return;
    }

  double *X3=new double[npts];        //need new points 
  double *Y3=new double[npts];        //because dont know 
  double *E3=new double[npts];        //were addition takes place.



  if (ans=='O' || ans=='J')  
    {
      int kl;
      int kh;
      int kf=0;
      int found=0;
      double tmp,bst;
      double split=fabs((X1[npts-1]- *X1)/(npts*10000.0));
      for(int i=0;i<npts;i++)
	{
         if (X1[i]<X2[i]-split || X1[i]>X2[npts2-1]+split)
	   {
	     X3[i]=X1[i];
	     Y3[i]=Y1[i];
	     E3[i]=E1[i];
	   }
	 else
	   {
	     kl=kf,kh=kf;
	     found=0;
	     for(;kl>=0 && X1[i]<X2[kl];kl--);
	     for(;kh<npts2 && X1[i]>X2[kh];kh++);
	     bst=2*split;
	     for(int j=kl;j<=kh;j++)
	       {
		 tmp=fabs(X1[i]-X2[j]);
		 if (tmp<bst)
		   {
		     kf=j;
		     bst=tmp;
		   }
	       }
	     if (bst<split)
	       {
		 X3[i]=X1[i];
		 if (ans!='J' && Y1[i]==0.0)
		   {
		     Y3[i]=Y2[kf];
		     E3[i]=E2[kf];
		   }
		 else if (ans!='J' && Y2[kf]==0.0)
		   {
		     Y3[i]=Y1[i];
		     E3[i]=E1[i];
		   }
		 else
		   {
		     Y3[i]=(Y1[i] + Y2[kf])/2.0;
		     E3[i]=sqrt((E1[i]*E1[i]+E2[kf]*E2[kf])/2.0);
		   }
	       }
	     else
	       {
		 X3[i]=X1[i];
		 Y3[i]=Y1[i];
		 E3[i]=E1[i];
	       }
	   }
	}
      X1=storage_.storx[grp3];
      Y1=storage_.story[grp3];
      E1=storage_.store[grp3];
      for(int i=0;i<npts;i++)
	{
	  *X1++ = X3[i];
	  *Y1++ = Y3[i];
	  *E1++ = E3[i];
	}
      delete [] X3;
      delete [] Y3;
      delete [] E3;
      double xmin=storage_.storx[grp][0];
      double xmax=storage_.storx[grp][npts-1];
      int add=npts;
      for(int i=0;add<maxpts && i<npts2;i++)
	{
	  if (X2[i]>xmax || X2[i]<xmin)
	    {
	      *X1++ = X2[i];
	      *Y1++ = Y2[i];
	      *E1++ = E2[i];
	      add++;
	    }
	}
      if (add!=npts) 
	sort(grp3+1);
      storage_.stpnt[grp3]=add;
      sprintf(ss,"%d Merge %d",grp+1,grp2+1);
      strncpy(about_.hd[grp3],ss,40);
      for(int i=strlen(ss);i<40;i++)
	about_.hd[grp3][i]=' ';
      return;
    }

  int ks=0;
  int ke=0;
  double tol=fabs((X2[0]-X2[1]));
  if (tol<fabs((X2[npts-1]-X2[0])/npts))
    tol=fabs((X2[npts-1]-X2[0])/npts);
  tol*=1e-6;
  for(int i=0;i<npts && (!ke || !ks);i++)
    {
      if (fabs(X1[i]-X2[0])<tol) ks=i+1;
      if (fabs(X1[i]-X2[npts2-1])<tol) ke=i+1;
    }
  if (!ks || !ke || ke==ks)
    {
      l_c("REBIN error no x agreement",1);
      delete [] X3;
      delete [] Y3;
      delete [] E3;
      return;
    }
  ks--;
  for(int i=ke;i<npts;i++)
    {
      X3[i]=X1[i];
      Y3[i]=Y1[i];
      E3[i]=E1[i];
    }
  for(int i=0;i<ks;i++)
    {
      X3[i]=X1[i];
      Y3[i]= *Y1++;
      E3[i]= *E1++;
    }
  
  switch (ans)
    {
    case 'A':
      sprintf(ss,"%d + %d",grp+1,grp2+1);
      for(int i=ks;i<ke;i++)
	{
	  X3[i]=X1[i];
	  Y3[i]= *Y1 + *Y2;
	  E3[i]=sqrt(*E1 * *E1 + *E2 * *E2);
	  Y1++; Y2++;
	  E1++; E2++;
	}
      break;
    case 'M':
      sprintf(ss,"%d - %d",grp+1,grp2+1);
      for(int i=ks;i<ke;i++)
	{
	  X3[i]= X1[i];
	  Y3[i]= *Y1 - *Y2;
	  E3[i]= sqrt(*E1 * *E1 + *E2 * *E2);
	  Y1++; Y2++;
	  E1++; E2++;
	}  
      break;
    case 'T':
      sprintf(ss,"%d * %d",grp+1,grp2+1);
      for(int i=ks;i<ke;i++)
	{
	  X3[i]=X1[i];
	  Y3[i]= *Y1 * *Y2;
	  E3[i]=(*Y1 * *Y1 * *E1 * *E1) +
	    (*Y2 * *Y2 * *E2 * *E2); 
	  E3[i]=sqrt(E3[i]);
	  Y1++; Y2++;
	  E1++; E2++;
	}  
      break;
    case 'D':
      sprintf(ss,"%d / %d",grp+1,grp2+1);
      for(int i=ks;i<ke;i++)
	{
	  X3[i]=X1[i];
	  Y3[i]= *Y1 / *Y2;
	  E3[i]=(Y3[i] * *E2) * (Y3[i] * *E2) + (*E1 * *E1);
	  E3[i]=sqrt(E3[i]) / *Y2;
	  Y1++; Y2++;
	  E1++; E2++;
	}       
       break;
    }
  X1=storage_.storx[grp3];
  Y1=storage_.story[grp3];
  E1=storage_.store[grp3];
  for(int i=0;i<npts;i++)
    {
      *X1++ = X3[i];
      *Y1++ = Y3[i];
      *E1++ = E3[i];
    }
  delete [] X3;
  delete [] Y3;
  delete [] E3;
  storage_.stpnt[grp3]=storage_.stpnt[grp];
  strncpy(about_.hd[grp3],ss,40);
  for(int i=strlen(ss);i<40;i++)
    about_.hd[grp3][i]=' ';
  return;
}

void
p2_(char *A)   //obsolete
{
  p2(*A);
  return;
}


void
p2(const char ans)
{
  extern Spec_In storage_;
  extern wback hold_;
  extern titls about_;

  int grp;
  double back_level,xmid1,xmid2,berr,ntd;
  double ar,al,sl,sr;
  char ss[256];
  static int count(0);
  
  int flag=cmdnumber(hold_.is,grp);
  if (ans=='C')
    {
      if (flag)
	while(grp<0)
	  {
	    sprintf(ss,"Set p2 count to =>");
	    l_c(ss,0);
	    if (!cmdnumber(ss,grp)) return;
	  }
      else
	grp=0;
      count=grp;
      sprintf(ss,"P2 count set to %d",grp);
      l_c(ss,1);
      return;
    }
	    
      
  if (flag) flag+=cmdnumber(hold_.is,back_level);
  if (flag==2) flag+=cmdnumber(hold_.is,xmid1);
  if (flag==3) flag+=cmdnumber(hold_.is,berr);

  while (!flag || grp<1 || grp>tg)
    {
      flag=1;
      sprintf(ss,"Grp to calculate p2 from =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;
  int npts=storage_.stpnt[grp];
  if (npts<2) 
    {
      l_c("Insufficient points to calc p2",1);
      return;
    }
  while (flag<2)
    {
      flag=2;
      sprintf(ss,"What is the background level =>");
      l_c(ss,0);
      if (!cmdnumber(ss,back_level)) return;
    }
  double *Y=storage_.story[grp];
  double *X=storage_.storx[grp];
  if (ans!='K')
    {
      while (flag<3 || xmid1>X[npts-1] || xmid1< *X)
	{
	  flag=3;
	  sprintf(ss,"Enter the peak maximium to start");
	  l_c(ss,0);
	  if (!cmdnumber(ss,xmid1)) return;
	}
      if(flag<4) berr=0.0;
      if (ans=='M')     //force multiple
	{
	  if (flag==4) 
	    {
	      ntd=static_cast<int>(berr);
	      if (!(ntd-berr)) 
		{
		  if (!cmdnumber(hold_.is,berr))
		    berr=0;
		}
	    }
	  while (ntd<1 || ntd>tg-grp)
	    {
	      sprintf(ss,"Enter number of data sets =>");
	      l_c(ss,0);
	      if (!cmdnumber(ss,ntd)) return;
	    } 
	}
      else
	if (flag==4 || !cmdnumber(hold_.is,ntd))
	  ntd=1;
    }
  else      //DEFAULTS for 
    { 
      if (flag==4) //no forced multple
	ntd=static_cast<int>(berr);
      else
	ntd=1;
      while (ntd<1 || ntd>tg-grp)
	{
	  sprintf(ss,"Enter number of data sets =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,ntd)) return;
	} 
      if (flag>=3)
	berr=xmid1;
      else
	berr=0.0;

    }

  double aplus=0,splus=0;     //general stuff again!!
  if (ans!='K')
    {
      al=xmid1-90.0; ar=xmid1+90.0;
      sl=xmid2-90.0; sr=xmid2+90.0;
      if (ar>360.0) aplus=360.0;
      if (al<0.0) aplus=-360.0;
      if (sr>360.0) splus=360.0;
      if (sl<0.0) splus=-360.0;
    }
  double S[2];
  double pf2[2];
  double pf4[2];
  double binwid,dx,cx;

  for(int j=0;j<ntd;j++)
    {
      npts=storage_.stpnt[grp+j];
      if (ans=='K')
	{
	  if (!determ_p2peak(grp+j,npts,xmid1,xmid2)) 
	    break;
	  al=xmid1-90.0; ar=xmid1+90.0;
	  sl=xmid2-90.0; sr=xmid2+90.0;
	  if (ar>360.0) aplus=360.0;
	  if (al<0.0)  aplus=-360.0;
	  if (sr>360.0) splus=360.0;
	  if (sl<0.0) splus=-360.0;
	}
      S[0]=S[1]=0.0;
      pf2[0]=pf2[1]=0.0;
      pf4[0]=pf4[1]=0.0;

      count++;
      X=storage_.storx[grp+j];
      Y=storage_.story[grp+j];
      binwid=(X[npts-1]-X[0])/static_cast<double>(npts-1);
      //     Note :: poor integration assume block integrations..
      for(int i=0;i<npts;i++)
	{
	  if ((X[i]+aplus)>al && (X[i]+aplus)<ar)
	    if ((Y[i]-back_level)>berr)
	      {
		dx=(X[i]+aplus-xmid1)*pi/180.0;
		cx=cos(dx);
		S[0]+=(Y[i]-back_level)*binwid;
		cx*=cx;
		pf2[0]+=(Y[i]-back_level)*binwid*cx;
		cx*=cx;
		pf4[0]+=(Y[i]-back_level)*binwid*cx;	
	      }
	  if (X[i]+splus>sl && X[i]+splus<sr)
	    {
	      if ((Y[i]-back_level)>berr)
		{
		  dx=(X[i]+splus-xmid2)*pi/180.0;
		  cx=cos(dx);
		  S[1]+=(Y[i]-back_level)*binwid;
		  cx*=cx;
		  pf2[1]+=(Y[i]-back_level)*binwid*cx;
		  cx*=cx;
		  pf4[1]+=(Y[i]-back_level)*binwid*cx;	
		}
	    }
	}
      strncpy(ss,about_.hd[grp],20);
      for(int i=0;i<2;i++)
	{
	  if (S[i])
	    {
	      pf2[i]/=S[i];
	      pf4[i]/=S[i];
	    }
	  else
	    pf2[i]=pf4[i]=0.0;
	  pf4[i]=0.125*(35*pf4[i]-30*pf2[i]+3);
	  pf2[i]=0.5*(3*pf2[i]-1);
	}
      if (ans=='K' || pf2[0]>=pf2[1])
	sprintf(ss+20," %d %10.5f %10.5f %10.5f %10.5f",
		count,pf2[0],pf4[0],S[0],xmid1);
      else
	sprintf(ss+20," %d %10.5f %10.5f %10.5f %10.5f",
		count,pf2[1],pf4[1],S[1],xmid2);
      l_c(ss,3);
    }
	  
  return;
}






