#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <map>
#include <vector>
#include "words.h"
#include "fglobal.h"
#include "extract.h"
#include "cmd.h"

words::~words()
{}

words::words() : WordLen(0),
     comp_clist(45),comp_glist(7),comp_tlist(5),
     comp_blist(0),comp_elist(0) 
{

#include "wordlist.h"

  for(int i=0;i<cmdnumb;i++)
    {
      clist[listW[i]]=i;  //create map entry
      cmdword.push_back(listw[i]);  //create list of action
      cmdcomp.push_back(listAct[i]); // create full description vector
    }
  for(int i=0;i<gphnumb;i++)
    {
      glist[glistW[i]]=i;
      gphword.push_back(glistw[i]);
    }
  for(int i=0;i<tdnumb;i++)
    {
      tlist[tlistW[i]]=i;
      twoword.push_back(tlistw[i]);
    }
  for(int i=0;i<boxnumb;i++)
    {
      blist[blistW[i]]=i;
      boxword.push_back(blistw[i]);
    }
  for(int i=0;i<xfsnumb;i++)
    {
      elist[elistW[i]]=i;
      xfsword.push_back(elistw[i]);
    }

  return;  
}

words::words(const int N,const char **full,const char **small)
  : WordLen(3),
    comp_clist(45),comp_glist(7),comp_tlist(5),
    comp_blist(0),comp_elist(0) 
{
  
  for(int i=0;i<N;i++)
    {
      clist[full[i]]=i;
      cmdword.push_back(small[i]);
    }
  return;
}

void
words::set_wordlen(const int A)
{
  if (A>0 && A<5) 
    WordLen=A;
}

int 
words::boldline(const int rpl,char* BL,char* Num,
		const char* txt) const
  /* job is to carry out bold and number parts */
{
  extern wback hold_;
  if (BL && Num)
    {
      strcpy(BL,txt);
      strncpy(Num,hold_.is+rpl,holdlen-rpl);
      Num[holdlen-rpl]=0;
      return 0;
    }
  return 1;
}


int
words::word_lookup(char* boldname,char* numbers)
  /* checks words and then output */
{
  char s[85];
  int wstart,wlen;
  extern wback hold_;
  strncpy(s,hold_.is,80);
  char c[5];  //max of  4 letter words 
  char c2[5];
  char c3[5];
  if (extractword(c,s,80,wstart,wlen,5,WordLen)) return -1;
  c[4]=0;
  int twstart,twlen;
  int twords=1- extractword(c2,s+wlen,80-wlen,twstart,twlen,4);
  int lastvalue;
  for(lastvalue=79;hold_.is[lastvalue]==' ';lastvalue--);
  lastvalue++;
  int extra,estart,elen;
  c2[4]=0;
  if (twords)  //two words
    twlen+=twstart;
  int found;
  std::map<std::string,int>::iterator plist;
  char *rpl;
  if (hold_.graph_flag==0) 
    {
      plist=clist.find(c);
      if (plist==clist.end()) return -1;
      found= plist->second;
      if (twords && found<comp_clist)
	{
	  int tfd=found;
	  int slen=strlen(c2);
	  if (slen>4)
	    slen=4;
	  switch(tfd)
	    {
	    case 0:   //AXIS
	    case 1:  
	    case 2:  
	    case 3:  
	      if (!strncmp(c2,"scal",slen))      //scal and size
		{
		  boldline(wlen+twlen,boldname,numbers,"Axis Scale");
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ac ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"size",slen))      //scal and size
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Axis Size");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ac ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"tick",slen))      //Tick size
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Axis Tick");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("an ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"view",slen))      //view
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Axis View");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("av ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      
	      break;
	    case 4: // CURS
	    case 5:
	    case 6:
	      if (!strncmp(c2,"edit",slen))                   //curs edit
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Cursor Edit");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ce ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      else if (!strncmp(c2,"axis",slen))              //curs axis
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Cursor Axis");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc("ca ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      else if (!strncmp(c2,"zoom",4))              //curs zoom
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Zoom");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ca ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 7: case 8: case 9: case 10:            //EDIT
	      if (!strncmp(c2,"curs",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Cursor Edit");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ce ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 11: case 12: case 13:                //FIT
	      if (!strncmp(c2,"gaus",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Fit Gauss");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("jg ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"leve",slen) || !strncmp(c2,"lev",3))  // ????
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Fit Level");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("fel",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"valu",4) || !strncmp(c2,"val",3))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Fit Value");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("fev",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"writ",4) || !strncmp(c2,"prin",3))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Fit Write");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("few",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 14: case 15: case 16: case 17:   //GAUSS
	      if (!strncmp(c2,"leve",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Level");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gal ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (slen!=4 && !strncmp(c2,"set",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Set");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gas ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"repe",slen))  //Defunct ???
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Repeat");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gr ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (slen!=4 && !strncmp(c2,"dis",slen))   //Display
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Display");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gad ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"load",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Load");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gau ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"spea",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Spread");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gam ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"save",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Save");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gax ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"mult",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Spread");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gam ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"type",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Type");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("gat ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"wind",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Gauss Window");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("jg ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 18: case 19: case 20: case 21: case 22:  // WRITE
	    case 23: case 24:                             // OUTPUT
	      if (!strncmp(c2,"file",slen))
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Write File");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("oa ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 25: case 26: case 27: case 28:         // PLOT, DRAW
	    case 29: case 30: case 31:
	      if (!strncmp(c2,"colo",slen))              // plot colour
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Plot Colour");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("pc ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"over",slen))              // plot over
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Plot Over");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("po ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"erro",slen))              // plot error
		    
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Plot Error");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("pe ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"head",slen) ||
		  !strncmp(c2,"titl",slen))    //plot headers, titles
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Plot Title");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ph ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 32: case 33:                   //REBIN
	      if (!strncmp(c2,"rang",slen))      //range
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Rebin Ranged");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rr ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"smoo",slen))       //smooth
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Rebin Smoothed");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rs ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"spli",slen))         //spline
		{
		  if (boldname && numbers)
		    {
		      strcpy(boldname,"Rebin Spline");
		      strncpy(numbers,hold_.is+wlen+twlen,80-(wlen+twlen));
		      numbers[80-(wlen+twlen)]=0;
		    }
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rs ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"inde",slen))        //indentical
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ri ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"join",slen))        //joint
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rj ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"poin",slen))         //point
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rp ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (slen<4 && !strncmp(c2,"sav",slen))  //Sav-gold
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rg ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"copy",slen))          //Copy
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ri ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 34: case 35: case 36: case 37:   // TRANSFORM
	      if (!strncmp(c2,"deri",slen))        //trans deriv
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("td ",hold_.is,wlen,80);      	  
 		  return 0;
		}
	      if (slen<4 && !strncmp(c2,"cos",slen))   //trans cos
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("tc ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (slen<4 && !strncmp(c2,"sin",slen))        //trans sin
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ts ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"back",slen))        //trans back
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("tq ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"erro",slen))        //trans error
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("te ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"laud",slen))        //trans laud
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("tl ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"time",slen))        //trans time
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("tt ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"freq",slen))        //trans frequence
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("tf ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;

	    case 42: case 43: case 44: case 45:   //INTEGRATE
	      if (!strncmp(c2,"dire",slen))             //integrate direct
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("id ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (slen<3 && !strncmp(c2,"p2",slen))             //integrate 2p
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ik ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"tota",slen))             //integrate total
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("it ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"coun",slen))             //integrate counter
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ic ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"mult",slen))             //integrate multiple
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("im ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    default :
	      return -1;
	    }
	}
      if (boldname && numbers)
	{
	  strcpy(boldname,cmdcomp[found].c_str());
	  strncpy(numbers,hold_.is+wlen,80-wlen);
	  numbers[lastvalue-wlen]=0;
	}
      rpl=(char *) cmdword[found].c_str();
      replc(rpl,hold_.is,wlen,80);
      return 0;
    }
  else if (hold_.graph_flag==1) 
    {
      plist=glist.find(c);
      if (plist==glist.end()) return -1;
      found= plist->second;
      if (twords && found<comp_glist)
	{
	  int tfd=found;
	  switch(tfd)
	    {
	    case 0:                                 //plot
	    case 1:                                 //draw
	      if (!strncmp(c2,"colo",4))                   //plot colour
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("pc ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"over",4))              //plot over
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("po ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"erro",4) ||  //plot error
		  !strncmp(c2,"err",3))  
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("pe ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 2:                                   //move 
	      if (twords)                //Do we have THREE words!!!
		extra=
		  1-extractword(c3,s+twlen+wlen,
				80-twlen,estart,elen,4); 
	      estart=wlen+twlen;
	      c3[4]=0;
	      if (!strncmp(c2,"box",3))               //move box
		{
		  if (extra && strncmp(c3,"grou",4))
		    {
		      replc(" ",hold_.is+estart,elen,80-estart);
		      replc(" ",hold_.is+wlen,twlen,80-wlen);
		      replc("mbg ",hold_.is,wlen,80);  	  
		    }
		  else
		    {
		      replc(" ",hold_.is+wlen,twlen,80-wlen);
		      replc("mb ",hold_.is,wlen,80);  	  
		    }
		  return 0;
		}
	      if (!strncmp(c2,"line",4))         //move line
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ml ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"text",4))         //move text
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("mt ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"sym",3))          //move sym
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ms ",hold_.is,wlen,80);      	  
		  return 0;
		}
	    case 3:        //read
	    case 4:        //load
	      if (!strncmp(c2,"sym",3))
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rs ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"box",3))
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rb ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"axis",4))   //read axis
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ra ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"plot",4))   // read plot
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rp ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"line",4))   //read  lines
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rl ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"text",4))   //read text
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("rt ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"over",4))   //read overlay
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ro ",hold_.is,wlen,80);      	  
		  return 0;
		}

	    case 5:        //write
	    case 6:        //output
	      if (!strncmp(c2,"sym",3))
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ws ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"full",4) || !strncmp(c2,"all",3))
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("wf ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"box",3))
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("wb ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"axis",4))   //axis
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("wa ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"plot",4))   // axis
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("wp ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"line",4))   // lines
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("wl ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"data",4))   // data
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("wd ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"grap",4))   // graphics
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("wg ",hold_.is,wlen,80);      	  
		  return 0;
		}
	    default :
	      return 0;
	    }
	}
      rpl=(char *) gphword[found].c_str();
      replc(rpl,hold_.is,wlen,80);
      return 0;
    }
  else if (hold_.graph_flag==2) 
    {
      plist=tlist.find(c);
      if (plist==tlist.end()) return 0;
      found= plist->second;
      if (twords && found<comp_tlist)
	{
	  int tfd=found;
	  switch(tfd)
	    {
	    case 0:
	      if (!strncmp(c2,"curs",4))
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ce ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 1:
	      if (!strncmp(c2,"squa",4))
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("as ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    case 2:
	    case 3:
	      if (!strncmp(c2,"esrf",4))  //output esrf
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("oe ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if (!strncmp(c2,"clos",4))    //output close
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("oc ",hold_.is,wlen,80);      	  
		  return 0;
		}
	    case 4:
	      if  (!strncmp(c2,"asci",4))  //output esrf
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("da ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if  (!strncmp(c2,"esrf",4))  //output esrf
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("di ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if  (!strncmp(c2,"gadd",4))  //output esrf
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("dg ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if  (!strncmp(c2,"arra",4))  //output esrf
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("ds ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      if  (!strncmp(c2,"dare",4))  //output esrf
		{
		  replc(" ",hold_.is+wlen,twlen,80-wlen);
		  replc("dx ",hold_.is,wlen,80);      	  
		  return 0;
		}
	      break;
	    default:
	      return 0;
	    }
	}
      rpl=(char *) twoword[found].c_str();
      replc(rpl,hold_.is,wlen,80);
      return 0;
    }
  else if (hold_.graph_flag==3) 
    {
      plist=blist.find(c);
      if (plist==blist.end()) return 0;
      found= plist->second;
      rpl=(char *) boxword[found].c_str();
      replc(rpl,hold_.is,wlen,80);
      return 0;
    }
  else if (hold_.graph_flag==4) 
    {
      plist=elist.find(c);
      if (plist==elist.end()) return 0;
      found= plist->second;
      rpl=(char *) xfsword[found].c_str();
      replc(rpl,hold_.is,wlen,80);
      return 0;
    }
  return 0;
}





